/*
 * Decompiled with CFR 0.152.
 */
package de.griefed.serverpackcreator.versionmeta.fabric;

import com.google.common.collect.Lists;
import de.griefed.serverpackcreator.versionmeta.fabric.FabricInstaller;
import de.griefed.serverpackcreator.versionmeta.fabric.FabricLoader;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.Optional;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class FabricMeta {
    private static final Logger LOG = LogManager.getLogger(FabricMeta.class);
    private final File FABRIC_MANIFEST;
    private final File FABRIC_INSTALLER_MANIFEST;
    private final FabricLoader FABRIC_LOADER;
    private final FabricInstaller FABRIC_INSTALLER;

    public FabricMeta(File fabricManifest, File fabricInstallerManifest) {
        this.FABRIC_MANIFEST = fabricManifest;
        this.FABRIC_INSTALLER_MANIFEST = fabricInstallerManifest;
        this.FABRIC_LOADER = new FabricLoader(this.getXml(this.FABRIC_MANIFEST));
        this.FABRIC_INSTALLER = new FabricInstaller(this.getXml(this.FABRIC_INSTALLER_MANIFEST));
    }

    public FabricMeta update() throws MalformedURLException {
        this.FABRIC_LOADER.update(this.getXml(this.FABRIC_MANIFEST));
        this.FABRIC_INSTALLER.update(this.getXml(this.FABRIC_INSTALLER_MANIFEST));
        return this;
    }

    private Document getXml(File manifest) {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = null;
        Document xml = null;
        try {
            documentBuilder = documentBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException ex) {
            LOG.error("Couldn't read document.", (Throwable)ex);
        }
        try {
            assert (documentBuilder != null);
            xml = documentBuilder.parse(manifest);
        }
        catch (IOException | SAXException ex) {
            LOG.error("Couldn't read document.", (Throwable)ex);
        }
        assert (xml != null);
        xml.normalize();
        return xml;
    }

    public String latestLoaderVersion() {
        return this.FABRIC_LOADER.latestLoaderVersion();
    }

    public String releaseLoaderVersion() {
        return this.FABRIC_LOADER.releaseLoaderVersion();
    }

    public List<String> loaderVersionsAscending() {
        return this.FABRIC_LOADER.loaders();
    }

    public List<String> loaderVersionsDescending() {
        return Lists.reverse(this.FABRIC_LOADER.loaders());
    }

    public String[] loaderVersionsArrayAscending() {
        return this.FABRIC_LOADER.loaders().toArray(new String[0]);
    }

    public String[] loaderVersionsArrayDescending() {
        return Lists.reverse(this.FABRIC_LOADER.loaders()).toArray(new String[0]);
    }

    public String latestInstallerVersion() {
        return this.FABRIC_INSTALLER.latestInstallerVersion();
    }

    public String releaseInstallerVersion() {
        return this.FABRIC_INSTALLER.releaseInstallerVersion();
    }

    public List<String> installerVersionsAscending() {
        return this.FABRIC_INSTALLER.installers();
    }

    public List<String> installerVersionsDescending() {
        return Lists.reverse(this.FABRIC_INSTALLER.installers());
    }

    public String[] installerVersionsArrayAscending() {
        return this.FABRIC_INSTALLER.installers().toArray(new String[0]);
    }

    public String[] installerVersionsArrayDescending() {
        return Lists.reverse(this.FABRIC_INSTALLER.installers()).toArray(new String[0]);
    }

    public URL latestInstallerUrl() {
        return this.FABRIC_INSTALLER.latestInstallerUrl();
    }

    public URL releaseInstallerUrl() {
        return this.FABRIC_INSTALLER.releaseInstallerUrl();
    }

    public boolean isInstallerUrlAvailable(String fabricVersion) {
        return Optional.ofNullable(this.FABRIC_INSTALLER.meta().get(fabricVersion)).isPresent();
    }

    public Optional<URL> installerUrl(String fabricVersion) {
        return Optional.ofNullable(this.FABRIC_INSTALLER.meta().get(fabricVersion));
    }

    public Optional<URL> improvedLauncherUrl(String minecraftVersion, String fabricVersion) {
        return this.FABRIC_INSTALLER.improvedLauncherUrl(minecraftVersion, fabricVersion);
    }

    public boolean checkFabricVersion(String fabricVersion) {
        return this.FABRIC_LOADER.loaders().contains(fabricVersion);
    }
}

