/*
 * Decompiled with CFR 0.152.
 */
package de.griefed.serverpackcreator.versionmeta;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.griefed.serverpackcreator.versionmeta.InvalidTypeException;
import de.griefed.serverpackcreator.versionmeta.Type;
import de.griefed.serverpackcreator.versionmeta.fabric.FabricMeta;
import de.griefed.serverpackcreator.versionmeta.forge.ForgeMeta;
import de.griefed.serverpackcreator.versionmeta.minecraft.MinecraftMeta;
import de.griefed.serverpackcreator.versionmeta.quilt.QuiltMeta;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

@Service
public class VersionMeta {
    private static final Logger LOG = LogManager.getLogger(VersionMeta.class);
    private final ObjectMapper OBJECT_MAPPER = new ObjectMapper().disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES).enable(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY);
    private final DocumentBuilderFactory DOCUMENT_BUILDER_FACTORY = DocumentBuilderFactory.newInstance();
    private final File MINECRAFT_MANIFEST;
    private final File FORGE_MANIFEST;
    private final File FABRIC_MANIFEST;
    private final File FABRIC_INSTALLER_MANIFEST;
    private final File QUILT_MANIFEST;
    private final File QUILT_INSTALLER_MANIFEST;
    private final URL MINECRAFT_MANIFEST_URL = new URL("https://launchermeta.mojang.com/mc/game/version_manifest.json");
    private final URL FORGE_MANIFEST_URL = new URL("https://files.minecraftforge.net/net/minecraftforge/forge/maven-metadata.json");
    private final URL FABRIC_MANIFEST_URL = new URL("https://maven.fabricmc.net/net/fabricmc/fabric-loader/maven-metadata.xml");
    private final URL FABRIC_INSTALLER_MANIFEST_URL = new URL("https://maven.fabricmc.net/net/fabricmc/fabric-installer/maven-metadata.xml");
    private final URL QUILT_MANIFEST_URL = new URL("https://maven.quiltmc.org/repository/release/org/quiltmc/quilt-loader/maven-metadata.xml");
    private final URL QUILT_INSTALLER_MANIFEST_URL = new URL("https://maven.quiltmc.org/repository/release/org/quiltmc/quilt-installer/maven-metadata.xml");
    private final MinecraftMeta MINECRAFT_META;
    private final FabricMeta FABRIC_META;
    private final ForgeMeta FORGE_META;
    private final QuiltMeta QUIL_META;

    @Autowired
    public VersionMeta(File minecraftManifest, File forgeManifest, File fabricManifest, File fabricInstallerManifest, File quiltManifest, File quiltInstallerManifest) throws IOException {
        this.MINECRAFT_MANIFEST = minecraftManifest;
        this.FORGE_MANIFEST = forgeManifest;
        this.FABRIC_MANIFEST = fabricManifest;
        this.FABRIC_INSTALLER_MANIFEST = fabricInstallerManifest;
        this.QUILT_MANIFEST = quiltManifest;
        this.QUILT_INSTALLER_MANIFEST = quiltInstallerManifest;
        this.checkManifests();
        this.FORGE_META = new ForgeMeta(forgeManifest);
        this.MINECRAFT_META = new MinecraftMeta(minecraftManifest, this.FORGE_META);
        this.FABRIC_META = new FabricMeta(fabricManifest, fabricInstallerManifest);
        this.FORGE_META.initialize(this.MINECRAFT_META);
        this.QUIL_META = new QuiltMeta(quiltManifest, quiltInstallerManifest);
        this.MINECRAFT_META.update();
        this.FABRIC_META.update();
        this.FORGE_META.update();
        this.QUIL_META.update();
    }

    private void checkManifests() {
        this.checkManifest(this.MINECRAFT_MANIFEST, this.MINECRAFT_MANIFEST_URL, Type.MINECRAFT);
        this.checkManifest(this.FORGE_MANIFEST, this.FORGE_MANIFEST_URL, Type.FORGE);
        this.checkManifest(this.FABRIC_MANIFEST, this.FABRIC_MANIFEST_URL, Type.FABRIC);
        this.checkManifest(this.FABRIC_INSTALLER_MANIFEST, this.FABRIC_INSTALLER_MANIFEST_URL, Type.FABRIC_INSTALLER);
        this.checkManifest(this.QUILT_MANIFEST, this.QUILT_MANIFEST_URL, Type.QUILT);
        this.checkManifest(this.QUILT_INSTALLER_MANIFEST, this.QUILT_INSTALLER_MANIFEST_URL, Type.QUILT_INSTALLER);
    }

    private void checkManifest(File manifestToCheck, URL urlToManifest, Type manifestType) {
        if (manifestToCheck.exists()) {
            try (InputStream existing = Files.newInputStream(manifestToCheck.toPath(), new OpenOption[0]);
                 InputStream newManifest = urlToManifest.openStream();){
                int countOldFile = 0;
                int countNewFile = 0;
                switch (manifestType) {
                    case MINECRAFT: {
                        countOldFile = this.getJson(existing).get("versions").size();
                        countNewFile = this.getJson(newManifest).get("versions").size();
                        break;
                    }
                    case FORGE: {
                        for (JsonNode mcVer : this.getJson(existing)) {
                            countOldFile += mcVer.size();
                        }
                        for (JsonNode mcVer : this.getJson(newManifest)) {
                            countNewFile += mcVer.size();
                        }
                        break;
                    }
                    case FABRIC: 
                    case FABRIC_INSTALLER: 
                    case QUILT: 
                    case QUILT_INSTALLER: {
                        countOldFile = this.getXml(existing).getElementsByTagName("version").getLength();
                        countNewFile = this.getXml(newManifest).getElementsByTagName("version").getLength();
                        break;
                    }
                    default: {
                        throw new InvalidTypeException("Manifest type must be either Type.MINECRAFT, Type.FORGE, Type.FABRIC or Type.FABRIC_INSTALLER. Specified: " + (Object)((Object)manifestType));
                    }
                }
                LOG.debug("Nodes/Versions/Size in/of old " + manifestToCheck + ": " + countOldFile);
                LOG.debug("Nodes/Versions/Size in/of new " + manifestToCheck + ": " + countNewFile);
                if (countNewFile > countOldFile) {
                    LOG.info("Refreshing " + manifestToCheck + ".");
                    this.updateManifest(manifestToCheck, urlToManifest);
                } else {
                    LOG.info("Manifest " + manifestToCheck + " does not need to be refreshed.");
                }
            }
            catch (InvalidTypeException | IOException ex) {
                LOG.error("Couldn't refresh manifest " + manifestToCheck, (Throwable)ex);
            }
        } else {
            this.updateManifest(manifestToCheck, urlToManifest);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateManifest(File manifestToRefresh, URL urlToManifest) {
        FileUtils.deleteQuietly(manifestToRefresh);
        try {
            FileUtils.createParentDirectories(manifestToRefresh);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        ReadableByteChannel readableByteChannel = null;
        OutputStream fileOutputStream = null;
        FileChannel fileChannel = null;
        try {
            readableByteChannel = Channels.newChannel(urlToManifest.openStream());
            fileOutputStream = new FileOutputStream(manifestToRefresh);
            fileChannel = ((FileOutputStream)fileOutputStream).getChannel();
            ((FileOutputStream)fileOutputStream).getChannel().transferFrom(readableByteChannel, 0L, Long.MAX_VALUE);
        }
        catch (IOException ex) {
            LOG.error("An error occurred downloading " + manifestToRefresh + ".", (Throwable)ex);
            FileUtils.deleteQuietly(manifestToRefresh);
        }
        finally {
            try {
                fileOutputStream.flush();
            }
            catch (Exception exception) {}
            try {
                ((FileOutputStream)fileOutputStream).close();
            }
            catch (Exception exception) {}
            try {
                readableByteChannel.close();
            }
            catch (Exception exception) {}
            try {
                fileChannel.close();
            }
            catch (Exception exception) {}
        }
    }

    private JsonNode getJson(InputStream inputStream) throws IOException {
        return this.OBJECT_MAPPER.readTree(inputStream);
    }

    private Document getXml(InputStream manifest) {
        DocumentBuilder documentBuilder = null;
        Document xml = null;
        try {
            documentBuilder = this.DOCUMENT_BUILDER_FACTORY.newDocumentBuilder();
        }
        catch (ParserConfigurationException ex) {
            LOG.error("Couldn't read document.", (Throwable)ex);
        }
        try {
            assert (documentBuilder != null);
            xml = documentBuilder.parse(manifest);
        }
        catch (IOException | SAXException ex) {
            LOG.error("Couldn't read document.", (Throwable)ex);
        }
        assert (xml != null);
        xml.normalize();
        return xml;
    }

    public VersionMeta update() throws IOException {
        this.checkManifests();
        this.MINECRAFT_META.update();
        this.FABRIC_META.update();
        this.FORGE_META.update();
        return this;
    }

    public MinecraftMeta minecraft() {
        return this.MINECRAFT_META;
    }

    public FabricMeta fabric() {
        return this.FABRIC_META;
    }

    public ForgeMeta forge() {
        return this.FORGE_META;
    }

    public QuiltMeta quilt() {
        return this.QUIL_META;
    }
}

