/*
 * Decompiled with CFR 0.152.
 */
package de.griefed.serverpackcreator.utilities;

import de.griefed.serverpackcreator.ApplicationProperties;
import de.griefed.serverpackcreator.ConfigurationHandler;
import de.griefed.serverpackcreator.i18n.LocalizationManager;
import de.griefed.serverpackcreator.utilities.ConfigUtilities;
import de.griefed.serverpackcreator.utilities.common.Utilities;
import de.griefed.serverpackcreator.utilities.misc.Generated;
import de.griefed.serverpackcreator.versionmeta.VersionMeta;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Scanner;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Generated
public class ConfigurationCreator {
    private static final Logger LOG = LogManager.getLogger(ConfigurationCreator.class);
    private final LocalizationManager LOCALIZATIONMANAGER;
    private final ConfigurationHandler CONFIGURATIONHANDLER;
    private final ApplicationProperties APPLICATIONPROPERTIES;
    private final VersionMeta VERSIONMETA;
    private final Utilities UTILITIES;
    private final ConfigUtilities CONFIGUTILITIES;

    public ConfigurationCreator(LocalizationManager injectedLocalizationManager, ConfigurationHandler injectedConfigurationHandler, ApplicationProperties injectedApplicationProperties, Utilities injectedUtilities, VersionMeta injectedVersionMeta, ConfigUtilities injectedConfigUtilities) throws IOException {
        this.APPLICATIONPROPERTIES = injectedApplicationProperties == null ? new ApplicationProperties() : injectedApplicationProperties;
        this.LOCALIZATIONMANAGER = injectedLocalizationManager == null ? new LocalizationManager(this.APPLICATIONPROPERTIES) : injectedLocalizationManager;
        this.VERSIONMETA = injectedVersionMeta == null ? new VersionMeta(this.APPLICATIONPROPERTIES.MINECRAFT_VERSION_MANIFEST_LOCATION(), this.APPLICATIONPROPERTIES.FORGE_VERSION_MANIFEST_LOCATION(), this.APPLICATIONPROPERTIES.FABRIC_VERSION_MANIFEST_LOCATION(), this.APPLICATIONPROPERTIES.FABRIC_INSTALLER_VERSION_MANIFEST_LOCATION(), this.APPLICATIONPROPERTIES.QUILT_VERSION_MANIFEST_LOCATION(), this.APPLICATIONPROPERTIES.QUILT_INSTALLER_VERSION_MANIFEST_LOCATION()) : injectedVersionMeta;
        this.UTILITIES = injectedUtilities == null ? new Utilities(this.LOCALIZATIONMANAGER, this.APPLICATIONPROPERTIES) : injectedUtilities;
        this.CONFIGUTILITIES = injectedConfigUtilities == null ? new ConfigUtilities(this.LOCALIZATIONMANAGER, this.UTILITIES, this.APPLICATIONPROPERTIES, this.VERSIONMETA) : injectedConfigUtilities;
        this.CONFIGURATIONHANDLER = injectedConfigurationHandler == null ? new ConfigurationHandler(this.LOCALIZATIONMANAGER, this.VERSIONMETA, this.APPLICATIONPROPERTIES, this.UTILITIES, this.CONFIGUTILITIES) : injectedConfigurationHandler;
    }

    public void createConfigurationFile() {
        String serverPackSuffix;
        String javaArgs;
        boolean includeZipCreation;
        boolean includeServerProperties;
        boolean includeServerIcon;
        String javaPath;
        String modLoaderVersion;
        String modLoader;
        String minecraftVersion;
        boolean includeServerInstallation;
        String serverPropertiesPath;
        String serverIconPath;
        String[] tmpCopyDirs;
        String[] tmpClientMods;
        String modpackDir;
        List<Object> clientMods = new ArrayList<String>(100);
        ArrayList<String> copyDirs = new ArrayList<String>(100);
        ArrayList<String> encounteredErrors = new ArrayList<String>(100);
        Scanner reader = new Scanner(System.in);
        LOG.info(String.format(this.LOCALIZATIONMANAGER.getLocalizedString("configuration.log.info.start"), "-cgen"));
        do {
            String tmpServerProperties;
            String tmpServerIcon;
            String tmpModpackDir;
            LOG.info(this.LOCALIZATIONMANAGER.getLocalizedString("configuration.log.info.modpack.enter"));
            LOG.info(this.LOCALIZATIONMANAGER.getLocalizedString("configuration.log.info.modpack.example"));
            while (true) {
                System.out.print(this.LOCALIZATIONMANAGER.getLocalizedString("configuration.log.info.modpack.cli") + " ");
                tmpModpackDir = reader.nextLine();
                if (!this.CONFIGURATIONHANDLER.checkModpackDir(tmpModpackDir, encounteredErrors)) continue;
                LOG.info(String.format(this.LOCALIZATIONMANAGER.getLocalizedString("configuration.log.info.checkreturn"), tmpModpackDir));
                LOG.info(this.LOCALIZATIONMANAGER.getLocalizedString("configuration.log.info.modpack.checkreturninfo"));
                System.out.print(this.LOCALIZATIONMANAGER.getLocalizedString("configuration.log.info.answer") + " ");
                if (this.UTILITIES.BooleanUtils().readBoolean()) break;
            }
            modpackDir = tmpModpackDir.replace("\\", "/");
            LOG.info(String.format(this.LOCALIZATIONMANAGER.getLocalizedString("configuration.log.info.checkreturn"), modpackDir));
            System.out.println();
            LOG.info(this.LOCALIZATIONMANAGER.getLocalizedString("configuration.log.info.clientmods.enter"));
            do {
                clientMods.clear();
                clientMods.addAll(this.UTILITIES.ListUtils().readStringArray());
                LOG.info(String.format(this.LOCALIZATIONMANAGER.getLocalizedString("configuration.log.info.checkreturn"), clientMods));
                if (clientMods.isEmpty()) {
                    clientMods = this.APPLICATIONPROPERTIES.getListFallbackMods();
                    LOG.warn(this.LOCALIZATIONMANAGER.getLocalizedString("configuration.log.warn.checkconfig.clientmods"));
                    for (String string : clientMods) {
                        LOG.warn(String.format("    %s", string));
                    }
                }
                LOG.info(this.LOCALIZATIONMANAGER.getLocalizedString("configuration.log.info.clientmods.checkreturninfo"));
                System.out.print(this.LOCALIZATIONMANAGER.getLocalizedString("configuration.log.info.answer") + " ");
            } while (!this.UTILITIES.BooleanUtils().readBoolean());
            LOG.info(String.format(this.LOCALIZATIONMANAGER.getLocalizedString("configuration.log.info.checkreturn"), clientMods));
            tmpClientMods = new String[clientMods.size()];
            clientMods.toArray(tmpClientMods);
            System.out.println();
            LOG.info(this.LOCALIZATIONMANAGER.getLocalizedString("configuration.log.info.copydirs.enter"));
            List<Object> dirList = Arrays.asList((Object[])Objects.requireNonNull(new File(modpackDir).list((current, name) -> new File(current, name).isDirectory())));
            LOG.info(String.format(this.LOCALIZATIONMANAGER.getLocalizedString("configuration.log.info.copydirs.dirsinmodpack"), dirList.toString().replace("[", "").replace("]", "")));
            while (true) {
                copyDirs.clear();
                LOG.info(this.LOCALIZATIONMANAGER.getLocalizedString("configuration.log.info.copydirs.specify"));
                copyDirs.addAll(this.UTILITIES.ListUtils().readStringArray());
                if (!this.CONFIGURATIONHANDLER.checkCopyDirs(copyDirs, modpackDir, encounteredErrors)) continue;
                LOG.info(String.format(this.LOCALIZATIONMANAGER.getLocalizedString("configuration.log.info.checkreturn"), copyDirs));
                LOG.info(this.LOCALIZATIONMANAGER.getLocalizedString("configuration.log.info.copydirs.checkreturninfo"));
                System.out.print(this.LOCALIZATIONMANAGER.getLocalizedString("configuration.log.info.answer") + " ");
                if (this.UTILITIES.BooleanUtils().readBoolean()) break;
            }
            LOG.info(String.format(this.LOCALIZATIONMANAGER.getLocalizedString("configuration.log.info.checkreturn"), copyDirs));
            tmpCopyDirs = new String[copyDirs.size()];
            copyDirs.toArray(tmpCopyDirs);
            System.out.println();
            LOG.info(this.LOCALIZATIONMANAGER.getLocalizedString("configuration.log.info.custom.icon.enter"));
            while (true) {
                System.out.print(this.LOCALIZATIONMANAGER.getLocalizedString("configuration.log.info.custom.icon.path"));
                tmpServerIcon = reader.nextLine();
                if (!this.CONFIGURATIONHANDLER.checkIconAndProperties(tmpServerIcon)) continue;
                LOG.info(String.format(this.LOCALIZATIONMANAGER.getLocalizedString("configuration.log.info.checkreturn"), tmpServerIcon));
                LOG.info(this.LOCALIZATIONMANAGER.getLocalizedString("configuration.log.info.custom.icon.end"));
                System.out.print(this.LOCALIZATIONMANAGER.getLocalizedString("configuration.log.info.answer") + " ");
                if (this.UTILITIES.BooleanUtils().readBoolean()) break;
            }
            serverIconPath = tmpServerIcon.replace("\\", "/");
            LOG.info(String.format(this.LOCALIZATIONMANAGER.getLocalizedString("configuration.log.info.checkreturn"), serverIconPath));
            System.out.println();
            LOG.info(this.LOCALIZATIONMANAGER.getLocalizedString("configuration.log.info.custom.properties.enter"));
            while (true) {
                System.out.print(this.LOCALIZATIONMANAGER.getLocalizedString("configuration.log.info.custom.properties.path"));
                tmpServerProperties = reader.nextLine();
                if (!this.CONFIGURATIONHANDLER.checkIconAndProperties(tmpServerProperties)) continue;
                LOG.info(String.format(this.LOCALIZATIONMANAGER.getLocalizedString("configuration.log.info.checkreturn"), tmpServerProperties));
                LOG.info(this.LOCALIZATIONMANAGER.getLocalizedString("configuration.log.info.custom.properties.end"));
                System.out.print(this.LOCALIZATIONMANAGER.getLocalizedString("configuration.log.info.answer") + " ");
                if (this.UTILITIES.BooleanUtils().readBoolean()) break;
            }
            serverPropertiesPath = tmpServerProperties.replace("\\", "/");
            LOG.info(String.format(this.LOCALIZATIONMANAGER.getLocalizedString("configuration.log.info.checkreturn"), serverPropertiesPath));
            System.out.println();
            LOG.info(this.LOCALIZATIONMANAGER.getLocalizedString("configuration.log.info.server.enter"));
            System.out.print(this.LOCALIZATIONMANAGER.getLocalizedString("configuration.log.info.server.include") + " ");
            includeServerInstallation = this.UTILITIES.BooleanUtils().readBoolean();
            LOG.info(String.format(this.LOCALIZATIONMANAGER.getLocalizedString("configuration.log.info.checkreturn"), includeServerInstallation));
            LOG.info(this.LOCALIZATIONMANAGER.getLocalizedString("configuration.log.info.minecraft.enter"));
            do {
                System.out.print(this.LOCALIZATIONMANAGER.getLocalizedString("configuration.log.info.minecraft.specify") + " ");
                minecraftVersion = reader.nextLine();
            } while (!this.VERSIONMETA.minecraft().checkMinecraftVersion(minecraftVersion));
            LOG.info(String.format(this.LOCALIZATIONMANAGER.getLocalizedString("configuration.log.info.checkreturn"), minecraftVersion));
            System.out.println();
            LOG.info(this.LOCALIZATIONMANAGER.getLocalizedString("configuration.log.info.modloader.enter"));
            do {
                System.out.print(this.LOCALIZATIONMANAGER.getLocalizedString("configuration.log.info.modloader.cli") + " ");
            } while (!this.CONFIGURATIONHANDLER.checkModloader(modLoader = reader.nextLine()));
            modLoader = this.CONFIGUTILITIES.getModLoaderCase(modLoader);
            LOG.info(String.format(this.LOCALIZATIONMANAGER.getLocalizedString("configuration.log.info.checkreturn"), modLoader));
            System.out.println();
            LOG.info(String.format(this.LOCALIZATIONMANAGER.getLocalizedString("configuration.log.info.modloaderversion.enter"), modLoader));
            do {
                System.out.print(this.LOCALIZATIONMANAGER.getLocalizedString("configuration.log.info.modloaderversion.cli") + " ");
            } while (!this.CONFIGURATIONHANDLER.checkModloaderVersion(modLoader, modLoaderVersion = reader.nextLine(), minecraftVersion));
            LOG.info(String.format(this.LOCALIZATIONMANAGER.getLocalizedString("configuration.log.info.checkreturn"), modLoaderVersion));
            System.out.println();
            LOG.info(this.LOCALIZATIONMANAGER.getLocalizedString("configuration.log.info.java.enter"));
            LOG.info(this.LOCALIZATIONMANAGER.getLocalizedString("configuration.log.info.java.enter2"));
            LOG.info(this.LOCALIZATIONMANAGER.getLocalizedString("configuration.log.info.java.example"));
            System.out.print(this.LOCALIZATIONMANAGER.getLocalizedString("configuration.log.info.java.cli") + " ");
            javaPath = this.CONFIGURATIONHANDLER.getJavaPath(reader.nextLine());
            System.out.println(String.format(this.LOCALIZATIONMANAGER.getLocalizedString("configuration.log.warn.getjavapath.set"), javaPath));
            System.out.println();
            LOG.info(this.LOCALIZATIONMANAGER.getLocalizedString("configuration.log.info.icon.enter"));
            System.out.print(this.LOCALIZATIONMANAGER.getLocalizedString("configuration.log.info.icon.cli") + " ");
            includeServerIcon = this.UTILITIES.BooleanUtils().readBoolean();
            LOG.info(String.format(this.LOCALIZATIONMANAGER.getLocalizedString("configuration.log.info.checkreturn"), includeServerIcon));
            System.out.println();
            LOG.info(this.LOCALIZATIONMANAGER.getLocalizedString("configuration.log.info.properties.enter"));
            System.out.print(this.LOCALIZATIONMANAGER.getLocalizedString("configuration.log.info.properties.cli") + " ");
            includeServerProperties = this.UTILITIES.BooleanUtils().readBoolean();
            LOG.info(String.format(this.LOCALIZATIONMANAGER.getLocalizedString("configuration.log.info.checkreturn"), includeServerProperties));
            System.out.println();
            LOG.info(this.LOCALIZATIONMANAGER.getLocalizedString("configuration.log.info.zip.enter"));
            System.out.print(this.LOCALIZATIONMANAGER.getLocalizedString("configuration.log.info.zip.cli") + " ");
            includeZipCreation = this.UTILITIES.BooleanUtils().readBoolean();
            LOG.info(String.format(this.LOCALIZATIONMANAGER.getLocalizedString("configuration.log.info.checkreturn"), includeZipCreation));
            LOG.info(this.LOCALIZATIONMANAGER.getLocalizedString("configuration.log.info.javaargs.cli"));
            System.out.print(this.LOCALIZATIONMANAGER.getLocalizedString("configuration.log.info.javaargs.enter"));
            javaArgs = reader.nextLine();
            if (javaArgs.isEmpty()) {
                javaArgs = "empty";
            }
            LOG.info(String.format(this.LOCALIZATIONMANAGER.getLocalizedString("configuration.log.info.printconfig.javaargs"), javaArgs));
            LOG.info(this.LOCALIZATIONMANAGER.getLocalizedString("configuration.log.info.serverpacksuffix.cli"));
            System.out.print(this.LOCALIZATIONMANAGER.getLocalizedString("configuration.log.info.serverpacksuffix.enter"));
            serverPackSuffix = reader.nextLine();
            this.CONFIGUTILITIES.printConfigurationModel(modpackDir, clientMods, copyDirs, includeServerInstallation, javaPath, minecraftVersion, modLoader, modLoaderVersion, includeServerIcon, includeServerProperties, includeZipCreation, javaArgs, serverPackSuffix, serverIconPath, serverPropertiesPath);
            LOG.info(this.LOCALIZATIONMANAGER.getLocalizedString("configuration.log.info.config.enter"));
            System.out.print(this.LOCALIZATIONMANAGER.getLocalizedString("configuration.log.info.answer") + " ");
        } while (!this.UTILITIES.BooleanUtils().readBoolean());
        reader.close();
        if (this.CONFIGUTILITIES.writeConfigToFile(modpackDir, Arrays.asList(tmpClientMods), Arrays.asList(tmpCopyDirs), serverIconPath, serverPropertiesPath, includeServerInstallation, javaPath, minecraftVersion, modLoader, modLoaderVersion, includeServerIcon, includeServerProperties, includeZipCreation, javaArgs, serverPackSuffix, this.APPLICATIONPROPERTIES.DEFAULT_CONFIG())) {
            LOG.info(this.LOCALIZATIONMANAGER.getLocalizedString("configuration.log.info.config.written"));
        }
    }
}

