/*
 * Decompiled with CFR 0.152.
 */
package de.griefed.serverpackcreator.utilities;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.griefed.serverpackcreator.ApplicationProperties;
import de.griefed.serverpackcreator.ConfigurationModel;
import de.griefed.serverpackcreator.i18n.LocalizationManager;
import de.griefed.serverpackcreator.utilities.common.Utilities;
import de.griefed.serverpackcreator.versionmeta.VersionMeta;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemAlreadyExistsException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.ProviderNotFoundException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ConfigUtilities {
    private static final Logger LOG = LogManager.getLogger(ConfigUtilities.class);
    private final LocalizationManager LOCALIZATIONMANAGER;
    private final Utilities UTILITIES;
    private final ApplicationProperties APPLICATIONPROPERTIES;
    private final VersionMeta VERSIONMETA;

    @Autowired
    public ConfigUtilities(LocalizationManager injectedLocalizationManager, Utilities injectedUtilities, ApplicationProperties injectedApplicationProperties, VersionMeta injectedVersionMeta) throws IOException {
        this.APPLICATIONPROPERTIES = injectedApplicationProperties == null ? new ApplicationProperties() : injectedApplicationProperties;
        this.LOCALIZATIONMANAGER = injectedLocalizationManager == null ? new LocalizationManager(this.APPLICATIONPROPERTIES) : injectedLocalizationManager;
        this.UTILITIES = injectedUtilities == null ? new Utilities(this.LOCALIZATIONMANAGER, this.APPLICATIONPROPERTIES) : injectedUtilities;
        this.VERSIONMETA = injectedVersionMeta == null ? new VersionMeta(this.APPLICATIONPROPERTIES.MINECRAFT_VERSION_MANIFEST_LOCATION(), this.APPLICATIONPROPERTIES.FORGE_VERSION_MANIFEST_LOCATION(), this.APPLICATIONPROPERTIES.FABRIC_VERSION_MANIFEST_LOCATION(), this.APPLICATIONPROPERTIES.FABRIC_INSTALLER_VERSION_MANIFEST_LOCATION(), this.APPLICATIONPROPERTIES.QUILT_VERSION_MANIFEST_LOCATION(), this.APPLICATIONPROPERTIES.QUILT_INSTALLER_VERSION_MANIFEST_LOCATION()) : injectedVersionMeta;
    }

    public String getModLoaderCase(String modloader) {
        if (modloader.equalsIgnoreCase("Forge")) {
            return "Forge";
        }
        if (modloader.equalsIgnoreCase("Fabric")) {
            return "Fabric";
        }
        if (modloader.toLowerCase().contains("forge")) {
            return "Forge";
        }
        if (modloader.toLowerCase().contains("fabric")) {
            return "Fabric";
        }
        return "Forge";
    }

    public boolean writeConfigToFile(ConfigurationModel configurationModel, File fileName) {
        return this.writeConfigToFile(configurationModel.getModpackDir(), configurationModel.getClientMods(), configurationModel.getCopyDirs(), configurationModel.getServerIconPath(), configurationModel.getServerPropertiesPath(), configurationModel.getIncludeServerInstallation(), configurationModel.getJavaPath(), configurationModel.getMinecraftVersion(), configurationModel.getModLoader(), configurationModel.getModLoaderVersion(), configurationModel.getIncludeServerIcon(), configurationModel.getIncludeServerProperties(), configurationModel.getIncludeZipCreation(), configurationModel.getJavaArgs(), configurationModel.getServerPackSuffix(), fileName);
    }

    public boolean writeConfigToFile(String modpackDir, List<String> clientMods, List<String> copyDirs, String serverIconPath, String serverPropertiesPath, boolean includeServer, String javaPath, String minecraftVersion, String modLoader, String modLoaderVersion, boolean includeIcon, boolean includeProperties, boolean includeZip, String javaArgs, String serverPackSuffix, File fileName) {
        boolean configWritten = false;
        String configString = String.format("%s\nmodpackDir = \"%s\"\n\n%s\nclientMods = %s\n\n%s\ncopyDirs = %s\n\n%s\nserverIconPath = \"%s\"\n\n%s\nserverPropertiesPath = \"%s\"\n\n%s\nincludeServerInstallation = %b\n\n%s\njavaPath = \"%s\"\n\n%s\nminecraftVersion = \"%s\"\n\n%s\nmodLoader = \"%s\"\n\n%s\nmodLoaderVersion = \"%s\"\n\n%s\nincludeServerIcon = %b\n\n%s\nincludeServerProperties = %b\n\n%s\nincludeZipCreation = %b\n\n%s\njavaArgs = \"%s\"\n\n%s\nserverPackSuffix = \"%s\"", this.LOCALIZATIONMANAGER.getLocalizedString("configuration.writeconfigtofile.modpackdir"), modpackDir.replace("\\", "/"), this.LOCALIZATIONMANAGER.getLocalizedString("configuration.writeconfigtofile.clientmods"), this.UTILITIES.ListUtils().encapsulateListElements(this.UTILITIES.ListUtils().cleanList(clientMods)), this.LOCALIZATIONMANAGER.getLocalizedString("configuration.writeconfigtofile.copydirs"), this.UTILITIES.ListUtils().encapsulateListElements(this.UTILITIES.ListUtils().cleanList(copyDirs)), this.LOCALIZATIONMANAGER.getLocalizedString("configuration.writeconfigtofile.custom.icon"), serverIconPath, this.LOCALIZATIONMANAGER.getLocalizedString("configuration.writeconfigtofile.custom.properties"), serverPropertiesPath, this.LOCALIZATIONMANAGER.getLocalizedString("configuration.writeconfigtofile.includeserverinstallation"), includeServer, this.LOCALIZATIONMANAGER.getLocalizedString("configuration.writeconfigtofile.javapath"), javaPath.replace("\\", "/"), this.LOCALIZATIONMANAGER.getLocalizedString("configuration.writeconfigtofile.minecraftversion"), minecraftVersion, this.LOCALIZATIONMANAGER.getLocalizedString("configuration.writeconfigtofile.modloader"), modLoader, this.LOCALIZATIONMANAGER.getLocalizedString("configuration.writeconfigtofile.modloaderversion"), modLoaderVersion, this.LOCALIZATIONMANAGER.getLocalizedString("configuration.writeconfigtofile.includeservericon"), includeIcon, this.LOCALIZATIONMANAGER.getLocalizedString("configuration.writeconfigtofile.includeserverproperties"), includeProperties, this.LOCALIZATIONMANAGER.getLocalizedString("configuration.writeconfigtofile.includezipcreation"), includeZip, this.LOCALIZATIONMANAGER.getLocalizedString("configuration.writeconfigtofile.javaargs"), javaArgs, this.LOCALIZATIONMANAGER.getLocalizedString("configuration.writeconfigtofile.serverpacksuffix"), serverPackSuffix);
        if (fileName.exists()) {
            FileUtils.deleteQuietly(fileName);
        }
        try {
            BufferedWriter writer = new BufferedWriter(new FileWriter(fileName));
            writer.write(configString);
            writer.close();
            configWritten = true;
            LOG.info(this.LOCALIZATIONMANAGER.getLocalizedString("defaultfiles.log.info.writeconfigtofile.confignew"));
        }
        catch (IOException ex) {
            LOG.error(this.LOCALIZATIONMANAGER.getLocalizedString("defaultfiles.log.error.writeconfigtofile"), (Throwable)ex);
        }
        return configWritten;
    }

    @Deprecated
    public List<String> getConfigurationAsList(ConfigurationModel configurationModel) {
        ArrayList<String> configurationAsList = new ArrayList<String>(100);
        configurationAsList.add(configurationModel.getModpackDir());
        configurationAsList.add(this.UTILITIES.StringUtils().buildString(configurationModel.getClientMods()));
        configurationAsList.add(this.UTILITIES.StringUtils().buildString(configurationModel.getCopyDirs()));
        configurationAsList.add(configurationModel.getJavaPath());
        configurationAsList.add(configurationModel.getMinecraftVersion());
        configurationAsList.add(configurationModel.getModLoader());
        configurationAsList.add(configurationModel.getModLoaderVersion());
        configurationAsList.add(String.valueOf(configurationModel.getIncludeServerInstallation()));
        configurationAsList.add(String.valueOf(configurationModel.getIncludeServerIcon()));
        configurationAsList.add(String.valueOf(configurationModel.getIncludeServerProperties()));
        configurationAsList.add(String.valueOf(configurationModel.getIncludeZipCreation()));
        LOG.debug(String.format("Configuration to pass to addons is: %s", configurationAsList));
        return configurationAsList;
    }

    public void printConfigurationModel(ConfigurationModel configurationModel) {
        this.printConfigurationModel(configurationModel.getModpackDir(), configurationModel.getClientMods(), configurationModel.getCopyDirs(), configurationModel.getIncludeServerInstallation(), configurationModel.getJavaPath(), configurationModel.getMinecraftVersion(), configurationModel.getModLoader(), configurationModel.getModLoaderVersion(), configurationModel.getIncludeServerIcon(), configurationModel.getIncludeServerProperties(), configurationModel.getIncludeZipCreation(), configurationModel.getJavaArgs(), configurationModel.getServerPackSuffix(), configurationModel.getServerIconPath(), configurationModel.getServerPropertiesPath());
    }

    public void printConfigurationModel(String modpackDirectory, List<String> clientsideMods, List<String> copyDirectories, boolean installServer, String javaInstallPath, String minecraftVer, String modloader, String modloaderVersion, boolean includeIcon, boolean includeProperties, boolean includeZip, String javaArgs, String serverPackSuffix, String serverIconPath, String serverPropertiesPath) {
        LOG.info(this.LOCALIZATIONMANAGER.getLocalizedString("configuration.log.info.printconfig.start"));
        LOG.info(String.format(this.LOCALIZATIONMANAGER.getLocalizedString("configuration.log.info.printconfig.modpackdir"), modpackDirectory));
        if (clientsideMods.isEmpty()) {
            LOG.warn(this.LOCALIZATIONMANAGER.getLocalizedString("configuration.log.warn.printconfig.noclientmods"));
        } else {
            LOG.info(this.LOCALIZATIONMANAGER.getLocalizedString("configuration.log.info.printconfig.clientmods"));
            for (String mod : clientsideMods) {
                LOG.info(String.format("    %s", mod));
            }
        }
        LOG.info(this.LOCALIZATIONMANAGER.getLocalizedString("configuration.log.info.printconfig.copydirs"));
        if (copyDirectories != null) {
            for (String directory : copyDirectories) {
                LOG.info(String.format("    %s", directory));
            }
        } else {
            LOG.error(this.LOCALIZATIONMANAGER.getLocalizedString("configuration.log.error.printconfig.copydirs"));
        }
        LOG.info(String.format(this.LOCALIZATIONMANAGER.getLocalizedString("configuration.log.info.printconfig.server"), installServer));
        LOG.info(String.format(this.LOCALIZATIONMANAGER.getLocalizedString("configuration.log.info.printconfig.javapath"), javaInstallPath));
        LOG.info(String.format(this.LOCALIZATIONMANAGER.getLocalizedString("configuration.log.info.printconfig.minecraftversion"), minecraftVer));
        LOG.info(String.format(this.LOCALIZATIONMANAGER.getLocalizedString("configuration.log.info.printconfig.modloader"), modloader));
        LOG.info(String.format(this.LOCALIZATIONMANAGER.getLocalizedString("configuration.log.info.printconfig.modloaderversion"), modloaderVersion));
        LOG.info(String.format(this.LOCALIZATIONMANAGER.getLocalizedString("configuration.log.info.printconfig.icon"), includeIcon));
        LOG.info(String.format(this.LOCALIZATIONMANAGER.getLocalizedString("configuration.log.info.printconfig.properties"), includeProperties));
        LOG.info(String.format(this.LOCALIZATIONMANAGER.getLocalizedString("configuration.log.info.printconfig.zip"), includeZip));
        LOG.info(String.format(this.LOCALIZATIONMANAGER.getLocalizedString("configuration.log.info.printconfig.javaargs"), javaArgs));
        LOG.info(String.format(this.LOCALIZATIONMANAGER.getLocalizedString("configuration.log.info.printconfig.serverpacksuffix"), serverPackSuffix));
        LOG.info(String.format(this.LOCALIZATIONMANAGER.getLocalizedString("utilities.log.info.config.print.servericon"), serverIconPath));
        LOG.info(String.format(this.LOCALIZATIONMANAGER.getLocalizedString("utilities.log.info.config.print.serverproperties"), serverPropertiesPath));
    }

    public void updateConfigModelFromCurseManifest(ConfigurationModel configurationModel, File manifest) throws IOException {
        configurationModel.setCurseModpack(this.getJson(manifest));
        String[] modloaderAndVersion = configurationModel.getCurseModpack().get("minecraft").get("modLoaders").get(0).get("id").asText().split("-");
        configurationModel.setMinecraftVersion(configurationModel.getCurseModpack().get("minecraft").get("version").asText());
        if (this.checkCurseForgeJsonForFabric(configurationModel.getCurseModpack())) {
            if (modloaderAndVersion[0].equalsIgnoreCase("Fabric")) {
                configurationModel.setModLoader("Fabric");
                configurationModel.setModLoaderVersion(modloaderAndVersion[1]);
            } else {
                LOG.info(this.LOCALIZATIONMANAGER.getLocalizedString("configuration.log.info.iscurse.fabric"));
                LOG.debug(this.LOCALIZATIONMANAGER.getLocalizedString("configuration.log.debug.modloader.forge"));
                configurationModel.setModLoader("Fabric");
                configurationModel.setModLoaderVersion(this.VERSIONMETA.fabric().releaseLoaderVersion());
            }
        } else {
            LOG.debug(this.LOCALIZATIONMANAGER.getLocalizedString("configuration.log.debug.modloader.forge"));
            configurationModel.setModLoader("Forge");
            configurationModel.setModLoaderVersion(modloaderAndVersion[1]);
        }
    }

    public void updateConfigModelFromMinecraftInstance(ConfigurationModel configurationModel, File minecraftInstance) throws IOException {
        configurationModel.setCurseModpack(this.getJson(minecraftInstance));
        String[] modLoaderAndVersion = configurationModel.getCurseModpack().get("baseModLoader").get("name").asText().split("-");
        configurationModel.setModLoader(this.getModLoaderCase(modLoaderAndVersion[0]));
        configurationModel.setModLoaderVersion(modLoaderAndVersion[1]);
        configurationModel.setMinecraftVersion(configurationModel.getCurseModpack().get("baseModLoader").get("minecraftVersion").asText());
    }

    public void updateConfigModelFromConfigJson(ConfigurationModel configurationModel, File config) throws IOException {
        configurationModel.setCurseModpack(this.getJson(config));
        configurationModel.setModLoader(this.getModLoaderCase(configurationModel.getCurseModpack().get("loader").get("loaderType").asText()));
        configurationModel.setMinecraftVersion(configurationModel.getCurseModpack().get("loader").get("mcVersion").asText());
        if (configurationModel.getModLoader().equalsIgnoreCase("forge")) {
            configurationModel.setModLoaderVersion(configurationModel.getCurseModpack().get("loader").get("loaderVersion").asText().split("-")[1]);
        } else {
            configurationModel.setModLoaderVersion(configurationModel.getCurseModpack().get("loader").get("loaderVersion").asText());
        }
    }

    public void updateConfigModelFromMMCPack(ConfigurationModel configurationModel, File mmcPack) throws IOException {
        configurationModel.setCurseModpack(this.getJson(mmcPack));
        for (JsonNode jsonNode : configurationModel.getCurseModpack().get("components")) {
            if (jsonNode.get("uid").asText().equals("net.minecraft")) {
                configurationModel.setMinecraftVersion(jsonNode.get("version").asText());
                continue;
            }
            if (jsonNode.get("uid").asText().equals("net.minecraftforge")) {
                configurationModel.setModLoader("Forge");
                configurationModel.setModLoaderVersion(jsonNode.get("version").asText());
                continue;
            }
            if (!jsonNode.get("uid").asText().equals("net.fabricmc.fabric-loader")) continue;
            configurationModel.setModLoader("Fabric");
            configurationModel.setModLoaderVersion(jsonNode.get("version").asText());
        }
    }

    public String updateDestinationFromInstanceCfg(File instanceCfg) throws IOException {
        String name;
        try (InputStream inputStream = Files.newInputStream(instanceCfg.toPath(), new OpenOption[0]);){
            Properties properties = new Properties();
            properties.load(inputStream);
            name = properties.getProperty("name", null);
        }
        return name;
    }

    private JsonNode getJson(File jsonFile) throws IOException {
        return this.getObjectMapper().readTree(Files.readAllBytes(Paths.get(jsonFile.getAbsolutePath().replace("\\", "/"), new String[0])));
    }

    private ObjectMapper getObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        objectMapper.enable(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY);
        return objectMapper;
    }

    public List<String> suggestCopyDirs(String modpackDir) {
        LOG.info(this.LOCALIZATIONMANAGER.getLocalizedString("configuration.log.info.suggestcopydirs.start"));
        File[] listDirectoriesInModpack = new File(modpackDir).listFiles();
        ArrayList<String> dirsInModpack = new ArrayList<String>(100);
        try {
            assert (listDirectoriesInModpack != null);
            for (File dir : listDirectoriesInModpack) {
                if (!dir.isDirectory()) continue;
                dirsInModpack.add(dir.getName());
            }
        }
        catch (NullPointerException np) {
            LOG.error("Error: Something went wrong during the setup of the modpack. Copy dirs should never be empty. Please check the logs for errors and open an issue on https://github.com/Griefed/ServerPackCreator/issues.", (Throwable)np);
        }
        int idirs = 0;
        while (idirs < this.APPLICATIONPROPERTIES.getDirectoriesToExclude().size()) {
            int i2 = idirs++;
            dirsInModpack.removeIf(n -> n.contains(this.APPLICATIONPROPERTIES.getDirectoriesToExclude().get(i2)));
        }
        LOG.info(String.format(this.LOCALIZATIONMANAGER.getLocalizedString("configuration.log.info.suggestcopydirs.list"), dirsInModpack));
        return dirsInModpack;
    }

    public boolean checkCurseForgeJsonForFabric(JsonNode modpackJson) {
        for (int i2 = 0; i2 < modpackJson.get("files").size(); ++i2) {
            LOG.debug(String.format("Mod ID: %s", modpackJson.get("files").get(i2).get("projectID").asText()));
            LOG.debug(String.format("File ID: %s", modpackJson.get("files").get(i2).get("fileID").asText()));
            if (!modpackJson.get("files").get(i2).get("projectID").asText().equalsIgnoreCase("361988") && !modpackJson.get("files").get(i2).get("fileID").asText().equalsIgnoreCase("306612")) continue;
            LOG.info(this.LOCALIZATIONMANAGER.getLocalizedString("configuration.log.info.containsfabric"));
            return true;
        }
        String[] modloaderAndVersion = modpackJson.get("minecraft").get("modLoaders").get(0).get("id").asText().split("-");
        return modloaderAndVersion[0].equalsIgnoreCase("fabric");
    }

    public List<String> directoriesInModpackZip(Path zipURI) throws IllegalArgumentException, FileSystemAlreadyExistsException, ProviderNotFoundException, IOException, SecurityException {
        ArrayList<String> directories = new ArrayList<String>(100);
        LOG.debug("URI: " + zipURI);
        FileSystem fileSystems = FileSystems.newFileSystem(zipURI, null);
        fileSystems.getRootDirectories().forEach(root -> {
            LOG.debug("root: " + root);
            try (Stream<Path> paths = Files.walk(root, new FileVisitOption[0]);){
                paths.forEach(path -> {
                    if (path.toString().matches("^[/\\\\]\\w+[/\\\\]?$")) {
                        LOG.debug("Path in ZIP: " + path);
                        directories.add(path.toString().replace("/", ""));
                    }
                });
            }
            catch (IOException ex) {
                LOG.error("No root available.", (Throwable)ex);
            }
        });
        if (directories.isEmpty()) {
            Enumeration<? extends ZipEntry> entries;
            try (ZipFile zipFile = new ZipFile(zipURI.toString());){
                entries = zipFile.entries();
            }
            while (entries.hasMoreElements()) {
                ZipEntry zipEntry = entries.nextElement();
                LOG.debug("ZIP entry: " + zipEntry.getName());
                if (!zipEntry.getName().matches("^[/\\\\]\\w+[/\\\\]?$")) continue;
                directories.add(zipEntry.getName());
            }
        }
        fileSystems.close();
        return directories;
    }
}

