/*
 * Decompiled with CFR 0.152.
 */
package de.griefed.serverpackcreator.swing.utilities;

import de.griefed.serverpackcreator.utilities.misc.Generated;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JViewport;

@Generated
public class BackgroundPanel
extends JPanel {
    public static final int SCALED = 0;
    public static final int TILED = 1;
    public static final int ACTUAL = 2;
    private Paint painter;
    private Image image;
    private int style = 0;
    private float alignmentX = 0.5f;
    private float alignmentY = 0.5f;
    private boolean isTransparentAdd = true;

    public BackgroundPanel(Image image) {
        this(image, 0);
    }

    public BackgroundPanel(Image image, int style) {
        this.setImage(image);
        this.setStyle(style);
        this.setLayout(new BorderLayout());
    }

    public BackgroundPanel(Image image, int style, float alignmentX, float alignmentY) {
        this.setImage(image);
        this.setStyle(style);
        this.setImageAlignmentX(alignmentX);
        this.setImageAlignmentY(alignmentY);
        this.setLayout(new BorderLayout());
    }

    public BackgroundPanel(Paint painter) {
        this.setPaint(painter);
        this.setLayout(new BorderLayout());
    }

    public void setImage(Image image) {
        this.image = image;
        this.repaint();
    }

    public void setStyle(int style) {
        this.style = style;
        this.repaint();
    }

    public void setPaint(Paint painter) {
        this.painter = painter;
        this.repaint();
    }

    public void setImageAlignmentX(float alignmentX) {
        this.alignmentX = alignmentX > 1.0f ? 1.0f : Math.max(alignmentX, 0.0f);
        this.repaint();
    }

    public void setImageAlignmentY(float alignmentY) {
        this.alignmentY = alignmentY > 1.0f ? 1.0f : Math.max(alignmentY, 0.0f);
        this.repaint();
    }

    public void addComponent(JComponent component) {
        this.addComponent(component, null);
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.image == null) {
            return super.getPreferredSize();
        }
        return new Dimension(this.image.getWidth(null), this.image.getHeight(null));
    }

    public void addComponent(JComponent component, Object constraints) {
        if (this.isTransparentAdd) {
            this.makeComponentTransparent(component);
        }
        super.add((Component)component, constraints);
    }

    public void setTransparentAdd(boolean isTransparentAdd) {
        this.isTransparentAdd = isTransparentAdd;
    }

    private void makeComponentTransparent(JComponent component) {
        component.setOpaque(false);
        if (component instanceof JScrollPane) {
            JScrollPane scrollPane = (JScrollPane)component;
            JViewport viewport = scrollPane.getViewport();
            viewport.setOpaque(false);
            Component c = viewport.getView();
            if (c instanceof JComponent) {
                ((JComponent)c).setOpaque(false);
            }
        }
    }

    @Override
    protected void paintComponent(Graphics g2) {
        super.paintComponent(g2);
        if (this.painter != null) {
            Dimension d = this.getSize();
            Graphics2D g22 = (Graphics2D)g2;
            g22.setPaint(this.painter);
            g22.fill(new Rectangle(0, 0, d.width, d.height));
        }
        if (this.image == null) {
            return;
        }
        switch (this.style) {
            case 1: {
                this.drawTiled(g2);
                break;
            }
            case 2: {
                this.drawActual(g2);
                break;
            }
            default: {
                this.drawScaled(g2);
            }
        }
    }

    private void drawScaled(Graphics g2) {
        Dimension d = this.getSize();
        g2.drawImage(this.image, 0, 0, d.width, d.height, null);
    }

    private void drawTiled(Graphics g2) {
        Dimension d = this.getSize();
        int width = this.image.getWidth(null);
        int height = this.image.getHeight(null);
        for (int x = 0; x < d.width; x += width) {
            for (int y = 0; y < d.height; y += height) {
                g2.drawImage(this.image, x, y, null, null);
            }
        }
    }

    private void drawActual(Graphics g2) {
        Dimension d = this.getSize();
        Insets insets = this.getInsets();
        int width = d.width - insets.left - insets.right;
        int height = d.height - insets.top - insets.left;
        float x = (float)(width - this.image.getWidth(null)) * this.alignmentX;
        float y = (float)(height - this.image.getHeight(null)) * this.alignmentY;
        g2.drawImage(this.image, (int)x + insets.left, (int)y + insets.top, this);
    }
}

