/*
 * Decompiled with CFR 0.152.
 */
package de.griefed.serverpackcreator.swing;

import de.griefed.serverpackcreator.ApplicationProperties;
import de.griefed.serverpackcreator.ConfigurationHandler;
import de.griefed.serverpackcreator.ServerPackHandler;
import de.griefed.serverpackcreator.i18n.LocalizationManager;
import de.griefed.serverpackcreator.plugins.ApplicationPlugins;
import de.griefed.serverpackcreator.swing.MainMenuBar;
import de.griefed.serverpackcreator.swing.ServerPackCreatorSplash;
import de.griefed.serverpackcreator.swing.TabAddonsHandlerLog;
import de.griefed.serverpackcreator.swing.TabCreateServerPack;
import de.griefed.serverpackcreator.swing.TabServerPackCreatorLog;
import de.griefed.serverpackcreator.swing.themes.DarkTheme;
import de.griefed.serverpackcreator.swing.themes.LightTheme;
import de.griefed.serverpackcreator.swing.utilities.BackgroundPanel;
import de.griefed.serverpackcreator.utilities.ConfigUtilities;
import de.griefed.serverpackcreator.utilities.UpdateChecker;
import de.griefed.serverpackcreator.utilities.common.Utilities;
import de.griefed.serverpackcreator.utilities.misc.Generated;
import de.griefed.serverpackcreator.versionmeta.VersionMeta;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.Objects;
import java.util.Random;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import mdlaf.MaterialLookAndFeel;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Generated
public class ServerPackCreatorGui {
    private static final Logger LOG = LogManager.getLogger(ServerPackCreatorGui.class);
    private final ImageIcon ICON_SERVERPACKCREATOR_BANNER = new ImageIcon(Objects.requireNonNull(ServerPackCreatorGui.class.getResource("/de/griefed/resources/gui/banner.png")));
    private final Image ICON_SERVERPACKCREATOR = Toolkit.getDefaultToolkit().getImage(Objects.requireNonNull(ServerPackCreatorGui.class.getResource("/de/griefed/resources/gui/app.png")));
    private final Dimension DIMENSION_WINDOW = new Dimension(1050, 800);
    private final ApplicationProperties APPLICATIONPROPERTIES;
    private final ServerPackCreatorSplash SERVERPACKCREATORSPLASH;
    private final LightTheme LIGHTTHEME = new LightTheme();
    private final DarkTheme DARKTHEME = new DarkTheme();
    private final MaterialLookAndFeel LAF_LIGHT = new MaterialLookAndFeel(this.LIGHTTHEME);
    private final MaterialLookAndFeel LAF_DARK = new MaterialLookAndFeel(this.DARKTHEME);
    private final BackgroundPanel BACKGROUNDPANEL;
    private final JFrame FRAME_SERVERPACKCREATOR;
    private final TabCreateServerPack TAB_CREATESERVERPACK;
    private final JTabbedPane TABBEDPANE;
    private final MainMenuBar MENUBAR;
    private BufferedImage bufferedImage;

    public ServerPackCreatorGui(LocalizationManager injectedLocalizationManager, ConfigurationHandler injectedConfigurationHandler, ServerPackHandler injectedServerPackHandler, ApplicationProperties injectedApplicationProperties, VersionMeta injectedVersionMeta, Utilities injectedUtilities, UpdateChecker injectedUpdateChecker, ApplicationPlugins injectedPluginManager, ConfigUtilities injectedConfigUtilities, ServerPackCreatorSplash injectedServerPackCreatorSplash) throws IOException {
        this.SERVERPACKCREATORSPLASH = injectedServerPackCreatorSplash;
        this.SERVERPACKCREATORSPLASH.update(90);
        this.APPLICATIONPROPERTIES = injectedApplicationProperties == null ? new ApplicationProperties() : injectedApplicationProperties;
        LocalizationManager LOCALIZATIONMANAGER = injectedLocalizationManager == null ? new LocalizationManager(this.APPLICATIONPROPERTIES) : injectedLocalizationManager;
        VersionMeta VERSIONMETA = injectedVersionMeta == null ? new VersionMeta(this.APPLICATIONPROPERTIES.MINECRAFT_VERSION_MANIFEST_LOCATION(), this.APPLICATIONPROPERTIES.FORGE_VERSION_MANIFEST_LOCATION(), this.APPLICATIONPROPERTIES.FABRIC_VERSION_MANIFEST_LOCATION(), this.APPLICATIONPROPERTIES.FABRIC_INSTALLER_VERSION_MANIFEST_LOCATION(), this.APPLICATIONPROPERTIES.QUILT_VERSION_MANIFEST_LOCATION(), this.APPLICATIONPROPERTIES.QUILT_INSTALLER_VERSION_MANIFEST_LOCATION()) : injectedVersionMeta;
        Utilities UTILITIES = injectedUtilities == null ? new Utilities(LOCALIZATIONMANAGER, this.APPLICATIONPROPERTIES) : injectedUtilities;
        ConfigUtilities CONFIGUTILITIES = injectedConfigUtilities == null ? new ConfigUtilities(LOCALIZATIONMANAGER, UTILITIES, this.APPLICATIONPROPERTIES, VERSIONMETA) : injectedConfigUtilities;
        ConfigurationHandler CONFIGURATIONHANDLER = injectedConfigurationHandler == null ? new ConfigurationHandler(LOCALIZATIONMANAGER, VERSIONMETA, this.APPLICATIONPROPERTIES, UTILITIES, CONFIGUTILITIES) : injectedConfigurationHandler;
        ApplicationPlugins APPLICATIONPLUGINS = injectedPluginManager == null ? new ApplicationPlugins() : injectedPluginManager;
        ServerPackHandler CREATESERVERPACK = injectedServerPackHandler == null ? new ServerPackHandler(LOCALIZATIONMANAGER, this.APPLICATIONPROPERTIES, VERSIONMETA, UTILITIES, APPLICATIONPLUGINS) : injectedServerPackHandler;
        UpdateChecker UPDATECHECKER = injectedUpdateChecker == null ? new UpdateChecker() : injectedUpdateChecker;
        try {
            this.bufferedImage = ImageIO.read(Objects.requireNonNull(this.getClass().getResource("/de/griefed/resources/gui/tile" + new Random().nextInt(4) + ".jpg")));
        }
        catch (IOException ex) {
            LOG.error("Could not read image for tiling.", (Throwable)ex);
        }
        this.FRAME_SERVERPACKCREATOR = new JFrame(LOCALIZATIONMANAGER.getLocalizedString("createserverpack.gui.createandshowgui") + " - " + this.APPLICATIONPROPERTIES.SERVERPACKCREATOR_VERSION());
        this.TAB_CREATESERVERPACK = new TabCreateServerPack(LOCALIZATIONMANAGER, CONFIGURATIONHANDLER, CREATESERVERPACK, VERSIONMETA, this.APPLICATIONPROPERTIES, this.FRAME_SERVERPACKCREATOR, UTILITIES, APPLICATIONPLUGINS, CONFIGUTILITIES, this.DARKTHEME, this.LIGHTTHEME);
        TabServerPackCreatorLog TAB_LOG_SERVERPACKCREATOR = new TabServerPackCreatorLog(LOCALIZATIONMANAGER, this.APPLICATIONPROPERTIES, LOCALIZATIONMANAGER.getLocalizedString("createserverpack.gui.tabbedpane.serverpackcreatorlog.tooltip"));
        TabAddonsHandlerLog TAB_LOG_ADDONSHANDLER = new TabAddonsHandlerLog(LOCALIZATIONMANAGER.getLocalizedString("createserverpack.gui.tabbedpane.addonshandlerlog.tip"));
        this.BACKGROUNDPANEL = new BackgroundPanel(this.bufferedImage, 1, 0.0f, 0.0f);
        this.TABBEDPANE = new JTabbedPane(1);
        this.TABBEDPANE.addTab(LOCALIZATIONMANAGER.getLocalizedString("createserverpack.gui.tabbedpane.createserverpack.title"), null, this.TAB_CREATESERVERPACK, LOCALIZATIONMANAGER.getLocalizedString("createserverpack.gui.tabbedpane.createserverpack.tip"));
        this.TABBEDPANE.addTab(LOCALIZATIONMANAGER.getLocalizedString("createserverpack.gui.tabbedpane.serverpackcreatorlog.title"), null, TAB_LOG_SERVERPACKCREATOR, LOCALIZATIONMANAGER.getLocalizedString("createserverpack.gui.tabbedpane.serverpackcreatorlog.tip"));
        this.TABBEDPANE.addTab(LOCALIZATIONMANAGER.getLocalizedString("createserverpack.gui.tabbedpane.addonshandlerlog.title"), null, TAB_LOG_ADDONSHANDLER);
        this.TABBEDPANE.setMnemonicAt(0, 49);
        this.TABBEDPANE.setMnemonicAt(1, 50);
        this.TABBEDPANE.setMnemonicAt(2, 51);
        if (!APPLICATIONPLUGINS.pluginsTabExtension().isEmpty()) {
            APPLICATIONPLUGINS.pluginsTabExtension().forEach(plugin -> this.TABBEDPANE.addTab(plugin.getTabTitle(), plugin.getTabIcon(), plugin.getTab(), plugin.getTabTooltip()));
        } else {
            LOG.info("No TabbedPane addons to add.");
        }
        this.TABBEDPANE.setTabLayoutPolicy(1);
        this.MENUBAR = new MainMenuBar(LOCALIZATIONMANAGER, this.LIGHTTHEME, this.DARKTHEME, this.FRAME_SERVERPACKCREATOR, this.LAF_LIGHT, this.LAF_DARK, this.TAB_CREATESERVERPACK, this.TABBEDPANE, this.APPLICATIONPROPERTIES, UPDATECHECKER, UTILITIES);
        this.FRAME_SERVERPACKCREATOR.setJMenuBar(this.MENUBAR.createMenuBar());
    }

    public void mainGUI() {
        SwingUtilities.invokeLater(() -> {
            try {
                if (this.APPLICATIONPROPERTIES.getProperty("de.griefed.serverpackcreator.gui.darkmode").equals("true")) {
                    UIManager.setLookAndFeel(this.LAF_DARK);
                    MaterialLookAndFeel.changeTheme(this.DARKTHEME);
                } else {
                    UIManager.setLookAndFeel(this.LAF_LIGHT);
                    MaterialLookAndFeel.changeTheme(this.LIGHTTHEME);
                }
            }
            catch (UnsupportedLookAndFeelException ex) {
                LOG.error("Error: There was an error setting the look and feel.", (Throwable)ex);
            }
            this.SERVERPACKCREATORSPLASH.update(95);
            this.createAndShowGUI();
        });
    }

    private void createAndShowGUI() {
        this.SERVERPACKCREATORSPLASH.close();
        JLabel serverPackCreatorBanner = new JLabel(this.ICON_SERVERPACKCREATOR_BANNER);
        serverPackCreatorBanner.setOpaque(false);
        this.FRAME_SERVERPACKCREATOR.setDefaultCloseOperation(3);
        this.FRAME_SERVERPACKCREATOR.setContentPane(this.BACKGROUNDPANEL);
        this.FRAME_SERVERPACKCREATOR.setIconImage(this.ICON_SERVERPACKCREATOR);
        this.FRAME_SERVERPACKCREATOR.add((Component)serverPackCreatorBanner, "First");
        this.FRAME_SERVERPACKCREATOR.add((Component)this.TABBEDPANE, "Center");
        this.FRAME_SERVERPACKCREATOR.setSize(this.DIMENSION_WINDOW);
        this.FRAME_SERVERPACKCREATOR.setPreferredSize(this.DIMENSION_WINDOW);
        this.FRAME_SERVERPACKCREATOR.setLocationRelativeTo(null);
        this.FRAME_SERVERPACKCREATOR.setResizable(true);
        this.FRAME_SERVERPACKCREATOR.pack();
        SwingUtilities.updateComponentTreeUI(this.FRAME_SERVERPACKCREATOR);
        this.TABBEDPANE.setOpaque(true);
        this.FRAME_SERVERPACKCREATOR.setVisible(true);
        this.TAB_CREATESERVERPACK.validateInputFields();
        this.TAB_CREATESERVERPACK.updatePanelTheme();
        this.MENUBAR.displayUpdateDialog();
    }
}

