/*
 * Decompiled with CFR 0.152.
 */
package de.griefed.serverpackcreator.spring.zip;

import de.griefed.serverpackcreator.ConfigurationHandler;
import de.griefed.serverpackcreator.spring.NotificationResponse;
import de.griefed.serverpackcreator.spring.task.TaskSubmitter;
import de.griefed.serverpackcreator.utilities.ConfigUtilities;
import de.griefed.serverpackcreator.utilities.common.Utilities;
import de.griefed.serverpackcreator.versionmeta.VersionMeta;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class ZipService {
    private static final Logger LOG = LogManager.getLogger(ZipService.class);
    private final TaskSubmitter TASKSUBMITTER;
    private final ConfigurationHandler CONFIGURATIONHANDLER;
    private final Utilities UTILITIES;
    private final NotificationResponse NOTIFICATIONRESPONSE;
    private final VersionMeta VERSIONMETA;
    private final ConfigUtilities CONFIGUTILITIES;

    @Autowired
    public ZipService(TaskSubmitter injectedTaskSubmitter, ConfigurationHandler injectedConfigurationHandler, Utilities injectedUtilities, NotificationResponse injectedNotificationResponse, VersionMeta injectedVersionMeta, ConfigUtilities injectedConfigUtilities) {
        this.TASKSUBMITTER = injectedTaskSubmitter;
        this.CONFIGURATIONHANDLER = injectedConfigurationHandler;
        this.UTILITIES = injectedUtilities;
        this.NOTIFICATIONRESPONSE = injectedNotificationResponse;
        this.VERSIONMETA = injectedVersionMeta;
        this.CONFIGUTILITIES = injectedConfigUtilities;
    }

    protected Path saveUploadedFile(MultipartFile uploadedFile) throws IOException {
        byte[] fileBytes = uploadedFile.getBytes();
        Path zipPath = Paths.get("work/modpacks/" + uploadedFile.getOriginalFilename(), new String[0]);
        if (zipPath.toFile().isFile()) {
            int incrementation = 0;
            String substring = zipPath.toString().replace("\\", "/").substring(0, zipPath.toString().replace("\\", "/").length() - 4);
            while (new File(substring + "_" + incrementation + ".zip").isFile()) {
                ++incrementation;
            }
            zipPath = Paths.get(substring + "_" + incrementation + ".zip", new String[0]);
        }
        Files.write(zipPath, fileBytes, new OpenOption[0]);
        return zipPath;
    }

    protected String submitGenerationTask(String zipGenerationProperties) {
        String[] parameters = zipGenerationProperties.split("&");
        if (!parameters[0].substring(parameters[0].length() - 4).equalsIgnoreCase(".zip") || !new File("work/modpacks/" + parameters[0]).isFile()) {
            LOG.info("ZIP-archive work/modpacks/" + parameters[0] + " not found.");
            return this.NOTIFICATIONRESPONSE.zipResponse("ZIP-archive not found.", 5000, "error", "negative", parameters[0], false);
        }
        if (!this.VERSIONMETA.minecraft().checkMinecraftVersion(parameters[2])) {
            LOG.info("Minecraft version " + parameters[2] + " incorrect.");
            return this.NOTIFICATIONRESPONSE.zipResponse("Incorrect Minecraft version: " + parameters[2], 5000, "error", "negative", null, false);
        }
        if (this.CONFIGURATIONHANDLER.checkModloader(parameters[3])) {
            if (this.CONFIGUTILITIES.getModLoaderCase(parameters[3]).equals("Forge")) {
                if (!this.VERSIONMETA.forge().checkForgeAndMinecraftVersion(parameters[2], parameters[4])) {
                    LOG.info(parameters[3] + " version " + parameters[2] + "-" + parameters[4] + " incorrect.");
                    return this.NOTIFICATIONRESPONSE.zipResponse("Incorrect Forge version: " + parameters[2], 5000, "error", "negative", null, false);
                }
            } else if (!this.VERSIONMETA.fabric().checkFabricVersion(parameters[4])) {
                LOG.info(parameters[3] + " version " + parameters[4] + " incorrect.");
                return this.NOTIFICATIONRESPONSE.zipResponse("Incorrect Fabric version: " + parameters[4], 5000, "error", "negative", null, false);
            }
        } else {
            LOG.info("Modloader " + parameters[3] + " incorrect.");
            return this.NOTIFICATIONRESPONSE.zipResponse("Modloader incorrect: " + parameters[3], 5000, "error", "negative", null, false);
        }
        this.TASKSUBMITTER.generateZip(zipGenerationProperties);
        return this.NOTIFICATIONRESPONSE.zipResponse("Request submitted. Check the downloads section later on. Keep a look out for :" + parameters[0] + " in the File Disk Name column.", 7000, "info", "positive", parameters[0], true);
    }
}

