/*
 * Decompiled with CFR 0.152.
 */
package de.griefed.serverpackcreator.spring.task;

import de.griefed.serverpackcreator.ApplicationProperties;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.jms.artemis.ArtemisConfigurationCustomizer;
import org.springframework.context.annotation.Configuration;

@Configuration
public class ArtemisConfig
implements ArtemisConfigurationCustomizer {
    private final ApplicationProperties APPLICATIONPROPERTIES;

    @Autowired
    public ArtemisConfig(ApplicationProperties injectedApplicationProperties) {
        this.APPLICATIONPROPERTIES = injectedApplicationProperties;
    }

    @Override
    public void customize(org.apache.activemq.artemis.core.config.Configuration configuration) {
        if (configuration != null) {
            configuration.setMaxDiskUsage(this.APPLICATIONPROPERTIES.getQueueMaxDiskUsage());
            AddressSettings addressSettings = new AddressSettings();
            addressSettings.setDefaultConsumerWindowSize(0);
            configuration.addAddressesSetting("tasks.background", addressSettings);
            QueueConfiguration queueConfiguration = new QueueConfiguration("tasks.background");
            queueConfiguration.setAddress("tasks.background");
            queueConfiguration.setName("tasks.background");
            queueConfiguration.setLastValueKey("unique_id");
            queueConfiguration.setRoutingType(RoutingType.ANYCAST);
            configuration.addQueueConfiguration(queueConfiguration);
        }
    }
}

