/*
 * Decompiled with CFR 0.152.
 */
package de.griefed.serverpackcreator.spring;

import de.griefed.serverpackcreator.utilities.common.Utilities;
import de.griefed.serverpackcreator.versionmeta.VersionMeta;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@CrossOrigin(origins={"*"})
@RequestMapping(value={"/api/v1/versions"})
public class VersionsController {
    private final VersionMeta VERSIONMETA;
    private final Utilities UTILITIES;

    @Autowired
    public VersionsController(VersionMeta injectedVersionMeta, Utilities injectedUtilities) {
        this.VERSIONMETA = injectedVersionMeta;
        this.UTILITIES = injectedUtilities;
    }

    @GetMapping(value={"/minecraft"})
    public ResponseEntity<String> getAvailableMinecraftVersions() {
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().header("Content-Type", "application/json")).body("{\"minecraft\":" + this.UTILITIES.ListUtils().encapsulateListElements(this.VERSIONMETA.minecraft().releaseVersionsDescending()) + "}");
    }

    @GetMapping(value={"/forge/{minecraftversion}"})
    public ResponseEntity<String> getAvailableForgeVersions(@PathVariable(value="minecraftversion") String minecraftVersion) {
        if (this.VERSIONMETA.forge().availableForgeVersionsDescending(minecraftVersion).isPresent()) {
            return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().header("Content-Type", "application/json")).body("{\"forge\":" + this.UTILITIES.ListUtils().encapsulateListElements(this.VERSIONMETA.forge().availableForgeVersionsDescending(minecraftVersion).get()) + "}");
        }
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().header("Content-Type", "application/json")).body("{\"forge\":[]}");
    }

    @GetMapping(value={"/fabric"})
    public ResponseEntity<String> getAvailableFabricVersions() {
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().header("Content-Type", "application/json")).body("{\"fabric\":" + this.UTILITIES.ListUtils().encapsulateListElements(this.VERSIONMETA.fabric().loaderVersionsDescending()) + "}");
    }

    @GetMapping(value={"/fabric/installer"}, produces={"application/json"})
    public ResponseEntity<String> getAvailableFabricInstallerVersions() {
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().header("Content-Type", "application/json")).body("{\"release\":\"" + this.VERSIONMETA.fabric().releaseInstallerVersion() + "\",\"latest\":\"" + this.VERSIONMETA.fabric().releaseInstallerVersion() + "\"}");
    }

    @GetMapping(value={"/quilt"})
    public ResponseEntity<String> getAvailableQuiltVersions() {
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().header("Content-Type", "application/json")).body("{\"quilt\":" + this.UTILITIES.ListUtils().encapsulateListElements(this.VERSIONMETA.quilt().loaderVersionsDescending()) + "}");
    }

    @GetMapping(value={"/quilt/installer"}, produces={"application/json"})
    public ResponseEntity<String> getAvailableQuiltInstallerVersions() {
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().header("Content-Type", "application/json")).body("{\"release\":\"" + this.VERSIONMETA.quilt().releaseInstallerVersion() + "\",\"latest\":\"" + this.VERSIONMETA.quilt().releaseInstallerVersion() + "\"}");
    }
}

