/*
 * Decompiled with CFR 0.152.
 */
package de.griefed.serverpackcreator;

import com.fasterxml.jackson.core.json.JsonReadFeature;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.moandjiezana.toml.Toml;
import de.griefed.serverpackcreator.ApplicationProperties;
import de.griefed.serverpackcreator.ConfigurationModel;
import de.griefed.serverpackcreator.i18n.LocalizationManager;
import de.griefed.serverpackcreator.plugins.ApplicationPlugins;
import de.griefed.serverpackcreator.spring.serverpack.ServerPackModel;
import de.griefed.serverpackcreator.utilities.common.Utilities;
import de.griefed.serverpackcreator.versionmeta.VersionMeta;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.math.BigInteger;
import java.nio.file.DirectoryNotEmptyException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.stream.Stream;
import javax.imageio.ImageIO;
import net.lingala.zip4j.ZipFile;
import net.lingala.zip4j.model.ExcludeFileFilter;
import net.lingala.zip4j.model.ZipParameters;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.time.StopWatch;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ServerPackHandler {
    private static final Logger LOG = LogManager.getLogger(ServerPackHandler.class);
    private static final Logger LOG_ADDONS = LogManager.getLogger("AddonsLogger");
    private static final Logger LOG_INSTALLER = LogManager.getLogger("InstallerLogger");
    private final LocalizationManager LOCALIZATIONMANAGER;
    private final VersionMeta VERSIONMETA;
    private final ApplicationProperties APPLICATIONPROPERTIES;
    private final Utilities UTILITIES;
    private final ApplicationPlugins APPLICATIONPLUGINS;
    private final StopWatch STOPWATCH_SCANS = new StopWatch();

    @Autowired
    public ServerPackHandler(LocalizationManager injectedLocalizationManager, ApplicationProperties injectedApplicationProperties, VersionMeta injectedVersionMeta, Utilities injectedUtilities, ApplicationPlugins injectedApplicationPlugins) throws IOException {
        this.APPLICATIONPROPERTIES = injectedApplicationProperties == null ? new ApplicationProperties() : injectedApplicationProperties;
        this.LOCALIZATIONMANAGER = injectedLocalizationManager == null ? new LocalizationManager(this.APPLICATIONPROPERTIES) : injectedLocalizationManager;
        this.VERSIONMETA = injectedVersionMeta == null ? new VersionMeta(this.APPLICATIONPROPERTIES.MINECRAFT_VERSION_MANIFEST_LOCATION(), this.APPLICATIONPROPERTIES.FORGE_VERSION_MANIFEST_LOCATION(), this.APPLICATIONPROPERTIES.FABRIC_VERSION_MANIFEST_LOCATION(), this.APPLICATIONPROPERTIES.FABRIC_INSTALLER_VERSION_MANIFEST_LOCATION(), this.APPLICATIONPROPERTIES.QUILT_VERSION_MANIFEST_LOCATION(), this.APPLICATIONPROPERTIES.QUILT_INSTALLER_VERSION_MANIFEST_LOCATION()) : injectedVersionMeta;
        this.UTILITIES = injectedUtilities == null ? new Utilities(this.LOCALIZATIONMANAGER, this.APPLICATIONPROPERTIES) : injectedUtilities;
        this.APPLICATIONPLUGINS = injectedApplicationPlugins == null ? new ApplicationPlugins() : injectedApplicationPlugins;
    }

    private ObjectMapper getObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        objectMapper.enable(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY);
        return objectMapper;
    }

    public ServerPackModel run(@NotNull ServerPackModel serverPackModel) {
        String destination = String.format("%s/%s", this.APPLICATIONPROPERTIES.getDirectoryServerPacks(), serverPackModel.getModpackDir().substring(serverPackModel.getModpackDir().lastIndexOf("/") + 1) + serverPackModel.getServerPackSuffix());
        this.run((ConfigurationModel)serverPackModel);
        this.cleanupEnvironment(false, destination);
        serverPackModel.setStatus("Available");
        serverPackModel.setSize(Double.parseDouble(String.valueOf(FileUtils.sizeOfAsBigInteger(new File(destination + "_server_pack.zip")).divide(BigInteger.valueOf(0x100000L)))));
        serverPackModel.setPath(destination + "_server_pack.zip");
        return serverPackModel;
    }

    public boolean run(@NotNull ConfigurationModel configurationModel) {
        String destination = new File(String.format("%s/%s", this.APPLICATIONPROPERTIES.getDirectoryServerPacks(), configurationModel.getModpackDir().substring(configurationModel.getModpackDir().lastIndexOf("/") + 1) + configurationModel.getServerPackSuffix())).getAbsolutePath().replace("\\", "/");
        if (this.APPLICATIONPROPERTIES.getProperty("de.griefed.serverpackcreator.serverpack.overwrite.enabled").equals("false") && new File(destination).exists()) {
            LOG.info(this.LOCALIZATIONMANAGER.getLocalizedString("createserverpack.log.info.overwrite"));
        } else {
            this.cleanupEnvironment(true, destination);
            try {
                Files.createDirectories(Paths.get(destination, new String[0]), new FileAttribute[0]);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (!this.APPLICATIONPLUGINS.pluginsPreGenExtension().isEmpty()) {
                LOG_ADDONS.info(this.LOCALIZATIONMANAGER.getLocalizedString("addons.log.info.execute.pregen"));
                this.APPLICATIONPLUGINS.pluginsPreGenExtension().forEach(plugin -> {
                    LOG_ADDONS.info(String.format(this.LOCALIZATIONMANAGER.getLocalizedString("addons.log.info.execute.addon"), plugin.getName()));
                    try {
                        plugin.run(this.APPLICATIONPROPERTIES, configurationModel, destination);
                    }
                    catch (Exception ex) {
                        LOG_ADDONS.error(String.format(this.LOCALIZATIONMANAGER.getLocalizedString("addons.log.error"), plugin.getName()), (Throwable)ex);
                    }
                });
            } else {
                LOG.info(this.LOCALIZATIONMANAGER.getLocalizedString("addons.log.info.execute.pregen.none"));
            }
            this.copyFiles(configurationModel.getModpackDir(), configurationModel.getCopyDirs(), configurationModel.getClientMods(), configurationModel.getMinecraftVersion(), destination, configurationModel.getModLoader());
            this.createStartScripts(configurationModel.getModLoader(), configurationModel.getJavaArgs(), configurationModel.getMinecraftVersion(), configurationModel.getModLoaderVersion(), destination);
            if (configurationModel.getModLoader().equalsIgnoreCase("Fabric")) {
                this.provideImprovedFabricServerLauncher(configurationModel.getMinecraftVersion(), configurationModel.getModLoaderVersion(), destination);
            }
            if (configurationModel.getIncludeServerIcon()) {
                this.copyIcon(destination, configurationModel.getServerIconPath());
            } else {
                LOG.info(this.LOCALIZATIONMANAGER.getLocalizedString("main.log.info.runincli.icon"));
            }
            if (configurationModel.getIncludeServerProperties()) {
                this.copyProperties(destination, configurationModel.getServerPropertiesPath());
            } else {
                LOG.info(this.LOCALIZATIONMANAGER.getLocalizedString("main.log.info.runincli.properties"));
            }
            if (!this.APPLICATIONPLUGINS.pluginsPreZipExtension().isEmpty()) {
                LOG_ADDONS.info(this.LOCALIZATIONMANAGER.getLocalizedString("addons.log.info.execute.prezip"));
                this.APPLICATIONPLUGINS.pluginsPreZipExtension().forEach(plugin -> {
                    LOG_ADDONS.info(String.format(this.LOCALIZATIONMANAGER.getLocalizedString("addons.log.info.execute.addon"), plugin.getName()));
                    try {
                        plugin.run(this.APPLICATIONPROPERTIES, configurationModel, destination);
                    }
                    catch (Exception ex) {
                        LOG_ADDONS.error(String.format(this.LOCALIZATIONMANAGER.getLocalizedString("addons.log.error"), plugin.getName()), (Throwable)ex);
                    }
                });
            } else {
                LOG.info(this.LOCALIZATIONMANAGER.getLocalizedString("addons.log.info.execute.prezip.none"));
            }
            if (configurationModel.getIncludeZipCreation()) {
                this.zipBuilder(configurationModel.getMinecraftVersion(), configurationModel.getIncludeServerInstallation(), destination, configurationModel.getModLoader(), configurationModel.getModLoaderVersion());
            } else {
                LOG.info(this.LOCALIZATIONMANAGER.getLocalizedString("main.log.info.runincli.zip"));
            }
            if (configurationModel.getIncludeServerInstallation()) {
                this.installServer(configurationModel.getModLoader(), configurationModel.getMinecraftVersion(), configurationModel.getModLoaderVersion(), configurationModel.getJavaPath(), destination);
            } else {
                LOG.info(this.LOCALIZATIONMANAGER.getLocalizedString("main.log.info.runincli.server"));
            }
            LOG.info(String.format(this.LOCALIZATIONMANAGER.getLocalizedString("main.log.info.runincli.serverpack"), destination));
            LOG.info(String.format(this.LOCALIZATIONMANAGER.getLocalizedString("main.log.info.runincli.archive"), destination));
            LOG.info(this.LOCALIZATIONMANAGER.getLocalizedString("main.log.info.runincli.finish"));
            if (!this.APPLICATIONPLUGINS.pluginsPostGenExtension().isEmpty()) {
                LOG_ADDONS.info(this.LOCALIZATIONMANAGER.getLocalizedString("addons.log.info.execute.postgen"));
                this.APPLICATIONPLUGINS.pluginsPostGenExtension().forEach(plugin -> {
                    LOG_ADDONS.info(String.format(this.LOCALIZATIONMANAGER.getLocalizedString("addons.log.info.execute.addon"), plugin.getName()));
                    try {
                        plugin.run(this.APPLICATIONPROPERTIES, configurationModel, destination);
                    }
                    catch (Exception ex) {
                        LOG_ADDONS.error(String.format(this.LOCALIZATIONMANAGER.getLocalizedString("addons.log.error"), plugin.getName()), (Throwable)ex);
                    }
                });
            } else {
                LOG.info(this.LOCALIZATIONMANAGER.getLocalizedString("addons.log.info.execute.postgen.none"));
            }
        }
        return true;
    }

    private void provideImprovedFabricServerLauncher(String minecraftVersion, String fabricVersion, String destination) {
        String fileDestination = String.format("%s/fabric-server-launcher.jar", destination);
        if (this.VERSIONMETA.fabric().improvedLauncherUrl(minecraftVersion, fabricVersion).isPresent() && this.UTILITIES.WebUtils().downloadFile(fileDestination, this.VERSIONMETA.fabric().improvedLauncherUrl(minecraftVersion, fabricVersion).get())) {
            LOG.info(this.LOCALIZATIONMANAGER.getLocalizedString("createserverpack.log.info.fabric.improved"));
            try (BufferedWriter writer = new BufferedWriter(new FileWriter(String.valueOf(Paths.get(String.format("%s/SERVER_PACK_INFO.txt", destination), new String[0]))));){
                writer.write("If you are using this server pack on a managed server, meaning you can not execute scripts, please use the fabric-server-launcher.jar instead of the fabric-server-launch.jar. Note the extra \"er\" at the end of \"launcher\".\n");
                writer.write("This is the improved Fabric Server Launcher, which will take care of downloading and installing the Minecraft server and any and all libraries needed for running the Fabric server.\n");
                writer.write("\n");
                writer.write("The downside of this method is the occasional incompatibility of mods with the Fabric version, as the new Fabric Server Launcher always uses the latest available Fabric version.\n");
                writer.write("If a mod is incompatible with said latest Fabric version, contact the mod-author and ask them to remedy the situation.\n");
                writer.write("The official Fabric Discord had the following to add to this:\n");
                writer.write("    Fabric loader however is cross version, so unless there is a mod incompatibility (which usually involves the mod being broken / using non-api internals)\n");
                writer.write("    there is no good reason to use anything but the latest. I.e. the latest loader on any Minecraft version works with the new server launcher.");
            }
            catch (IOException ex) {
                LOG.error("Error downloading the improved Fabric server launcher.", (Throwable)ex);
            }
        }
    }

    private void cleanupEnvironment(boolean deleteZip, String destination) {
        LOG.info(this.LOCALIZATIONMANAGER.getLocalizedString("createserverpack.log.info.cleanupenvironment.folder.enter"));
        FileUtils.deleteQuietly(new File(destination));
        if (deleteZip) {
            LOG.info(this.LOCALIZATIONMANAGER.getLocalizedString("createserverpack.log.info.cleanupenvironment.zip.enter"));
            FileUtils.deleteQuietly(new File(String.format("%s_server_pack.zip", destination)));
        }
    }

    private void createStartScripts(String modLoader, String javaArguments, String minecraftVersion, String modloaderVersion, String destination) {
        if (javaArguments.equals("empty")) {
            javaArguments = "";
        }
        switch (modLoader) {
            case "Forge": {
                String[] minecraft = minecraftVersion.split("\\.");
                LOG.info(this.LOCALIZATIONMANAGER.getLocalizedString("createserverpack.log.info.copystartscripts.forge"));
                if (Integer.parseInt(minecraft[1]) < 17) {
                    this.forgeBatchScript(javaArguments, minecraftVersion, modloaderVersion, destination);
                    this.forgeShellScript(javaArguments, minecraftVersion, modloaderVersion, destination);
                    break;
                }
                this.forgeBatchScriptNewMC(javaArguments, minecraftVersion, modloaderVersion, destination);
                this.forgeShellScriptNewMC(javaArguments, minecraftVersion, modloaderVersion, destination);
                this.forgeJvmArgsTxt(javaArguments, destination);
                break;
            }
            case "Fabric": {
                LOG.info(this.LOCALIZATIONMANAGER.getLocalizedString("createserverpack.log.info.copystartscripts.fabric"));
                this.fabricBatchScript(javaArguments, minecraftVersion, modloaderVersion, destination);
                this.fabricShellScript(javaArguments, minecraftVersion, modloaderVersion, destination);
                break;
            }
            case "Quilt": {
                LOG.info(this.LOCALIZATIONMANAGER.getLocalizedString("createserverpack.log.info.copystartscripts.quilt"));
                this.quiltBatchScript(javaArguments, minecraftVersion, modloaderVersion, destination);
                this.quiltShellScript(javaArguments, minecraftVersion, modloaderVersion, destination);
                break;
            }
            default: {
                LOG.error(this.LOCALIZATIONMANAGER.getLocalizedString("configuration.log.error.checkmodloader"));
            }
        }
    }

    private void fabricShellScript(String javaArguments, String minecraftVersion, String modloaderVersion, String destination) {
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(String.valueOf(Paths.get(String.format("%s/%s", destination, this.APPLICATIONPROPERTIES.START_SCRIPT_LINUX()), new String[0]))));){
            if (!this.VERSIONMETA.minecraft().getServer(minecraftVersion).isPresent()) {
                LOG.error(this.LOCALIZATIONMANAGER.getLocalizedString("createserverpack.log.error.minecraft.server"));
                return;
            }
            writer.write("#!/usr/bin/env bash\n");
            writer.write("# Start script generated by ServerPackCreator.\n");
            writer.write("# This script checks for the Minecraft and Fabric JAR-Files, and if they are not found, they are downloaded and installed.\n");
            writer.write("# Should this server pack come with the improved Fabric Server Launcher, then it is used instead of the old one.\n");
            writer.write("# If everything is in order, the server is started.\n");
            writer.write("\n");
            writer.write("JAVA=\"java\"\n");
            writer.write("MINECRAFT=\"" + minecraftVersion + "\"\n");
            writer.write("FABRIC=\"" + modloaderVersion + "\"\n");
            writer.write("INSTALLER=\"" + this.VERSIONMETA.fabric().releaseInstallerVersion() + "\"\n");
            writer.write("ARGS=\"" + javaArguments + "\"\n");
            writer.write("OTHERARGS=\"-Dlog4j2.formatMsgNoLookups=true\"\n");
            writer.write("LAUNCHER=\"fabric-server-launch.jar\"");
            writer.write("\n");
            writer.write("if [[ -s \"fabric-server-launcher.jar\" ]];then\n");
            writer.write("\n");
            writer.write("  echo \"Improved Fabric Server Launcher found...\";\n");
            writer.write("  echo \"The improved launcher will be used to run this Fabric server.\";\n");
            writer.write("  LAUNCHER=\"fabric-server-launcher.jar\";\n");
            writer.write("\n");
            writer.write("elif [[ ! -s \"fabric-server-launch.jar\" ]];then\n");
            writer.write("\n");
            writer.write("  echo \"Fabric Server JAR-file not found. Downloading installer...\";\n");
            writer.write("  wget -O fabric-installer.jar https://maven.fabricmc.net/net/fabricmc/fabric-installer/$INSTALLER/fabric-installer-$INSTALLER.jar;\n");
            writer.write("\n");
            writer.write("  if [[ -s \"fabric-installer.jar\" ]];then\n");
            writer.write("\n");
            writer.write("    echo \"Installer downloaded. Installing...\";\n");
            writer.write("    $JAVA -jar fabric-installer.jar server -mcversion $MINECRAFT -loader $FABRIC -downloadMinecraft;\n");
            writer.write("\n");
            writer.write("    if [[ -s \"fabric-server-launch.jar\" ]];then\n");
            writer.write("      rm -rf .fabric-installer;\n");
            writer.write("      rm -f fabric-installer.jar;\n");
            writer.write("      echo \"Installation complete. fabric-installer.jar deleted.\";\n");
            writer.write("    fi\n");
            writer.write("\n");
            writer.write("  else\n");
            writer.write("    echo \"fabric-installer.jar not found. Maybe the Fabric servers are having trouble.\";\n");
            writer.write("    echo \"Please try again in a couple of minutes.\";\n");
            writer.write("  fi\n");
            writer.write("else\n");
            writer.write("  echo \"fabric-server-launch.jar present. Moving on...\";\n");
            writer.write("\n");
            writer.write("  if [[ ! -s \"server.jar\" ]];then\n");
            writer.write("    echo \"Minecraft Server JAR-file not found. Downloading...\";\n");
            writer.write("    wget -O server.jar " + this.VERSIONMETA.minecraft().getServer(minecraftVersion).get().url() + ";\n");
            writer.write("  else\n");
            writer.write("    echo \"server.jar present. Moving on...\";\n");
            writer.write("  fi\n");
            writer.write("\n");
            writer.write("fi\n");
            writer.write("\n");
            writer.write("if [[ ! -s \"eula.txt\" ]];then\n");
            writer.write("\n");
            writer.write("  echo \"Mojang's EULA has not yet been accepted. In order to run a Minecraft server, you must accept Mojang's EULA.\"\n");
            writer.write("  echo \"Mojang's EULA is available to read at https://account.mojang.com/documents/minecraft_eula\"\n");
            writer.write("  echo \"If you agree to Mojang's EULA then type 'I agree'\"\n");
            writer.write("\n");
            writer.write("  echo -n \"Response: \"\n");
            writer.write("  read ANSWER\n");
            writer.write("\n");
            writer.write("  if [[ \"$ANSWER\" = \"I agree\" ]]; then\n");
            writer.write("\n");
            writer.write("    echo \"User agreed to Mojang's EULA.\"\n");
            writer.write("    echo \"#By changing the setting below to TRUE you are indicating your agreement to our EULA (https://account.mojang.com/documents/minecraft_eula).\" > eula.txt;\n");
            writer.write("    echo \"eula=true\" >> eula.txt;\n");
            writer.write("\n");
            writer.write("  else\n");
            writer.write("    echo \"User did not agree to Mojang's EULA.\"\n");
            writer.write("    echo \"Entered: $ANSWER\"\n");
            writer.write("  fi\n");
            writer.write("\n");
            writer.write("else\n");
            writer.write("  echo \"eula.txt present. Moving on...\";\n");
            writer.write("fi\n");
            writer.write("\n");
            writer.write("echo \"Starting server...\";\n");
            writer.write("echo \"Minecraft version: $MINECRAFT\";\n");
            writer.write("echo \"Fabric version: $FABRIC\";\n");
            writer.write("echo \"Java version:\"\n");
            writer.write("$JAVA -version\n");
            writer.write("echo \"Java args: $ARGS\";\n");
            writer.write("\n");
            writer.write("$JAVA $OTHERARGS $ARGS -jar $LAUNCHER nogui");
        }
        catch (IOException ex) {
            LOG.error("Error generating shell-script for Fabric.", (Throwable)ex);
        }
    }

    private void fabricBatchScript(String javaArguments, String minecraftVersion, String modloaderVersion, String destination) {
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(String.valueOf(Paths.get(String.format("%s/%s", destination, this.APPLICATIONPROPERTIES.START_SCRIPT_WINDOWS()), new String[0]))));){
            if (!this.VERSIONMETA.minecraft().getServer(minecraftVersion).isPresent()) {
                LOG.error(this.LOCALIZATIONMANAGER.getLocalizedString("createserverpack.log.error.minecraft.server"));
                return;
            }
            writer.write(":: Start script generated by ServerPackCreator.\n");
            writer.write(":: This script checks for the Minecraft and Fabric JAR-Files, and if they are not found, they are downloaded and installed.\n");
            writer.write(":: Should this server pack come with the improved Fabric Server Launcher, then it is used instead of the old one.\n");
            writer.write(":: If everything is in order, the server is started.\n");
            writer.write("@ECHO off\n");
            writer.write("\n");
            writer.write("SET JAVA=\"java\"\n");
            writer.write("SET MINECRAFT=\"" + minecraftVersion + "\"\n");
            writer.write("SET FABRIC=\"" + modloaderVersion + "\"\n");
            writer.write("SET INSTALLER=\"" + this.VERSIONMETA.fabric().releaseInstallerVersion() + "\"\n");
            writer.write("SET ARGS=" + javaArguments + "\n");
            writer.write("SET OTHERARGS=\"-Dlog4j2.formatMsgNoLookups=true\"\n");
            writer.write("SET LAUNCHER=\"fabric-server-launch.jar\"\n");
            writer.write("SET AGREE=\"I agree\"\n");
            writer.write("\n");
            writer.write("IF EXIST fabric-server-launcher.jar (\n");
            writer.write("\n");
            writer.write("  ECHO Improved Fabric Server Launcher found...\n");
            writer.write("  ECHO The improved launcher will be used to run this Fabric server.\n");
            writer.write("  SET LAUNCHER=\"fabric-server-launcher.jar\"\n");
            writer.write("\n");
            writer.write(") ELSE (\n");
            writer.write("\n");
            writer.write("  IF NOT EXIST fabric-server-launch.jar (\n");
            writer.write("\n");
            writer.write("    ECHO Fabric Server JAR-file not found. Downloading installer...\n");
            writer.write("    powershell -Command \"(New-Object Net.WebClient).DownloadFile('https://maven.fabricmc.net/net/fabricmc/fabric-installer/%INSTALLER%/fabric-installer-%INSTALLER%.jar', 'fabric-installer.jar')\"\n");
            writer.write("\n");
            writer.write("    IF EXIST fabric-installer.jar (\n");
            writer.write("\n");
            writer.write("      ECHO Installer downloaded. Installing...\n");
            writer.write("      %JAVA% -jar fabric-installer.jar server -mcversion %MINECRAFT% -loader %FABRIC% -downloadMinecraft\n");
            writer.write("\n");
            writer.write("      IF EXIST fabric-server-launch.jar (\n");
            writer.write("        RMDIR /S /Q .fabric-installer\n");
            writer.write("        DEL fabric-installer.jar\n");
            writer.write("        ECHO Installation complete. fabric-installer.jar and installation files deleted.\n");
            writer.write("      )\n");
            writer.write("\n");
            writer.write("    ) ELSE (\n");
            writer.write("      ECHO fabric-installer.jar not found. Maybe the Fabric servers are having trouble.\n");
            writer.write("      ECHO Please try again in a couple of minutes.\n");
            writer.write("    )\n");
            writer.write("  ) ELSE (\n");
            writer.write("    ECHO fabric-server-launch.jar present. Moving on...\n");
            writer.write("\n");
            writer.write("    IF NOT EXIST server.jar (\n");
            writer.write("      ECHO Minecraft Server JAR-file not found. Downloading...\n");
            writer.write("      powershell -Command \"(New-Object Net.WebClient).DownloadFile('" + this.VERSIONMETA.minecraft().getServer(minecraftVersion).get().url() + "', 'server.jar')\"\n");
            writer.write("    ) ELSE (\n");
            writer.write("      ECHO server.jar present. Moving on...\n");
            writer.write("    )\n");
            writer.write("\n");
            writer.write("  )\n");
            writer.write("\n");
            writer.write(")\n");
            writer.write("\n");
            writer.write("IF NOT EXIST eula.txt (\n");
            writer.write("\n");
            writer.write("  ECHO Mojang's EULA has not yet been accepted. In order to run a Minecraft server, you must accept Mojang's EULA.\n");
            writer.write("  ECHO Mojang's EULA is available to read at https://account.mojang.com/documents/minecraft_eula\n");
            writer.write("  ECHO If you agree to Mojang's EULA then type \"I agree\"\n");
            writer.write("\n");
            writer.write("  set /P response=\"Response: \"\n");
            writer.write("\n");
            writer.write("  IF \"%response%\" == \"%AGREE%\" (\n");
            writer.write("\n");
            writer.write("    ECHO User agreed to Mojang's EULA.\n");
            writer.write("    ECHO #By changing the setting below to TRUE you are indicating your agreement to our EULA ^(https://account.mojang.com/documents/minecraft_eula^).> eula.txt\n");
            writer.write("    ECHO eula=true>> eula.txt\n");
            writer.write("\n");
            writer.write("  ) else (\n");
            writer.write("    ECHO User did not agree to Mojang's EULA. \n");
            writer.write("    ECHO Entered: %response%\n");
            writer.write("  )\n");
            writer.write("\n");
            writer.write(") ELSE (\n");
            writer.write("  ECHO eula.txt present. Moving on...\n");
            writer.write(")\n");
            writer.write("\n");
            writer.write("ECHO Starting server...\n");
            writer.write("ECHO Minecraft version: %MINECRAFT%\n");
            writer.write("ECHO Fabric version: %FABRIC%\n");
            writer.write("ECHO Java version:\n");
            writer.write("%JAVA% -version\n");
            writer.write("ECHO Java args: %ARGS%\n");
            writer.write("\n");
            writer.write("%JAVA% \"%OTHERARGS%\" %ARGS% -jar %LAUNCHER% nogui\n");
            writer.write("\n");
            writer.write("PAUSE");
        }
        catch (IOException ex) {
            LOG.error("Error generating batch-script for Fabric.", (Throwable)ex);
        }
    }

    private void quiltShellScript(String javaArguments, String minecraftVersion, String modloaderVersion, String destination) {
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(String.valueOf(Paths.get(String.format("%s/%s", destination, this.APPLICATIONPROPERTIES.START_SCRIPT_LINUX()), new String[0]))));){
            if (!this.VERSIONMETA.minecraft().getServer(minecraftVersion).isPresent()) {
                LOG.error(this.LOCALIZATIONMANAGER.getLocalizedString("createserverpack.log.error.minecraft.server"));
                return;
            }
            writer.write("#!/usr/bin/env bash\n");
            writer.write("# Start script generated by ServerPackCreator.\n");
            writer.write("# This script checks for the Minecraft and Quilt JAR-Files, and if they are not found, they are downloaded and installed.\n");
            writer.write("# If everything is in order, the server is started.\n");
            writer.write("\n");
            writer.write("JAVA=\"java\"\n");
            writer.write("MINECRAFT=\"" + minecraftVersion + "\"\n");
            writer.write("QUILT=\"" + modloaderVersion + "\"\n");
            writer.write("INSTALLER=\"" + this.VERSIONMETA.quilt().releaseInstallerVersion() + "\"\n");
            writer.write("ARGS=\"" + javaArguments + "\"\n");
            writer.write("OTHERARGS=\"-Dlog4j2.formatMsgNoLookups=true\"\n");
            writer.write("\n");
            writer.write("if [[ ! -s \"quilt-server-launch.jar\" ]];then\n");
            writer.write("\n");
            writer.write("  echo \"Quilt Server JAR-file not found. Downloading installer...\";\n");
            writer.write("  wget -O quilt-installer.jar https://maven.quiltmc.org/repository/release/org/quiltmc/quilt-installer/$INSTALLER/quilt-installer-$INSTALLER.jar;\n");
            writer.write("\n");
            writer.write("  if [[ -s \"quilt-installer.jar\" ]];then\n");
            writer.write("\n");
            writer.write("    echo \"Installer downloaded. Installing...\";\n");
            writer.write("    $JAVA -jar quilt-installer.jar install server $MINECRAFT --download-server --install-dir=.;\n");
            writer.write("    mv server/* .\n");
            writer.write("\n");
            writer.write("    if [[ -s \"quilt-server-launch.jar\" ]];then\n");
            writer.write("      rm quilt-installer.jar;\n");
            writer.write("      rm -r server;\n");
            writer.write("      echo \"Installation complete. quilt-installer.jar deleted.\";\n");
            writer.write("    fi\n");
            writer.write("\n");
            writer.write("  else\n");
            writer.write("    echo \"quilt-server-launch.jar not found. Maybe the Quilt servers are having trouble.\";\n");
            writer.write("    echo \"Please try again in a couple of minutes.\";\n");
            writer.write("  fi\n");
            writer.write("else\n");
            writer.write("  echo \"quilt-server-launch.jar present. Moving on...\";\n");
            writer.write("\n");
            writer.write("  if [[ ! -s \"server.jar\" ]];then\n");
            writer.write("    echo \"Minecraft Server JAR-file not found. Downloading...\";\n");
            writer.write("    wget -O server.jar " + this.VERSIONMETA.minecraft().getServer(minecraftVersion).get().url() + ";\n");
            writer.write("  else\n");
            writer.write("    echo \"server.jar present. Moving on...\";\n");
            writer.write("  fi\n");
            writer.write("\n");
            writer.write("fi\n");
            writer.write("\n");
            writer.write("if [[ ! -s \"eula.txt\" ]];then\n");
            writer.write("\n");
            writer.write("  echo \"Mojang's EULA has not yet been accepted. In order to run a Minecraft server, you must accept Mojang's EULA.\"\n");
            writer.write("  echo \"Mojang's EULA is available to read at https://account.mojang.com/documents/minecraft_eula\"\n");
            writer.write("  echo \"If you agree to Mojang's EULA then type 'I agree'\"\n");
            writer.write("\n");
            writer.write("  echo -n \"Response: \"\n");
            writer.write("  read ANSWER\n");
            writer.write("\n");
            writer.write("  if [[ \"$ANSWER\" = \"I agree\" ]]; then\n");
            writer.write("\n");
            writer.write("    echo \"User agreed to Mojang's EULA.\"\n");
            writer.write("    echo \"#By changing the setting below to TRUE you are indicating your agreement to our EULA (https://account.mojang.com/documents/minecraft_eula).\" > eula.txt;\n");
            writer.write("    echo \"eula=true\" >> eula.txt;\n");
            writer.write("\n");
            writer.write("  else\n");
            writer.write("    echo \"User did not agree to Mojang's EULA.\"\n");
            writer.write("    echo \"Entered: $ANSWER\"\n");
            writer.write("  fi\n");
            writer.write("\n");
            writer.write("else\n");
            writer.write("  echo \"eula.txt present. Moving on...\";\n");
            writer.write("fi\n");
            writer.write("\n");
            writer.write("echo \"Starting server...\";\n");
            writer.write("echo \"Minecraft version: $MINECRAFT\";\n");
            writer.write("echo \"Quilt version: $QUILT\";\n");
            writer.write("echo \"Java version:\"\n");
            writer.write("$JAVA -version\n");
            writer.write("echo \"Java args: $ARGS\";\n");
            writer.write("\n");
            writer.write("$JAVA $OTHERARGS $ARGS -jar quilt-server-launch.jar nogui");
        }
        catch (IOException ex) {
            LOG.error("Error generating shell-script for Quilt.", (Throwable)ex);
        }
    }

    private void quiltBatchScript(String javaArguments, String minecraftVersion, String modloaderVersion, String destination) {
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(String.valueOf(Paths.get(String.format("%s/%s", destination, this.APPLICATIONPROPERTIES.START_SCRIPT_WINDOWS()), new String[0]))));){
            if (!this.VERSIONMETA.minecraft().getServer(minecraftVersion).isPresent()) {
                LOG.error(this.LOCALIZATIONMANAGER.getLocalizedString("createserverpack.log.error.minecraft.server"));
                return;
            }
            writer.write(":: Start script generated by ServerPackCreator.\n");
            writer.write(":: This script checks for the Minecraft and Quilt JAR-Files, and if they are not found, they are downloaded and installed.\n");
            writer.write(":: If everything is in order, the server is started.\n");
            writer.write("@ECHO off\n");
            writer.write("\n");
            writer.write("SET JAVA=\"java\"\n");
            writer.write("SET MINECRAFT=\"" + minecraftVersion + "\"\n");
            writer.write("SET QUILT=\"" + modloaderVersion + "\"\n");
            writer.write("SET INSTALLER=\"" + this.VERSIONMETA.quilt().releaseInstallerVersion() + "\"\n");
            writer.write("SET ARGS=" + javaArguments + "\n");
            writer.write("SET OTHERARGS=\"-Dlog4j2.formatMsgNoLookups=true\"\n");
            writer.write("SET AGREE=\"I agree\"\n");
            writer.write("\n");
            writer.write("IF NOT EXIST quilt-server-launch.jar (\n");
            writer.write("\n");
            writer.write("  ECHO Quilt Server JAR-file not found. Downloading installer...\n");
            writer.write("  powershell -Command \"(New-Object Net.WebClient).DownloadFile('https://maven.quiltmc.org/repository/release/org/quiltmc/quilt-installer/%INSTALLER%/quilt-installer-%INSTALLER%.jar', 'quilt-installer.jar')\"\n");
            writer.write("\n");
            writer.write("  IF EXIST quilt-installer.jar (\n");
            writer.write("\n");
            writer.write("    ECHO Installer downloaded. Installing...\n");
            writer.write("    %JAVA% -jar quilt-installer.jar install server %MINECRAFT% --download-server --install-dir=.\n");
            writer.write("\n");
            writer.write("    IF EXIST quilt-server-launch.jar (\n");
            writer.write("      DEL quilt-installer.jar\n");
            writer.write("      ECHO Installation complete. quilt-installer.jar deleted.\n");
            writer.write("    )\n");
            writer.write("\n");
            writer.write("  ) ELSE (\n");
            writer.write("    ECHO quilt-installer.jar not found. Maybe the Quilt servers are having trouble.\n");
            writer.write("    ECHO Please try again in a couple of minutes.\n");
            writer.write("  )\n");
            writer.write(") ELSE (\n");
            writer.write("  ECHO quilt-server-launch.jar present. Moving on...\n");
            writer.write("\n");
            writer.write("  IF NOT EXIST server.jar (\n");
            writer.write("    ECHO Minecraft Server JAR-file not found. Downloading...\n");
            writer.write("    powershell -Command \"(New-Object Net.WebClient).DownloadFile('" + this.VERSIONMETA.minecraft().getServer(minecraftVersion).get().url() + "', 'server.jar')\"\n");
            writer.write("  ) ELSE (\n");
            writer.write("    ECHO server.jar present. Moving on...\n");
            writer.write("  )\n");
            writer.write("\n");
            writer.write(")\n");
            writer.write("\n");
            writer.write("IF NOT EXIST eula.txt (\n");
            writer.write("\n");
            writer.write("  ECHO Mojang's EULA has not yet been accepted. In order to run a Minecraft server, you must accept Mojang's EULA.\n");
            writer.write("  ECHO Mojang's EULA is available to read at https://account.mojang.com/documents/minecraft_eula\n");
            writer.write("  ECHO If you agree to Mojang's EULA then type \"I agree\"\n");
            writer.write("\n");
            writer.write("  set /P response=\"Response: \"\n");
            writer.write("\n");
            writer.write("  IF \"%response%\" == \"%AGREE%\" (\n");
            writer.write("\n");
            writer.write("    ECHO User agreed to Mojang's EULA.\n");
            writer.write("    ECHO #By changing the setting below to TRUE you are indicating your agreement to our EULA ^(https://account.mojang.com/documents/minecraft_eula^).> eula.txt\n");
            writer.write("    ECHO eula=true>> eula.txt\n");
            writer.write("\n");
            writer.write("  ) else (\n");
            writer.write("    ECHO User did not agree to Mojang's EULA. \n");
            writer.write("    ECHO Entered: %response%\n");
            writer.write("  )\n");
            writer.write("\n");
            writer.write(") ELSE (\n");
            writer.write("  ECHO eula.txt present. Moving on...\n");
            writer.write(")\n");
            writer.write("\n");
            writer.write("ECHO Starting server...\n");
            writer.write("ECHO Minecraft version: %MINECRAFT%\n");
            writer.write("ECHO Quilt version: %QUILT%\n");
            writer.write("ECHO Java version:\n");
            writer.write("%JAVA% -version\n");
            writer.write("ECHO Java args: %ARGS%\n");
            writer.write("\n");
            writer.write("%JAVA% \"%OTHERARGS%\" %ARGS% -jar quilt-server-launch.jar nogui\n");
            writer.write("\n");
            writer.write("PAUSE");
        }
        catch (IOException ex) {
            LOG.error("Error generating batch-script for Quilt.", (Throwable)ex);
        }
    }

    private void forgeJvmArgsTxt(String javaArguments, String destination) {
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(String.valueOf(Paths.get(String.format("%s/%s", destination, this.APPLICATIONPROPERTIES.USER_JVM_ARGS()), new String[0]))));){
            writer.write("# Xmx and Xms set the maximum and minimum RAM usage, respectively.\n");
            writer.write("# They can take any number, followed by an M or a G.\n");
            writer.write("# M means Megabyte, G means Gigabyte.\n");
            writer.write("# For example, to set the maximum to 3GB: -Xmx3G\n");
            writer.write("# To set the minimum to 2.5GB: -Xms2500M\n");
            writer.write("\n");
            writer.write("# A good default for a modded server is 4GB.\n");
            writer.write("# Uncomment the next line to set it.\n");
            writer.write("# -Xmx4G\n");
            writer.write(javaArguments);
        }
        catch (IOException ex) {
            LOG.error("Error generating user_jvm_args.txt for Forge.", (Throwable)ex);
        }
    }

    private void forgeShellScriptNewMC(String javaArguments, String minecraftVersion, String modloaderVersion, String destination) {
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(String.valueOf(Paths.get(String.format("%s/%s", destination, this.APPLICATIONPROPERTIES.START_SCRIPT_LINUX()), new String[0]))));){
            if (!this.VERSIONMETA.minecraft().getServer(minecraftVersion).isPresent()) {
                LOG.error(this.LOCALIZATIONMANAGER.getLocalizedString("createserverpack.log.error.minecraft.server"));
                return;
            }
            writer.write("#!/usr/bin/env bash\n");
            writer.write("# Start script generated by ServerPackCreator.\n");
            writer.write("# This script checks for the Minecraft and Forge JAR-files, and if they are not found, they are downloaded and installed.\n");
            writer.write("# If everything is in order, the server is started.\n");
            writer.write("\n");
            writer.write("JAVA=\"java\"\n");
            writer.write("MINECRAFT=\"" + minecraftVersion + "\"\n");
            writer.write("FORGE=\"" + modloaderVersion + "\"\n");
            writer.write("ARGS=\"" + javaArguments + "\"\n");
            writer.write("OTHERARGS=\"-Dlog4j2.formatMsgNoLookups=true\"\n");
            writer.write("\n");
            writer.write("if [[ ! -s \"libraries/net/minecraftforge/forge/$MINECRAFT-$FORGE/forge-$MINECRAFT-$FORGE-server.jar\" ]];then\n");
            writer.write("\n");
            writer.write("  echo \"Forge Server JAR-file not found. Downloading installer...\";\n");
            writer.write("  wget -O forge-installer.jar https://files.minecraftforge.net/maven/net/minecraftforge/forge/$MINECRAFT-$FORGE/forge-$MINECRAFT-$FORGE-installer.jar;\n");
            writer.write("\n");
            writer.write("  if [[ -s \"forge-installer.jar\" ]]; then\n");
            writer.write("\n");
            writer.write("    echo \"Installer downloaded. Installing...\";\n");
            writer.write("    $JAVA -jar forge-installer.jar --installServer;\n");
            writer.write("\n");
            writer.write("    if [[ -s \"libraries/net/minecraftforge/forge/$MINECRAFT-$FORGE/forge-$MINECRAFT-$FORGE-server.jar\" ]];then\n");
            writer.write("      rm -f forge-installer.jar;\n");
            writer.write("      echo \"Installation complete. forge-installer.jar deleted.\";\n");
            writer.write("    fi\n");
            writer.write("\n");
            writer.write("  else\n");
            writer.write("    echo \"forge-installer.jar not found. Maybe the Forge servers are having trouble.\";\n");
            writer.write("    echo \"Please try again in a couple of minutes.\";\n");
            writer.write("  fi\n");
            writer.write("else\n");
            writer.write("  echo \"Forge server present. Moving on...\"\n");
            writer.write("fi\n");
            writer.write("\n");
            writer.write("if [[ ! -s \"libraries/net/minecraft/server/$MINECRAFT/server-$MINECRAFT.jar\" ]];then\n");
            writer.write("  echo \"Minecraft Server JAR-file not found. Downloading...\";\n");
            writer.write("  wget -O libraries/net/minecraft/server/$MINECRAFT/server-$MINECRAFT.jar " + this.VERSIONMETA.minecraft().getServer(minecraftVersion).get().url() + ";\n");
            writer.write("else\n");
            writer.write("  echo \"Minecraft server present. Moving on...\"\n");
            writer.write("fi\n");
            writer.write("\n");
            writer.write("if [[ -s \"run.bat\" ]];then\n");
            writer.write("  rm -f run.bat;\n");
            writer.write("  echo \"Deleted run.bat as we already have start.bat\";\n");
            writer.write("fi\n");
            writer.write("if [[ -s \"run.sh\" ]];then\n");
            writer.write("  rm -f run.sh;\n");
            writer.write("  echo \"Deleted run.sh as we already have start.sh\";\n");
            writer.write("fi\n");
            writer.write("\n");
            writer.write("if [[ ! -s \"eula.txt\" ]];then\n");
            writer.write("  echo \"Mojang's EULA has not yet been accepted. In order to run a Minecraft server, you must accept Mojang's EULA.\"\n");
            writer.write("  echo \"Mojang's EULA is available to read at https://account.mojang.com/documents/minecraft_eula\"\n");
            writer.write("  echo \"If you agree to Mojang's EULA then type 'I agree'\"\n");
            writer.write("\n");
            writer.write("  echo -n \"Response: \"\n");
            writer.write("  read ANSWER\n");
            writer.write("\n");
            writer.write("  if [[ \"$ANSWER\" = \"I agree\" ]]; then\n");
            writer.write("    echo \"User agreed to Mojang's EULA.\"\n");
            writer.write("    echo \"#By changing the setting below to TRUE you are indicating your agreement to our EULA (https://account.mojang.com/documents/minecraft_eula).\" > eula.txt;\n");
            writer.write("    echo \"eula=true\" >> eula.txt;\n");
            writer.write("  else\n");
            writer.write("    echo \"User did not agree to Mojang's EULA.\"\n");
            writer.write("    echo \"Entered: $ANSWER\"\n");
            writer.write("  fi\n");
            writer.write("else\n");
            writer.write("  echo \"eula.txt present. Moving on...\";\n");
            writer.write("fi\n");
            writer.write("\n");
            writer.write("echo \"Starting server...\";\n");
            writer.write("echo \"Minecraft version: $MINECRAFT\";\n");
            writer.write("echo \"Forge version: $FORGE\";\n");
            writer.write("echo \"Java version:\"\n");
            writer.write("$JAVA -version\n");
            writer.write("echo \"Java args in user_jvm_args.txt: $ARGS\";\n");
            writer.write("\n");
            writer.write("# Forge requires a configured set of both JVM and program arguments.\n");
            writer.write("# Add custom JVM arguments to the user_jvm_args.txt\n");
            writer.write("# Add custom program arguments {such as nogui} to this file in the next line before the \"$@\" or\n");
            writer.write("#  pass them to this script directly\n");
            writer.write("echo \"If you receive the error message 'Error: Could not find or load main class @user_jvm_args.txt' you may be using the wrong Java-version for this modded Minecraft server. Contact the modpack-developer or, if you made the server pack yourself, do a quick google-search for the used Minecraft version to find out which Java-version is required in order to run this server.\"\n");
            writer.write("\n");
            writer.write("$JAVA $OTHERARGS @user_jvm_args.txt @libraries/net/minecraftforge/forge/$MINECRAFT-$FORGE/unix_args.txt nogui \"$@\"");
        }
        catch (IOException ex) {
            LOG.error("Error generating shell-script for Forge.", (Throwable)ex);
        }
    }

    private void forgeBatchScriptNewMC(String javaArguments, String minecraftVersion, String modloaderVersion, String destination) {
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(String.valueOf(Paths.get(String.format("%s/%s", destination, this.APPLICATIONPROPERTIES.START_SCRIPT_WINDOWS()), new String[0]))));){
            if (!this.VERSIONMETA.minecraft().getServer(minecraftVersion).isPresent()) {
                LOG.error(this.LOCALIZATIONMANAGER.getLocalizedString("createserverpack.log.error.minecraft.server"));
                return;
            }
            writer.write(":: Start script generated by ServerPackCreator.\n");
            writer.write(":: This script checks for the Minecraft and Forge JAR-files, and if they are not found, they are downloaded and installed.\n");
            writer.write(":: If everything is in order, the server is started.\n");
            writer.write("@ECHO off\n");
            writer.write("SetLocal EnableDelayedExpansion\n");
            writer.write("\n");
            writer.write("SET JAVA=\"java\"\n");
            writer.write("SET MINECRAFT=\"" + minecraftVersion + "\"\n");
            writer.write("SET FORGE=\"" + modloaderVersion + "\"\n");
            writer.write("SET ARGS=" + javaArguments + "\n");
            writer.write("SET OTHERARGS=\"-Dlog4j2.formatMsgNoLookups=true\"\n");
            writer.write("\n");
            writer.write("SET AGREE=\"I agree\"\n");
            writer.write("\n");
            writer.write("IF NOT EXIST libraries/net/minecraftforge/forge/%MINECRAFT%-%FORGE%/forge-%MINECRAFT%-%FORGE%-server.jar (\n");
            writer.write("\n");
            writer.write("  ECHO Forge Server JAR-file not found. Downloading installer...\n");
            writer.write("  powershell -Command \"(New-Object Net.WebClient).DownloadFile('https://files.minecraftforge.net/maven/net/minecraftforge/forge/%MINECRAFT%-%FORGE%/forge-%MINECRAFT%-%FORGE%-installer.jar', 'forge-installer.jar')\"\n");
            writer.write("\n");
            writer.write("  IF EXIST forge-installer.jar (\n");
            writer.write("\n");
            writer.write("    ECHO Installer downloaded. Installing...\n");
            writer.write("    %JAVA% -jar forge-installer.jar --installServer\n");
            writer.write("\n");
            writer.write("    IF EXIST libraries/net/minecraftforge/forge/%MINECRAFT%-%FORGE%/forge-%MINECRAFT%-%FORGE%-server.jar (\n");
            writer.write("      DEL forge-installer.jar\n");
            writer.write("      ECHO Installation complete. forge-installer.jar deleted.\n");
            writer.write("    )\n");
            writer.write("\n");
            writer.write("  ) ELSE (\n");
            writer.write("    ECHO forge-installer.jar not found. Maybe the Forge servers are having trouble.\n");
            writer.write("    ECHO Please try again in a couple of minutes.\n");
            writer.write("  )\n");
            writer.write(") ELSE (\n");
            writer.write("  ECHO Forge server present. Moving on...\n");
            writer.write(")\n");
            writer.write("\n");
            writer.write("IF NOT EXIST libraries/net/minecraft/server/%MINECRAFT%/server-%MINECRAFT%.jar (\n");
            writer.write("  ECHO Minecraft Server JAR-file not found. Downloading...\n");
            writer.write("  powershell -Command \"(New-Object Net.WebClient).DownloadFile('" + this.VERSIONMETA.minecraft().getServer(minecraftVersion).get().url() + "', 'libraries/net/minecraft/server/%MINECRAFT%/server-%MINECRAFT%.jar')\"\n");
            writer.write(") ELSE (\n");
            writer.write("  ECHO Minecraft server present. Moving on...\n");
            writer.write(")\n");
            writer.write("\n");
            writer.write("IF EXIST run.bat (\n");
            writer.write("  DEL run.bat\n");
            writer.write("  ECHO Deleted run.bat as we already have start.bat\n");
            writer.write(")\n");
            writer.write("IF EXIST run.sh (\n");
            writer.write("  DEL run.sh\n");
            writer.write("  ECHO Deleted run.sh as we already have start.sh\n");
            writer.write(")\n");
            writer.write("\n");
            writer.write("IF NOT EXIST eula.txt (\n");
            writer.write("  ECHO Mojang's EULA has not yet been accepted. In order to run a Minecraft server, you must accept Mojang's EULA.\n");
            writer.write("  ECHO Mojang's EULA is available to read at https://account.mojang.com/documents/minecraft_eula\n");
            writer.write("  ECHO If you agree to Mojang's EULA then type \"I agree\"\n");
            writer.write("\n");
            writer.write("  set /P response=\"Response: \"\n");
            writer.write("\n");
            writer.write("  IF \"%response%\" == \"%AGREE%\" (\n");
            writer.write("    ECHO User agreed to Mojang's EULA.\n");
            writer.write("    ECHO #By changing the setting below to TRUE you are indicating your agreement to our EULA ^(https://account.mojang.com/documents/minecraft_eula^).> eula.txt\n");
            writer.write("    ECHO eula=true>> eula.txt\n");
            writer.write("  ) else (\n");
            writer.write("    ECHO User did not agree to Mojang's EULA. \n");
            writer.write("    ECHO Entered: %response%\n");
            writer.write("  )\n");
            writer.write(") ELSE (\n");
            writer.write("  ECHO eula.txt present. Moving on...\n");
            writer.write(")\n");
            writer.write("\n");
            writer.write("ECHO Starting server...\n");
            writer.write("ECHO Minecraft version: %MINECRAFT%\n");
            writer.write("ECHO Forge version: %FORGE%\n");
            writer.write("ECHO Java version:\n");
            writer.write("%JAVA% -version\n");
            writer.write("ECHO Java args in user_jvm_args.txt: %ARGS%\n");
            writer.write("\n");
            writer.write("REM Forge requires a configured set of both JVM and program arguments.\n");
            writer.write("REM Add custom JVM arguments to the user_jvm_args.txt\n");
            writer.write("REM Add custom program arguments {such as nogui} to this file in the next line before the %* or\n");
            writer.write("REM  pass them to this script directly\n");
            writer.write("ECHO If you receive the error message \"Error: Could not find or load main class @user_jvm_args.txt\" you may be using the wrong Java-version for this modded Minecraft server. Contact the modpack-developer or, if you made the server pack yourself, do a quick google-search for the used Minecraft version to find out which Java-version is required in order to run this server.\n");
            writer.write("\n");
            writer.write("%JAVA% \"%OTHERARGS%\" @user_jvm_args.txt @libraries/net/minecraftforge/forge/%MINECRAFT%-%FORGE%/win_args.txt nogui %*\n");
            writer.write("\n");
            writer.write("PAUSE");
        }
        catch (IOException ex) {
            LOG.error("Error generating batch-script for Forge.", (Throwable)ex);
        }
    }

    private void forgeShellScript(String javaArguments, String minecraftVersion, String modloaderVersion, String destination) {
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(String.valueOf(Paths.get(String.format("%s/%s", destination, this.APPLICATIONPROPERTIES.START_SCRIPT_LINUX()), new String[0]))));){
            if (!this.VERSIONMETA.minecraft().getServer(minecraftVersion).isPresent()) {
                LOG.error(this.LOCALIZATIONMANAGER.getLocalizedString("createserverpack.log.error.minecraft.server"));
                return;
            }
            writer.write("#!/usr/bin/env bash\n");
            writer.write("# Start script generated by ServerPackCreator.\n");
            writer.write("# This script checks for the Minecraft and Forge JAR-files, and if they are not found, they are downloaded and installed.\n");
            writer.write("# If everything is in order, the server is started.\n");
            writer.write("\n");
            writer.write("JAVA=\"java\"\n");
            writer.write("MINECRAFT=\"" + minecraftVersion + "\"\n");
            writer.write("FORGE=\"" + modloaderVersion + "\"\n");
            writer.write("ARGS=\"" + javaArguments + "\"\n");
            writer.write("OTHERARGS=\"-Dlog4j2.formatMsgNoLookups=true\"\n");
            writer.write("\n");
            writer.write("if [[ ! -s \"forge.jar\" ]];then\n");
            writer.write("\n");
            writer.write("  echo \"Forge Server JAR-file not found. Downloading installer...\";\n");
            writer.write("  wget -O forge-installer.jar https://files.minecraftforge.net/maven/net/minecraftforge/forge/$MINECRAFT-$FORGE/forge-$MINECRAFT-$FORGE-installer.jar;\n");
            writer.write("\n");
            writer.write("  if [[ -s \"forge-installer.jar\" ]]; then\n");
            writer.write("\n");
            writer.write("    echo \"Installer downloaded. Installing...\";\n");
            writer.write("    $JAVA -jar forge-installer.jar --installServer;\n");
            writer.write("    mv forge-$MINECRAFT-$FORGE.jar forge.jar;\n");
            writer.write("\n");
            writer.write("    if [[ -s \"forge.jar\" ]];then\n");
            writer.write("      rm -f forge-installer.jar;\n");
            writer.write("      echo \"Installation complete. forge-installer.jar deleted.\";\n");
            writer.write("    fi\n");
            writer.write("\n");
            writer.write("  else\n");
            writer.write("    echo \"forge-installer.jar not found. Maybe the Forge servers are having trouble.\";\n");
            writer.write("    echo \"Please try again in a couple of minutes.\";\n");
            writer.write("  fi\n");
            writer.write("else\n");
            writer.write("  echo \"forge.jar present. Moving on...\"\n");
            writer.write("fi\n");
            writer.write("\n");
            writer.write("if [[ ! -s \"minecraft_server.$MINECRAFT.jar\" ]];then\n");
            writer.write("  echo \"Minecraft Server JAR-file not found. Downloading...\";\n");
            writer.write("  wget -O minecraft_server.$MINECRAFT.jar " + this.VERSIONMETA.minecraft().getServer(minecraftVersion).get().url() + ";\n");
            writer.write("else\n");
            writer.write("  echo \"minecraft_server.$MINECRAFT.jar present. Moving on...\"\n");
            writer.write("fi\n");
            writer.write("\n");
            writer.write("if [[ ! -s \"eula.txt\" ]];then\n");
            writer.write("  echo \"Mojang's EULA has not yet been accepted. In order to run a Minecraft server, you must accept Mojang's EULA.\"\n");
            writer.write("  echo \"Mojang's EULA is available to read at https://account.mojang.com/documents/minecraft_eula\"\n");
            writer.write("  echo \"If you agree to Mojang's EULA then type 'I agree'\"\n");
            writer.write("\n");
            writer.write("  echo -n \"Response: \"\n");
            writer.write("  read ANSWER\n");
            writer.write("\n");
            writer.write("  if [[ \"$ANSWER\" = \"I agree\" ]]; then\n");
            writer.write("    echo \"User agreed to Mojang's EULA.\"\n");
            writer.write("    echo \"#By changing the setting below to TRUE you are indicating your agreement to our EULA (https://account.mojang.com/documents/minecraft_eula).\" > eula.txt;\n");
            writer.write("    echo \"eula=true\" >> eula.txt;\n");
            writer.write("  else\n");
            writer.write("    echo \"User did not agree to Mojang's EULA.\"\n");
            writer.write("    echo \"Entered: $ANSWER\"\n");
            writer.write("  fi\n");
            writer.write("else\n");
            writer.write("  echo \"eula.txt present. Moving on...\";\n");
            writer.write("fi\n");
            writer.write("\n");
            writer.write("echo \"Starting server...\";\n");
            writer.write("echo \"Minecraft version: $MINECRAFT\";\n");
            writer.write("echo \"Forge version: $FORGE\";\n");
            writer.write("echo \"Java version:\"\n");
            writer.write("$JAVA -version\n");
            writer.write("echo \"Java args: $ARGS\";\n");
            writer.write("\n");
            writer.write("$JAVA $OTHERARGS $ARGS -jar forge.jar nogui");
        }
        catch (IOException ex) {
            LOG.error("Error generating shell-script for Forge.", (Throwable)ex);
        }
    }

    private void forgeBatchScript(String javaArguments, String minecraftVersion, String modloaderVersion, String destination) {
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(String.valueOf(Paths.get(String.format("%s/%s", destination, this.APPLICATIONPROPERTIES.START_SCRIPT_WINDOWS()), new String[0]))));){
            if (!this.VERSIONMETA.minecraft().getServer(minecraftVersion).isPresent()) {
                LOG.error(this.LOCALIZATIONMANAGER.getLocalizedString("createserverpack.log.error.minecraft.server"));
                return;
            }
            writer.write(":: Start script generated by ServerPackCreator.\n");
            writer.write(":: This script checks for the Minecraft and Forge JAR-files, and if they are not found, they are downloaded and installed.\n");
            writer.write(":: If everything is in order, the server is started.\n");
            writer.write("@ECHO off\n");
            writer.write("SetLocal EnableDelayedExpansion\n");
            writer.write("\n");
            writer.write("SET JAVA=\"java\"\n");
            writer.write("SET MINECRAFT=\"" + minecraftVersion + "\"\n");
            writer.write("SET FORGE=\"" + modloaderVersion + "\"\n");
            writer.write("SET ARGS=" + javaArguments + "\n");
            writer.write("SET OTHERARGS=\"-Dlog4j2.formatMsgNoLookups=true\"\n");
            writer.write("\n");
            writer.write("SET AGREE=\"I agree\"\n");
            writer.write("\n");
            writer.write("IF NOT EXIST forge.jar (\n");
            writer.write("\n");
            writer.write("  ECHO Forge Server JAR-file not found. Downloading installer...\n");
            writer.write("  powershell -Command \"(New-Object Net.WebClient).DownloadFile('https://files.minecraftforge.net/maven/net/minecraftforge/forge/%MINECRAFT%-%FORGE%/forge-%MINECRAFT%-%FORGE%-installer.jar', 'forge-installer.jar')\"\n");
            writer.write("\n");
            writer.write("  IF EXIST forge-installer.jar (\n");
            writer.write("\n");
            writer.write("    ECHO Installer downloaded. Installing...\n");
            writer.write("    %JAVA% -jar forge-installer.jar --installServer\n");
            writer.write("    MOVE forge-%MINECRAFT%-%FORGE%.jar forge.jar\n");
            writer.write("\n");
            writer.write("    IF EXIST forge.jar (\n");
            writer.write("      DEL forge-installer.jar\n");
            writer.write("      ECHO Installation complete. forge-installer.jar deleted.\n");
            writer.write("    )\n");
            writer.write("\n");
            writer.write("  ) ELSE (\n");
            writer.write("    ECHO forge-installer.jar not found. Maybe the Forge servers are having trouble.\n");
            writer.write("    ECHO Please try again in a couple of minutes.\n");
            writer.write("  )\n");
            writer.write(") ELSE (\n");
            writer.write("  ECHO forge.jar present. Moving on...\n");
            writer.write(")\n");
            writer.write("\n");
            writer.write("IF NOT EXIST minecraft_server.%MINECRAFT%.jar (\n");
            writer.write("  ECHO Minecraft Server JAR-file not found. Downloading...\n");
            writer.write("  powershell -Command \"(New-Object Net.WebClient).DownloadFile('" + this.VERSIONMETA.minecraft().getServer(minecraftVersion).get().url() + "', 'minecraft_server.%MINECRAFT%.jar')\"\n");
            writer.write(") ELSE (\n");
            writer.write("  ECHO minecraft_server.%MINECRAFT%.jar present. Moving on...\n");
            writer.write(")\n");
            writer.write("\n");
            writer.write("IF NOT EXIST eula.txt (\n");
            writer.write("  ECHO Mojang's EULA has not yet been accepted. In order to run a Minecraft server, you must accept Mojang's EULA.\n");
            writer.write("  ECHO Mojang's EULA is available to read at https://account.mojang.com/documents/minecraft_eula\n");
            writer.write("  ECHO If you agree to Mojang's EULA then type \"I agree\"\n");
            writer.write("\n");
            writer.write("  set /P response=\"Response: \"\n");
            writer.write("\n");
            writer.write("  IF \"%response%\" == \"%AGREE%\" (\n");
            writer.write("    ECHO User agreed to Mojang's EULA.\n");
            writer.write("    ECHO #By changing the setting below to TRUE you are indicating your agreement to our EULA ^(https://account.mojang.com/documents/minecraft_eula^).> eula.txt\n");
            writer.write("    ECHO eula=true>> eula.txt\n");
            writer.write("  ) else (\n");
            writer.write("    ECHO User did not agree to Mojang's EULA. \n");
            writer.write("    ECHO Entered: %response%\n");
            writer.write("  )\n");
            writer.write(") ELSE (\n");
            writer.write("  ECHO eula.txt present. Moving on...\n");
            writer.write(")\n");
            writer.write("\n");
            writer.write("ECHO Starting server...\n");
            writer.write("ECHO Minecraft version: %MINECRAFT%\n");
            writer.write("ECHO Forge version: %FORGE%\n");
            writer.write("ECHO Java version:\n");
            writer.write("%JAVA% -version\n");
            writer.write("ECHO Java args: %ARGS%\n");
            writer.write("\n");
            writer.write("%JAVA% \"%OTHERARGS%\" %ARGS% -jar forge.jar nogui\n");
            writer.write("\n");
            writer.write("PAUSE");
        }
        catch (IOException ex) {
            LOG.error("Error generating batch-script for Forge.", (Throwable)ex);
        }
    }

    private void copyFiles(String modpackDir, List<String> directoriesToCopy, List<String> clientMods, String minecraftVersion, String destination, String modloader) {
        try {
            Files.createDirectories(Paths.get(destination, new String[0]), new FileAttribute[0]);
        }
        catch (IOException ex) {
            LOG.error(String.format("Failed to create directory %s", destination));
        }
        if (directoriesToCopy.size() == 1 && directoriesToCopy.get(0).equals("lazy_mode")) {
            LOG.warn(this.LOCALIZATIONMANAGER.getLocalizedString("configuration.log.warn.checkconfig.copydirs.lazymode0"));
            LOG.warn(this.LOCALIZATIONMANAGER.getLocalizedString("configuration.log.warn.checkconfig.copydirs.lazymode1"));
            LOG.warn(this.LOCALIZATIONMANAGER.getLocalizedString("configuration.log.warn.checkconfig.copydirs.lazymode2"));
            LOG.warn(this.LOCALIZATIONMANAGER.getLocalizedString("configuration.log.warn.checkconfig.copydirs.lazymode3"));
            LOG.warn(this.LOCALIZATIONMANAGER.getLocalizedString("configuration.log.warn.checkconfig.copydirs.lazymode0"));
            try {
                FileUtils.copyDirectory(new File(modpackDir), new File(destination));
            }
            catch (IOException ex) {
                LOG.error("An error occurred copying the modpack to the server pack in lazy mode.", (Throwable)ex);
            }
        } else {
            List<String> exclusions = this.APPLICATIONPROPERTIES.getDirectoriesToExclude();
            directoriesToCopy.forEach(entry -> {
                if (entry.startsWith("!") && !exclusions.contains(entry.substring(1))) {
                    exclusions.add(entry.substring(1));
                }
            });
            directoriesToCopy.removeIf(n -> n.startsWith("!"));
            ArrayList<ServerPackFile> serverPackFiles = new ArrayList<ServerPackFile>(100000);
            for (String directory : directoriesToCopy) {
                String clientDir = String.format("%s/%s", modpackDir, directory).replace("\\", "/");
                String serverDir = String.format("%s/%s", destination, directory).replace("\\", "/");
                LOG.info(String.format(this.LOCALIZATIONMANAGER.getLocalizedString("createserverpack.log.info.copyfiles.setup"), directory));
                if (directory.contains(";")) {
                    serverPackFiles.addAll(this.getExplicitFiles(directory.split(";"), modpackDir, destination));
                    continue;
                }
                if (directory.startsWith("saves/")) {
                    serverPackFiles.addAll(this.getSaveFiles(clientDir, directory, destination));
                    continue;
                }
                if (directory.startsWith("mods")) {
                    List<String> listOfFiles = this.excludeClientMods(clientDir, clientMods, minecraftVersion, modloader);
                    try {
                        Files.createDirectories(Paths.get(serverDir, new String[0]), new FileAttribute[0]);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    for (String file : listOfFiles) {
                        if (this.excludeFileOrDirectory(file.replace("\\", "/"), exclusions)) {
                            LOG.info("Excluding " + file + " from server pack");
                            continue;
                        }
                        serverPackFiles.add(new ServerPackFile(file, String.format("%s/%s", serverDir, new File(file).getName())));
                    }
                    continue;
                }
                if (new File(directory).isFile()) {
                    serverPackFiles.add(new ServerPackFile(directory, String.format("%s/%s", destination, new File(directory).getName())));
                    continue;
                }
                if (new File(directory).isDirectory()) {
                    serverPackFiles.addAll(this.getDirectoryFiles(directory, destination));
                    continue;
                }
                serverPackFiles.addAll(this.getDirectoryFiles(clientDir, destination));
            }
            LOG.info(this.LOCALIZATIONMANAGER.getLocalizedString("createserverpack.log.info.copyfiles.copy"));
            serverPackFiles.forEach(serverPackFile -> {
                try {
                    serverPackFile.copy();
                }
                catch (IOException ex) {
                    LOG.error("An error occurred trying to copy " + serverPackFile.source() + " to " + serverPackFile.destination() + ".", (Throwable)ex);
                }
            });
        }
    }

    private List<ServerPackFile> getExplicitFiles(String[] combination, String modpackDir, String destination) {
        ArrayList<ServerPackFile> serverPackFiles = new ArrayList<ServerPackFile>();
        if (new File(String.format("%s/%s", modpackDir, combination[0])).isFile()) {
            serverPackFiles.add(new ServerPackFile(String.format("%s/%s", modpackDir, combination[0]), String.format("%s/%s", destination, combination[1])));
        } else if (new File(String.format("%s/%s", modpackDir, combination[0])).isDirectory()) {
            serverPackFiles.addAll(this.getDirectoryFiles(String.format("%s/%s", modpackDir, combination[0]), destination));
        } else if (new File(combination[0]).isFile()) {
            serverPackFiles.add(new ServerPackFile(combination[0], String.format("%s/%s", destination, combination[1])));
        } else if (new File(combination[0]).isDirectory()) {
            serverPackFiles.addAll(this.getDirectoryFiles(combination[0], destination));
        }
        return serverPackFiles;
    }

    private List<ServerPackFile> getDirectoryFiles(String source, String destination) {
        ArrayList<ServerPackFile> serverPackFiles = new ArrayList<ServerPackFile>();
        try (Stream<Path> files = Files.walk(Paths.get(source, new String[0]), new FileVisitOption[0]);){
            files.forEach(file -> {
                try {
                    serverPackFiles.add(new ServerPackFile((Path)file, Paths.get(String.format("%s/%s", destination, new File(source).getName()), new String[0]).resolve(Paths.get(source, new String[0]).relativize((Path)file))));
                }
                catch (UnsupportedOperationException ex) {
                    LOG.error(String.format(this.LOCALIZATIONMANAGER.getLocalizedString("createserverpack.log.error.copy.directory"), file, source), (Throwable)ex);
                }
            });
        }
        catch (IOException ex) {
            LOG.error(this.LOCALIZATIONMANAGER.getLocalizedString("createserverpack.log.error.copy"), (Throwable)ex);
        }
        return serverPackFiles;
    }

    private List<ServerPackFile> getSaveFiles(String clientDir, String directory, String destination) {
        ArrayList<ServerPackFile> serverPackFiles = new ArrayList<ServerPackFile>();
        try (Stream<Path> files = Files.walk(Paths.get(clientDir, new String[0]), new FileVisitOption[0]);){
            files.forEach(file -> {
                try {
                    serverPackFiles.add(new ServerPackFile((Path)file, Paths.get(String.format("%s/%s", destination, directory.substring(6)), new String[0]).resolve(Paths.get(clientDir, new String[0]).relativize((Path)file))));
                }
                catch (UnsupportedOperationException ex) {
                    LOG.error(String.format(this.LOCALIZATIONMANAGER.getLocalizedString("createserverpack.log.error.copy.directory"), file, clientDir), (Throwable)ex);
                }
            });
        }
        catch (IOException ex) {
            LOG.error("An error occurred during the copy-procedure to the server pack.", (Throwable)ex);
        }
        return serverPackFiles;
    }

    private List<String> excludeClientMods(String modsDir, List<String> userSpecifiedClientMods, String minecraftVersion, String modloader) {
        LOG.info(this.LOCALIZATIONMANAGER.getLocalizedString("createserverpack.log.info.excludeclientmods"));
        Collection<File> filesInModsDir = FileUtils.listFiles(new File(modsDir), new String[]{"jar"}, true);
        ArrayList<String> modsInModpack = new ArrayList<String>();
        ArrayList<String> autodiscoveredClientMods = new ArrayList<String>();
        if (this.APPLICATIONPROPERTIES.getProperty("de.griefed.serverpackcreator.serverpack.autodiscoverenabled").equals("true") && filesInModsDir != null) {
            String[] split = minecraftVersion.split("\\.");
            this.STOPWATCH_SCANS.reset();
            this.STOPWATCH_SCANS.start();
            switch (modloader) {
                case "Fabric": {
                    autodiscoveredClientMods.addAll(this.scanFabricModJson(filesInModsDir));
                    break;
                }
                case "Forge": {
                    if (Integer.parseInt(split[1]) > 12) {
                        autodiscoveredClientMods.addAll(this.scanTomls(filesInModsDir));
                        break;
                    }
                    autodiscoveredClientMods.addAll(this.scanAnnotations(filesInModsDir));
                    break;
                }
                case "Quilt": {
                    autodiscoveredClientMods.addAll(this.scanFabricModJson(filesInModsDir));
                    this.scanQuiltModJson(filesInModsDir).forEach(quiltMod -> {
                        if (!autodiscoveredClientMods.contains(quiltMod)) {
                            autodiscoveredClientMods.add((String)quiltMod);
                        }
                    });
                }
            }
            this.STOPWATCH_SCANS.stop();
            LOG.debug("Scanning of " + filesInModsDir.size() + " mods took " + this.STOPWATCH_SCANS);
            this.STOPWATCH_SCANS.reset();
        }
        if (filesInModsDir != null) {
            for (File mod : filesInModsDir) {
                if (!mod.isFile() || !mod.toString().endsWith("jar")) continue;
                modsInModpack.add(mod.getAbsolutePath());
            }
        }
        if (userSpecifiedClientMods.size() > 0) {
            for (int m3 = 0; m3 < userSpecifiedClientMods.size(); ++m3) {
                int i2 = m3;
                if (!modsInModpack.removeIf(n -> n.contains((CharSequence)userSpecifiedClientMods.get(i2)))) continue;
                LOG.debug("Removed user-specified mod from mods list as per input: " + userSpecifiedClientMods.get(i2));
            }
        }
        if (this.APPLICATIONPROPERTIES.getProperty("de.griefed.serverpackcreator.serverpack.autodiscoverenabled").equals("true") && autodiscoveredClientMods.size() > 0) {
            for (int m4 = 0; m4 < autodiscoveredClientMods.size(); ++m4) {
                int i3 = m4;
                if (!modsInModpack.removeIf(n -> n.replace("\\", "/").contains((CharSequence)autodiscoveredClientMods.get(i3)))) continue;
                LOG.debug("Automatically excluding mod: " + (String)autodiscoveredClientMods.get(i3));
            }
        }
        return modsInModpack;
    }

    private boolean excludeFileOrDirectory(String fileToCheckFor, List<String> exclusions) {
        boolean isPresentInList = false;
        for (String entry : exclusions) {
            if (!fileToCheckFor.contains(entry)) continue;
            isPresentInList = true;
            break;
        }
        return isPresentInList;
    }

    private void copyIcon(String destination, String pathToServerIcon) {
        block13: {
            LOG.info(this.LOCALIZATIONMANAGER.getLocalizedString("createserverpack.log.info.copyicon"));
            File iconFile = new File(String.format("%s/%s", destination, this.APPLICATIONPROPERTIES.DEFAULT_SERVER_ICON()));
            if (new File(pathToServerIcon).exists()) {
                Image scaledImage = null;
                try {
                    BufferedImage originalImage = ImageIO.read(new File(pathToServerIcon));
                    if (originalImage.getHeight() == 64 && originalImage.getWidth() == 64) {
                        try {
                            FileUtils.copyFile(new File(pathToServerIcon), iconFile);
                        }
                        catch (IOException e) {
                            LOG.error("An error occurred trying to copy the server-icon.", (Throwable)e);
                        }
                        break block13;
                    }
                    scaledImage = originalImage.getScaledInstance(64, 64, 4);
                    BufferedImage outputImage = new BufferedImage(scaledImage.getWidth(null), scaledImage.getHeight(null), 2);
                    outputImage.getGraphics().drawImage(scaledImage, 0, 0, null);
                    try {
                        ImageIO.write((RenderedImage)outputImage, "png", iconFile);
                    }
                    catch (IOException ex) {
                        LOG.error("Error scaling image.", (Throwable)ex);
                    }
                }
                catch (Exception ex) {
                    LOG.error("Error reading server-icon image.", (Throwable)ex);
                }
            } else if (pathToServerIcon.length() == 0) {
                LOG.info(this.LOCALIZATIONMANAGER.getLocalizedString("createserverpack.log.info.icon"));
                try {
                    FileUtils.copyFile(new File(String.format("server_files/%s", this.APPLICATIONPROPERTIES.DEFAULT_SERVER_ICON())), iconFile);
                }
                catch (IOException ex) {
                    LOG.error("An error occurred trying to copy the server-icon.", (Throwable)ex);
                }
            } else {
                LOG.error(String.format(this.LOCALIZATIONMANAGER.getLocalizedString("configuration.log.error.servericon"), pathToServerIcon));
            }
        }
    }

    private void copyProperties(String destination, String pathToServerProperties) {
        LOG.info(this.LOCALIZATIONMANAGER.getLocalizedString("createserverpack.log.info.copyproperties"));
        File defaultProperties = new File(String.format("%s/%s", destination, this.APPLICATIONPROPERTIES.DEFAULT_SERVER_PROPERTIES()));
        if (new File(pathToServerProperties).exists()) {
            try {
                FileUtils.copyFile(new File(pathToServerProperties), defaultProperties);
            }
            catch (IOException ex) {
                LOG.error("An error occurred trying to copy the server.properties-file.", (Throwable)ex);
            }
        } else if (pathToServerProperties.length() == 0) {
            LOG.info(this.LOCALIZATIONMANAGER.getLocalizedString("createserverpack.log.info.properties"));
            try {
                FileUtils.copyFile(new File(String.format("server_files/%s", this.APPLICATIONPROPERTIES.DEFAULT_SERVER_PROPERTIES())), defaultProperties);
            }
            catch (IOException ex) {
                LOG.error("An error occurred trying to copy the server.properties-file.", (Throwable)ex);
            }
        } else {
            LOG.error(String.format(this.LOCALIZATIONMANAGER.getLocalizedString("configuration.log.error.serverproperties"), pathToServerProperties));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void installServer(String modLoader, String minecraftVersion, String modLoaderVersion, String javaPath, String destination) {
        ArrayList<String> commandArguments = new ArrayList<String>();
        Process process = null;
        BufferedReader bufferedReader = null;
        switch (modLoader) {
            case "Fabric": {
                LOG_INSTALLER.info(this.LOCALIZATIONMANAGER.getLocalizedString("createserverpack.log.info.installserver.fabric.enter"));
                String fileDestination = String.format("%s/fabric-installer.jar", destination);
                if (this.UTILITIES.WebUtils().downloadFile(fileDestination, this.VERSIONMETA.fabric().releaseInstallerUrl())) {
                    LOG.info(this.LOCALIZATIONMANAGER.getLocalizedString("createserverpack.log.info.installserver.fabric.download"));
                    commandArguments.add(javaPath);
                    commandArguments.add("-jar");
                    commandArguments.add("fabric-installer.jar");
                    commandArguments.add("server");
                    commandArguments.add("-mcversion");
                    commandArguments.add(minecraftVersion);
                    commandArguments.add("-loader");
                    commandArguments.add(modLoaderVersion);
                    commandArguments.add("-downloadMinecraft");
                    break;
                }
                LOG.error("Something went wrong during the installation of Fabric. Maybe the Fabric server are down or unreachable? Skipping...");
                break;
            }
            case "Forge": {
                LOG_INSTALLER.info(this.LOCALIZATIONMANAGER.getLocalizedString("createserverpack.log.info.installserver.forge.enter"));
                String fileDestination = String.format("%s/forge-installer.jar", destination);
                if (this.VERSIONMETA.forge().getForgeInstance(minecraftVersion, modLoaderVersion).isPresent() && this.UTILITIES.WebUtils().downloadFile(fileDestination, this.VERSIONMETA.forge().getForgeInstance(minecraftVersion, modLoaderVersion).get().installerUrl())) {
                    LOG.info(this.LOCALIZATIONMANAGER.getLocalizedString("createserverpack.log.info.installserver.forge.download"));
                    commandArguments.add(javaPath);
                    commandArguments.add("-jar");
                    commandArguments.add("forge-installer.jar");
                    commandArguments.add("--installServer");
                    break;
                }
                LOG.error("Something went wrong during the installation of Forge. Maybe the Forge servers are down or unreachable? Skipping...");
                break;
            }
            case "Quilt": {
                LOG_INSTALLER.info(this.LOCALIZATIONMANAGER.getLocalizedString("createserverpack.log.info.installserver.quilt.enter"));
                String fileDestination = String.format("%s/quilt-installer.jar", destination);
                if (this.UTILITIES.WebUtils().downloadFile(fileDestination, this.VERSIONMETA.quilt().releaseInstallerUrl())) {
                    LOG.info(this.LOCALIZATIONMANAGER.getLocalizedString("createserverpack.log.info.installserver.quilt.download"));
                    commandArguments.add(javaPath);
                    commandArguments.add("-jar");
                    commandArguments.add("quilt-installer.jar");
                    commandArguments.add("install");
                    commandArguments.add("server");
                    commandArguments.add(minecraftVersion);
                    commandArguments.add("--download-server");
                    commandArguments.add("--install-dir=.");
                    break;
                }
                LOG.error("Something went wrong during the installation of Fabric. Maybe the Fabric server are down or unreachable? Skipping...");
                break;
            }
            default: {
                LOG.error(String.format(this.LOCALIZATIONMANAGER.getLocalizedString("configuration.log.error.checkmodloader"), modLoader));
            }
        }
        try {
            String line;
            LOG.info(String.format(this.LOCALIZATIONMANAGER.getLocalizedString("createserverpack.log.info.installserver.enter"), minecraftVersion, modLoader, modLoaderVersion));
            ProcessBuilder processBuilder = new ProcessBuilder(commandArguments).directory(new File(destination));
            LOG.debug("ProcessBuilder command: " + processBuilder.command());
            processBuilder.redirectErrorStream(true);
            process = processBuilder.start();
            bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            while ((line = bufferedReader.readLine()) != null) {
                LOG_INSTALLER.info(line);
            }
            LOG_INSTALLER.info(String.format(this.LOCALIZATIONMANAGER.getLocalizedString("createserverpack.log.info.installserver"), minecraftVersion, modLoader, modLoaderVersion));
            LOG.info(String.format(this.LOCALIZATIONMANAGER.getLocalizedString("createserverpack.log.info.installserver"), minecraftVersion, modLoader, modLoaderVersion));
            LOG.info(this.LOCALIZATIONMANAGER.getLocalizedString("createserverpack.log.info.installserver.details"));
        }
        catch (IOException ex) {
            LOG.error("Something went wrong during the installation of Forge. Maybe the Forge servers are down or unreachable? Skipping...", (Throwable)ex);
        }
        finally {
            try {
                bufferedReader.close();
            }
            catch (Exception exception) {}
            try {
                process.destroy();
            }
            catch (Exception exception) {}
            commandArguments.clear();
        }
        if (this.APPLICATIONPROPERTIES.getProperty("de.griefed.serverpackcreator.serverpack.cleanup.enabled").equalsIgnoreCase("true")) {
            this.cleanUpServerPack(minecraftVersion, modLoaderVersion, destination);
        } else {
            LOG.info(this.LOCALIZATIONMANAGER.getLocalizedString("createserverpack.log.info.cleanup"));
        }
    }

    public void zipBuilder(String minecraftVersion, boolean includeServerInstallation, String destination, String modloader, String modloaderVersion) {
        LOG.info(this.LOCALIZATIONMANAGER.getLocalizedString("createserverpack.log.info.zipbuilder.enter"));
        ZipParameters zipParameters = new ZipParameters();
        ArrayList filesToExclude = new ArrayList(100);
        if (this.APPLICATIONPROPERTIES.isZipFileExclusionEnabled()) {
            this.APPLICATIONPROPERTIES.getFilesToExcludeFromZipArchive().forEach(entry -> filesToExclude.add(new File(destination + "/" + entry.replace("MINECRAFT_VERSION", minecraftVersion).replace("MODLOADER", modloader).replace("MODLOADER_VERSION", modloaderVersion))));
            ExcludeFileFilter excludeFileFilter = filesToExclude::contains;
            zipParameters.setExcludeFileFilter(excludeFileFilter);
        } else {
            LOG.info(this.LOCALIZATIONMANAGER.getLocalizedString("createserverpack.log.info.zipbuilder.exclusion.deactivated"));
        }
        zipParameters.setIncludeRootFolder(false);
        zipParameters.setFileComment("Server pack made with ServerPackCreator " + this.APPLICATIONPROPERTIES.SERVERPACKCREATOR_VERSION() + " by Griefed.");
        try (ZipFile zip = new ZipFile(String.format("%s_server_pack.zip", destination));){
            zip.addFolder(new File(destination), zipParameters);
        }
        catch (IOException ex) {
            LOG.error("There was an error during zip creation.", (Throwable)ex);
        }
        if (includeServerInstallation) {
            LOG.warn(this.LOCALIZATIONMANAGER.getLocalizedString("createserverpack.log.warn.zipbuilder.minecraftjar1"));
            LOG.warn(this.LOCALIZATIONMANAGER.getLocalizedString("createserverpack.log.warn.zipbuilder.minecraftjar2"));
            LOG.warn(this.LOCALIZATIONMANAGER.getLocalizedString("createserverpack.log.warn.zipbuilder.minecraftjar3"));
        }
        LOG.info(this.LOCALIZATIONMANAGER.getLocalizedString("createserverpack.log.info.zipbuilder.finish"));
    }

    private void cleanUpServerPack(String minecraftVersion, String modLoaderVersion, String destination) {
        LOG.info(this.LOCALIZATIONMANAGER.getLocalizedString("createserverpack.log.info.cleanupserverpack.enter"));
        FileUtils.deleteQuietly(new File(String.format("%s/fabric-installer.jar", destination)));
        FileUtils.deleteQuietly(new File(String.format("%s/forge-installer.jar", destination)));
        FileUtils.deleteQuietly(new File(String.format("%s/quilt-installer.jar", destination)));
        FileUtils.deleteQuietly(new File(String.format("%s/installer.log", destination)));
        FileUtils.deleteQuietly(new File(String.format("%s/forge-installer.jar.log", destination)));
        Path path = Paths.get(String.format("%s/forge-%s-%s.jar", destination, minecraftVersion, modLoaderVersion), new String[0]);
        try {
            if (new File(String.format("%s/forge-%s-%s.jar", destination, minecraftVersion, modLoaderVersion)).exists()) {
                Files.copy(path, Paths.get(String.format("%s/forge.jar", destination), new String[0]), StandardCopyOption.REPLACE_EXISTING);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        FileUtils.deleteQuietly(path.toFile());
        FileUtils.deleteQuietly(Paths.get(String.format("%s/run.bat", destination), new String[0]).toFile());
        FileUtils.deleteQuietly(Paths.get(String.format("%s/run.sh", destination), new String[0]).toFile());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> scanTomls(Collection<File> filesInModsDir) {
        LOG.info(this.LOCALIZATIONMANAGER.getLocalizedString("createserverpack.log.info.scantoml"));
        ArrayList<String> serverMods = new ArrayList<String>();
        ArrayList<String> modsDelta = new ArrayList<String>();
        for (File mod : filesInModsDir) {
            if (!mod.toString().endsWith("jar")) continue;
            JarFile jarFile = null;
            InputStream inputStream = null;
            try {
                jarFile = new JarFile(mod);
                JarEntry jarEntry = jarFile.getJarEntry("META-INF/mods.toml");
                inputStream = jarFile.getInputStream(jarEntry);
            }
            catch (Exception ex) {
                LOG.error("Can not scan " + mod);
            }
            try {
                String modId;
                Toml modToml;
                block69: {
                    if (inputStream == null) continue;
                    modToml = new Toml().read(inputStream);
                    modId = modToml.getString("mods[0].modId");
                    try {
                        if (modToml.getString("mods[0].side").toLowerCase().matches("(server|both)") && !serverMods.contains(modId)) {
                            LOG.debug("Adding modId to list of server mods: " + modId);
                            serverMods.add(modId);
                        }
                    }
                    catch (NullPointerException nullPointerException) {
                        // empty catch block
                    }
                    try {
                        if (modToml.getList("dependencies." + modId) == null) break block69;
                        for (int i2 = 0; i2 < modToml.getList("dependencies." + modId).size(); ++i2) {
                            try {
                                if (modToml.getString("dependencies." + modId + "[" + i2 + "].modId").toLowerCase().matches("(forge|minecraft)")) {
                                    if (modToml.getString("dependencies." + modId + "[" + i2 + "].side") == null && !serverMods.contains(modId)) {
                                        LOG.debug("Adding modId to list of server mods: " + modId);
                                        serverMods.add(modId);
                                    }
                                    if (modToml.getString("dependencies." + modId + "[" + i2 + "].side").toLowerCase().matches("(server|both)") && !serverMods.contains(modId)) {
                                        LOG.debug("Adding modId to list of server mods: " + modId);
                                        serverMods.add(modId);
                                    }
                                } else if (!serverMods.contains(modId) && modToml.getString("mods[0].side") == null) {
                                    LOG.debug("Adding modId to list of server mods: " + modId);
                                    serverMods.add(modId);
                                }
                            }
                            catch (NullPointerException nullPointerException) {
                                // empty catch block
                            }
                            try {
                                if (modToml.getString("dependencies." + modId + "[" + i2 + "].modId").toLowerCase().matches("(forge|minecraft)") || !modToml.getString("dependencies." + modId + "[" + i2 + "].side").toLowerCase().matches("(server|both)") || serverMods.contains(modToml.getString("dependencies." + modId + "[" + i2 + "].modId"))) continue;
                                LOG.debug("Adding modId to list of server mods: " + modToml.getString("dependencies." + modId + "[" + i2 + "].modId"));
                                serverMods.add(modToml.getString("dependencies." + modId + "[" + i2 + "].modId"));
                                continue;
                            }
                            catch (NullPointerException nullPointerException) {
                                // empty catch block
                            }
                        }
                    }
                    catch (ClassCastException | NullPointerException ex) {
                        try {
                            for (int i3 = 0; i3 < modToml.getList("dependencies").size(); ++i3) {
                                LOG.warn(modId + " does not contain valid dependency definitions. Please contact the mod maker and ask them to fix their shit. :D");
                                String subDependencyId = null;
                                String subDependencySide = null;
                                for (String element : modToml.getList("dependencies").get(i3).toString().replace("{", "").replace("}", "").split(",")) {
                                    if (element.contains("modId")) {
                                        subDependencyId = element.substring(element.lastIndexOf("=") + 1);
                                        continue;
                                    }
                                    if (!element.contains("side")) continue;
                                    subDependencySide = element.substring(element.lastIndexOf("=") + 1);
                                }
                                if (subDependencyId == null || subDependencySide == null) continue;
                                if (!subDependencyId.equalsIgnoreCase("minecraft") && !subDependencyId.equalsIgnoreCase("forge")) {
                                    if (!subDependencySide.equalsIgnoreCase("both") && !subDependencySide.equalsIgnoreCase("server") || serverMods.contains(subDependencyId)) continue;
                                    LOG.debug("Adding modId to list of server mods: " + subDependencyId);
                                    serverMods.add(subDependencyId);
                                    continue;
                                }
                                if (!subDependencySide.equalsIgnoreCase("both") && !subDependencySide.equalsIgnoreCase("server") || serverMods.contains(modId)) continue;
                                LOG.debug("Adding modId to list of server mods: " + modId);
                                serverMods.add(modId);
                            }
                        }
                        catch (ClassCastException | NullPointerException runtimeException) {
                            // empty catch block
                        }
                    }
                }
                try {
                    if (modToml.getString("mods[0].side") != null) continue;
                    try {
                        block70: {
                            if (modToml.getList("dependencies." + modId) != null) continue;
                            try {
                                if (modToml.getList("dependencies") == null && !serverMods.contains(modId)) {
                                    LOG.debug("Adding modId to list of server mods: " + modId);
                                    serverMods.add(modId);
                                }
                            }
                            catch (ClassCastException ex) {
                                if (serverMods.contains(modId)) break block70;
                                LOG.debug("Adding modId to list of server mods: " + modId);
                                serverMods.add(modId);
                            }
                        }
                        if (serverMods.contains(modId)) continue;
                        LOG.debug("Adding modId to list of server mods: " + modId);
                        serverMods.add(modId);
                    }
                    catch (NullPointerException ex) {
                        if (serverMods.contains(modId)) continue;
                        LOG.debug("Adding modId to list of server mods: " + modId);
                        serverMods.add(modId);
                    }
                }
                catch (ClassCastException | NullPointerException ex) {
                    // empty catch block
                }
            }
            catch (Exception ex) {
                LOG.error("Error acquiring sideness from mod " + mod, (Throwable)ex);
            }
            finally {
                try {
                    jarFile.close();
                }
                catch (Exception ex) {}
                try {
                    inputStream.close();
                }
                catch (Exception ex) {}
            }
        }
        for (File mod : filesInModsDir) {
            String modToCheck = mod.toString().replace("\\", "/");
            boolean addToDelta = true;
            JarFile jarFile = null;
            InputStream inputStream = null;
            try {
                jarFile = new JarFile(mod);
                JarEntry jarEntry = jarFile.getJarEntry("META-INF/mods.toml");
                inputStream = jarFile.getInputStream(jarEntry);
            }
            catch (Exception ex) {
                LOG.error("Can not scan " + mod);
            }
            try {
                if (inputStream == null) continue;
                Toml modToml = new Toml().read(inputStream);
                for (String modId : serverMods) {
                    if (!modToml.getString("mods[0].modId").toLowerCase().matches(modId)) continue;
                    addToDelta = false;
                }
                if (!addToDelta) continue;
                modsDelta.add(modToCheck);
            }
            catch (Exception ex) {
                LOG.error("Couldn't acquire modId for mod " + mod, (Throwable)ex);
            }
            finally {
                try {
                    jarFile.close();
                }
                catch (Exception exception) {}
                try {
                    inputStream.close();
                }
                catch (Exception exception) {}
            }
        }
        return modsDelta;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> scanAnnotations(Collection<File> filesInModsDir) {
        LOG.info(this.LOCALIZATIONMANAGER.getLocalizedString("createserverpack.log.info.scanannotation"));
        ArrayList<Object> modDependencies = new ArrayList<Object>();
        ArrayList<String> clientMods = new ArrayList<String>();
        ArrayList<String> modsDelta = new ArrayList<String>();
        for (File file : filesInModsDir) {
            if (!file.toString().endsWith("jar")) continue;
            String modId = null;
            ArrayList<String> additionalMods = new ArrayList<String>();
            JarFile jarFile = null;
            InputStream inputStream = null;
            try {
                jarFile = new JarFile(file);
                JarEntry jarEntry = jarFile.getJarEntry("META-INF/fml_cache_annotation.json");
                inputStream = jarFile.getInputStream(jarEntry);
            }
            catch (Exception ex) {
                LOG.error("Can not scan " + file);
            }
            try {
                Object dependency32;
                if (inputStream == null) continue;
                JsonNode modJson = this.getObjectMapper().readTree(inputStream);
                for (JsonNode node : modJson) {
                    try {
                        for (JsonNode child : node.get("annotations")) {
                            block87: {
                                if (modId == null) {
                                    try {
                                        if (!child.get("values").get("modid").get("value").asText().isEmpty()) {
                                            modId = child.get("values").get("modid").get("value").asText();
                                        }
                                        if (child.get("values").get("clientSideOnly").get("value").asText().equalsIgnoreCase("true") && !clientMods.contains(modId)) {
                                            clientMods.add(modId);
                                            LOG.debug("Added clientMod: " + modId);
                                        }
                                    }
                                    catch (NullPointerException nullPointerException) {}
                                } else {
                                    try {
                                        if (child.get("values").get("modid").get("value").asText().isEmpty()) break block87;
                                        if (modId.equals(child.get("values").get("modid").get("value").asText())) {
                                            try {
                                                if (child.get("values").get("clientSideOnly").get("value").asText().equalsIgnoreCase("true") && !clientMods.contains(modId)) {
                                                    clientMods.add(modId);
                                                    LOG.debug("Added clientMod: " + modId);
                                                }
                                                break block87;
                                            }
                                            catch (NullPointerException nullPointerException) {}
                                            break block87;
                                        }
                                        additionalMods.add(child.get("values").get("modid").get("value").asText());
                                    }
                                    catch (NullPointerException nullPointerException) {
                                        // empty catch block
                                    }
                                }
                            }
                            try {
                                if (child.get("values").get("dependencies").get("value").asText().isEmpty()) continue;
                                if (child.get("values").get("dependencies").get("value").asText().contains(";")) {
                                    String[] dependencies;
                                    for (String string : dependencies = child.get("values").get("dependencies").get("value").asText().split(";")) {
                                        String string2;
                                        if (!string.matches("(before:.*|after:.*|required-after:.*|)") || modDependencies.contains(string2 = string.substring(string.lastIndexOf(":") + 1).replaceAll("(@.*|\\[.*)", "")) || string2.equalsIgnoreCase("forge") || string2.equals("*")) continue;
                                        modDependencies.add(string2);
                                        LOG.debug("Added dependency " + string2);
                                    }
                                    continue;
                                }
                                if (!child.get("values").get("dependencies").get("value").asText().matches("(before:.*|after:.*|required-after:.*|)") || modDependencies.contains(dependency32 = child.get("values").get("dependencies").get("value").asText().substring(child.get("values").get("dependencies").get("value").asText().lastIndexOf(":") + 1).replaceAll("(@.*|\\[.*)", "")) || ((String)dependency32).equalsIgnoreCase("forge") || ((String)dependency32).equals("*")) continue;
                                modDependencies.add(dependency32);
                                LOG.debug("Added dependency " + (String)dependency32);
                            }
                            catch (NullPointerException dependency32) {}
                        }
                    }
                    catch (NullPointerException nullPointerException) {
                    }
                }
                if (additionalMods.isEmpty()) continue;
                for (String additionalModId : additionalMods) {
                    for (JsonNode node : modJson) {
                        try {
                            dependency32 = node.get("annotations").iterator();
                            while (dependency32.hasNext()) {
                                String string;
                                JsonNode child = dependency32.next();
                                boolean additionalModDependsOnFirst = false;
                                try {
                                    if (child.get("values").get("modid").get("value").asText().equals(additionalModId) && !child.get("values").get("dependencies").get("value").asText().isEmpty()) {
                                        String dependency4;
                                        if (child.get("values").get("dependencies").get("value").asText().contains(";")) {
                                            String[] dependencies;
                                            for (String dependency5 : dependencies = child.get("values").get("dependencies").get("value").asText().split(";")) {
                                                if (!dependency5.matches("(before:.*|after:.*|required-after:.*|)") || !(dependency5 = dependency5.substring(dependency5.lastIndexOf(":") + 1).replaceAll("(@.*|\\[.*)", "")).equals(modId)) continue;
                                                additionalModDependsOnFirst = true;
                                            }
                                        } else if (child.get("values").get("dependencies").get("value").asText().matches("(before:.*|after:.*|required-after:.*|)") && (dependency4 = child.get("values").get("dependencies").get("value").asText().substring(child.get("values").get("dependencies").get("value").asText().lastIndexOf(":") + 1).replaceAll("(@.*|\\[.*)", "")).equals(modId)) {
                                            additionalModDependsOnFirst = true;
                                        }
                                    }
                                }
                                catch (NullPointerException dependency4) {
                                    // empty catch block
                                }
                                if (!additionalModDependsOnFirst) continue;
                                boolean clientSide = false;
                                try {
                                    for (JsonNode children : node.get("annotations")) {
                                        try {
                                            if (!children.get("values").get("modid").get("value").asText().equals(additionalModId) || !children.get("values").get("clientSideOnly").get("value").asText().equalsIgnoreCase("true")) continue;
                                            clientSide = true;
                                        }
                                        catch (NullPointerException nullPointerException) {}
                                    }
                                }
                                catch (NullPointerException nullPointerException) {
                                    // empty catch block
                                }
                                if (clientSide || !clientMods.removeIf(arg_0 -> ServerPackHandler.lambda$scanAnnotations$12(string = modId, arg_0))) continue;
                                LOG.info("Removing " + modId + " from list of clientside-only mods. It contains multiple mods at once, and one of them is NOT clientside-only.");
                            }
                        }
                        catch (NullPointerException dependency32) {
                        }
                    }
                }
            }
            catch (IOException ex) {
                LOG.error("Couldn't acquire sideness for mod " + file, (Throwable)ex);
            }
            finally {
                try {
                    jarFile.close();
                }
                catch (Exception ex) {}
                try {
                    inputStream.close();
                }
                catch (Exception ex) {}
            }
        }
        for (String string : modDependencies) {
            if (!clientMods.removeIf(n -> n.contains(dependency))) continue;
            LOG.debug("Removing " + string + " from list of clientmods as it is a dependency for another mod.");
        }
        for (File file : filesInModsDir) {
            String modToCheck = file.toString().replace("\\", "/");
            String modIdTocheck = null;
            boolean addToDelta = false;
            JarFile jarFile = null;
            InputStream inputStream = null;
            try {
                jarFile = new JarFile(file);
                JarEntry jarEntry = jarFile.getJarEntry("META-INF/fml_cache_annotation.json");
                inputStream = jarFile.getInputStream(jarEntry);
            }
            catch (Exception ex) {
                LOG.error("Can not scan " + file);
            }
            try {
                if (inputStream == null) continue;
                JsonNode modJson = this.getObjectMapper().readTree(inputStream);
                for (JsonNode node : modJson) {
                    try {
                        for (JsonNode child : node.get("annotations")) {
                            try {
                                if (!child.get("values").get("modid").get("value").asText().isEmpty()) {
                                    modIdTocheck = child.get("values").get("modid").get("value").asText();
                                }
                            }
                            catch (NullPointerException nullPointerException) {
                                // empty catch block
                            }
                            try {
                                if (!child.get("values").get("clientSideOnly").get("value").asText().equalsIgnoreCase("true") || !clientMods.contains(modIdTocheck)) continue;
                                addToDelta = true;
                            }
                            catch (NullPointerException nullPointerException) {}
                        }
                    }
                    catch (NullPointerException nullPointerException) {
                    }
                }
                if (!addToDelta) continue;
                modsDelta.add(modToCheck);
            }
            catch (Exception ex) {
                LOG.error("Couldn't acquire modId for mod " + file, (Throwable)ex);
            }
            finally {
                try {
                    jarFile.close();
                }
                catch (Exception exception) {}
                try {
                    inputStream.close();
                }
                catch (Exception exception) {}
            }
        }
        return modsDelta;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> scanFabricModJson(Collection<File> filesInModsDir) {
        LOG.info(this.LOCALIZATIONMANAGER.getLocalizedString("createserverpack.log.info.scanfabricmodjson"));
        ArrayList modDependencies = new ArrayList();
        ArrayList<String> clientMods = new ArrayList<String>();
        ArrayList<String> modsDelta = new ArrayList<String>();
        for (File mod : filesInModsDir) {
            if (!mod.toString().endsWith("jar")) continue;
            JarFile jarFile = null;
            InputStream inputStream = null;
            try {
                jarFile = new JarFile(mod);
                JarEntry jarEntry = jarFile.getJarEntry("fabric.mod.json");
                inputStream = jarFile.getInputStream(jarEntry);
            }
            catch (Exception ex) {
                LOG.error("Can not scan " + mod);
            }
            try {
                if (inputStream == null) continue;
                JsonNode modJson = this.getObjectMapper().enable(JsonReadFeature.ALLOW_UNESCAPED_CONTROL_CHARS.mappedFeature()).readTree(inputStream);
                String modId = modJson.get("id").asText();
                try {
                    if (modJson.get("environment").asText().equalsIgnoreCase("client") && !clientMods.contains(modId)) {
                        clientMods.add(modId);
                        LOG.debug("Added clientMod: " + modId);
                    }
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                try {
                    modJson.get("depends").fieldNames().forEachRemaining(dependency -> {
                        if (!modDependencies.contains(dependency)) {
                            modDependencies.add(dependency);
                        }
                    });
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
            }
            catch (IOException ex) {
                LOG.error("Couldn't acquire sideness for mod " + mod, (Throwable)ex);
            }
            finally {
                try {
                    jarFile.close();
                }
                catch (Exception ex) {}
                try {
                    inputStream.close();
                }
                catch (Exception ex) {}
            }
        }
        for (String dependency2 : modDependencies) {
            clientMods.removeIf(n -> n.contains(dependency2));
            LOG.debug("Removing " + dependency2 + " from list of clientmods as it is a dependency for another mod.");
        }
        for (File mod : filesInModsDir) {
            String modToCheck = mod.toString().replace("\\", "/");
            boolean addToDelta = false;
            JarFile jarFile = null;
            InputStream inputStream = null;
            try {
                jarFile = new JarFile(mod);
                JarEntry jarEntry = jarFile.getJarEntry("fabric.mod.json");
                inputStream = jarFile.getInputStream(jarEntry);
            }
            catch (Exception ex) {
                LOG.error("Can not scan " + mod);
            }
            try {
                if (inputStream == null) continue;
                JsonNode modJson = this.getObjectMapper().enable(JsonReadFeature.ALLOW_UNESCAPED_CONTROL_CHARS.mappedFeature()).readTree(inputStream);
                String modIdTocheck = modJson.get("id").asText();
                try {
                    if (modJson.get("environment").asText().equalsIgnoreCase("client") && clientMods.contains(modIdTocheck)) {
                        addToDelta = true;
                    }
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                if (!addToDelta) continue;
                modsDelta.add(modToCheck);
            }
            catch (Exception ex) {
                LOG.error("Couldn't acquire modId for mod " + mod, (Throwable)ex);
            }
            finally {
                try {
                    jarFile.close();
                }
                catch (Exception exception) {}
                try {
                    inputStream.close();
                }
                catch (Exception exception) {}
            }
        }
        return modsDelta;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> scanQuiltModJson(Collection<File> filesInModsDir) {
        LOG.info(this.LOCALIZATIONMANAGER.getLocalizedString("createserverpack.log.info.scanquiltmodjson"));
        ArrayList<String> modDependencies = new ArrayList<String>();
        ArrayList<String> clientMods = new ArrayList<String>();
        ArrayList<String> modsDelta = new ArrayList<String>();
        for (File mod : filesInModsDir) {
            if (!mod.toString().endsWith("jar")) continue;
            JarFile jarFile = null;
            InputStream inputStream = null;
            try {
                jarFile = new JarFile(mod);
                JarEntry jarEntry = jarFile.getJarEntry("quilt.mod.json");
                inputStream = jarFile.getInputStream(jarEntry);
            }
            catch (Exception ex) {
                LOG.error("Can not scan " + mod);
            }
            try {
                if (inputStream == null) continue;
                JsonNode modJson = this.getObjectMapper().enable(JsonReadFeature.ALLOW_UNESCAPED_CONTROL_CHARS.mappedFeature()).readTree(inputStream);
                String modId = modJson.get("quilt_loader").get("id").asText();
                try {
                    if (modJson.get("minecraft").get("environment").asText().equalsIgnoreCase("client") && !clientMods.contains(modId)) {
                        clientMods.add(modId);
                        LOG.debug("Added clientMod: " + modId);
                    }
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                try {
                    for (JsonNode dependency : modJson.get("quilt_loader").get("depends")) {
                        if (dependency.isContainerNode()) {
                            if (modDependencies.contains(dependency.get("id").asText())) continue;
                            modDependencies.add(dependency.get("id").asText());
                            continue;
                        }
                        if (modDependencies.contains(dependency.asText())) continue;
                        modDependencies.add(dependency.asText());
                    }
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
            }
            catch (IOException ex) {
                LOG.error("Couldn't acquire sideness for mod " + mod, (Throwable)ex);
            }
            finally {
                try {
                    jarFile.close();
                }
                catch (Exception ex) {}
                try {
                    inputStream.close();
                }
                catch (Exception ex) {}
            }
        }
        for (String dependency : modDependencies) {
            clientMods.removeIf(n -> n.contains(dependency));
            LOG.debug("Removing " + dependency + " from list of clientmods as it is a dependency for another mod.");
        }
        for (File mod : filesInModsDir) {
            String modToCheck = mod.toString().replace("\\", "/");
            boolean addToDelta = false;
            JarFile jarFile = null;
            InputStream inputStream = null;
            try {
                jarFile = new JarFile(mod);
                JarEntry jarEntry = jarFile.getJarEntry("quilt.mod.json");
                inputStream = jarFile.getInputStream(jarEntry);
            }
            catch (Exception ex) {
                LOG.error("Can not scan " + mod);
            }
            try {
                if (inputStream == null) continue;
                JsonNode modJson = this.getObjectMapper().enable(JsonReadFeature.ALLOW_UNESCAPED_CONTROL_CHARS.mappedFeature()).readTree(inputStream);
                String modIdTocheck = modJson.get("quilt_loader").get("id").asText();
                try {
                    if (modJson.get("minecraft").get("environment").asText().equalsIgnoreCase("client") && clientMods.contains(modIdTocheck)) {
                        addToDelta = true;
                    }
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                if (!addToDelta) continue;
                modsDelta.add(modToCheck);
            }
            catch (Exception ex) {
                LOG.error("Couldn't acquire modId for mod " + mod, (Throwable)ex);
            }
            finally {
                try {
                    jarFile.close();
                }
                catch (Exception exception) {}
                try {
                    inputStream.close();
                }
                catch (Exception exception) {}
            }
        }
        return modsDelta;
    }

    private static /* synthetic */ boolean lambda$scanAnnotations$12(String finalModId, String n) {
        return n.equals(finalModId);
    }

    private static class ServerPackFile {
        private final File SOURCE_FILE;
        private final Path SOURCE_PATH;
        private final File DESTINATION_FILE;
        private final Path DESTINATION_PATH;

        public ServerPackFile(File sourceFile, File destinationFile) throws InvalidPathException {
            this.SOURCE_FILE = sourceFile;
            this.SOURCE_PATH = sourceFile.toPath();
            this.DESTINATION_FILE = destinationFile;
            this.DESTINATION_PATH = destinationFile.toPath();
        }

        public ServerPackFile(String sourceFile, String destinationFile) throws NullPointerException, InvalidPathException {
            this.SOURCE_FILE = new File(sourceFile);
            this.SOURCE_PATH = this.SOURCE_FILE.toPath();
            this.DESTINATION_FILE = new File(destinationFile);
            this.DESTINATION_PATH = this.DESTINATION_FILE.toPath();
        }

        public ServerPackFile(Path sourcePath, Path destinationPath) throws UnsupportedOperationException {
            this.SOURCE_FILE = sourcePath.toFile();
            this.SOURCE_PATH = sourcePath;
            this.DESTINATION_FILE = destinationPath.toFile();
            this.DESTINATION_PATH = destinationPath;
        }

        public File source() {
            return this.SOURCE_FILE;
        }

        public File destination() {
            return this.DESTINATION_FILE;
        }

        public Path sourcePath() {
            return this.SOURCE_PATH;
        }

        public Path destinationPath() {
            return this.DESTINATION_PATH;
        }

        public void copy() throws SecurityException, UnsupportedOperationException, IOException {
            try {
                if (!this.SOURCE_FILE.isDirectory()) {
                    FileUtils.copyFile(this.SOURCE_FILE, this.DESTINATION_FILE, true, StandardCopyOption.REPLACE_EXISTING);
                } else {
                    Files.copy(this.SOURCE_PATH, this.DESTINATION_PATH, StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.COPY_ATTRIBUTES);
                }
                LOG.debug("Successfully copied ServerPackFile");
                LOG.debug("    Source: " + this.SOURCE_PATH);
                LOG.debug("    Destination: " + this.DESTINATION_PATH);
            }
            catch (DirectoryNotEmptyException directoryNotEmptyException) {
                // empty catch block
            }
        }

        public String toString() {
            return this.SOURCE_PATH + ";" + this.DESTINATION_PATH;
        }
    }
}

