/*
 * Decompiled with CFR 0.152.
 */
package de.griefed.serverpackcreator;

import de.griefed.serverpackcreator.ApplicationProperties;
import de.griefed.serverpackcreator.ConfigurationHandler;
import de.griefed.serverpackcreator.ConfigurationModel;
import de.griefed.serverpackcreator.ServerPackHandler;
import de.griefed.serverpackcreator.i18n.IncorrectLanguageException;
import de.griefed.serverpackcreator.i18n.LocalizationManager;
import de.griefed.serverpackcreator.plugins.ApplicationPlugins;
import de.griefed.serverpackcreator.swing.ServerPackCreatorGui;
import de.griefed.serverpackcreator.swing.ServerPackCreatorSplash;
import de.griefed.serverpackcreator.utilities.ConfigUtilities;
import de.griefed.serverpackcreator.utilities.ConfigurationCreator;
import de.griefed.serverpackcreator.utilities.UpdateChecker;
import de.griefed.serverpackcreator.utilities.common.Utilities;
import de.griefed.serverpackcreator.utilities.misc.Generated;
import de.griefed.serverpackcreator.versionmeta.VersionMeta;
import de.griefed.versionchecker.Update;
import java.awt.GraphicsEnvironment;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.InputMismatchException;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Scanner;
import java.util.concurrent.Executors;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.monitor.FileAlterationListener;
import org.apache.commons.io.monitor.FileAlterationMonitor;
import org.apache.commons.io.monitor.FileAlterationObserver;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.context.annotation.PropertySource;
import org.springframework.context.annotation.PropertySources;
import org.springframework.scheduling.annotation.EnableScheduling;

@Generated
@SpringBootApplication
@EnableScheduling
@PropertySources(value={@PropertySource(value={"classpath:application.properties"}), @PropertySource(value={"classpath:serverpackcreator.properties"})})
public class ServerPackCreator {
    private static final Logger LOG = LogManager.getLogger(ServerPackCreator.class);
    private final CommandlineParser COMMANDLINE_PARSER;
    private final ApplicationProperties APPLICATIONPROPERTIES;
    private final LocalizationManager LOCALIZATIONMANAGER;
    private final String[] ARGS;
    private final File LOG4J2XML = new File("log4j2.xml");
    private final File SERVERPACKCREATOR_PROPERTIES = new File("serverpackcreator.properties");
    private Utilities utilities = null;
    private VersionMeta versionMeta = null;
    private ConfigUtilities configUtilities = null;
    private ConfigurationHandler configurationHandler = null;
    private ApplicationPlugins applicationPlugins = null;
    private ServerPackHandler serverPackHandler = null;
    private ServerPackCreatorSplash serverPackCreatorSplash = null;
    private UpdateChecker updateChecker = null;
    private HashMap<String, String> systemInformation;

    public ServerPackCreator(String[] args) {
        this.ARGS = args;
        this.COMMANDLINE_PARSER = new CommandlineParser(this.ARGS);
        this.APPLICATIONPROPERTIES = new ApplicationProperties();
        this.LOCALIZATIONMANAGER = this.COMMANDLINE_PARSER.getLanguageToUse().isPresent() ? new LocalizationManager(this.APPLICATIONPROPERTIES, this.COMMANDLINE_PARSER.getLanguageToUse().get()) : new LocalizationManager(this.APPLICATIONPROPERTIES);
    }

    public static void main(String[] args) throws IOException {
        ServerPackCreator serverPackCreator = new ServerPackCreator(args);
        serverPackCreator.run();
    }

    public static void web(String[] args) {
        SpringApplication.run(ServerPackCreator.class, args);
    }

    public void run() throws IOException {
        this.run(this.COMMANDLINE_PARSER.getModeToRunIn());
    }

    public void run(CommandlineParser.Mode modeToRunIn) throws IOException {
        switch (modeToRunIn) {
            case HELP: {
                this.printHelp();
                this.continuedRunOptions();
                break;
            }
            case UPDATE: {
                this.updateCheck();
                this.continuedRunOptions();
                break;
            }
            case WEB: {
                this.stageOne();
                this.stageFour();
                this.checkDatabase();
                this.runWebservice();
                break;
            }
            case CGEN: {
                this.stageOne();
                this.stageTwo();
                this.createConfig();
                this.continuedRunOptions();
                break;
            }
            case CLI: {
                this.stageOne();
                this.stageTwo();
                this.stageThree();
                this.runHeadless();
                break;
            }
            case GUI: {
                this.showSplashScreen();
                this.stageOne();
                this.serverPackCreatorSplash.update(20);
                this.stageTwo();
                this.serverPackCreatorSplash.update(40);
                this.stageThree();
                this.serverPackCreatorSplash.update(60);
                Executors.newSingleThreadExecutor().execute(this::stageFour);
                this.serverPackCreatorSplash.update(80);
                this.runGui();
                break;
            }
            case SETUP: {
                this.stageOne();
            }
            default: {
                LOG.debug("Exit specified or invalid mode chosen. Exiting...");
            }
        }
    }

    private void stageOne() {
        Object langSource;
        System.setProperty("log4j2.formatMsgNoLookups", "true");
        System.setProperty("file.encoding", StandardCharsets.UTF_8.name());
        this.utilities = new Utilities(this.LOCALIZATIONMANAGER, this.APPLICATIONPROPERTIES);
        this.systemInformation = this.utilities.JarUtils().systemInformation(this.utilities.JarUtils().getApplicationHomeForClass(ServerPackCreator.class));
        LOG.debug("System information jarPath: " + this.systemInformation.get("jarPath"));
        LOG.debug("System information jarName: " + this.systemInformation.get("jarName"));
        if (!this.utilities.FileUtils().checkPermissions(new File(this.systemInformation.get("jarPath")).getParentFile())) {
            LOG.error("One or more file or directory has no read- or write-permission. This may lead to corrupted server packs! Check the permissions of the ServerPackCreator base directory!");
        }
        this.utilities.JarUtils().copyFileFromJar(this.LOG4J2XML, ServerPackCreator.class);
        if (!this.SERVERPACKCREATOR_PROPERTIES.exists()) {
            try {
                this.SERVERPACKCREATOR_PROPERTIES.createNewFile();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        try {
            String prefix = "BOOT-INF/classes";
            langSource = "/de/griefed/resources/lang";
            if (this.systemInformation.get("jarName").endsWith(".exe")) {
                prefix = "";
                langSource = "de/griefed/resources/lang";
            }
            this.utilities.JarUtils().copyFolderFromJar(ServerPackCreator.class, (String)langSource, "lang", prefix, ".properties");
        }
        catch (IOException ex) {
            LOG.error("Error copying \"/de/griefed/resources/lang\" from the JAR-file.");
        }
        try {
            Files.createDirectories(Paths.get("./server_files", new String[0]), new FileAttribute[0]);
        }
        catch (IOException ex) {
            LOG.error("Could not create server_files directory.", (Throwable)ex);
        }
        try {
            Files.createDirectories(Paths.get("./work", new String[0]), new FileAttribute[0]);
        }
        catch (IOException ex) {
            LOG.error("Could not create work directory.", (Throwable)ex);
        }
        try {
            Files.createDirectories(Paths.get("./work/temp", new String[0]), new FileAttribute[0]);
        }
        catch (IOException ex) {
            LOG.error("Could not create work/temp directory.", (Throwable)ex);
        }
        try {
            Files.createDirectories(Paths.get("./work/modpacks", new String[0]), new FileAttribute[0]);
        }
        catch (IOException ex) {
            LOG.error("Could not create work/modpacks directory.", (Throwable)ex);
        }
        try {
            Files.createDirectories(Paths.get("./server-packs", new String[0]), new FileAttribute[0]);
        }
        catch (IOException ex) {
            LOG.error("Could not create server-packs directory.", (Throwable)ex);
        }
        try {
            Files.createDirectories(Paths.get(System.getProperty("pf4j.pluginsDir", "./plugins"), new String[0]), new FileAttribute[0]);
        }
        catch (IOException ex) {
            LOG.error("Could not create plugins directory.", (Throwable)ex);
        }
        if (!new File(System.getProperty("pf4j.pluginsDir", "./plugins") + "/disabled.txt").isFile()) {
            try {
                BufferedWriter writer = new BufferedWriter(new FileWriter(Paths.get(System.getProperty("pf4j.pluginsDir", "./plugins"), new String[0]) + "/disabled.txt"));
                langSource = null;
                try {
                    writer.write("########################################\n");
                    writer.write("# - Load all plugins except these.   - #\n");
                    writer.write("# - Add one plugin-id per line.      - #\n");
                    writer.write("########################################\n");
                    writer.write("#example-plugin\n");
                }
                catch (Throwable throwable) {
                    langSource = throwable;
                    throw throwable;
                }
                finally {
                    if (writer != null) {
                        if (langSource != null) {
                            try {
                                writer.close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)langSource).addSuppressed(throwable);
                            }
                        } else {
                            writer.close();
                        }
                    }
                }
            }
            catch (IOException ex) {
                LOG.error("Error generating disable.txt in the plugins directory.", (Throwable)ex);
            }
        }
        boolean config = this.checkForConfig();
        boolean serverProperties = this.checkServerFilesFile(this.APPLICATIONPROPERTIES.DEFAULT_SERVER_PROPERTIES());
        boolean serverIcon = this.checkServerFilesFile(this.APPLICATIONPROPERTIES.DEFAULT_SERVER_ICON());
        if (config || serverProperties || serverIcon) {
            LOG.warn(this.LOCALIZATIONMANAGER.getLocalizedString("defaultfiles.log.warn.filessetup.warning0"));
            LOG.warn(this.LOCALIZATIONMANAGER.getLocalizedString("defaultfiles.log.warn.filessetup.warning1"));
            LOG.warn(this.LOCALIZATIONMANAGER.getLocalizedString("defaultfiles.log.warn.filessetup.warning2"));
            LOG.warn(this.LOCALIZATIONMANAGER.getLocalizedString("defaultfiles.log.warn.filessetup.warning3"));
            LOG.warn(this.LOCALIZATIONMANAGER.getLocalizedString("defaultfiles.log.warn.filessetup.warning0"));
        } else {
            LOG.info(this.LOCALIZATIONMANAGER.getLocalizedString("defaultfiles.log.info.filessetup.finish"));
        }
        LOG.debug("Gathering system information to include in log to make debugging easier.");
        this.APPLICATIONPROPERTIES.setProperty("homeDir", this.systemInformation.get("jarPath").substring(0, this.systemInformation.get("jarPath").replace("\\", "/").lastIndexOf("/")).replace("\\", "/"));
        if (this.APPLICATIONPROPERTIES.SERVERPACKCREATOR_VERSION().contains("dev") || this.APPLICATIONPROPERTIES.SERVERPACKCREATOR_VERSION().contains("alpha") || this.APPLICATIONPROPERTIES.SERVERPACKCREATOR_VERSION().contains("beta")) {
            LOG.debug(this.LOCALIZATIONMANAGER.getLocalizedString("main.log.debug.warning"));
            LOG.warn(this.LOCALIZATIONMANAGER.getLocalizedString("main.log.warn.wip0"));
            LOG.warn(this.LOCALIZATIONMANAGER.getLocalizedString("main.log.warn.wip1"));
            LOG.warn(this.LOCALIZATIONMANAGER.getLocalizedString("main.log.warn.wip2"));
            LOG.warn(this.LOCALIZATIONMANAGER.getLocalizedString("main.log.warn.wip3"));
            LOG.warn(this.LOCALIZATIONMANAGER.getLocalizedString("main.log.warn.wip4"));
            LOG.warn(this.LOCALIZATIONMANAGER.getLocalizedString("main.log.warn.wip0"));
        }
        LOG.info(this.LOCALIZATIONMANAGER.getLocalizedString("main.log.info.system.enter"));
        LOG.info("ServerPackCreator version: " + this.APPLICATIONPROPERTIES.SERVERPACKCREATOR_VERSION());
        LOG.info(String.format(this.LOCALIZATIONMANAGER.getLocalizedString("main.log.info.system.jarpath"), this.systemInformation.get("jarPath")));
        LOG.info(String.format(this.LOCALIZATIONMANAGER.getLocalizedString("main.log.info.system.jarname"), this.systemInformation.get("jarName")));
        LOG.info(String.format(this.LOCALIZATIONMANAGER.getLocalizedString("main.log.info.system.java"), this.systemInformation.get("javaVersion")));
        LOG.info(String.format(this.LOCALIZATIONMANAGER.getLocalizedString("main.log.info.system.osarchitecture"), this.systemInformation.get("osArch")));
        LOG.info(String.format(this.LOCALIZATIONMANAGER.getLocalizedString("main.log.info.system.osname"), this.systemInformation.get("osName")));
        LOG.info(String.format(this.LOCALIZATIONMANAGER.getLocalizedString("main.log.info.system.osversion"), this.systemInformation.get("osVersion")));
        LOG.info(this.LOCALIZATIONMANAGER.getLocalizedString("main.log.info.system.include"));
    }

    private void stageTwo() throws IOException {
        this.versionMeta = new VersionMeta(this.APPLICATIONPROPERTIES.MINECRAFT_VERSION_MANIFEST_LOCATION(), this.APPLICATIONPROPERTIES.FORGE_VERSION_MANIFEST_LOCATION(), this.APPLICATIONPROPERTIES.FABRIC_VERSION_MANIFEST_LOCATION(), this.APPLICATIONPROPERTIES.FABRIC_INSTALLER_VERSION_MANIFEST_LOCATION(), this.APPLICATIONPROPERTIES.QUILT_VERSION_MANIFEST_LOCATION(), this.APPLICATIONPROPERTIES.QUILT_INSTALLER_VERSION_MANIFEST_LOCATION());
        this.configUtilities = new ConfigUtilities(this.LOCALIZATIONMANAGER, this.utilities, this.APPLICATIONPROPERTIES, this.versionMeta);
        this.configurationHandler = new ConfigurationHandler(this.LOCALIZATIONMANAGER, this.versionMeta, this.APPLICATIONPROPERTIES, this.utilities, this.configUtilities);
    }

    private void stageThree() throws IOException {
        this.applicationPlugins = new ApplicationPlugins();
        this.serverPackHandler = new ServerPackHandler(this.LOCALIZATIONMANAGER, this.APPLICATIONPROPERTIES, this.versionMeta, this.utilities, this.applicationPlugins);
        if (this.updateChecker == null) {
            this.updateChecker = new UpdateChecker();
        }
    }

    private void stageFour() {
        LOG.debug("Setting up FileWatcher...");
        FileAlterationObserver fileAlterationObserver = new FileAlterationObserver(new File("."));
        FileAlterationListener fileAlterationListener = new FileAlterationListener(){

            @Override
            public void onStart(FileAlterationObserver observer) {
            }

            @Override
            public void onDirectoryCreate(File directory) {
            }

            @Override
            public void onDirectoryChange(File directory) {
            }

            @Override
            public void onDirectoryDelete(File directory) {
            }

            @Override
            public void onFileCreate(File file) {
            }

            @Override
            public void onFileChange(File file) {
            }

            @Override
            public void onFileDelete(File file) {
                if (!file.toString().replace("\\", "/").startsWith("./server-packs") && !file.toString().replace("\\", "/").startsWith("./work/modpacks")) {
                    if (this.check(file, ServerPackCreator.this.APPLICATIONPROPERTIES.SERVERPACKCREATOR_PROPERTIES())) {
                        this.createFile(ServerPackCreator.this.APPLICATIONPROPERTIES.SERVERPACKCREATOR_PROPERTIES());
                        ServerPackCreator.this.APPLICATIONPROPERTIES.reload();
                        LOG.info("Restored serverpackcreator.properties and loaded defaults.");
                    } else if (this.check(file, ServerPackCreator.this.APPLICATIONPROPERTIES.DEFAULT_SERVER_PROPERTIES())) {
                        ServerPackCreator.this.checkServerFilesFile(ServerPackCreator.this.APPLICATIONPROPERTIES.DEFAULT_SERVER_PROPERTIES());
                        LOG.info("Restored default server.properties.");
                    } else if (this.check(file, ServerPackCreator.this.APPLICATIONPROPERTIES.DEFAULT_SERVER_ICON())) {
                        ServerPackCreator.this.checkServerFilesFile(ServerPackCreator.this.APPLICATIONPROPERTIES.DEFAULT_SERVER_ICON());
                        LOG.info("Restored default server-icon.png.");
                    }
                }
            }

            @Override
            public void onStop(FileAlterationObserver observer) {
            }

            private boolean check(File watched, File toCreate) {
                return watched.toString().replace("\\", "/").substring(watched.toString().replace("\\", "/").lastIndexOf("/") + 1).equals(toCreate.toString());
            }

            private void createFile(File toCreate) {
                try {
                    FileUtils.copyInputStreamToFile(Objects.requireNonNull(ServerPackCreator.class.getResourceAsStream("/" + toCreate.getName())), toCreate);
                }
                catch (IOException ex) {
                    LOG.error("Error creating file: " + toCreate, (Throwable)ex);
                }
            }
        };
        fileAlterationObserver.addListener(fileAlterationListener);
        FileAlterationMonitor fileAlterationMonitor = new FileAlterationMonitor(1000L);
        fileAlterationMonitor.addObserver(fileAlterationObserver);
        try {
            fileAlterationMonitor.start();
        }
        catch (Exception ex) {
            LOG.error("Error starting the FileWatcher Monitor.", (Throwable)ex);
        }
        LOG.debug("File-watcher started...");
    }

    private void showSplashScreen() {
        this.serverPackCreatorSplash = new ServerPackCreatorSplash(this.APPLICATIONPROPERTIES.SERVERPACKCREATOR_VERSION());
    }

    private void runGui() throws IOException {
        if (this.updateChecker == null) {
            this.updateChecker = new UpdateChecker();
        }
        new ServerPackCreatorGui(this.LOCALIZATIONMANAGER, this.configurationHandler, this.serverPackHandler, this.APPLICATIONPROPERTIES, this.versionMeta, this.utilities, this.updateChecker, this.applicationPlugins, this.configUtilities, this.serverPackCreatorSplash).mainGUI();
    }

    private void continuedRunOptions() throws IOException {
        int selection;
        this.printMenu();
        Scanner scanner = new Scanner(System.in);
        block13: do {
            try {
                selection = scanner.nextInt();
                if (selection == 7 && GraphicsEnvironment.isHeadless()) {
                    System.out.println(this.LOCALIZATIONMANAGER.getLocalizedString("run.menu.error.gui"));
                    selection = 100;
                }
                switch (selection) {
                    case 1: {
                        this.printHelp();
                        this.printMenu();
                        selection = 100;
                        break;
                    }
                    case 2: {
                        this.updateCheck();
                        this.printMenu();
                        selection = 100;
                        break;
                    }
                    case 3: {
                        this.changeLocale();
                        this.printMenu();
                        selection = 100;
                        break;
                    }
                    case 4: {
                        this.createConfig();
                        this.printMenu();
                        selection = 100;
                        break;
                    }
                    default: {
                        if (selection <= 7) continue block13;
                        System.out.println(this.LOCALIZATIONMANAGER.getLocalizedString("run.menu.error.selection"));
                        this.printMenu();
                        break;
                    }
                }
            }
            catch (InputMismatchException ex) {
                System.out.println(this.LOCALIZATIONMANAGER.getLocalizedString("run.menu.error.selection"));
                selection = 100;
            }
        } while (selection > 7);
        scanner.close();
        switch (selection) {
            case 5: {
                this.run(CommandlineParser.Mode.CLI);
                break;
            }
            case 6: {
                this.run(CommandlineParser.Mode.WEB);
                break;
            }
            case 7: {
                this.run(CommandlineParser.Mode.GUI);
                break;
            }
            default: {
                System.out.println(this.LOCALIZATIONMANAGER.getLocalizedString("run.menu.exit"));
                System.exit(0);
            }
        }
    }

    private void changeLocale() {
        String userLocale;
        System.out.println(this.LOCALIZATIONMANAGER.getLocalizedString("run.menu.change.locale"));
        System.out.println(this.LOCALIZATIONMANAGER.getLocalizedString("run.menu.change.locale.format"));
        Scanner scanner = new Scanner(System.in);
        String regex = "^[a-zA-Z]+_[a-zA-Z]+$";
        do {
            if (!(userLocale = scanner.next()).matches(regex)) {
                System.out.println(this.LOCALIZATIONMANAGER.getLocalizedString("run.menu.change.locale.error"));
                continue;
            }
            try {
                this.LOCALIZATIONMANAGER.initialize(userLocale);
            }
            catch (IncorrectLanguageException e) {
                System.out.println(this.LOCALIZATIONMANAGER.getLocalizedString("run.menu.change.locale.error"));
                userLocale = "";
            }
        } while (!userLocale.matches(regex));
        scanner.close();
        System.out.println(this.LOCALIZATIONMANAGER.getLocalizedString("cli.usingLanguage") + " " + this.LOCALIZATIONMANAGER.getLocalizedString("localeName"));
    }

    private void printMenu() {
        int i2;
        System.out.println();
        System.out.println(this.LOCALIZATIONMANAGER.getLocalizedString("run.menu.options"));
        System.out.println("(1) : " + this.LOCALIZATIONMANAGER.getLocalizedString("run.menu.options1"));
        System.out.println("(2) : " + this.LOCALIZATIONMANAGER.getLocalizedString("run.menu.options2"));
        System.out.println("(3) : " + this.LOCALIZATIONMANAGER.getLocalizedString("run.menu.options3"));
        System.out.println("(4) : " + this.LOCALIZATIONMANAGER.getLocalizedString("run.menu.options4"));
        System.out.println("(5) : " + this.LOCALIZATIONMANAGER.getLocalizedString("run.menu.options5"));
        System.out.println("(6) : " + this.LOCALIZATIONMANAGER.getLocalizedString("run.menu.options6"));
        System.out.println("(7) : " + this.LOCALIZATIONMANAGER.getLocalizedString("run.menu.options7"));
        System.out.println("(0) : " + this.LOCALIZATIONMANAGER.getLocalizedString("run.menu.options0"));
        int lengthOfText = 0;
        for (i2 = 0; i2 < 8; ++i2) {
            if (this.LOCALIZATIONMANAGER.getLocalizedString("run.menu.options" + i2).length() + 6 <= lengthOfText) continue;
            lengthOfText = this.LOCALIZATIONMANAGER.getLocalizedString("run.menu.options" + i2).length() + 6;
        }
        for (i2 = 0; i2 < lengthOfText; ++i2) {
            System.out.print("-");
        }
        System.out.println();
        System.out.print(this.LOCALIZATIONMANAGER.getLocalizedString("run.menu.options.select") + ": ");
    }

    private void runHeadless() throws IOException {
        if (!new File("serverpackcreator.conf").exists()) {
            this.createConfig();
        }
        ConfigurationModel configurationModel = new ConfigurationModel();
        if (this.configurationHandler.checkConfiguration(this.APPLICATIONPROPERTIES.DEFAULT_CONFIG(), configurationModel, false) && this.serverPackHandler.run(configurationModel)) {
            System.exit(0);
        } else {
            System.exit(1);
        }
    }

    private void createConfig() throws IOException {
        new ConfigurationCreator(this.LOCALIZATIONMANAGER, this.configurationHandler, this.APPLICATIONPROPERTIES, this.utilities, this.versionMeta, this.configUtilities).createConfigurationFile();
    }

    private void runWebservice() {
        if (this.systemInformation.get("osName").contains("windows") || this.systemInformation.get("osName").contains("Windows")) {
            Scanner reader = new Scanner(System.in);
            LOG.warn(this.LOCALIZATIONMANAGER.getLocalizedString("main.log.warn.windows"));
            System.out.print(this.LOCALIZATIONMANAGER.getLocalizedString("main.log.warn.windows.input") + " ");
            String answer = "foobar";
            do {
                if ((answer = reader.nextLine()).equals("No")) {
                    LOG.info(this.LOCALIZATIONMANAGER.getLocalizedString("main.log.warn.windows.no"));
                    reader.close();
                    System.exit(0);
                    continue;
                }
                if (!answer.equals("Yes")) continue;
                LOG.warn(this.LOCALIZATIONMANAGER.getLocalizedString("main.log.warn.windows.yes"));
                reader.close();
                ServerPackCreator.web(this.ARGS);
            } while (!answer.matches("^(Yes|No)$"));
        } else {
            ServerPackCreator.web(this.ARGS);
        }
    }

    public boolean checkForConfig() {
        boolean firstRun;
        block8: {
            firstRun = false;
            if (this.APPLICATIONPROPERTIES.OLD_CONFIG().exists()) {
                try {
                    Files.copy(this.APPLICATIONPROPERTIES.OLD_CONFIG().getAbsoluteFile().toPath(), this.APPLICATIONPROPERTIES.DEFAULT_CONFIG().getAbsoluteFile().toPath(), new CopyOption[0]);
                    if (this.APPLICATIONPROPERTIES.OLD_CONFIG().delete()) {
                        LOG.info(this.LOCALIZATIONMANAGER.getLocalizedString("defaultfiles.log.info.checkforconfig.old"));
                    }
                    break block8;
                }
                catch (IOException ex) {
                    if (!ex.toString().startsWith("java.nio.file.FileAlreadyExistsException")) {
                        LOG.error("Error renaming creator.conf to serverpackcreator.conf.", (Throwable)ex);
                    }
                    break block8;
                }
            }
            if (!this.APPLICATIONPROPERTIES.DEFAULT_CONFIG().exists()) {
                try {
                    FileUtils.copyInputStreamToFile(Objects.requireNonNull(ServerPackCreator.class.getResourceAsStream(String.format("/de/griefed/resources/%s", this.APPLICATIONPROPERTIES.DEFAULT_CONFIG().getName()))), this.APPLICATIONPROPERTIES.DEFAULT_CONFIG());
                    LOG.info(this.LOCALIZATIONMANAGER.getLocalizedString("defaultfiles.log.info.checkforconfig.config"));
                    firstRun = true;
                }
                catch (IOException ex) {
                    if (ex.toString().startsWith("java.nio.file.FileAlreadyExistsException")) break block8;
                    LOG.error("Could not extract default config-file.", (Throwable)ex);
                    firstRun = true;
                }
            }
        }
        return firstRun;
    }

    public boolean checkServerFilesFile(File fileToCheckFor) {
        boolean firstRun;
        block3: {
            firstRun = false;
            if (!new File(String.format("server_files/%s", fileToCheckFor)).exists()) {
                try {
                    FileUtils.copyInputStreamToFile(Objects.requireNonNull(ServerPackCreator.class.getResourceAsStream(String.format("/de/griefed/resources/server_files/%s", fileToCheckFor))), new File(String.format("./server_files/%s", fileToCheckFor)));
                    LOG.info(String.format(this.LOCALIZATIONMANAGER.getLocalizedString("defaultfiles.log.info.checkforfile"), fileToCheckFor));
                    firstRun = true;
                }
                catch (IOException ex) {
                    if (ex.toString().startsWith("java.nio.file.FileAlreadyExistsException")) break block3;
                    LOG.error(String.format("Could not extract default %s file.", fileToCheckFor), (Throwable)ex);
                    firstRun = true;
                }
            }
        }
        return firstRun;
    }

    public void checkDatabase() {
        Connection connection = null;
        try {
            connection = DriverManager.getConnection("jdbc:sqlite:" + this.APPLICATIONPROPERTIES.SERVERPACKCREATOR_DATABASE());
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            LOG.debug("Database driver name: " + databaseMetaData.getDriverName());
            LOG.debug("Database driver version: " + databaseMetaData.getDriverVersion());
            LOG.debug("Database product name: " + databaseMetaData.getDatabaseProductName());
            LOG.debug("Database product version: " + databaseMetaData.getDatabaseProductVersion());
        }
        catch (SQLException ex) {
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException ex) {
                    LOG.error("Couldn't close SQL connection", (Throwable)ex);
                }
            }
        }
    }

    public void updateCheck() {
        if (this.updateChecker == null) {
            this.updateChecker = new UpdateChecker();
        } else {
            this.updateChecker.refresh();
        }
        Optional<Update> update = this.updateChecker.checkForUpdate(this.APPLICATIONPROPERTIES.SERVERPACKCREATOR_VERSION(), this.APPLICATIONPROPERTIES.checkForAvailablePreReleases());
        System.out.println();
        if (update.isPresent()) {
            System.out.println(this.LOCALIZATIONMANAGER.getLocalizedString("update.dialog.available"));
            System.out.println("    " + update.get().version());
            System.out.println("    " + update.get().url());
        } else {
            System.out.println(this.LOCALIZATIONMANAGER.getLocalizedString("updates.log.info.none"));
        }
    }

    private void printHelp() {
        System.out.println(this.LOCALIZATIONMANAGER.getLocalizedString("serverpackcreator.help.intro"));
        System.out.println(this.LOCALIZATIONMANAGER.getLocalizedString("serverpackcreator.help.arguments.intro"));
        System.out.println(this.LOCALIZATIONMANAGER.getLocalizedString("serverpackcreator.help.arguments.lang"));
        System.out.println(this.LOCALIZATIONMANAGER.getLocalizedString("serverpackcreator.help.arguments.help"));
        System.out.println(this.LOCALIZATIONMANAGER.getLocalizedString("serverpackcreator.help.arguments.update"));
        System.out.println(this.LOCALIZATIONMANAGER.getLocalizedString("serverpackcreator.help.arguments.cgen"));
        System.out.println(this.LOCALIZATIONMANAGER.getLocalizedString("serverpackcreator.help.arguments.cli"));
        System.out.println(this.LOCALIZATIONMANAGER.getLocalizedString("serverpackcreator.help.arguments.web"));
        System.out.println(this.LOCALIZATIONMANAGER.getLocalizedString("serverpackcreator.help.arguments.gui"));
        System.out.println(this.LOCALIZATIONMANAGER.getLocalizedString("serverpackcreator.help.arguments.setup"));
        System.out.println(this.LOCALIZATIONMANAGER.getLocalizedString("serverpackcreator.help.support.intro"));
        System.out.println(this.LOCALIZATIONMANAGER.getLocalizedString("serverpackcreator.help.support.issues"));
        System.out.println(this.LOCALIZATIONMANAGER.getLocalizedString("serverpackcreator.help.support.discord"));
        System.out.println(this.LOCALIZATIONMANAGER.getLocalizedString("serverpackcreator.help.support.wiki"));
        System.out.println(this.LOCALIZATIONMANAGER.getLocalizedString("serverpackcreator.help.support.someluv"));
    }

    public static class CommandlineParser {
        private final Mode MODE;
        private final String LANG;

        public CommandlineParser(String[] args) {
            List<String> argsList = Arrays.asList(args);
            this.LANG = argsList.contains(Mode.LANG.argument()) ? argsList.get(argsList.indexOf(Mode.LANG.argument()) + 1) : null;
            if (argsList.contains(Mode.HELP.argument())) {
                this.MODE = Mode.HELP;
                return;
            }
            if (argsList.contains(Mode.UPDATE.argument())) {
                this.MODE = Mode.UPDATE;
                return;
            }
            if (argsList.contains(Mode.CGEN.argument())) {
                this.MODE = Mode.CGEN;
                return;
            }
            if (argsList.contains(Mode.CLI.argument())) {
                this.MODE = Mode.CLI;
                return;
            }
            if (GraphicsEnvironment.isHeadless()) {
                this.MODE = Mode.CLI;
                return;
            }
            if (argsList.contains(Mode.WEB.argument())) {
                this.MODE = Mode.WEB;
                return;
            }
            if (argsList.contains(Mode.GUI.argument())) {
                this.MODE = Mode.GUI;
                return;
            }
            if (argsList.contains(Mode.SETUP.argument())) {
                this.MODE = Mode.SETUP;
                return;
            }
            if (!GraphicsEnvironment.isHeadless()) {
                this.MODE = Mode.GUI;
                return;
            }
            this.MODE = Mode.EXIT;
        }

        protected Mode getModeToRunIn() {
            return this.MODE;
        }

        protected Optional<String> getLanguageToUse() {
            return Optional.ofNullable(this.LANG);
        }

        public static enum Mode {
            HELP("-help"),
            UPDATE("-update"),
            CGEN("-cgen"),
            CLI("-cli"),
            WEB("-web"),
            GUI("-gui"),
            SETUP("--setup"),
            EXIT("exit"),
            LANG("-lang");

            private final String ARGUMENT;

            private Mode(String cliArg) {
                this.ARGUMENT = cliArg;
            }

            public String argument() {
                return this.ARGUMENT;
            }
        }
    }
}

