/*
 * Decompiled with CFR 0.152.
 */
package de.griefed.serverpackcreator;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.ClassPathResource;
import org.springframework.stereotype.Component;

@Component
public class ApplicationProperties
extends Properties {
    private static final Logger LOG = LogManager.getLogger(ApplicationProperties.class);
    private final File SERVERPACKCREATOR_PROPERTIES = new File("serverpackcreator.properties");
    private final File START_SCRIPT_WINDOWS = new File("start.bat");
    private final File START_SCRIPT_LINUX = new File("start.sh");
    private final File USER_JVM_ARGS = new File("user_jvm_args.txt");
    private final String FALLBACK_MODS_DEFAULT_ASSTRING = "3dSkinLayers-,3dskinlayers-,Absolutely-Not-A-Zoom-Mod-,AdvancementPlaques-,AmbientEnvironment-,AmbientSounds_,antighost-,armorchroma-,armorpointspp-,ArmorSoundTweak-,authme-,autoreconnect-,auto-reconnect-,axolotl-item-fix-,backtools-,BetterAdvancements-,BetterAnimationsCollection-,betterbiomeblend-,BetterDarkMode-,BetterF3-,BetterFoliage-,BetterPingDisplay-,BetterPlacement-,BetterTaskbar-,bhmenu-,BH-Menu-,blur-,Blur-,borderless-mining-,catalogue-,charmonium-,Charmonium-,chat_heads-,cherishedworlds-,classicbar-,clickadv-,ClientTweaks_,configured-,Controlling-,CraftPresence-,CTM-,cullleaves-,customdiscordrpc-,CustomMainMenu-,dashloader-,DefaultOptions_,defaultoptions-,DefaultSettings-,DeleteWorldsToTrash-,desiredservers-,Ding-,drippyloadingscreen_,drippyloadingscreen-,DripSounds-,Durability101-,DurabilityNotifier-,dynamic-fps-,dynamic-music-,DynamicSurroundings-,DynamicSurroundingsHuds-,dynmus-,effective-,eggtab-,EiraMoticons_,eiramoticons-,EnchantmentDescriptions-,entity-texture-features-,EquipmentCompare-,extremesoundmuffler-,extremeSoundMuffler-,fabricemotes-,Fallingleaves-,fallingleaves-,fancymenu_,findme-,flickerfix-,FPS-Monitor-,FpsReducer-,FullscreenWindowed-,InventoryEssentials_,InventorySpam-,InventoryTweaks-,invtweaks-,ItemBorders-,ItemStitchingFix-,itemzoom,itlt-,jeed-,jehc-,jeiintegration_,just-enough-harvestcraft-,justenoughbeacons-,JustEnoughCalculation-,JustEnoughProfessions-,JustEnoughProfessions-,JustEnoughResources-,keymap-,keywizard-,konkrete_,lazydfu-,LegendaryTooltips-,light-overlay-,LightOverlay-,LLOverlayReloaded-,loadmyresources_,lootbeams-,mcbindtype-,medievalmusic-,modcredits-,modmenu-,modnametooltip_,modnametooltip-,moreoverlays-,MouseTweaks-,movement-vision-,multihotbar-,musicdr-,music-duration-reducer-,MyServerIsCompatible-,Neat ,ngrok-lan-expose-mod-,NotifMod-,OldJavaWarning-,OptiFine,OptiForge,ornaments-,overloadedarmorbar-,PackMenu-,PickUpNotifier-,Ping-,preciseblockplacing-,presencefootsteps-,PresenceFootsteps-,ReAuth-,rebrand-,ResourceLoader-,shutupexperimentalsettings-,SimpleDiscordRichPresence-,smoothboot-,sounddeviceoptions-,SpawnerFix-,spoticraft-,tconplanner-,timestamps-,Tips-,TipTheScales-,Toast Control-,Toast-Control-,ToastControl-,torchoptimizer-,torohealth-,toughnessbar-,TravelersTitles-,WindowedFullscreen-,WorldNameRandomizer-,yisthereautojump-";
    private final String SERVERPACKCREATOR_VERSION;
    private final String[] SUPPORTED_MODLOADERS = new String[]{"Fabric", "Forge", "Quilt"};
    private final List<String> FALLBACK_CLIENTSIDE_MODS = new ArrayList<String>(Arrays.asList("3dSkinLayers-,3dskinlayers-,Absolutely-Not-A-Zoom-Mod-,AdvancementPlaques-,AmbientEnvironment-,AmbientSounds_,antighost-,armorchroma-,armorpointspp-,ArmorSoundTweak-,authme-,autoreconnect-,auto-reconnect-,axolotl-item-fix-,backtools-,BetterAdvancements-,BetterAnimationsCollection-,betterbiomeblend-,BetterDarkMode-,BetterF3-,BetterFoliage-,BetterPingDisplay-,BetterPlacement-,BetterTaskbar-,bhmenu-,BH-Menu-,blur-,Blur-,borderless-mining-,catalogue-,charmonium-,Charmonium-,chat_heads-,cherishedworlds-,classicbar-,clickadv-,ClientTweaks_,configured-,Controlling-,CraftPresence-,CTM-,cullleaves-,customdiscordrpc-,CustomMainMenu-,dashloader-,DefaultOptions_,defaultoptions-,DefaultSettings-,DeleteWorldsToTrash-,desiredservers-,Ding-,drippyloadingscreen_,drippyloadingscreen-,DripSounds-,Durability101-,DurabilityNotifier-,dynamic-fps-,dynamic-music-,DynamicSurroundings-,DynamicSurroundingsHuds-,dynmus-,effective-,eggtab-,EiraMoticons_,eiramoticons-,EnchantmentDescriptions-,entity-texture-features-,EquipmentCompare-,extremesoundmuffler-,extremeSoundMuffler-,fabricemotes-,Fallingleaves-,fallingleaves-,fancymenu_,findme-,flickerfix-,FPS-Monitor-,FpsReducer-,FullscreenWindowed-,InventoryEssentials_,InventorySpam-,InventoryTweaks-,invtweaks-,ItemBorders-,ItemStitchingFix-,itemzoom,itlt-,jeed-,jehc-,jeiintegration_,just-enough-harvestcraft-,justenoughbeacons-,JustEnoughCalculation-,JustEnoughProfessions-,JustEnoughProfessions-,JustEnoughResources-,keymap-,keywizard-,konkrete_,lazydfu-,LegendaryTooltips-,light-overlay-,LightOverlay-,LLOverlayReloaded-,loadmyresources_,lootbeams-,mcbindtype-,medievalmusic-,modcredits-,modmenu-,modnametooltip_,modnametooltip-,moreoverlays-,MouseTweaks-,movement-vision-,multihotbar-,musicdr-,music-duration-reducer-,MyServerIsCompatible-,Neat ,ngrok-lan-expose-mod-,NotifMod-,OldJavaWarning-,OptiFine,OptiForge,ornaments-,overloadedarmorbar-,PackMenu-,PickUpNotifier-,Ping-,preciseblockplacing-,presencefootsteps-,PresenceFootsteps-,ReAuth-,rebrand-,ResourceLoader-,shutupexperimentalsettings-,SimpleDiscordRichPresence-,smoothboot-,sounddeviceoptions-,SpawnerFix-,spoticraft-,tconplanner-,timestamps-,Tips-,TipTheScales-,Toast Control-,Toast-Control-,ToastControl-,torchoptimizer-,torohealth-,toughnessbar-,TravelersTitles-,WindowedFullscreen-,WorldNameRandomizer-,yisthereautojump-".split(",")));
    private final String FALLBACK_DIRECTORIES_INCLUDE_ASSTRING = "mods,config,defaultconfigs,scripts";
    private final List<String> FALLBACK_DIRECTORIES_INCLUDE = new ArrayList<String>(Arrays.asList("mods,config,defaultconfigs,scripts".split(",")));
    private final String FALLBACK_DIRECTORIES_EXCLUDE_ASSTRING = "overrides,packmenu,resourcepacks,server_pack,fancymenu,libraries";
    private final List<String> FALLBACK_DIRECTORIES_EXCLUDE = new ArrayList<String>(Arrays.asList("overrides,packmenu,resourcepacks,server_pack,fancymenu,libraries".split(",")));
    private final String FALLBACK_FILES_EXCLUDE_ZIP_ASSTRING = "minecraft_server.MINECRAFT_VERSION.jar,server.jar,libraries/net/minecraft/server/MINECRAFT_VERSION/server-MINECRAFT_VERSION.jar";
    private final List<String> FALLBACK_FILES_EXCLUDE_ZIP = new ArrayList<String>(Arrays.asList("minecraft_server.MINECRAFT_VERSION.jar,server.jar,libraries/net/minecraft/server/MINECRAFT_VERSION/server-MINECRAFT_VERSION.jar".split(",")));
    private final File DEFAULT_CONFIG = new File("serverpackcreator.conf");
    private final File OLD_CONFIG = new File("creator.conf");
    private final File DEFAULT_SERVER_PROPERTIES = new File("server.properties");
    private final File DEFAULT_SERVER_ICON = new File("server-icon.png");
    private final File MINECRAFT_VERSION_MANIFEST = new File("minecraft-manifest.json");
    private final File FORGE_VERSION_MANIFEST = new File("forge-manifest.json");
    private final File FABRIC_VERSION_MANIFEST = new File("fabric-manifest.xml");
    private final File FABRIC_INSTALLER_VERSION_MANIFEST = new File("fabric-installer-manifest.xml");
    private final File QUILT_VERSION_MANIFEST = new File("quilt-manifest.xml");
    private final File QUILT_INSTALLER_VERSION_MANIFEST = new File("quilt-installer-manifest.xml");
    private final File SERVERPACKCREATOR_DATABASE = new File("serverpackcreator.db");
    private final File MINECRAFT_VERSION_MANIFEST_LOCATION = new File("./work/minecraft-manifest.json");
    private final File FORGE_VERSION_MANIFEST_LOCATION = new File("./work/forge-manifest.json");
    private final File FABRIC_VERSION_MANIFEST_LOCATION = new File("./work/fabric-manifest.xml");
    private final File FABRIC_INSTALLER_VERSION_MANIFEST_LOCATION = new File("./work/fabric-installer-manifest.xml");
    private final File QUILT_VERSION_MANIFEST_LOCATION = new File("./work/quilt-manifest.xml");
    private final File QUILT_INSTALLER_VERSION_MANIFEST_LOCATION = new File("./work/quilt-installer-manifest.xml");
    private String directoryServerPacks;
    private List<String> listFallbackMods;
    private List<String> directoriesToExclude;
    private List<String> directoriesToInclude;
    private int queueMaxDiskUsage;
    private boolean saveLoadedConfiguration;
    private boolean versioncheck_prerelease;
    private String aikarsFlags;
    private List<String> filesToExcludeFromZipArchive;
    private boolean isZipFileExclusionEnabled;

    @Autowired
    public ApplicationProperties() {
        try (InputStream inputStream = new ClassPathResource("serverpackcreator.properties").getInputStream();){
            this.load(inputStream);
        }
        catch (IOException ex) {
            LOG.error("Couldn't read properties file.", (Throwable)ex);
        }
        String version = ApplicationProperties.class.getPackage().getImplementationVersion();
        this.SERVERPACKCREATOR_VERSION = version != null ? version : "dev";
        this.reload();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void reload() {
        if (new File("serverpackcreator.properties").exists()) {
            try (InputStream inputStream = Files.newInputStream(Paths.get("serverpackcreator.properties", new String[0]), new OpenOption[0]);){
                this.load(inputStream);
            }
            catch (IOException ex) {
                LOG.error("Couldn't read properties file.", (Throwable)ex);
            }
        }
        String tempDir = null;
        try {
            tempDir = this.getProperty("de.griefed.serverpackcreator.configuration.directories.serverpacks", "server-packs");
        }
        catch (NullPointerException npe) {
            this.setProperty("de.griefed.serverpackcreator.configuration.directories.serverpacks", "server-packs");
            tempDir = "server-packs";
        }
        finally {
            if (tempDir != null && !tempDir.isEmpty() && new File(tempDir).isDirectory()) {
                this.setProperty("de.griefed.serverpackcreator.configuration.directories.serverpacks", tempDir);
                this.directoryServerPacks = tempDir;
                try (OutputStream outputStream = Files.newOutputStream(this.SERVERPACKCREATOR_PROPERTIES.toPath(), new OpenOption[0]);){
                    this.store(outputStream, null);
                }
                catch (IOException ex) {
                    LOG.error("Couldn't write properties-file.", (Throwable)ex);
                }
            } else {
                this.directoryServerPacks = "server-packs";
            }
        }
        if (this.getProperty("de.griefed.serverpackcreator.configuration.fallbackmodslist") == null) {
            this.listFallbackMods = this.FALLBACK_CLIENTSIDE_MODS;
            LOG.debug("Fallbackmodslist property null. Using fallback.");
        } else {
            this.listFallbackMods = this.getProperty("de.griefed.serverpackcreator.configuration.fallbackmodslist").contains(",") ? new ArrayList<String>(Arrays.asList(this.getProperty("de.griefed.serverpackcreator.configuration.fallbackmodslist", this.FALLBACK_MODS_DEFAULT_ASSTRING).split(","))) : Collections.singletonList(this.getProperty("de.griefed.serverpackcreator.configuration.fallbackmodslist"));
        }
        LOG.debug("Fallbackmodslist set to: " + this.listFallbackMods);
        if (this.getProperty("de.griefed.serverpackcreator.configuration.directories.shouldexclude") == null) {
            this.directoriesToExclude = this.FALLBACK_DIRECTORIES_EXCLUDE;
            LOG.debug("directories.shouldexclude-property null. Using fallback.");
        } else {
            this.directoriesToExclude = this.getProperty("de.griefed.serverpackcreator.configuration.directories.shouldexclude").contains(",") ? new ArrayList<String>(Arrays.asList(this.getProperty("de.griefed.serverpackcreator.configuration.directories.shouldexclude", "overrides,packmenu,resourcepacks,server_pack,fancymenu,libraries").split(","))) : Collections.singletonList(this.getProperty("de.griefed.serverpackcreator.configuration.directories.shouldexclude"));
        }
        LOG.debug("Directories to exclude set to: " + this.directoriesToExclude);
        if (this.getProperty("de.griefed.serverpackcreator.configuration.directories.mustinclude") == null) {
            this.directoriesToInclude = this.FALLBACK_DIRECTORIES_INCLUDE;
            LOG.debug("directories.mustinclude-property null. Using fallback.");
        } else {
            this.directoriesToInclude = this.getProperty("de.griefed.serverpackcreator.configuration.directories.mustinclude").contains(",") ? new ArrayList<String>(Arrays.asList(this.getProperty("de.griefed.serverpackcreator.configuration.directories.mustinclude", "mods,config,defaultconfigs,scripts").split(","))) : Collections.singletonList(this.getProperty("de.griefed.serverpackcreator.configuration.directories.mustinclude"));
        }
        LOG.debug("Directories which must always be included set to: " + this.directoriesToInclude);
        this.queueMaxDiskUsage = Integer.parseInt(this.getProperty("de.griefed.serverpackcreator.spring.artemis.queue.max_disk_usage", "90"));
        this.saveLoadedConfiguration = Boolean.parseBoolean(this.getProperty("de.griefed.serverpackcreator.configuration.saveloadedconfig", "false"));
        this.versioncheck_prerelease = Boolean.parseBoolean(this.getProperty("de.griefed.serverpackcreator.versioncheck.prerelease", "false"));
        this.aikarsFlags = this.getProperty("de.griefed.serverpackcreator.configuration.aikar", "-Xms4G -Xmx4G -XX:+UseG1GC -XX:+ParallelRefProcEnabled -XX:MaxGCPauseMillis=200 -XX:+UnlockExperimentalVMOptions -XX:+DisableExplicitGC -XX:+AlwaysPreTouch -XX:G1NewSizePercent=30 -XX:G1MaxNewSizePercent=40 -XX:G1HeapRegionSize=8M -XX:G1ReservePercent=20 -XX:G1HeapWastePercent=5 -XX:G1MixedGCCountTarget=4 -XX:InitiatingHeapOccupancyPercent=15 -XX:G1MixedGCLiveThresholdPercent=90 -XX:G1RSetUpdatingPauseTimePercent=5 -XX:SurvivorRatio=32 -XX:+PerfDisableSharedMem -XX:MaxTenuringThreshold=1 -Dusing.aikars.flags=https://mcflags.emc.gs -Daikars.new.flags=true");
        if (this.getProperty("de.griefed.serverpackcreator.serverpack.zip.exclude") == null) {
            this.filesToExcludeFromZipArchive = this.FALLBACK_FILES_EXCLUDE_ZIP;
            LOG.debug("serverpack.zip.exclude-property null. Using fallback.");
        } else {
            this.filesToExcludeFromZipArchive = this.getProperty("de.griefed.serverpackcreator.serverpack.zip.exclude").contains(",") ? new ArrayList<String>(Arrays.asList(this.getProperty("de.griefed.serverpackcreator.serverpack.zip.exclude", "minecraft_server.MINECRAFT_VERSION.jar,server.jar,libraries/net/minecraft/server/MINECRAFT_VERSION/server-MINECRAFT_VERSION.jar").split(","))) : Collections.singletonList(this.getProperty("de.griefed.serverpackcreator.serverpack.zip.exclude", "minecraft_server.MINECRAFT_VERSION.jar,server.jar,libraries/net/minecraft/server/MINECRAFT_VERSION/server-MINECRAFT_VERSION.jar"));
        }
        LOG.debug("Files which must be excluded from ZIP-archives set to: " + this.filesToExcludeFromZipArchive);
        this.isZipFileExclusionEnabled = Boolean.parseBoolean(this.getProperty("de.griefed.serverpackcreator.serverpack.zip.exclude.enabled", "true"));
    }

    public File SERVERPACKCREATOR_PROPERTIES() {
        return this.SERVERPACKCREATOR_PROPERTIES;
    }

    public File START_SCRIPT_WINDOWS() {
        return this.START_SCRIPT_WINDOWS;
    }

    public File START_SCRIPT_LINUX() {
        return this.START_SCRIPT_LINUX;
    }

    public File USER_JVM_ARGS() {
        return this.USER_JVM_ARGS;
    }

    public List<String> FALLBACK_CLIENTSIDE_MODS() {
        return this.FALLBACK_CLIENTSIDE_MODS;
    }

    public File DEFAULT_CONFIG() {
        return this.DEFAULT_CONFIG;
    }

    public File OLD_CONFIG() {
        return this.OLD_CONFIG;
    }

    public File DEFAULT_SERVER_PROPERTIES() {
        return this.DEFAULT_SERVER_PROPERTIES;
    }

    public File DEFAULT_SERVER_ICON() {
        return this.DEFAULT_SERVER_ICON;
    }

    public File MINECRAFT_VERSION_MANIFEST() {
        return this.MINECRAFT_VERSION_MANIFEST;
    }

    public File FORGE_VERSION_MANIFEST() {
        return this.FORGE_VERSION_MANIFEST;
    }

    public File FABRIC_VERSION_MANIFEST() {
        return this.FABRIC_VERSION_MANIFEST;
    }

    public File FABRIC_INSTALLER_VERSION_MANIFEST() {
        return this.FABRIC_INSTALLER_VERSION_MANIFEST;
    }

    public File QUILT_VERSION_MANIFEST() {
        return this.QUILT_VERSION_MANIFEST;
    }

    public File QUILT_INSTALLER_VERSION_MANIFEST() {
        return this.QUILT_INSTALLER_VERSION_MANIFEST;
    }

    public File SERVERPACKCREATOR_DATABASE() {
        return this.SERVERPACKCREATOR_DATABASE;
    }

    public File MINECRAFT_VERSION_MANIFEST_LOCATION() {
        return this.MINECRAFT_VERSION_MANIFEST_LOCATION;
    }

    public File FORGE_VERSION_MANIFEST_LOCATION() {
        return this.FORGE_VERSION_MANIFEST_LOCATION;
    }

    public File FABRIC_VERSION_MANIFEST_LOCATION() {
        return this.FABRIC_VERSION_MANIFEST_LOCATION;
    }

    public File FABRIC_INSTALLER_VERSION_MANIFEST_LOCATION() {
        return this.FABRIC_INSTALLER_VERSION_MANIFEST_LOCATION;
    }

    public File QUILT_VERSION_MANIFEST_LOCATION() {
        return this.QUILT_VERSION_MANIFEST_LOCATION;
    }

    public File QUILT_INSTALLER_VERSION_MANIFEST_LOCATION() {
        return this.QUILT_INSTALLER_VERSION_MANIFEST_LOCATION;
    }

    public String SERVERPACKCREATOR_VERSION() {
        return this.SERVERPACKCREATOR_VERSION;
    }

    public String[] SUPPORTED_MODLOADERS() {
        return this.SUPPORTED_MODLOADERS;
    }

    public String DIRECTORY_SERVER_FILES() {
        return "server_files";
    }

    public String DIRECTORY_PLUGINS() {
        return "plugins";
    }

    public String getDirectoryServerPacks() {
        return this.directoryServerPacks;
    }

    public List<String> getListFallbackMods() {
        return this.listFallbackMods;
    }

    public List<String> getDirectoriesToInclude() {
        return this.directoriesToInclude;
    }

    public List<String> getDirectoriesToExclude() {
        return this.directoriesToExclude;
    }

    public void addDirectoryToExclude(String entry) {
        if (!this.directoriesToExclude.contains(entry) && !this.directoriesToInclude.contains(entry)) {
            LOG.debug("Adding " + entry + " to list of files or directories to exclude.");
            this.directoriesToExclude.add(entry);
        }
    }

    public boolean getSaveLoadedConfiguration() {
        return this.saveLoadedConfiguration;
    }

    public int getQueueMaxDiskUsage() {
        return this.queueMaxDiskUsage;
    }

    public boolean checkForAvailablePreReleases() {
        return this.versioncheck_prerelease;
    }

    public String getAikarsFlags() {
        return this.aikarsFlags;
    }

    public List<String> getFilesToExcludeFromZipArchive() {
        return this.filesToExcludeFromZipArchive;
    }

    public boolean isZipFileExclusionEnabled() {
        return this.isZipFileExclusionEnabled;
    }

    public boolean updateFallback() {
        Properties properties;
        Throwable throwable;
        try {
            throwable = null;
            try (InputStream github = new URL("https://raw.githubusercontent.com/Griefed/ServerPackCreator/main/backend/main/resources/serverpackcreator.properties").openStream();){
                properties = new Properties();
                properties.load(github);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        catch (IOException e) {
            LOG.debug("GitHub could not be reached. Checking GitLab.", (Throwable)e);
            try (InputStream gitlab = new URL("https://gitlab.com/Griefed/ServerPackCreator/-/raw/main/backend/main/resources/serverpackcreator.properties").openStream();){
                properties = new Properties();
                properties.load(gitlab);
            }
            catch (IOException ex) {
                LOG.debug("GitLab could not be reached. Checking GitGriefed", (Throwable)ex);
                try (InputStream gitgriefed = new URL("https://git.griefed.de/Griefed/ServerPackCreator/-/raw/main/backend/main/resources/serverpackcreator.properties").openStream();){
                    properties = new Properties();
                    properties.load(gitgriefed);
                }
                catch (IOException exe) {
                    LOG.debug("GitGriefed could not be reached.", (Throwable)exe);
                    properties = null;
                }
            }
        }
        if (properties != null && !this.getProperty("de.griefed.serverpackcreator.configuration.fallbackmodslist").equals(properties.getProperty("de.griefed.serverpackcreator.configuration.fallbackmodslist"))) {
            this.setProperty("de.griefed.serverpackcreator.configuration.fallbackmodslist", properties.getProperty("de.griefed.serverpackcreator.configuration.fallbackmodslist"));
            try {
                throwable = null;
                try (OutputStream outputStream = Files.newOutputStream(this.SERVERPACKCREATOR_PROPERTIES.toPath(), new OpenOption[0]);){
                    this.store(outputStream, null);
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
            }
            catch (IOException ex) {
                LOG.error("Couldn't write properties-file.", (Throwable)ex);
            }
            this.listFallbackMods = new ArrayList<String>(Arrays.asList(this.getProperty("de.griefed.serverpackcreator.configuration.fallbackmodslist", this.FALLBACK_MODS_DEFAULT_ASSTRING).split(",")));
            LOG.debug("Fallbackmodslist set to: " + this.listFallbackMods);
            LOG.info("The fallback-list for clientside only mods has been updated.");
            return true;
        }
        LOG.info("No fallback-list updates available.");
        return false;
    }
}

