/*
 * Decompiled with CFR 0.152.
 */
package com.moandjiezana.toml;

import com.moandjiezana.toml.Context;
import com.moandjiezana.toml.Results;
import com.moandjiezana.toml.ValueReader;
import java.util.concurrent.atomic.AtomicInteger;

class MultilineLiteralStringValueReader
implements ValueReader {
    static final MultilineLiteralStringValueReader MULTILINE_LITERAL_STRING_VALUE_READER = new MultilineLiteralStringValueReader();

    @Override
    public boolean canRead(String s2) {
        return s2.startsWith("'''");
    }

    @Override
    public Object read(String s2, AtomicInteger index, Context context) {
        AtomicInteger line = context.line;
        int startLine = line.get();
        int originalStartIndex = index.get();
        int startIndex = index.addAndGet(3);
        int endIndex = -1;
        if (s2.charAt(startIndex) == '\n') {
            startIndex = index.incrementAndGet();
            line.incrementAndGet();
        }
        int i2 = startIndex;
        while (i2 < s2.length()) {
            char c = s2.charAt(i2);
            if (c == '\n') {
                line.incrementAndGet();
            }
            if (c == '\'' && s2.length() > i2 + 2 && s2.charAt(i2 + 1) == '\'' && s2.charAt(i2 + 2) == '\'') {
                endIndex = i2;
                index.addAndGet(2);
                break;
            }
            i2 = index.incrementAndGet();
        }
        if (endIndex == -1) {
            Results.Errors errors = new Results.Errors();
            errors.unterminated(context.identifier.getName(), s2.substring(originalStartIndex), startLine);
            return errors;
        }
        return s2.substring(startIndex, endIndex);
    }

    private MultilineLiteralStringValueReader() {
    }
}

