/*
 * Decompiled with CFR 0.152.
 */
package com.moandjiezana.toml;

import com.moandjiezana.toml.Context;
import com.moandjiezana.toml.Identifier;
import com.moandjiezana.toml.Keys;
import java.util.concurrent.atomic.AtomicInteger;

class IdentifierConverter {
    static final IdentifierConverter IDENTIFIER_CONVERTER = new IdentifierConverter();

    Identifier convert(String s2, AtomicInteger index, Context context) {
        boolean quoted = false;
        StringBuilder name = new StringBuilder();
        boolean terminated = false;
        boolean isKey = s2.charAt(index.get()) != '[';
        boolean isTableArray = !isKey && s2.length() > index.get() + 1 && s2.charAt(index.get() + 1) == '[';
        boolean inComment = false;
        int i2 = index.get();
        while (i2 < s2.length()) {
            char c = s2.charAt(i2);
            if (Keys.isQuote(c) && (i2 == 0 || s2.charAt(i2 - 1) != '\\')) {
                quoted = !quoted;
                name.append(c);
            } else {
                if (c == '\n') {
                    index.decrementAndGet();
                    break;
                }
                if (quoted) {
                    name.append(c);
                } else {
                    if (c == '=' && isKey) {
                        terminated = true;
                        break;
                    }
                    if (c == ']' && !isKey) {
                        if (!isTableArray || s2.length() > index.get() + 1 && s2.charAt(index.get() + 1) == ']') {
                            terminated = true;
                            name.append(']');
                            if (isTableArray) {
                                name.append(']');
                            }
                        }
                    } else if (terminated && c == '#') {
                        inComment = true;
                    } else {
                        if (terminated && !Character.isWhitespace(c) && !inComment) {
                            terminated = false;
                            break;
                        }
                        if (!terminated) {
                            name.append(c);
                        }
                    }
                }
            }
            i2 = index.incrementAndGet();
        }
        if (!terminated) {
            if (isKey) {
                context.errors.unterminatedKey(name.toString(), context.line.get());
            } else {
                context.errors.invalidKey(name.toString(), context.line.get());
            }
            return Identifier.INVALID;
        }
        return Identifier.from(name.toString(), context);
    }

    private IdentifierConverter() {
    }
}

