/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.common.iteration;

import java.util.NoSuchElementException;
import org.wildfly.common.iteration.ByteIterator;

final class ConcatByteIterator
extends ByteIterator {
    private final ByteIterator[] iterators;
    private long index = 0L;

    ConcatByteIterator(ByteIterator[] iterators) {
        this.iterators = iterators;
    }

    private int seekNext() {
        for (int i2 = 0; i2 < this.iterators.length; ++i2) {
            if (!this.iterators[i2].hasNext()) continue;
            return i2;
        }
        return -1;
    }

    private int seekPrevious() {
        for (int i2 = this.iterators.length - 1; i2 >= 0; --i2) {
            if (!this.iterators[i2].hasPrevious()) continue;
            return i2;
        }
        return -1;
    }

    @Override
    public boolean hasNext() {
        return this.seekNext() != -1;
    }

    @Override
    public boolean hasPrevious() {
        return this.seekPrevious() != -1;
    }

    @Override
    public int next() throws NoSuchElementException {
        int seek = this.seekNext();
        if (seek == -1) {
            throw new NoSuchElementException();
        }
        int next = this.iterators[seek].next();
        ++this.index;
        return next;
    }

    @Override
    public int peekNext() throws NoSuchElementException {
        int seek = this.seekNext();
        if (seek == -1) {
            throw new NoSuchElementException();
        }
        return this.iterators[seek].peekNext();
    }

    @Override
    public int previous() throws NoSuchElementException {
        int seek = this.seekPrevious();
        if (seek == -1) {
            throw new NoSuchElementException();
        }
        int previous = this.iterators[seek].previous();
        --this.index;
        return previous;
    }

    @Override
    public int peekPrevious() throws NoSuchElementException {
        int seek = this.seekPrevious();
        if (seek == -1) {
            throw new NoSuchElementException();
        }
        return this.iterators[seek].peekPrevious();
    }

    @Override
    public long getIndex() {
        return this.index;
    }
}

