/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.core;

import java.lang.reflect.Constructor;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.TypeConverter;
import org.springframework.core.MethodParameter;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class DataClassRowMapper<T>
extends BeanPropertyRowMapper<T> {
    @Nullable
    private Constructor<T> mappedConstructor;
    @Nullable
    private String[] constructorParameterNames;
    @Nullable
    private TypeDescriptor[] constructorParameterTypes;

    public DataClassRowMapper() {
    }

    public DataClassRowMapper(Class<T> mappedClass) {
        super(mappedClass);
    }

    @Override
    protected void initialize(Class<T> mappedClass) {
        super.initialize(mappedClass);
        this.mappedConstructor = BeanUtils.getResolvableConstructor(mappedClass);
        int paramCount = this.mappedConstructor.getParameterCount();
        if (paramCount > 0) {
            for (String name : this.constructorParameterNames = BeanUtils.getParameterNames(this.mappedConstructor)) {
                this.suppressProperty(name);
            }
            this.constructorParameterTypes = new TypeDescriptor[paramCount];
            for (int i2 = 0; i2 < paramCount; ++i2) {
                this.constructorParameterTypes[i2] = new TypeDescriptor(new MethodParameter(this.mappedConstructor, i2));
            }
        }
    }

    @Override
    protected T constructMappedInstance(ResultSet rs, TypeConverter tc) throws SQLException {
        Object[] args;
        Assert.state(this.mappedConstructor != null, "Mapped constructor was not initialized");
        if (this.constructorParameterNames != null && this.constructorParameterTypes != null) {
            args = new Object[this.constructorParameterNames.length];
            for (int i2 = 0; i2 < args.length; ++i2) {
                int index;
                String name = this.constructorParameterNames[i2];
                try {
                    index = rs.findColumn(this.lowerCaseName(name));
                }
                catch (SQLException ex) {
                    index = rs.findColumn(this.underscoreName(name));
                }
                TypeDescriptor td = this.constructorParameterTypes[i2];
                Object value = this.getColumnValue(rs, index, td.getType());
                args[i2] = tc.convertIfNecessary(value, td.getType(), td);
            }
        } else {
            args = new Object[]{};
        }
        return BeanUtils.instantiateClass(this.mappedConstructor, args);
    }

    public static <T> DataClassRowMapper<T> newInstance(Class<T> mappedClass) {
        return new DataClassRowMapper<T>(mappedClass);
    }

    public static <T> DataClassRowMapper<T> newInstance(Class<T> mappedClass, @Nullable ConversionService conversionService) {
        DataClassRowMapper<T> rowMapper = DataClassRowMapper.newInstance(mappedClass);
        rowMapper.setConversionService(conversionService);
        return rowMapper;
    }
}

