/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.devtools.livereload;

import java.io.IOException;
import java.io.OutputStream;
import org.springframework.boot.devtools.livereload.ConnectionInputStream;
import org.springframework.util.Assert;

class Frame {
    private static final byte[] NO_BYTES = new byte[0];
    private final Type type;
    private final byte[] payload;

    Frame(String payload) {
        Assert.notNull((Object)payload, "Payload must not be null");
        this.type = Type.TEXT;
        this.payload = payload.getBytes();
    }

    Frame(Type type) {
        Assert.notNull((Object)type, "Type must not be null");
        this.type = type;
        this.payload = NO_BYTES;
    }

    Frame(Type type, byte[] payload) {
        this.type = type;
        this.payload = payload;
    }

    Type getType() {
        return this.type;
    }

    byte[] getPayload() {
        return this.payload;
    }

    public String toString() {
        return new String(this.payload);
    }

    void write(OutputStream outputStream) throws IOException {
        outputStream.write(0x80 | this.type.code);
        if (this.payload.length < 126) {
            outputStream.write(this.payload.length & 0x7F);
        } else {
            outputStream.write(126);
            outputStream.write(this.payload.length >> 8 & 0xFF);
            outputStream.write(this.payload.length & 0xFF);
        }
        outputStream.write(this.payload);
        outputStream.flush();
    }

    static Frame read(ConnectionInputStream inputStream) throws IOException {
        int firstByte = inputStream.checkedRead();
        Assert.state((firstByte & 0x80) != 0, "Fragmented frames are not supported");
        int maskAndLength = inputStream.checkedRead();
        boolean hasMask = (maskAndLength & 0x80) != 0;
        int length = maskAndLength & 0x7F;
        Assert.state(length != 127, "Large frames are not supported");
        if (length == 126) {
            length = inputStream.checkedRead() << 8 | inputStream.checkedRead();
        }
        byte[] mask = new byte[4];
        if (hasMask) {
            inputStream.readFully(mask, 0, mask.length);
        }
        byte[] payload = new byte[length];
        inputStream.readFully(payload, 0, length);
        if (hasMask) {
            for (int i2 = 0; i2 < payload.length; ++i2) {
                int n = i2;
                payload[n] = (byte)(payload[n] ^ mask[i2 % 4]);
            }
        }
        return new Frame(Type.forCode(firstByte & 0xF), payload);
    }

    static enum Type {
        CONTINUATION(0),
        TEXT(1),
        BINARY(2),
        CLOSE(8),
        PING(9),
        PONG(10);

        private final int code;

        private Type(int code) {
            this.code = code;
        }

        static Type forCode(int code) {
            for (Type type : Type.values()) {
                if (type.code != code) continue;
                return type;
            }
            throw new IllegalStateException("Unknown code " + code);
        }
    }
}

