/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.util;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.Predicate;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class FastArray<T>
implements Iterable<T> {
    protected T[] elements;
    protected int index;
    protected int size;
    protected int increment = 5;
    protected int print_limit = 20;

    public FastArray(int capacity) {
        this.elements = new Object[capacity];
    }

    public int capacity() {
        return this.elements.length;
    }

    public int index() {
        return this.index;
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public int increment() {
        return this.increment;
    }

    public FastArray<T> increment(int i2) {
        this.increment = FastArray.ensurePositive(i2);
        return this;
    }

    public int printLimit() {
        return this.print_limit;
    }

    public FastArray<T> printLimit(int l) {
        this.print_limit = l;
        return this;
    }

    public int add(T el) {
        return this.add(el, true);
    }

    public int add(T el, boolean resize) {
        if (el == null) {
            return 0;
        }
        if (this.index == this.elements.length) {
            if (!resize) {
                return 0;
            }
            this.resize(this.index + this.increment);
        }
        this.elements[this.index++] = el;
        ++this.size;
        return 1;
    }

    public int add(T[] els, int length) {
        if (els == null) {
            return 0;
        }
        if (length > els.length) {
            length = els.length;
        }
        if (this.index + length > this.elements.length) {
            this.resize(this.index + length + this.increment);
        }
        System.arraycopy(els, 0, this.elements, this.index, length);
        int added = 0;
        int end_index = this.index + length;
        while (this.index < end_index) {
            if (this.elements[this.index++] == null) continue;
            ++added;
        }
        this.size += added;
        return added;
    }

    @SafeVarargs
    public final int add(T ... els) {
        return els == null ? 0 : this.add(els, els.length);
    }

    public int add(Collection<T> list) {
        if (list == null) {
            return 0;
        }
        int list_size = list.size();
        if (this.index + list_size > this.elements.length) {
            this.resize(this.index + list_size + this.increment);
        }
        int old_size = this.size;
        for (T el : list) {
            if (el == null) continue;
            this.elements[this.index++] = el;
            ++this.size;
        }
        return this.size - old_size;
    }

    public int add(FastArray<T> fa) {
        return this.add(fa, true);
    }

    public int add(FastArray<T> fa, boolean resize) {
        if (fa == null) {
            return 0;
        }
        if (this == fa) {
            throw new IllegalArgumentException("cannot add FastArray to itself");
        }
        int fa_size = fa.size();
        if (this.index + fa_size > this.elements.length && resize) {
            this.resize(this.index + fa_size + this.increment);
        }
        int old_size = this.size;
        for (Object el : fa) {
            if (this.index >= this.elements.length) {
                return this.size - old_size;
            }
            this.elements[this.index++] = el;
            ++this.size;
        }
        return this.size - old_size;
    }

    public int transferFrom(FastArray<T> other, boolean clear) {
        if (other == null || this == other) {
            return 0;
        }
        int capacity = this.elements.length;
        int other_size = other.size();
        int other_capacity = other.capacity();
        if (other_size == 0) {
            return 0;
        }
        if (capacity < other_capacity) {
            this.elements = Arrays.copyOf(other.elements, other_capacity);
        } else {
            System.arraycopy(other.elements, 0, this.elements, 0, other_capacity);
        }
        if (this.index > other.index) {
            for (int i2 = other.index; i2 < this.index; ++i2) {
                this.elements[i2] = null;
            }
        }
        this.index = other.index;
        this.size = other_size;
        if (clear) {
            other.clear(true);
        }
        return other_size;
    }

    public T get(int idx) {
        if (idx < 0 || idx >= this.index) {
            return null;
        }
        return this.elements[idx];
    }

    public FastArray<T> set(int idx, T el) {
        if (idx < 0 || idx >= this.index) {
            return this;
        }
        T old_el = this.elements[idx];
        if (old_el == null) {
            if (el != null) {
                ++this.size;
            }
        } else if (el == null) {
            --this.size;
        }
        this.elements[idx] = el;
        return this;
    }

    public FastArray<T> set(T[] elements) {
        this.elements = Objects.requireNonNull(elements);
        this.index = elements.length;
        this.size = this.count();
        return this;
    }

    public boolean anyMatch(Predicate<T> pred) {
        if (pred == null) {
            return false;
        }
        for (Object el : this) {
            if (el == null || !pred.test(el)) continue;
            return true;
        }
        return false;
    }

    public FastArray<T> remove(int idx) {
        return this.set(idx, null);
    }

    public FastArray<T> removeIf(Predicate<T> filter2, boolean replace_all) {
        return this.replaceIf(filter2, null, replace_all);
    }

    public FastArray<T> replaceIf(Predicate<T> filter2, T new_el, boolean replace_all) {
        if (filter2 == null) {
            return this;
        }
        FastIterator it = this.iteratorWithFilter(filter2);
        while (it.hasNext()) {
            it.next();
            it.replace(new_el);
            if (replace_all) continue;
            break;
        }
        return this;
    }

    public FastArray<T> clear(boolean null_elements) {
        if (null_elements) {
            for (int i2 = 0; i2 < this.index; ++i2) {
                this.elements[i2] = null;
            }
        }
        this.size = 0;
        this.index = 0;
        return this;
    }

    public FastIterator iterator() {
        return new FastIterator(null);
    }

    public FastIterator iteratorWithFilter(Predicate<T> filter2) {
        return new FastIterator(filter2);
    }

    public Stream<T> stream() {
        Spliterator sp = Spliterators.spliterator(this.iterator(), (long)this.size, 0);
        return StreamSupport.stream(sp, false);
    }

    public int count() {
        int cnt = 0;
        for (int i2 = 0; i2 < this.index; ++i2) {
            if (this.elements[i2] == null) continue;
            ++cnt;
        }
        return cnt;
    }

    public String toString() {
        return String.format("%d elements (cap=%d): [%s]", this.size, this.capacity(), this.print());
    }

    public String print() {
        return this.print(this.print_limit);
    }

    public FastArray<T> resize(int new_capacity) {
        if (new_capacity <= this.elements.length) {
            return this;
        }
        this.elements = Arrays.copyOf(this.elements, new_capacity);
        return this;
    }

    protected String print(int limit) {
        boolean first = true;
        StringBuilder sb = new StringBuilder();
        int count = 0;
        for (T el : this.elements) {
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            sb.append(el);
            if (limit <= 0 || ++count < limit) continue;
            return sb.append(" ...").toString();
        }
        return sb.toString();
    }

    protected static int ensurePositive(int i2) {
        if (i2 < 1) {
            throw new IllegalArgumentException("value needs to be >= 1");
        }
        return i2;
    }

    public class FastIterator
    implements Iterator<T> {
        protected int current_index = -1;
        protected final Predicate<T> filter;
        protected int hit_count;

        public FastIterator(Predicate<T> filter2) {
            this.filter = filter2;
        }

        @Override
        public boolean hasNext() {
            while (this.current_index + 1 < FastArray.this.index && this.hit_count < FastArray.this.size && this.nullOrNoFilterMatch(this.current_index + 1)) {
                ++this.current_index;
            }
            return this.current_index + 1 < FastArray.this.index && this.hit_count < FastArray.this.size;
        }

        @Override
        public T next() {
            if (this.current_index + 1 >= FastArray.this.index) {
                throw new NoSuchElementException();
            }
            ++this.hit_count;
            return FastArray.this.elements[++this.current_index];
        }

        @Override
        public void remove() {
            this.replace(null);
        }

        public void replace(T el) {
            if (this.current_index >= 0) {
                int old_size = FastArray.this.size;
                FastArray.this.set(this.current_index, el);
                if (FastArray.this.size < old_size) {
                    this.hit_count = Math.max(this.hit_count - 1, 0);
                }
            }
        }

        public int currentIndex() {
            return this.current_index;
        }

        public int hitCount() {
            return this.hit_count;
        }

        protected boolean nullOrNoFilterMatch(int index) {
            boolean result;
            if (FastArray.this.elements[index] == null) {
                return true;
            }
            boolean bl = result = this.filter != null && !this.filter.test(FastArray.this.elements[index]);
            if (result) {
                ++this.hit_count;
            }
            return result;
        }

        public String toString() {
            return String.format("curr-index=%d hit-count=%d", this.current_index, this.hit_count);
        }
    }
}

