/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.util;

import java.io.DataOutput;
import java.io.IOException;
import java.io.UTFDataFormatException;
import java.nio.ByteBuffer;
import org.jgroups.util.ByteArray;

public class ByteBufferOutputStream
implements DataOutput {
    protected final ByteBuffer buf;

    public ByteBufferOutputStream(ByteBuffer buf) {
        this.buf = buf;
    }

    public void reset() {
        this.buf.clear();
    }

    public ByteBuffer getBuffer() {
        return this.buf;
    }

    public ByteArray getBufferAsBuffer() {
        return new ByteArray(this.buf.array(), this.buf.arrayOffset(), this.buf.position());
    }

    @Override
    public void write(int b) throws IOException {
        this.buf.put((byte)b);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.buf.put(b, off, len);
    }

    @Override
    public void writeBoolean(boolean v) throws IOException {
        this.write(v ? 1 : 0);
    }

    @Override
    public void writeByte(int v) throws IOException {
        this.write(v);
    }

    @Override
    public void writeShort(int v) throws IOException {
        this.buf.putShort((short)v);
    }

    @Override
    public void writeChar(int v) throws IOException {
        this.buf.putChar((char)v);
    }

    @Override
    public void writeInt(int v) throws IOException {
        this.buf.putInt(v);
    }

    @Override
    public void writeLong(long v) throws IOException {
        this.buf.putLong(v);
    }

    @Override
    public void writeFloat(float v) throws IOException {
        this.buf.putFloat(v);
    }

    @Override
    public void writeDouble(double v) throws IOException {
        this.buf.putDouble(v);
    }

    @Override
    public void writeBytes(String s2) throws IOException {
        int len = s2.length();
        for (int i2 = 0; i2 < len; ++i2) {
            this.write((byte)s2.charAt(i2));
        }
    }

    @Override
    public void writeChars(String s2) throws IOException {
        int len = s2.length();
        for (int i2 = 0; i2 < len; ++i2) {
            char v = s2.charAt(i2);
            this.write(v >>> 8 & 0xFF);
            this.write(v >>> 0 & 0xFF);
        }
    }

    @Override
    public void writeUTF(String str) throws IOException {
        char c;
        int strlen = str.length();
        int utflen = 0;
        int count = 0;
        for (int i2 = 0; i2 < strlen; ++i2) {
            c = str.charAt(i2);
            if (c >= '\u0001' && c <= '\u007f') {
                ++utflen;
                continue;
            }
            if (c > '\u07ff') {
                utflen += 3;
                continue;
            }
            utflen += 2;
        }
        if (utflen > 65535) {
            throw new UTFDataFormatException("encoded string too long: " + utflen + " bytes");
        }
        this.writeShort(utflen);
        byte[] bytearr = new byte[utflen];
        int i3 = 0;
        for (i3 = 0; i3 < strlen && (c = str.charAt(i3)) >= '\u0001' && c <= '\u007f'; ++i3) {
            bytearr[count++] = (byte)c;
        }
        while (i3 < strlen) {
            c = str.charAt(i3);
            if (c >= '\u0001' && c <= '\u007f') {
                bytearr[count++] = (byte)c;
            } else if (c > '\u07ff') {
                bytearr[count++] = (byte)(0xE0 | c >> 12 & 0xF);
                bytearr[count++] = (byte)(0x80 | c >> 6 & 0x3F);
                bytearr[count++] = (byte)(0x80 | c >> 0 & 0x3F);
            } else {
                bytearr[count++] = (byte)(0xC0 | c >> 6 & 0x1F);
                bytearr[count++] = (byte)(0x80 | c >> 0 & 0x3F);
            }
            ++i3;
        }
        this.write(bytearr, 0, utflen);
    }

    public String toString() {
        return this.buf.toString();
    }
}

