/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.utils.critical;

import org.apache.activemq.artemis.utils.critical.CriticalAnalyzer;
import org.apache.activemq.artemis.utils.critical.CriticalCloseable;
import org.apache.activemq.artemis.utils.critical.CriticalComponent;
import org.apache.activemq.artemis.utils.critical.CriticalMeasure;
import org.apache.activemq.artemis.utils.critical.EmptyCriticalAnalyzer;

public class CriticalComponentImpl
implements CriticalComponent {
    private final CriticalMeasure[] measures;
    private final CriticalAnalyzer analyzer;

    @Override
    public CriticalAnalyzer getCriticalAnalyzer() {
        return this.analyzer;
    }

    public CriticalComponentImpl(CriticalAnalyzer analyzer, int numberOfPaths) {
        if (analyzer == null) {
            analyzer = EmptyCriticalAnalyzer.getInstance();
        }
        this.analyzer = analyzer;
        if (analyzer.isMeasuring()) {
            this.measures = new CriticalMeasure[numberOfPaths];
            for (int i2 = 0; i2 < numberOfPaths; ++i2) {
                this.measures[i2] = new CriticalMeasure(this, i2);
            }
        } else {
            this.measures = null;
        }
    }

    @Override
    public CriticalCloseable measureCritical(int path) {
        if (!this.analyzer.isMeasuring()) {
            return CriticalMeasure.dummyCloseable;
        }
        return this.measures[path].measure();
    }

    @Override
    public boolean checkExpiration(long timeout, boolean reset) {
        for (int i2 = 0; i2 < this.measures.length; ++i2) {
            if (!this.measures[i2].checkExpiration(timeout, reset)) continue;
            return true;
        }
        return false;
    }
}

