/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.utils;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.security.Principal;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.security.auth.Subject;
import org.apache.activemq.artemis.core.security.CheckType;
import org.apache.activemq.artemis.core.security.Role;
import org.apache.activemq.artemis.core.server.ActiveMQServerLogger;
import org.apache.activemq.artemis.spi.core.security.jaas.RolePrincipal;

public class SecurityManagerUtil {
    private static final String WILDCARD = "*";

    public static Set<RolePrincipal> getPrincipalsInRole(CheckType checkType, Set<Role> roles, String rolePrincipalClass) {
        HashSet<RolePrincipal> principals = new HashSet<RolePrincipal>();
        for (Role role : roles) {
            if (!checkType.hasRole(role)) continue;
            try {
                principals.add((RolePrincipal)SecurityManagerUtil.createGroupPrincipal(role.getName(), rolePrincipalClass));
            }
            catch (Exception e) {
                ActiveMQServerLogger.LOGGER.failedAddRolePrincipal(e);
            }
        }
        return principals;
    }

    public static Object createGroupPrincipal(String name, String groupClass) throws Exception {
        Object instance;
        Class<?>[] paramTypes;
        int i2;
        if (WILDCARD.equals(name)) {
            return new Principal(){

                @Override
                public String getName() {
                    return SecurityManagerUtil.WILDCARD;
                }

                @Override
                public boolean equals(Object other) {
                    return true;
                }

                @Override
                public int hashCode() {
                    return SecurityManagerUtil.WILDCARD.hashCode();
                }
            };
        }
        Object[] param = new Object[]{name};
        Class<?> cls = Class.forName(groupClass);
        Constructor<?>[] constructors = cls.getConstructors();
        for (i2 = 0; !(i2 >= constructors.length || (paramTypes = constructors[i2].getParameterTypes()).length != 0 && paramTypes[0].equals(String.class)); ++i2) {
        }
        if (i2 < constructors.length) {
            instance = constructors[i2].newInstance(param);
        } else {
            Class<?>[] paramTypes2;
            instance = cls.newInstance();
            Method[] methods = cls.getMethods();
            i2 = 0;
            for (i2 = 0; !(i2 >= methods.length || (paramTypes2 = methods[i2].getParameterTypes()).length != 0 && methods[i2].getName().equals("setName") && paramTypes2[0].equals(String.class)); ++i2) {
            }
            if (i2 < methods.length) {
                methods[i2].invoke(instance, param);
            } else {
                throw new NoSuchMethodException();
            }
        }
        return instance;
    }

    public static boolean authorize(Subject subject, Set<Role> roles, CheckType checkType, String rolePrincipalClass) {
        boolean authorized = false;
        if (subject != null) {
            Set<RolePrincipal> rolesWithPermission = SecurityManagerUtil.getPrincipalsInRole(checkType, roles, rolePrincipalClass);
            HashSet<Principal> rolesForSubject = new HashSet<Principal>();
            try {
                rolesForSubject.addAll(subject.getPrincipals(Class.forName(rolePrincipalClass).asSubclass(Principal.class)));
            }
            catch (Exception e) {
                ActiveMQServerLogger.LOGGER.failedToFindRolesForTheSubject(e);
            }
            if (rolesForSubject.size() > 0 && rolesWithPermission.size() > 0) {
                Iterator rolesForSubjectIter = rolesForSubject.iterator();
                while (!authorized && rolesForSubjectIter.hasNext()) {
                    Iterator<RolePrincipal> rolesWithPermissionIter = rolesWithPermission.iterator();
                    Principal subjectRole = (Principal)rolesForSubjectIter.next();
                    while (!authorized && rolesWithPermissionIter.hasNext()) {
                        Principal roleWithPermission = rolesWithPermissionIter.next();
                        authorized = subjectRole.equals(roleWithPermission);
                    }
                }
            }
        }
        return authorized;
    }
}

