/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.utils;

import io.netty.buffer.ByteBuf;
import io.netty.util.internal.PlatformDependent;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.ByteBuffer;
import java.nio.ReadOnlyBufferException;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.logs.ActiveMQUtilBundle;
import org.jboss.logging.Logger;

public class ByteUtil {
    public static final String NON_ASCII_STRING = "@@@@@";
    private static final char[] hexArray = "0123456789ABCDEF".toCharArray();
    private static final String prefix = "^\\s*(\\d+)\\s*";
    private static final String suffix = "(b)?\\s*$";
    private static final Pattern ONE = Pattern.compile("^\\s*(\\d+)\\s*(b)?\\s*$", 2);
    private static final Pattern KILO = Pattern.compile("^\\s*(\\d+)\\s*k(b)?\\s*$", 2);
    private static final Pattern MEGA = Pattern.compile("^\\s*(\\d+)\\s*m(b)?\\s*$", 2);
    private static final Pattern GIGA = Pattern.compile("^\\s*(\\d+)\\s*g(b)?\\s*$", 2);
    private static final String[] BYTE_SUFFIXES = new String[]{"E", "P", "T", "G", "M", "K", ""};
    private static final double[] BYTE_MAGNITUDES = new double[7];

    public static void debugFrame(Logger logger2, String message, ByteBuf byteIn) {
        if (logger2.isTraceEnabled()) {
            ByteUtil.outFrame(logger2, message, byteIn, false);
        }
    }

    public static void outFrame(Logger logger2, String message, ByteBuf byteIn, boolean info) {
        int location = byteIn.readerIndex();
        byte[] frame = new byte[byteIn.writerIndex()];
        byteIn.readBytes(frame);
        try {
            if (info) {
                logger2.info(message + "\n" + ByteUtil.formatGroup(ByteUtil.bytesToHex(frame), 8, 16));
            } else {
                logger2.trace(message + "\n" + ByteUtil.formatGroup(ByteUtil.bytesToHex(frame), 8, 16));
            }
        }
        catch (Exception e) {
            logger2.warn((Object)e.getMessage(), e);
        }
        byteIn.readerIndex(location);
    }

    public static String formatGroup(String str, int groupSize, int lineBreak) {
        StringBuffer buffer = new StringBuffer();
        int line = 1;
        buffer.append("/*  0 */ \"");
        for (int i2 = 0; i2 < str.length(); i2 += groupSize) {
            buffer.append(str.substring(i2, i2 + Math.min(str.length() - i2, groupSize)));
            if ((i2 + groupSize) % lineBreak == 0) {
                buffer.append("\" +\n/* ");
                if (++line < 10) {
                    buffer.append(" ");
                }
                buffer.append(Integer.toString(i2) + " */ \"");
                continue;
            }
            if ((i2 + groupSize) % groupSize != 0 || str.length() - i2 <= groupSize) continue;
            buffer.append("\" + \"");
        }
        buffer.append("\";");
        return buffer.toString();
    }

    public static String maxString(String value, int size) {
        if (value.length() < size) {
            return value;
        }
        return value.substring(0, size / 2) + " ... " + value.substring(value.length() - size / 2);
    }

    public static String bytesToHex(byte[] bytes) {
        char[] hexChars = new char[bytes.length * 2];
        for (int j = 0; j < bytes.length; ++j) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 2] = hexArray[v >>> 4];
            hexChars[j * 2 + 1] = hexArray[v & 0xF];
        }
        return new String(hexChars);
    }

    public static String debugByteArray(byte[] byteArray) {
        StringWriter builder = new StringWriter();
        PrintWriter writer = new PrintWriter(builder);
        for (int i2 = 0; i2 < byteArray.length; ++i2) {
            writer.print("\t[" + i2 + "]=" + ByteUtil.byteToChar(byteArray[i2]) + " / " + byteArray[i2]);
            if (i2 > 0 && i2 % 8 == 0) {
                writer.println();
                continue;
            }
            writer.print(" ");
        }
        return builder.toString();
    }

    public static String byteToChar(byte value) {
        char[] hexChars = new char[2];
        int v = value & 0xFF;
        hexChars[0] = hexArray[v >>> 4];
        hexChars[1] = hexArray[v & 0xF];
        return new String(hexChars);
    }

    public static String bytesToHex(byte[] bytes, int groupSize) {
        if (bytes == null) {
            return "NULL";
        }
        if (bytes.length == 0) {
            return "[]";
        }
        char[] hexChars = new char[bytes.length * 2 + ByteUtil.numberOfGroups(bytes, groupSize)];
        int outPos = 0;
        for (int j = 0; j < bytes.length; ++j) {
            if (j > 0 && j % groupSize == 0) {
                hexChars[outPos++] = 32;
            }
            int v = bytes[j] & 0xFF;
            hexChars[outPos++] = hexArray[v >>> 4];
            hexChars[outPos++] = hexArray[v & 0xF];
        }
        return new String(hexChars);
    }

    public static String toSimpleString(byte[] bytes) {
        SimpleString simpleString = new SimpleString(bytes);
        String value = simpleString.toString();
        for (char c : value.toCharArray()) {
            if (c >= ' ' && c <= '\u007f') continue;
            return NON_ASCII_STRING;
        }
        return value;
    }

    private static int numberOfGroups(byte[] bytes, int groupSize) {
        int groups = bytes.length / groupSize;
        if (bytes.length % groupSize == 0) {
            --groups;
        }
        return groups;
    }

    public static final byte[] intToBytes(int value) {
        return new byte[]{(byte)(value >>> 24), (byte)(value >>> 16), (byte)(value >>> 8), (byte)value};
    }

    public static int bytesToInt(byte[] b) {
        return b[3] & 0xFF | (b[2] & 0xFF) << 8 | (b[1] & 0xFF) << 16 | (b[0] & 0xFF) << 24;
    }

    public static long bytesToLong(byte[] b) {
        return (long)b[7] & 0xFFL | ((long)b[6] & 0xFFL) << 8 | ((long)b[5] & 0xFFL) << 16 | ((long)b[4] & 0xFFL) << 24 | ((long)b[3] & 0xFFL) << 32 | ((long)b[2] & 0xFFL) << 40 | ((long)b[1] & 0xFFL) << 48 | ((long)b[0] & 0xFFL) << 56;
    }

    public static byte[] longToBytes(long value) {
        byte[] output = new byte[8];
        ByteUtil.longToBytes(value, output, 0);
        return output;
    }

    public static void longToBytes(long x, byte[] output, int offset) {
        output[offset] = (byte)(x >>> 56);
        output[offset + 1] = (byte)(x >>> 48);
        output[offset + 2] = (byte)(x >>> 40);
        output[offset + 3] = (byte)(x >>> 32);
        output[offset + 4] = (byte)(x >>> 24);
        output[offset + 5] = (byte)(x >>> 16);
        output[offset + 6] = (byte)(x >>> 8);
        output[offset + 7] = (byte)x;
    }

    public static byte[] doubleLongToBytes(long value1, long value2) {
        byte[] output = new byte[16];
        ByteUtil.longToBytes(value1, output, 0);
        ByteUtil.longToBytes(value2, output, 8);
        return output;
    }

    public static byte[] hexToBytes(String hexStr) {
        byte[] bytes = new byte[hexStr.length() / 2];
        for (int i2 = 0; i2 < bytes.length; ++i2) {
            bytes[i2] = (byte)Integer.parseInt(hexStr.substring(2 * i2, 2 * i2 + 2), 16);
        }
        return bytes;
    }

    public static String readLine(ActiveMQBuffer buffer) {
        StringBuilder sb = new StringBuilder("");
        char c = buffer.readChar();
        while (c != '\n') {
            sb.append(c);
            c = buffer.readChar();
        }
        return sb.toString();
    }

    public static long convertTextBytes(String text) {
        try {
            Matcher m3 = ONE.matcher(text);
            if (m3.matches()) {
                return Long.parseLong(m3.group(1));
            }
            m3 = KILO.matcher(text);
            if (m3.matches()) {
                return Long.parseLong(m3.group(1)) * 1024L;
            }
            m3 = MEGA.matcher(text);
            if (m3.matches()) {
                return Long.parseLong(m3.group(1)) * 1024L * 1024L;
            }
            m3 = GIGA.matcher(text);
            if (m3.matches()) {
                return Long.parseLong(m3.group(1)) * 1024L * 1024L * 1024L;
            }
            return Long.parseLong(text);
        }
        catch (NumberFormatException e) {
            throw ActiveMQUtilBundle.BUNDLE.failedToParseLong(text);
        }
    }

    public static int hashCode(byte[] bytes) {
        if (PlatformDependent.hasUnsafe() && PlatformDependent.isUnaligned()) {
            return ByteUtil.unsafeHashCode(bytes);
        }
        return Arrays.hashCode(bytes);
    }

    private static int unsafeHashCode(byte[] bytes) {
        if (bytes == null) {
            return 0;
        }
        int len = bytes.length;
        int hashCode = 1;
        int intCount = len >>> 2;
        int arrayIndex = 0;
        for (int i2 = 0; i2 < intCount; ++i2) {
            hashCode = 31 * hashCode + PlatformDependent.getInt(bytes, arrayIndex);
            arrayIndex += 4;
        }
        byte remaining = (byte)(len & 3);
        if (remaining > 0) {
            hashCode = ByteUtil.unsafeUnrolledHashCode(bytes, arrayIndex, remaining, hashCode);
        }
        return hashCode == 0 ? 1 : hashCode;
    }

    private static int unsafeUnrolledHashCode(byte[] bytes, int index, int bytesCount, int h2) {
        assert (bytesCount > 0 && bytesCount < 4);
        h2 = 31 * h2 + PlatformDependent.getByte(bytes, index);
        if (bytesCount == 1) {
            return h2;
        }
        h2 = 31 * h2 + PlatformDependent.getByte(bytes, index + 1);
        if (bytesCount == 2) {
            return h2;
        }
        h2 = 31 * h2 + PlatformDependent.getByte(bytes, index + 2);
        return h2;
    }

    public static boolean equals(byte[] left, byte[] right) {
        return ByteUtil.equals(left, right, 0, right.length);
    }

    public static boolean equals(byte[] left, byte[] right, int rightOffset, int rightLength) {
        if (left == right) {
            return true;
        }
        if (left == null || right == null) {
            return false;
        }
        if (left.length != rightLength) {
            return false;
        }
        if (PlatformDependent.isUnaligned() && PlatformDependent.hasUnsafe()) {
            return ByteUtil.equalsUnsafe(left, right, rightOffset, rightLength);
        }
        return ByteUtil.equalsSafe(left, right, rightOffset, rightLength);
    }

    private static boolean equalsSafe(byte[] left, byte[] right, int rightOffset, int rightLength) {
        for (int i2 = 0; i2 < rightLength; ++i2) {
            if (left[i2] == right[rightOffset + i2]) continue;
            return false;
        }
        return true;
    }

    private static boolean equalsUnsafe(byte[] left, byte[] right, int rightOffset, int rightLength) {
        int i2;
        int longCount = rightLength >>> 3;
        int bytesCount = rightLength & 7;
        int bytesIndex = rightOffset;
        int charsIndex = 0;
        for (i2 = 0; i2 < longCount; ++i2) {
            long bytesLong;
            long charsLong = PlatformDependent.getLong(left, charsIndex);
            if (charsLong != (bytesLong = PlatformDependent.getLong(right, bytesIndex))) {
                return false;
            }
            bytesIndex += 8;
            charsIndex += 8;
        }
        for (i2 = 0; i2 < bytesCount; ++i2) {
            byte bytesByte;
            byte charsByte = PlatformDependent.getByte(left, charsIndex);
            if (charsByte != (bytesByte = PlatformDependent.getByte(right, bytesIndex))) {
                return false;
            }
            ++bytesIndex;
            ++charsIndex;
        }
        return true;
    }

    public static void ensureExactWritable(ByteBuf buffer, int minWritableBytes) {
        if (buffer.maxFastWritableBytes() < minWritableBytes) {
            buffer.capacity(buffer.writerIndex() + minWritableBytes);
        }
    }

    public static boolean equals(byte[] bytes, ByteBuf byteBuf, int offset, int length) {
        if (bytes.length != length) {
            return false;
        }
        if (PlatformDependent.isUnaligned() && PlatformDependent.hasUnsafe()) {
            if (offset + length > byteBuf.writerIndex()) {
                throw new IndexOutOfBoundsException();
            }
            if (byteBuf.hasArray()) {
                return ByteUtil.equals(bytes, byteBuf.array(), byteBuf.arrayOffset() + offset, length);
            }
            if (byteBuf.hasMemoryAddress()) {
                return ByteUtil.equalsOffHeap(bytes, byteBuf.memoryAddress(), offset, length);
            }
        }
        return ByteUtil.equalsOnHeap(bytes, byteBuf, offset, length);
    }

    private static boolean equalsOnHeap(byte[] bytes, ByteBuf byteBuf, int offset, int length) {
        if (bytes.length != length) {
            return false;
        }
        for (int i2 = 0; i2 < length; ++i2) {
            if (bytes[i2] == byteBuf.getByte(offset + i2)) continue;
            return false;
        }
        return true;
    }

    private static boolean equalsOffHeap(byte[] bytes, long address, int offset, int length) {
        int i2;
        int longCount = length >>> 3;
        int bytesCount = length & 7;
        long bytesAddress = address + (long)offset;
        int charsIndex = 0;
        for (i2 = 0; i2 < longCount; ++i2) {
            long bytesLong;
            long charsLong = PlatformDependent.getLong(bytes, charsIndex);
            if (charsLong != (bytesLong = PlatformDependent.getLong(bytesAddress))) {
                return false;
            }
            bytesAddress += 8L;
            charsIndex += 8;
        }
        for (i2 = 0; i2 < bytesCount; ++i2) {
            byte bytesByte;
            byte charsByte = PlatformDependent.getByte(bytes, charsIndex);
            if (charsByte != (bytesByte = PlatformDependent.getByte(bytesAddress))) {
                return false;
            }
            ++bytesAddress;
            ++charsIndex;
        }
        return true;
    }

    public static int intFromBytes(byte b1, byte b2, byte b3, byte b4) {
        return b1 << 24 | (b2 & 0xFF) << 16 | (b3 & 0xFF) << 8 | b4 & 0xFF;
    }

    public static void zeros(ByteBuffer buffer) {
        ByteUtil.uncheckedZeros(buffer, 0, buffer.capacity());
    }

    public static void zeros(ByteBuffer buffer, int offset, int bytes) {
        if (offset < 0 || bytes < 0) {
            throw new IllegalArgumentException();
        }
        int capacity = buffer.capacity();
        if (offset >= capacity || offset + bytes > capacity) {
            throw new IndexOutOfBoundsException();
        }
        ByteUtil.uncheckedZeros(buffer, offset, bytes);
    }

    private static void uncheckedZeros(ByteBuffer buffer, int offset, int bytes) {
        if (buffer.isReadOnly()) {
            throw new ReadOnlyBufferException();
        }
        boolean zero = false;
        if (buffer.isDirect() && PlatformDependent.hasUnsafe()) {
            PlatformDependent.setMemory(PlatformDependent.directBufferAddress(buffer) + (long)offset, bytes, (byte)0);
        } else if (buffer.hasArray()) {
            int arrayOffset = buffer.arrayOffset();
            int start = arrayOffset + offset;
            Arrays.fill(buffer.array(), start, start + bytes, (byte)0);
        } else {
            for (int i2 = 0; i2 < bytes; ++i2) {
                buffer.put(i2 + offset, (byte)0);
            }
        }
    }

    public static String getHumanReadableByteCount(long bytes) {
        int i2;
        if (bytes == 0L) {
            return "0B";
        }
        for (i2 = 0; i2 < BYTE_MAGNITUDES.length && BYTE_MAGNITUDES[i2] > (double)bytes; ++i2) {
        }
        return String.format("%.1f%sB", (double)bytes / BYTE_MAGNITUDES[i2], BYTE_SUFFIXES[i2]);
    }

    static {
        int i2 = 18;
        int j = 0;
        while (i2 >= 0) {
            ByteUtil.BYTE_MAGNITUDES[j] = Math.pow(10.0, i2);
            i2 -= 3;
            ++j;
        }
    }
}

