/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.activemq.artemis.api.core.ActiveMQExceptionType;
import org.apache.activemq.artemis.api.core.Pair;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.config.ConnectorServiceConfiguration;
import org.apache.activemq.artemis.core.persistence.StorageManager;
import org.apache.activemq.artemis.core.postoffice.PostOffice;
import org.apache.activemq.artemis.core.server.ActiveMQComponent;
import org.apache.activemq.artemis.core.server.ActiveMQServerLogger;
import org.apache.activemq.artemis.core.server.ConnectorService;
import org.apache.activemq.artemis.core.server.ConnectorServiceFactory;
import org.apache.activemq.artemis.core.server.ServiceRegistry;
import org.apache.activemq.artemis.utils.ConfigurationHelper;

public final class ConnectorsService
implements ActiveMQComponent {
    private final StorageManager storageManager;
    private final PostOffice postOffice;
    private final ScheduledExecutorService scheduledPool;
    private boolean isStarted = false;
    private final Configuration configuration;
    private final Map<String, ConnectorService> connectors = new HashMap<String, ConnectorService>();
    private final ServiceRegistry serviceRegistry;

    public ConnectorsService(Configuration configuration, StorageManager storageManager, ScheduledExecutorService scheduledPool, PostOffice postOffice, ServiceRegistry serviceRegistry) {
        this.configuration = configuration;
        this.storageManager = storageManager;
        this.scheduledPool = scheduledPool;
        this.postOffice = postOffice;
        this.serviceRegistry = serviceRegistry;
    }

    @Override
    public synchronized void start() throws Exception {
        Collection<Pair<ConnectorServiceFactory, ConnectorServiceConfiguration>> connectorServiceFactories = this.serviceRegistry.getConnectorServices(this.configuration.getConnectorServiceConfigurations());
        for (Pair<ConnectorServiceFactory, ConnectorServiceConfiguration> pair : connectorServiceFactories) {
            try {
                this.createService(pair.getB(), pair.getA());
            }
            catch (Throwable e) {
                ActiveMQServerLogger.LOGGER.errorStartingConnectorService(e, pair.getB().getConnectorName());
            }
        }
        this.isStarted = true;
    }

    public synchronized void createService(ConnectorServiceConfiguration info, ConnectorServiceFactory factory) throws Exception {
        Set<String> invalid;
        if (this.connectors.containsKey(info.getConnectorName())) {
            throw ActiveMQExceptionType.GENERIC_EXCEPTION.createException("Connector service " + info.getConnectorName() + " already created");
        }
        if (info.getParams() != null && !(invalid = ConfigurationHelper.checkKeys(factory.getAllowableProperties(), info.getParams().keySet())).isEmpty()) {
            throw ActiveMQExceptionType.GENERIC_EXCEPTION.createException("Invalid connector keys for connector service " + info.getConnectorName() + ": " + ConfigurationHelper.stringSetToCommaListString(invalid));
        }
        invalid = ConfigurationHelper.checkKeysExist(factory.getRequiredProperties(), info.getParams().keySet());
        if (!invalid.isEmpty()) {
            throw ActiveMQExceptionType.GENERIC_EXCEPTION.createException("Missing connector keys for connector service " + info.getConnectorName() + ": " + ConfigurationHelper.stringSetToCommaListString(invalid));
        }
        ConnectorService connectorService = factory.createConnectorService(info.getConnectorName(), info.getParams(), this.storageManager, this.postOffice, this.scheduledPool);
        connectorService.start();
        this.connectors.put(info.getConnectorName(), connectorService);
    }

    public synchronized void destroyService(String name) throws Exception {
        if (!this.connectors.containsKey(name)) {
            throw ActiveMQExceptionType.GENERIC_EXCEPTION.createException("Connector service " + name + " does not exist");
        }
        ConnectorService connectorService = this.connectors.get(name);
        connectorService.stop();
        this.connectors.remove(name);
    }

    @Override
    public synchronized void stop() throws Exception {
        if (!this.isStarted) {
            return;
        }
        for (Map.Entry<String, ConnectorService> connector : this.connectors.entrySet()) {
            try {
                connector.getValue().stop();
            }
            catch (Throwable e) {
                ActiveMQServerLogger.LOGGER.errorStoppingConnectorService(e, connector.getKey());
            }
        }
        this.connectors.clear();
        this.isStarted = false;
    }

    @Override
    public synchronized boolean isStarted() {
        return this.isStarted;
    }

    public synchronized Map<String, ConnectorService> getConnectors() {
        return Collections.unmodifiableMap(this.connectors);
    }
}

