/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.protocol.core.impl.wireformat;

import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.client.SendAcknowledgementHandler;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.SessionSendContinuationMessage;

public class SessionSendContinuationMessage_V2
extends SessionSendContinuationMessage {
    private long correlationID;

    public SessionSendContinuationMessage_V2() {
    }

    public SessionSendContinuationMessage_V2(Message message, byte[] body2, boolean continues, boolean requiresResponse, long messageBodySize, SendAcknowledgementHandler handler) {
        super(message, body2, continues, requiresResponse, messageBodySize, handler);
    }

    @Override
    public int expectedEncodeSize() {
        return super.expectedEncodeSize() + 8;
    }

    @Override
    public void encodeRest(ActiveMQBuffer buffer) {
        super.encodeRest(buffer);
        buffer.writeLong(this.correlationID);
    }

    @Override
    public void decodeRest(ActiveMQBuffer buffer) {
        super.decodeRest(buffer);
        if (buffer.readableBytes() >= 8) {
            this.correlationID = buffer.readLong();
        }
    }

    @Override
    public long getCorrelationID() {
        return this.correlationID;
    }

    @Override
    public void setCorrelationID(long correlationID) {
        this.correlationID = correlationID;
    }

    @Override
    public boolean isResponseAsync() {
        return true;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (int)(this.correlationID ^ this.correlationID >>> 32);
        return result;
    }

    @Override
    protected String getPacketString() {
        StringBuffer buff = new StringBuffer(super.getPacketString());
        buff.append(", continues=" + this.continues);
        buff.append(", message=" + this.message);
        buff.append(", messageBodySize=" + this.messageBodySize);
        buff.append(", requiresResponse=" + this.requiresResponse);
        buff.append(", correlationID=" + this.correlationID);
        buff.append("]");
        return buff.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof SessionSendContinuationMessage_V2)) {
            return false;
        }
        SessionSendContinuationMessage_V2 other = (SessionSendContinuationMessage_V2)obj;
        return this.correlationID == other.correlationID;
    }
}

