/*
 * Decompiled with CFR 0.152.
 */
package mslinks.data;

import io.ByteReader;
import io.ByteWriter;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.util.regex.Pattern;
import mslinks.Serializable;
import mslinks.ShellLinkException;
import mslinks.UnsupportedCLSIDException;
import mslinks.data.GUID;

public class ItemID
implements Serializable {
    private static final GUID mycomputer = new GUID("20d04fe0-3aea-1069-a2d8-08002b30309d");
    private static byte[] ub1 = new byte[]{4, 0, -17, -66};
    private static byte[] ub2 = new byte[]{42, 0, 0, 0};
    private static final int EXT_VERSION_WINXP = 3;
    private static final int EXT_VERSION_VISTA = 7;
    private static final int EXT_VERSION_WIN7 = 8;
    private static final int EXT_VERSION_WIN8 = 9;
    public static final int TYPE_UNKNOWN = 0;
    public static final int TYPE_FILE_OLD = 54;
    public static final int TYPE_DIRECTORY_OLD = 53;
    public static final int TYPE_FILE = 50;
    public static final int TYPE_DIRECTORY = 49;
    public static final int TYPE_DRIVE_OLD = 35;
    public static final int TYPE_DRIVE = 47;
    public static final int TYPE_CLSID = 31;
    private int type;
    private int size;
    private String shortname;
    private String longname;
    private GUID clsid;
    private byte[] data;

    public ItemID() {
        this.shortname = "";
        this.longname = "";
    }

    public ItemID(byte[] d) {
        this.data = d;
    }

    public ItemID(ByteReader br, int maxSize) throws IOException, ShellLinkException {
        int pos = br.getPosition();
        int endPos = pos + maxSize;
        this.type = br.read();
        if (this.type == 47 || this.type == 35) {
            this.setName(br.readString(maxSize - 1));
            br.seek(endPos - br.getPosition());
        } else if (this.type == 54 || this.type == 53) {
            br.read();
            this.size = (int)br.read4bytes();
            br.read4bytes();
            br.read2bytes();
            this.longname = br.readUnicodeString(endPos - br.getPosition());
            this.shortname = br.readString(endPos - br.getPosition());
            br.seek(endPos - br.getPosition());
        } else if (this.type == 50 || this.type == 49) {
            br.read();
            this.size = (int)br.read4bytes();
            br.read4bytes();
            br.read2bytes();
            this.shortname = br.readString(endPos - br.getPosition());
            if (ItemID.isLongFilename(this.shortname)) {
                this.longname = this.shortname;
                this.shortname = br.readString(endPos - br.getPosition());
                br.seek(pos + maxSize - br.getPosition());
                return;
            }
            if (endPos - br.getPosition() <= 2) {
                this.longname = this.shortname;
                br.seek(endPos - br.getPosition());
                return;
            }
            if ((br.getPosition() - pos & 1) != 0) {
                br.read();
            }
            pos = br.getPosition();
            int extSize = (int)br.read2bytes();
            int extensionVersion = (int)br.read2bytes();
            br.read4bytes();
            br.read4bytes();
            br.read4bytes();
            switch (extensionVersion) {
                case 3: {
                    br.seek(4);
                    break;
                }
                case 7: {
                    br.seek(22);
                    break;
                }
                case 8: {
                    br.seek(26);
                    break;
                }
                case 9: {
                    br.seek(30);
                    break;
                }
                default: {
                    throw new ShellLinkException("Unknown extension version");
                }
            }
            this.longname = br.readUnicodeString(pos + extSize - br.getPosition());
            br.seek(pos + extSize - br.getPosition());
        } else if (this.type == 31) {
            br.read();
            this.clsid = new GUID(br);
            if (!this.clsid.equals(mycomputer)) {
                throw new UnsupportedCLSIDException();
            }
        } else {
            throw new ShellLinkException("unsupported ItemID type");
        }
    }

    @Override
    public void serialize(ByteWriter bw) throws IOException {
        if (this.data != null) {
            bw.writeBytes(this.data);
            return;
        }
        boolean unicodeName = this.longname != null && !this.longname.equals(this.shortname);
        int pos = bw.getPosition();
        int attr = 0;
        switch (this.type) {
            case 31: {
                bw.write(this.type);
                bw.write(0);
                this.clsid.serialize(bw);
                return;
            }
            case 35: 
            case 47: {
                bw.write(this.type);
                byte[] b = this.getName().getBytes();
                bw.write(b);
                for (int i2 = 0; i2 < 22 - b.length; ++i2) {
                    bw.write(0);
                }
                return;
            }
            case 49: 
            case 53: {
                bw.write(unicodeName ? 53 : 49);
                bw.write(0);
                bw.write4bytes(0L);
                attr = 16;
                break;
            }
            case 50: 
            case 54: {
                bw.write(unicodeName ? 54 : 50);
                bw.write(0);
                bw.write4bytes(this.size);
            }
        }
        bw.write4bytes(0L);
        bw.write2bytes(attr);
        if (unicodeName) {
            bw.writeUnicodeString(this.longname, true);
            bw.writeBytes(this.shortname.getBytes());
            bw.write(0);
        } else {
            bw.writeBytes(this.shortname.getBytes());
            bw.write(0);
            bw.write(0);
        }
    }

    public String getName() {
        if (this.longname != null && !this.longname.equals("")) {
            return this.longname;
        }
        return this.shortname;
    }

    public ItemID setName(String s2) throws ShellLinkException {
        if (s2 == null) {
            return this;
        }
        if (this.type == 50 || this.type == 49) {
            if (s2.contains("\\")) {
                throw new ShellLinkException("wrong name");
            }
            this.longname = s2;
            String string = this.shortname = ItemID.isLongFilename(s2) ? ItemID.generateShortName(s2) : s2;
        }
        if (this.type == 47 || this.type == 35) {
            if (Pattern.matches("\\w+:\\\\", s2)) {
                this.shortname = this.longname = s2;
            } else if (Pattern.matches("\\w+:", s2)) {
                this.shortname = this.longname = s2 + "\\";
            } else if (Pattern.matches("\\w+", s2)) {
                this.shortname = this.longname = s2 + ":\\";
            } else {
                throw new ShellLinkException("wrong name");
            }
        }
        return this;
    }

    public int getSize() {
        return this.size;
    }

    public ItemID setSize(int s2) throws ShellLinkException {
        if (this.type != 50) {
            throw new ShellLinkException("only files has size");
        }
        this.size = s2;
        return this;
    }

    public int getType() {
        return this.type;
    }

    public ItemID setType(int t) throws ShellLinkException {
        if (t == 31) {
            this.type = t;
            this.clsid = mycomputer;
            return this;
        }
        if (t == 50 || t == 49 || t == 47 || t == 35) {
            this.type = t;
            return this;
        }
        throw new ShellLinkException("wrong type");
    }

    private static boolean isLongFilename(String filename) {
        if (filename.charAt(0) == '.' || filename.charAt(filename.length() - 1) == '.') {
            return true;
        }
        if (!filename.matches("^\\p{ASCII}+$")) {
            return true;
        }
        int dotIdx = filename.lastIndexOf(46);
        String baseName = dotIdx == -1 ? filename : filename.substring(0, dotIdx);
        String ext = dotIdx == -1 ? "" : filename.substring(dotIdx + 1);
        String wrongSymbolsPattern = ".*[\\.\"\\/\\\\\\[\\]:;=, ]+.*";
        return baseName.length() > 8 || ext.length() > 3 || baseName.matches(wrongSymbolsPattern) || ext.matches(wrongSymbolsPattern);
    }

    private static String generateShortName(String longname) {
        int dotIdx = (longname = longname.replaceAll("\\.$|^\\.", "")).lastIndexOf(46);
        String baseName = dotIdx == -1 ? longname : longname.substring(0, dotIdx);
        String ext = dotIdx == -1 ? "" : longname.substring(dotIdx + 1);
        ext = ext.replaceAll(" ", "").replaceAll("[\\.\"\\/\\\\\\[\\]:;=,\\+]", "_");
        ext = ext.substring(0, Math.min(3, ext.length()));
        baseName = baseName.replaceAll(" ", "").replaceAll("[\\.\"\\/\\\\\\[\\]:;=,\\+]", "_");
        baseName = baseName.substring(0, Math.min(6, baseName.length()));
        StringBuilder shortname = new StringBuilder(baseName + "~1" + (ext.isEmpty() ? "" : "." + ext));
        CharsetEncoder asciiEncoder = Charset.forName("US-ASCII").newEncoder();
        for (int i2 = 0; i2 < shortname.length(); ++i2) {
            if (asciiEncoder.canEncode(shortname.charAt(i2))) continue;
            shortname.setCharAt(i2, '_');
        }
        return shortname.toString().toUpperCase();
    }
}

