/*
 * Decompiled with CFR 0.152.
 */
package mdlaf.components.taskpane;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.plaf.ComponentUI;
import org.jdesktop.swingx.JXTaskPane;
import org.jdesktop.swingx.plaf.basic.BasicTaskPaneUI;

public class MaterialTaskPaneUI
extends BasicTaskPaneUI {
    protected Color contentBackground;
    protected Color background;
    protected Color borderColor;
    protected Icon uncollapsed;
    protected Icon collapsed;
    protected boolean mouseHoverEnable;
    protected int arch;

    public static ComponentUI createUI(JComponent c) {
        return new MaterialTaskPaneUI();
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        this.contentBackground = UIManager.getColor("TaskPane.contentBackground");
        this.background = UIManager.getColor("TaskPane.background");
        this.group.getContentPane().setBackground(this.contentBackground);
        this.uncollapsed = UIManager.getIcon("TaskPane.yesCollapsed");
        this.collapsed = UIManager.getIcon("TaskPane.noCollapsed");
        this.mouseHoverEnable = UIManager.getBoolean("TaskPane.mouseHover");
        this.arch = UIManager.getInt("TaskPane.arch");
    }

    @Override
    public void uninstallUI(JComponent c) {
        c.setCursor(Cursor.getDefaultCursor());
        super.uninstallUI(c);
    }

    @Override
    public void update(Graphics g2, JComponent c) {
        super.update(g2, c);
    }

    @Override
    protected Border createContentPaneBorder() {
        this.borderColor = UIManager.getColor("TaskPane.borderColor");
        BasicTaskPaneUI.ContentPaneBorder contentPanel = new BasicTaskPaneUI.ContentPaneBorder(this.borderColor);
        Border taskBorder = UIManager.getBorder("TaskPane.border");
        return new CompoundBorder(contentPanel, taskBorder);
    }

    @Override
    protected void uninstallListeners() {
        super.uninstallListeners();
    }

    @Override
    protected Border createPaneBorder() {
        return new MaterialPaneBorder();
    }

    @Override
    public void paint(Graphics g2, JComponent c) {
        super.paint(g2, c);
    }

    protected class MaterialPaneBorder
    extends BasicTaskPaneUI.PaneBorder {
        protected MaterialPaneBorder() {
            super(MaterialTaskPaneUI.this);
        }

        @Override
        protected void paintTitleBackground(JXTaskPane group, Graphics g2) {
            this.label.setBackground(MaterialTaskPaneUI.this.background);
            if (group.isSpecial()) {
                g2.setColor(this.specialTitleBackground);
            } else {
                g2.setColor(this.titleBackgroundGradientStart);
            }
            Graphics2D graphics2D = (Graphics2D)g2;
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2 = graphics2D;
            g2.fillRoundRect(-2, 0, group.getWidth(), group.getHeight(), MaterialTaskPaneUI.this.arch, MaterialTaskPaneUI.this.arch);
            this.paintChevronControls(group, g2, 0, 0, group.getWidth(), group.getHeight());
        }

        @Override
        protected boolean isMouseOverBorder() {
            return MaterialTaskPaneUI.this.mouseHoverEnable;
        }

        @Override
        public Dimension getPreferredSize(JXTaskPane group) {
            this.configureLabel(group);
            Dimension dim = this.label.getPreferredSize();
            dim.width += MaterialTaskPaneUI.this.getTitleHeight(group);
            dim.height = MaterialTaskPaneUI.this.getTitleHeight(group);
            return dim;
        }

        @Override
        protected void paintChevronControls(JXTaskPane group, Graphics g2, int x, int y, int width, int height) {
            if (group.isCollapsed()) {
                group.setIcon(MaterialTaskPaneUI.this.collapsed);
            } else {
                group.setIcon(MaterialTaskPaneUI.this.uncollapsed);
            }
        }
    }
}

