/*
 * Decompiled with CFR 0.152.
 */
package de.griefed.serverpackcreator.versionmeta.legacyfabric;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.griefed.serverpackcreator.versionmeta.ManifestParser;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

abstract class LegacyFabricVersioning
extends ManifestParser {
    private final List<String> RELEASES = new ArrayList<String>(100);
    private final List<String> SNAPSHOTS = new ArrayList<String>(100);
    private final List<String> ALL = new ArrayList<String>(200);
    private final ObjectMapper MAPPER;
    private final File MANIFEST;

    LegacyFabricVersioning(File manifest, ObjectMapper mapper) {
        this.MAPPER = mapper;
        this.MANIFEST = manifest;
    }

    void update() throws IOException {
        this.RELEASES.clear();
        this.SNAPSHOTS.clear();
        this.ALL.clear();
        this.getJson(this.MANIFEST, this.MAPPER).forEach(node -> {
            String version = node.get("version").asText();
            this.ALL.add(version);
            if (node.get("stable").asBoolean()) {
                this.RELEASES.add(version);
            } else {
                this.SNAPSHOTS.add(version);
            }
        });
    }

    List<String> releases() {
        return this.RELEASES;
    }

    List<String> snapshots() {
        return this.SNAPSHOTS;
    }

    List<String> all() {
        return this.ALL;
    }
}

