/*
 * Decompiled with CFR 0.152.
 */
package de.griefed.serverpackcreator.versionmeta.forge;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.griefed.serverpackcreator.versionmeta.ManifestParser;
import de.griefed.serverpackcreator.versionmeta.forge.ForgeInstance;
import de.griefed.serverpackcreator.versionmeta.minecraft.MinecraftMeta;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

final class ForgeLoader
extends ManifestParser {
    private static final Logger LOG = LogManager.getLogger(ForgeLoader.class);
    private final ObjectMapper MAPPER;
    private final MinecraftMeta MINECRAFT_META;
    private final List<String> minecraftVersions = new ArrayList<String>(100);
    private final List<String> forgeVersions = new ArrayList<String>(100);
    private final File MANIFEST;
    private HashMap<String, List<String>> versionMeta;
    private HashMap<String, String> forgeToMinecraftMeta;
    private HashMap<String, ForgeInstance> instanceMeta;

    ForgeLoader(File forgemanifest, ObjectMapper mapper, MinecraftMeta injectedMinecraftMeta) {
        this.MANIFEST = forgemanifest;
        this.MAPPER = mapper;
        this.MINECRAFT_META = injectedMinecraftMeta;
    }

    void update() throws IOException {
        this.minecraftVersions.clear();
        this.forgeVersions.clear();
        this.versionMeta = new HashMap(200);
        this.forgeToMinecraftMeta = new HashMap(200);
        this.instanceMeta = new HashMap(200);
        JsonNode forgeManifest = this.getJson(this.MANIFEST, this.MAPPER);
        forgeManifest.fieldNames().forEachRemaining(field -> {
            String mcVersion;
            if (this.MINECRAFT_META.getClient(field.replace("_", "-")).isPresent()) {
                mcVersion = field.replace("_", "-");
                this.minecraftVersions.add(field.replace("_", "-"));
            } else {
                mcVersion = field;
                this.minecraftVersions.add((String)field);
            }
            ArrayList forgeVersionsForMCVer = new ArrayList(100);
            forgeManifest.get((String)field).forEach(forge -> {
                this.forgeVersions.add(forge.asText().substring(mcVersion.length() + 1));
                forgeVersionsForMCVer.add(forge.asText().substring(mcVersion.length() + 1));
                try {
                    ForgeInstance forgeInstance = new ForgeInstance(mcVersion, forge.asText().substring(mcVersion.length() + 1), this.MINECRAFT_META);
                    this.instanceMeta.put(mcVersion + forge.asText().substring(mcVersion.length()), forgeInstance);
                    this.forgeToMinecraftMeta.put(forge.asText().substring(mcVersion.length() + 1), mcVersion);
                }
                catch (MalformedURLException | NoSuchElementException ex) {
                    LOG.debug("Could not create Forge instance for Minecraft " + mcVersion + " and Forge " + forge.asText().substring(mcVersion.length() + 1), (Throwable)ex);
                }
            });
            this.versionMeta.put(mcVersion, forgeVersionsForMCVer);
        });
    }

    List<String> minecraftVersions() {
        return this.minecraftVersions;
    }

    List<String> forgeVersions() {
        return this.forgeVersions;
    }

    HashMap<String, List<String>> versionMeta() {
        return this.versionMeta;
    }

    HashMap<String, String> forgeToMinecraftMeta() {
        return this.forgeToMinecraftMeta;
    }

    HashMap<String, ForgeInstance> instanceMeta() {
        return this.instanceMeta;
    }
}

