/*
 * Decompiled with CFR 0.152.
 */
package de.griefed.serverpackcreator.versionmeta.fabric;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.griefed.serverpackcreator.versionmeta.fabric.FabricIntermediary;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;

public final class FabricIntermediaries {
    private final ObjectMapper OBJECT_MAPPER;
    private final File INTERMEDIARY_MANIFEST;
    private final HashMap<String, FabricIntermediary> INTERMEDIARIES = new HashMap(100);

    public FabricIntermediaries(File intermediaryManifest, ObjectMapper objectMapper) {
        this.INTERMEDIARY_MANIFEST = intermediaryManifest;
        this.OBJECT_MAPPER = objectMapper;
    }

    public void update() throws IOException {
        for (FabricIntermediary intermediary : this.listIntermediariesFromManifest()) {
            this.INTERMEDIARIES.put(intermediary.getVersion(), intermediary);
        }
    }

    private List<FabricIntermediary> listIntermediariesFromManifest() throws IOException {
        return this.OBJECT_MAPPER.readValue(this.INTERMEDIARY_MANIFEST, new TypeReference<List<FabricIntermediary>>(){});
    }

    public Optional<FabricIntermediary> getIntermediary(String minecraftVersion) {
        return Optional.ofNullable(this.INTERMEDIARIES.get(minecraftVersion));
    }

    public boolean areIntermediariesPresent(String minecraftVersion) {
        return this.getIntermediary(minecraftVersion).isPresent();
    }
}

