/*
 * Decompiled with CFR 0.152.
 */
package de.griefed.serverpackcreator.versionmeta.fabric;

import de.griefed.serverpackcreator.versionmeta.ManifestParser;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

final class FabricInstaller
extends ManifestParser {
    private final String URL_TEMPLATE_INSTALLER = "https://maven.fabricmc.net/net/fabricmc/fabric-installer/%s/fabric-installer-%s.jar";
    private final File MANIFEST;
    private final List<String> installers = new ArrayList<String>(100);
    private final HashMap<String, URL> installerUrlMeta = new HashMap(100);
    private String latestInstaller;
    private String releaseInstaller;
    private URL latestInstallerUrl;
    private URL releaseInstallerUrl;

    FabricInstaller(File manifest) {
        this.MANIFEST = manifest;
    }

    void update() throws ParserConfigurationException, IOException, SAXException {
        Document document = this.getXml(this.MANIFEST);
        this.latestInstaller = document.getElementsByTagName("latest").item(0).getChildNodes().item(0).getNodeValue();
        this.releaseInstaller = document.getElementsByTagName("release").item(0).getChildNodes().item(0).getNodeValue();
        try {
            this.latestInstallerUrl = new URL(String.format("https://maven.fabricmc.net/net/fabricmc/fabric-installer/%s/fabric-installer-%s.jar", this.latestInstaller, this.latestInstaller));
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        try {
            this.releaseInstallerUrl = new URL(String.format("https://maven.fabricmc.net/net/fabricmc/fabric-installer/%s/fabric-installer-%s.jar", this.releaseInstaller, this.releaseInstaller));
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        this.installers.clear();
        for (int i2 = 0; i2 < document.getElementsByTagName("version").getLength(); ++i2) {
            this.installers.add(document.getElementsByTagName("version").item(i2).getChildNodes().item(0).getNodeValue());
        }
        this.installerUrlMeta.clear();
        this.installers.forEach(version -> {
            try {
                this.installerUrlMeta.put((String)version, this.installerUrl((String)version));
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        });
    }

    private URL installerUrl(String fabricInstallerVersion) throws MalformedURLException {
        return new URL(String.format("https://maven.fabricmc.net/net/fabricmc/fabric-installer/%s/fabric-installer-%s.jar", fabricInstallerVersion, fabricInstallerVersion));
    }

    List<String> installers() {
        return this.installers;
    }

    HashMap<String, URL> meta() {
        return this.installerUrlMeta;
    }

    String latestInstallerVersion() {
        return this.latestInstaller;
    }

    String releaseInstallerVersion() {
        return this.releaseInstaller;
    }

    URL latestInstallerUrl() {
        return this.latestInstallerUrl;
    }

    URL releaseInstallerUrl() {
        return this.releaseInstallerUrl;
    }

    Optional<URL> improvedLauncherUrl(String minecraftVersion, String fabricVersion) {
        try {
            return Optional.of(new URL(String.format("https://meta.fabricmc.net/v2/versions/loader/%s/%s/%s/server/jar", minecraftVersion, fabricVersion, this.releaseInstaller)));
        }
        catch (MalformedURLException ex) {
            return Optional.empty();
        }
    }
}

