/*
 * Decompiled with CFR 0.152.
 */
package de.griefed.serverpackcreator.utilities.common;

import de.griefed.serverpackcreator.ApplicationProperties;
import java.awt.Desktop;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.ProtocolException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import javax.net.ssl.HttpsURLConnection;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.stereotype.Component;

@Component
public final class WebUtilities {
    private static final Logger LOG = LogManager.getLogger(WebUtilities.class);
    private final ApplicationProperties APPLICATIONPROPERTIES;

    public WebUtilities(ApplicationProperties injectedApplicationProperties) {
        this.APPLICATIONPROPERTIES = injectedApplicationProperties;
    }

    public boolean downloadAndReplaceFile(File destinationFile, URL downloadURL) {
        return this.downloadAndReplaceFile(destinationFile.getAbsoluteFile().toString().replace("\\", "/"), downloadURL);
    }

    public boolean downloadAndReplaceFile(String fileDestination, URL downloadURL) {
        FileUtils.deleteQuietly(new File(fileDestination));
        return this.downloadFile(fileDestination, downloadURL);
    }

    public boolean downloadFile(File destinationFile, URL downloadURL) {
        return this.downloadFile(destinationFile.getAbsoluteFile().toString().replace("\\", "/"), downloadURL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean downloadFile(String fileDestination, URL downloadURL) {
        try {
            FileUtils.createParentDirectories(new File(fileDestination));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        ReadableByteChannel readableByteChannel = null;
        OutputStream fileOutputStream = null;
        AbstractInterruptibleChannel fileChannel = null;
        try {
            readableByteChannel = Channels.newChannel(downloadURL.openStream());
            fileOutputStream = new FileOutputStream(fileDestination.replace("\\", "/"));
            fileChannel = ((FileOutputStream)fileOutputStream).getChannel();
            ((FileChannel)fileChannel).transferFrom(readableByteChannel, 0L, Long.MAX_VALUE);
        }
        catch (IOException ex) {
            LOG.error("An error occurred downloading " + fileDestination + " from " + downloadURL + ".", (Throwable)ex);
        }
        finally {
            try {
                fileOutputStream.flush();
            }
            catch (Exception exception) {}
            try {
                ((FileOutputStream)fileOutputStream).close();
            }
            catch (Exception exception) {}
            try {
                readableByteChannel.close();
            }
            catch (Exception exception) {}
            try {
                fileChannel.close();
            }
            catch (Exception exception) {}
        }
        return new File(fileDestination).exists();
    }

    public void openLinkInBrowser(URL url) {
        try {
            this.openLinkInBrowser(url.toURI());
        }
        catch (URISyntaxException ex) {
            LOG.error("Error opening browser with link " + url + ".", (Throwable)ex);
        }
    }

    public void openLinkInBrowser(URI uri) {
        try {
            if (Desktop.getDesktop().isSupported(Desktop.Action.BROWSE)) {
                Desktop.getDesktop().browse(uri);
            }
        }
        catch (IOException ex) {
            LOG.error("Error opening browser with link " + uri + ".", (Throwable)ex);
        }
    }

    public boolean hasteBinPreChecks(File fileToCheck) {
        long fileSize = FileUtils.sizeOf(fileToCheck);
        try {
            if (fileSize < 10000000L && FileUtils.readFileToString(fileToCheck, StandardCharsets.UTF_8).length() < 400000) {
                LOG.debug("Smaller. " + fileSize + " byte.");
                return true;
            }
            LOG.debug("Bigger. " + fileSize + " byte.");
            return false;
        }
        catch (IOException ex) {
            LOG.error("Couldn't read file: " + fileToCheck, (Throwable)ex);
            return false;
        }
    }

    public String createHasteBinFromFile(File textFile) {
        String text = null;
        String requestURL = this.APPLICATIONPROPERTIES.getHasteBinServerUrl();
        String response = null;
        URL url = null;
        HttpsURLConnection conn = null;
        try {
            url = new URL(requestURL);
        }
        catch (IOException ex) {
            LOG.error("Error during acquisition of request URL.", (Throwable)ex);
        }
        try {
            text = FileUtils.readFileToString(textFile, "UTF-8");
        }
        catch (IOException ex) {
            LOG.error("Error reading text from file.", (Throwable)ex);
        }
        byte[] postData = Objects.requireNonNull(text).getBytes(StandardCharsets.UTF_8);
        int postDataLength = postData.length;
        try {
            conn = (HttpsURLConnection)Objects.requireNonNull(url).openConnection();
        }
        catch (IOException ex) {
            LOG.error("Error during opening of connection to URL.", (Throwable)ex);
        }
        Objects.requireNonNull(conn).setDoOutput(true);
        conn.setInstanceFollowRedirects(false);
        try {
            conn.setRequestMethod("POST");
        }
        catch (ProtocolException ex) {
            LOG.error("Error during request of POST method.", (Throwable)ex);
        }
        conn.setRequestProperty("User-Agent", "HasteBin-Creator for ServerPackCreator");
        conn.setRequestProperty("Content-Length", Integer.toString(postDataLength));
        conn.setUseCaches(false);
        try (DataOutputStream dataOutputStream = new DataOutputStream(conn.getOutputStream());){
            dataOutputStream.write(postData);
            try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(conn.getInputStream()));){
                response = bufferedReader.readLine();
            }
            catch (IOException ex) {
                LOG.error("Error encountered when acquiring HasteBin.", (Throwable)ex);
            }
        }
        catch (IOException ex) {
            LOG.error("Error encountered when acquiring HasteBin.", (Throwable)ex);
        }
        if (((String)Objects.requireNonNull(response)).contains("\"key\"")) {
            response = requestURL.replace("/documents", "/") + response.substring(response.indexOf(":") + 2, response.length() - 2);
        }
        if (response.contains(requestURL.replace("/documents", ""))) {
            return response;
        }
        return "Error encountered when acquiring response from URL.";
    }

    public String getResponseAsString(URL url) throws IOException {
        String currentLine;
        BufferedReader in = new BufferedReader(new InputStreamReader(url.openConnection().getInputStream()));
        StringBuilder response = new StringBuilder();
        while ((currentLine = in.readLine()) != null) {
            response.append(currentLine);
        }
        in.close();
        return response.toString();
    }

    public int getResponseCode(URL url) throws IOException {
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        return connection.getResponseCode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isReachable(URL url) {
        boolean available;
        HttpURLConnection connection = null;
        try {
            String host = url.getHost();
            LOG.debug("URL:  " + url);
            LOG.debug("Host: " + host);
            connection = (HttpURLConnection)url.openConnection();
            available = connection.getResponseCode() == 200;
        }
        catch (IOException e) {
            available = false;
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
        if (!available) {
            LOG.warn("Could not successfully connect to " + url);
        }
        return available;
    }
}

