/*
 * Decompiled with CFR 0.152.
 */
package de.griefed.serverpackcreator.utilities;

import de.griefed.versionchecker.GitHubChecker;
import de.griefed.versionchecker.GitLabChecker;
import de.griefed.versionchecker.Update;
import java.io.IOException;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public final class UpdateChecker {
    private static final Logger LOG = LogManager.getLogger(UpdateChecker.class);
    private GitHubChecker gitHub;
    private GitLabChecker gitGriefed;
    private GitLabChecker gitLab;

    @Autowired
    public UpdateChecker() {
        try {
            this.gitHub = new GitHubChecker("Griefed/ServerPackCreator").refresh();
        }
        catch (IOException ex) {
            LOG.error("Either GitHub is currently unreachable, or the GitHub user/repository you set resulted in a malformed URL. " + ex.getMessage());
            this.gitHub = null;
        }
        try {
            this.gitLab = new GitLabChecker("https://gitlab.com/api/v4/projects/32677538/releases").refresh();
        }
        catch (IOException ex) {
            LOG.error("Either GitLab is currently unreachable, or the GitLab URL you set resulted in a malformed URL." + ex.getMessage());
            this.gitLab = null;
        }
        try {
            this.gitGriefed = new GitLabChecker("https://git.griefed.de/api/v4/projects/63/releases").refresh();
        }
        catch (IOException ex) {
            LOG.error("Either Git.Griefed is currently unavailable, or the Git.Griefed URL you set resulted in a malformed URL." + ex.getMessage());
            this.gitGriefed = null;
        }
    }

    public void refresh() {
        if (this.gitHub != null) {
            try {
                this.gitHub.refresh();
            }
            catch (Exception ex) {
                LOG.error("Error refreshing GitHub.", (Throwable)ex);
                this.gitHub = null;
            }
        }
        if (this.gitLab != null) {
            try {
                this.gitLab.refresh();
            }
            catch (Exception ex) {
                LOG.error("Error refreshing GitLab.", (Throwable)ex);
                this.gitLab = null;
            }
        }
        if (this.gitGriefed != null) {
            try {
                this.gitGriefed.refresh();
            }
            catch (Exception ex) {
                LOG.error("Error refreshing GitGriefed.", (Throwable)ex);
                this.gitGriefed = null;
            }
        }
    }

    public Optional<Update> checkForUpdate(@NotNull String version, Boolean preReleaseCheck) {
        if (version.equalsIgnoreCase("dev")) {
            return Optional.empty();
        }
        Optional<Update> update = Optional.empty();
        if (this.gitHub != null) {
            LOG.debug("Checking GitHub for updates...");
            update = this.gitHub.check(version, preReleaseCheck);
        }
        if (this.gitGriefed != null) {
            LOG.debug("Checking GitGriefed for updates...");
            if (update.isPresent() && this.gitGriefed.check(update.get().version(), preReleaseCheck).isPresent()) {
                update = this.gitGriefed.check(update.get().version(), preReleaseCheck);
            } else if (!update.isPresent()) {
                update = this.gitGriefed.check(version, preReleaseCheck);
            }
        }
        if (this.gitLab != null) {
            LOG.debug("Checking GitLab for updates...");
            if (update.isPresent() && this.gitLab.check(update.get().version(), preReleaseCheck).isPresent()) {
                update = this.gitLab.check(update.get().version(), preReleaseCheck);
            } else if (!update.isPresent()) {
                update = this.gitLab.check(version, preReleaseCheck);
            }
        }
        return update;
    }
}

