/*
 * Decompiled with CFR 0.152.
 */
package de.griefed.serverpackcreator.swing.utilities;

import de.griefed.serverpackcreator.i18n.I18n;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.IOException;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.AbstractCellEditor;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.swing.text.JTextComponent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ScriptSettings
extends JTable {
    private static final Logger LOG = LogManager.getLogger(ScriptSettings.class);
    private boolean isSelectAllForMouseEvent = false;
    private boolean isSelectAllForActionEvent = false;
    private boolean isSelectAllForKeyEvent = false;

    public ScriptSettings(I18n i18n) {
        this(new DefaultTableModel(new Object[]{i18n.getMessage("createserverpack.gui.createserverpack.scriptsettings.table.column.variable"), i18n.getMessage("createserverpack.gui.createserverpack.scriptsettings.table.column.value"), i18n.getMessage("createserverpack.gui.createserverpack.scriptsettings.table.column.clear")}, 100), null, null);
    }

    public ScriptSettings(TableModel dm, TableColumnModel cm, ListSelectionModel sm) {
        super(dm, cm, sm);
        try {
            AbstractAction delete = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JTable table = (JTable)e.getSource();
                    int modelRow = Integer.parseInt(e.getActionCommand());
                    ((DefaultTableModel)table.getModel()).removeRow(modelRow);
                }
            };
            new ButtonColumn(this, delete, 2);
        }
        catch (IOException ex) {
            LOG.error("Couldn't create button column.", (Throwable)ex);
        }
        this.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        this.setSelectAllForEdit(true);
        this.getColumnModel().getColumn(2).setMinWidth(60);
        this.getColumnModel().getColumn(2).setMaxWidth(60);
        this.getColumnModel().getColumn(2).setWidth(60);
        this.getColumnModel().getColumn(2).setResizable(false);
    }

    @Override
    public boolean editCellAt(int row, int column, EventObject e) {
        boolean result = super.editCellAt(row, column, e);
        if (this.isSelectAllForMouseEvent || this.isSelectAllForActionEvent || this.isSelectAllForKeyEvent) {
            this.selectAll(e);
        }
        return result;
    }

    private void selectAll(EventObject e) {
        Component editor = this.getEditorComponent();
        if (!(editor instanceof JTextComponent)) {
            return;
        }
        if (e == null) {
            ((JTextComponent)editor).selectAll();
            return;
        }
        if (e instanceof KeyEvent && this.isSelectAllForKeyEvent) {
            ((JTextComponent)editor).selectAll();
            return;
        }
        if (e instanceof ActionEvent && this.isSelectAllForActionEvent) {
            ((JTextComponent)editor).selectAll();
            return;
        }
        if (e instanceof MouseEvent && this.isSelectAllForMouseEvent) {
            SwingUtilities.invokeLater(() -> ((JTextComponent)editor).selectAll());
        }
    }

    public void setSelectAllForEdit(boolean isSelectAllForEdit) {
        this.isSelectAllForMouseEvent = isSelectAllForEdit;
        this.isSelectAllForActionEvent = isSelectAllForEdit;
        this.isSelectAllForKeyEvent = isSelectAllForEdit;
    }

    public void setSelectAllForMouseEvent(boolean isSelectAllForMouseEvent) {
        this.isSelectAllForMouseEvent = isSelectAllForMouseEvent;
    }

    public void setSelectAllForActionEvent(boolean isSelectAllForActionEvent) {
        this.isSelectAllForActionEvent = isSelectAllForActionEvent;
    }

    public void setSelectAllForKeyEvent(boolean isSelectAllForKeyEvent) {
        this.isSelectAllForKeyEvent = isSelectAllForKeyEvent;
    }

    public void loadData(HashMap<String, String> data) {
        this.clearData();
        int row = 0;
        for (Map.Entry<String, String> entry : data.entrySet()) {
            this.getModel().setValueAt(entry.getKey(), row, 0);
            this.getModel().setValueAt(entry.getValue(), row, 1);
            ++row;
        }
    }

    public HashMap<String, String> getData() {
        HashMap<String, String> data = new HashMap<String, String>(100);
        for (int row = 0; row < this.getModel().getRowCount(); ++row) {
            if (this.getModel().getValueAt(row, 0).toString().isEmpty() || this.getModel().getValueAt(row, 1).toString().isEmpty()) continue;
            data.put(this.getModel().getValueAt(row, 0).toString(), this.getModel().getValueAt(row, 1).toString());
        }
        return data;
    }

    public void clearData() {
        for (int row = 0; row < this.getModel().getRowCount(); ++row) {
            this.getModel().setValueAt("", row, 0);
            this.getModel().setValueAt("", row, 1);
        }
        this.getModel().setValueAt("SPC_JAVA_SPC", 0, 0);
        this.getModel().setValueAt("java", 0, 1);
    }

    public class ButtonColumn
    extends AbstractCellEditor
    implements TableCellRenderer,
    TableCellEditor,
    ActionListener,
    MouseListener {
        private final JTable table;
        private final Action action;
        private final Border originalBorder;
        private final JButton renderButton;
        private final JButton editButton;
        private Border focusBorder;
        private Object editorValue;
        private boolean isButtonColumnEditor;

        public ButtonColumn(JTable table, Action action, int column) throws IOException {
            this.table = table;
            this.action = action;
            ImageIcon delete = new ImageIcon(ImageIO.read(Objects.requireNonNull(ScriptSettings.class.getResource("/de/griefed/resources/gui/delete.png"))).getScaledInstance(32, 32, 4));
            this.renderButton = new JButton(delete);
            this.editButton = new JButton(delete);
            this.editButton.setFocusPainted(false);
            this.editButton.addActionListener(this);
            this.originalBorder = this.editButton.getBorder();
            this.setFocusBorder(new LineBorder(Color.BLUE));
            TableColumnModel columnModel = table.getColumnModel();
            columnModel.getColumn(column).setCellRenderer(this);
            columnModel.getColumn(column).setCellEditor(this);
            table.addMouseListener(this);
        }

        public void setFocusBorder(Border focusBorder) {
            this.focusBorder = focusBorder;
            this.editButton.setBorder(focusBorder);
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.editorValue = value;
            return this.editButton;
        }

        @Override
        public Object getCellEditorValue() {
            return this.editorValue;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (isSelected) {
                this.renderButton.setForeground(table.getSelectionForeground());
                this.renderButton.setBackground(table.getSelectionBackground());
            } else {
                this.renderButton.setForeground(table.getForeground());
                this.renderButton.setBackground(UIManager.getColor("Button.background"));
            }
            if (hasFocus) {
                this.renderButton.setBorder(this.focusBorder);
            } else {
                this.renderButton.setBorder(this.originalBorder);
            }
            return this.renderButton;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int row = this.table.convertRowIndexToModel(this.table.getEditingRow());
            this.fireEditingStopped();
            ActionEvent event = new ActionEvent(this.table, 1001, String.valueOf(row));
            this.action.actionPerformed(event);
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (this.table.isEditing() && this.table.getCellEditor().equals(this)) {
                this.isButtonColumnEditor = true;
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (this.isButtonColumnEditor && this.table.isEditing()) {
                this.table.getCellEditor().stopCellEditing();
            }
            this.isButtonColumnEditor = false;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }
    }
}

