/*
 * Decompiled with CFR 0.152.
 */
package de.griefed.serverpackcreator.swing.utilities;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import javax.swing.Icon;

public class RotatedIcon
implements Icon {
    private final Icon icon;
    private final Rotate rotate;
    private double degrees;
    private boolean circularIcon;

    public RotatedIcon(Icon icon) {
        this(icon, Rotate.UP);
    }

    public RotatedIcon(Icon icon, Rotate rotate) {
        this.icon = icon;
        this.rotate = rotate;
    }

    public RotatedIcon(Icon icon, double degrees2) {
        this(icon, degrees2, false);
    }

    public RotatedIcon(Icon icon, double degrees2, boolean circularIcon) {
        this(icon, Rotate.ABOUT_CENTER);
        this.degrees = degrees2;
        this.circularIcon = circularIcon;
    }

    public Icon getIcon() {
        return this.icon;
    }

    public Rotate getRotate() {
        return this.rotate;
    }

    public double getDegrees() {
        return this.degrees;
    }

    public void setDegrees(double degrees2) {
        this.degrees = degrees2;
    }

    public boolean isCircularIcon() {
        return this.circularIcon;
    }

    public void setCircularIcon(boolean circularIcon) {
        this.circularIcon = circularIcon;
    }

    @Override
    public int getIconWidth() {
        if (this.rotate == Rotate.ABOUT_CENTER) {
            if (this.circularIcon) {
                return this.icon.getIconWidth();
            }
            double radians2 = Math.toRadians(this.degrees);
            double sin = Math.abs(Math.sin(radians2));
            double cos = Math.abs(Math.cos(radians2));
            return (int)Math.floor((double)this.icon.getIconWidth() * cos + (double)this.icon.getIconHeight() * sin);
        }
        if (this.rotate == Rotate.UPSIDE_DOWN) {
            return this.icon.getIconWidth();
        }
        return this.icon.getIconHeight();
    }

    @Override
    public int getIconHeight() {
        if (this.rotate == Rotate.ABOUT_CENTER) {
            if (this.circularIcon) {
                return this.icon.getIconHeight();
            }
            double radians2 = Math.toRadians(this.degrees);
            double sin = Math.abs(Math.sin(radians2));
            double cos = Math.abs(Math.cos(radians2));
            return (int)Math.floor((double)this.icon.getIconHeight() * cos + (double)this.icon.getIconWidth() * sin);
        }
        if (this.rotate == Rotate.UPSIDE_DOWN) {
            return this.icon.getIconHeight();
        }
        return this.icon.getIconWidth();
    }

    @Override
    public void paintIcon(Component c, Graphics g2, int x, int y) {
        int yAdjustment;
        Graphics2D g22 = (Graphics2D)g2.create();
        int cWidth = this.icon.getIconWidth() / 2;
        int cHeight = this.icon.getIconHeight() / 2;
        int xAdjustment = this.icon.getIconWidth() % 2 == 0 ? 0 : -1;
        int n = yAdjustment = this.icon.getIconHeight() % 2 == 0 ? 0 : -1;
        if (this.rotate == Rotate.DOWN) {
            g22.translate(x + cHeight, y + cWidth);
            g22.rotate(Math.toRadians(90.0));
            this.icon.paintIcon(c, g22, -cWidth, yAdjustment - cHeight);
        } else if (this.rotate == Rotate.UP) {
            g22.translate(x + cHeight, y + cWidth);
            g22.rotate(Math.toRadians(-90.0));
            this.icon.paintIcon(c, g22, xAdjustment - cWidth, -cHeight);
        } else if (this.rotate == Rotate.UPSIDE_DOWN) {
            g22.translate(x + cWidth, y + cHeight);
            g22.rotate(Math.toRadians(180.0));
            this.icon.paintIcon(c, g22, xAdjustment - cWidth, yAdjustment - cHeight);
        } else if (this.rotate == Rotate.ABOUT_CENTER) {
            g22.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g22.setClip(x, y, this.getIconWidth(), this.getIconHeight());
            g22.translate((this.getIconWidth() - this.icon.getIconWidth()) / 2, (this.getIconHeight() - this.icon.getIconHeight()) / 2);
            g22.rotate(Math.toRadians(this.degrees), x + cWidth, y + cHeight);
            this.icon.paintIcon(c, g22, x, y);
        }
        g22.dispose();
    }

    public static enum Rotate {
        DOWN,
        UP,
        UPSIDE_DOWN,
        ABOUT_CENTER;

    }
}

