/*
 * Decompiled with CFR 0.152.
 */
package de.griefed.serverpackcreator.addons.swinggui;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.UnmodifiableConfig;
import com.electronwill.nightconfig.core.io.WritingMode;
import com.electronwill.nightconfig.toml.TomlFormat;
import de.griefed.serverpackcreator.ApplicationProperties;
import de.griefed.serverpackcreator.utilities.common.Utilities;
import de.griefed.serverpackcreator.versionmeta.VersionMeta;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class ExtensionTab
extends JPanel {
    protected static final Logger LOG_ADDONS = LogManager.getLogger("AddonsLogger");
    protected final Optional<CommentedConfig> ADDON_CONFIG;
    private final VersionMeta VERSIONMETA;
    private final ApplicationProperties APPLICATIONPROPERTIES;
    private final Utilities UTILITIES;
    private final Optional<File> CONFIG_FILE;

    protected ExtensionTab(VersionMeta versionMeta, ApplicationProperties applicationProperties, Utilities utilities, Optional<CommentedConfig> addonConfig, Optional<File> configFile) {
        this.VERSIONMETA = versionMeta;
        this.APPLICATIONPROPERTIES = applicationProperties;
        this.UTILITIES = utilities;
        this.ADDON_CONFIG = addonConfig;
        this.CONFIG_FILE = configFile;
    }

    protected final void saveConfiguration() {
        SwingUtilities.invokeLater(() -> {
            if (this.ADDON_CONFIG.isPresent() && this.CONFIG_FILE.isPresent()) {
                TomlFormat.instance().createWriter().write((UnmodifiableConfig)this.ADDON_CONFIG.get(), this.CONFIG_FILE.get(), WritingMode.REPLACE, StandardCharsets.UTF_8);
                LOG_ADDONS.info("Configuration saved.");
            } else {
                LOG_ADDONS.info("No configuration or configuration file available.");
            }
        });
    }

    protected final VersionMeta getVersionMeta() {
        return this.VERSIONMETA;
    }

    protected final ApplicationProperties getApplicationProperties() {
        return this.APPLICATIONPROPERTIES;
    }

    protected final Utilities getUtilities() {
        return this.UTILITIES;
    }
}

