/*
 * Decompiled with CFR 0.152.
 */
package de.griefed.serverpackcreator.addons;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.toml.TomlFormat;
import de.griefed.serverpackcreator.addons.BaseInformation;
import java.io.IOException;
import java.net.URL;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.pf4j.Plugin;
import org.pf4j.PluginRuntimeException;
import org.pf4j.PluginWrapper;

public abstract class ServerPackCreatorAddon
extends Plugin
implements BaseInformation {
    protected static final Logger LOG_ADDONS = LogManager.getLogger("AddonsLogger");
    private static final Logger LOG = LogManager.getLogger(ServerPackCreatorAddon.class);
    private final String NAME;
    private final String DESCRIPTION;
    private final String AUTHOR;
    private final String VERSION;

    public ServerPackCreatorAddon(PluginWrapper wrapper) throws IOException {
        super(wrapper);
        String classPath = Objects.requireNonNull(this.getClass().getResource(this.getClass().getSimpleName() + ".class")).toString();
        CommentedConfig addonToml = (CommentedConfig)TomlFormat.instance().createParser().parse(new URL(classPath.substring(0, classPath.lastIndexOf("!") + 1) + "/addon.toml").openStream());
        this.NAME = (String)addonToml.get("name");
        this.DESCRIPTION = (String)addonToml.get("description");
        this.AUTHOR = (String)addonToml.get("author");
        this.VERSION = (String)addonToml.get("version");
    }

    @Override
    public void start() throws PluginRuntimeException {
        super.start();
        LOG.info("Addon-ID:          " + this.getId());
        LOG.info("Addon-Name:        " + this.NAME);
        LOG.info("Addon-Description: " + this.DESCRIPTION);
        LOG.info("Addon-Author:      " + this.AUTHOR);
        LOG.info("Addon-Version:     " + this.VERSION);
        LOG.info("Started: " + this.NAME + " (" + this.getId() + ")");
        LOG_ADDONS.info("Addon-ID:          " + this.getId());
        LOG_ADDONS.info("Addon-Name:        " + this.NAME);
        LOG_ADDONS.info("Addon-Description: " + this.DESCRIPTION);
        LOG_ADDONS.info("Addon-Author:      " + this.AUTHOR);
        LOG_ADDONS.info("Addon-Version:     " + this.VERSION);
        LOG_ADDONS.info("Started: " + this.NAME + " (" + this.getId() + ")");
    }

    @Override
    public void stop() throws PluginRuntimeException {
        super.stop();
        LOG.info("Stopped: " + this.NAME + " (" + this.getId() + ")");
        LOG_ADDONS.info("Stopped: " + this.NAME + " (" + this.getId() + ")");
    }

    public String getId() {
        return this.getWrapper().getPluginId();
    }

    @Override
    public String getName() {
        return this.NAME;
    }

    @Override
    public String getDescription() {
        return this.DESCRIPTION;
    }

    @Override
    public String getAuthor() {
        return this.AUTHOR;
    }

    @Override
    public String getVersion() {
        return this.VERSION;
    }
}

