/*
 * Decompiled with CFR 0.152.
 */
package de.griefed.serverpackcreator;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.file.FileNotFoundAction;
import com.electronwill.nightconfig.toml.TomlParser;
import de.griefed.serverpackcreator.ApplicationProperties;
import de.griefed.serverpackcreator.ConfigurationModel;
import de.griefed.serverpackcreator.addons.configurationhandler.ConfigCheckExtension;
import de.griefed.serverpackcreator.addons.serverpackhandler.PostGenExtension;
import de.griefed.serverpackcreator.addons.serverpackhandler.PreGenExtension;
import de.griefed.serverpackcreator.addons.serverpackhandler.PreZipExtension;
import de.griefed.serverpackcreator.addons.swinggui.ConfigPanelExtension;
import de.griefed.serverpackcreator.addons.swinggui.ExtensionConfigPanel;
import de.griefed.serverpackcreator.addons.swinggui.TabExtension;
import de.griefed.serverpackcreator.swing.TabCreateServerPack;
import de.griefed.serverpackcreator.utilities.common.Utilities;
import de.griefed.serverpackcreator.versionmeta.VersionMeta;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.JTabbedPane;
import net.lingala.zip4j.ZipFile;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.pf4j.ExtensionFactory;
import org.pf4j.JarPluginManager;
import org.pf4j.PluginWrapper;
import org.pf4j.SingletonExtensionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public final class ApplicationAddons
extends JarPluginManager {
    private static final Logger LOG = LogManager.getLogger(ApplicationAddons.class);
    private static final Logger LOG_ADDONS = LogManager.getLogger("AddonsLogger");
    private final ApplicationProperties APPLICATIONPROPERTIES;
    private final VersionMeta VERSIONMETA;
    private final Utilities UTILITIES;
    private final HashMap<String, CommentedConfig> ADDON_CONFIGS = new HashMap(100);
    private final HashMap<String, File> ADDON_CONFIG_FILES = new HashMap(100);

    @Autowired
    public ApplicationAddons(TomlParser tomlParser, ApplicationProperties injectedApplicationProperties, VersionMeta injectedVersionMeta, Utilities injectedUtilities) {
        this.APPLICATIONPROPERTIES = injectedApplicationProperties;
        this.VERSIONMETA = injectedVersionMeta;
        this.UTILITIES = injectedUtilities;
        LOG.info("Addon directory: " + new File(System.getProperty("pf4j.pluginsDir", "plugins")).getAbsolutePath());
        this.loadPlugins();
        this.startPlugins();
        this.extractAddonConfigs(tomlParser);
        this.availableExtensions();
    }

    @Override
    protected ExtensionFactory createExtensionFactory() {
        return new SingletonExtensionFactory(this, ConfigCheckExtension.class.getName(), PostGenExtension.class.getName(), PreGenExtension.class.getName(), PreZipExtension.class.getName(), ConfigPanelExtension.class.getName(), TabExtension.class.getName());
    }

    private void extractAddonConfigs(TomlParser tomlParser) {
        this.getPlugins().forEach(plugin -> {
            String path = "./plugins/config";
            String addonConfig = plugin.getPluginId() + ".toml";
            File addonConfigFile = new File(path + "/" + addonConfig);
            if (!addonConfigFile.exists()) {
                try (ZipFile addonJar = new ZipFile(plugin.getPluginPath().toFile());){
                    addonJar.extractFile("config.toml", path, addonConfig);
                }
                catch (Exception ex) {
                    LOG.error("Could not extract config.toml from " + plugin.getPluginPath().toFile().getName() + ". Does it contain a valid config.toml?");
                    LOG.debug("", (Throwable)ex);
                }
            }
            if (addonConfigFile.isFile()) {
                this.registerAddonConfig(tomlParser, plugin.getPluginId(), addonConfigFile);
            }
        });
    }

    private void registerAddonConfig(TomlParser tomlParser, String addonId, File addonConfig) {
        try {
            this.ADDON_CONFIGS.put(addonId, (CommentedConfig)tomlParser.parse(addonConfig, FileNotFoundAction.THROW_ERROR, StandardCharsets.UTF_8));
            this.ADDON_CONFIG_FILES.put(addonId, addonConfig);
        }
        catch (Exception ex) {
            LOG.error("Could not parse addon config for " + addonId + ", file " + addonConfig.getName(), (Throwable)ex);
        }
    }

    public Optional<CommentedConfig> getAddonConfig(String addonId) {
        return Optional.ofNullable(this.ADDON_CONFIGS.get(addonId));
    }

    public Optional<File> getAddonConfigFile(String addonId) {
        return Optional.ofNullable(this.ADDON_CONFIG_FILES.get(addonId));
    }

    private ArrayList<CommentedConfig> getExtensionSpecificConfigs(PluginWrapper plugin, ConfigurationModel configurationModel, String extensionId) {
        ArrayList<CommentedConfig> extConf = new ArrayList<CommentedConfig>(10);
        if (configurationModel.getAddonConfigs(plugin.getPluginId()).isPresent()) {
            this.getExtensionConfigs(plugin, configurationModel).forEach(config -> {
                if (config.get("extension").equals(extensionId)) {
                    extConf.add((CommentedConfig)config);
                }
            });
        }
        return extConf;
    }

    private ArrayList<CommentedConfig> getExtensionConfigs(PluginWrapper plugin, ConfigurationModel configurationModel) {
        ArrayList<CommentedConfig> configs = new ArrayList<CommentedConfig>(10);
        if (configurationModel.getAddonConfigs(plugin.getPluginId()).isPresent()) {
            configs.addAll((Collection<CommentedConfig>)configurationModel.getAddonConfigs(plugin.getPluginId()).get());
        }
        return configs;
    }

    void runPreGenExtensions(ConfigurationModel configurationModel, String destination) {
        this.getPlugins().forEach(plugin -> {
            if (!plugin.getPluginManager().getExtensions(PreGenExtension.class).isEmpty()) {
                LOG.info("Executing PreGenExtension extensions.");
                LOG_ADDONS.info("Executing PreGenExtension extensions.");
                plugin.getPluginManager().getExtensions(PreGenExtension.class).forEach(preGenExt -> {
                    LOG_ADDONS.info("Executing extension " + preGenExt.getName());
                    try {
                        preGenExt.run(this.VERSIONMETA, this.UTILITIES, this.APPLICATIONPROPERTIES, configurationModel, destination, this.getAddonConfig(plugin.getPluginId()), this.getExtensionSpecificConfigs((PluginWrapper)plugin, configurationModel, preGenExt.getExtensionId()));
                    }
                    catch (Error | Exception ex) {
                        LOG_ADDONS.error("Extension " + preGenExt.getName() + " in plugin " + plugin.getPluginId() + " encountered an error.", ex);
                    }
                });
            } else {
                LOG.info("No PreGenExtension extension to execute.");
                LOG_ADDONS.info("No PreGenExtension extension to execute.");
            }
        });
    }

    void runPreZipExtensions(ConfigurationModel configurationModel, String destination) {
        this.getPlugins().forEach(plugin -> {
            if (!plugin.getPluginManager().getExtensions(PreZipExtension.class).isEmpty()) {
                LOG.info("Executing PreZipExtension extensions.");
                LOG_ADDONS.info("Executing PreZipExtension extensions.");
                plugin.getPluginManager().getExtensions(PreZipExtension.class).forEach(preZipExt -> {
                    LOG_ADDONS.info("Executing extension " + preZipExt.getName());
                    try {
                        preZipExt.run(this.VERSIONMETA, this.UTILITIES, this.APPLICATIONPROPERTIES, configurationModel, destination, this.getAddonConfig(plugin.getPluginId()), this.getExtensionSpecificConfigs((PluginWrapper)plugin, configurationModel, preZipExt.getExtensionId()));
                    }
                    catch (Error | Exception ex) {
                        LOG_ADDONS.error("Extension " + preZipExt.getName() + " in plugin " + plugin.getPluginId() + " encountered an error.", ex);
                    }
                });
            } else {
                LOG.info("No PreZipExtension extension to execute.");
                LOG_ADDONS.info("No PreZipExtension extension to execute.");
            }
        });
    }

    void runPostGenExtensions(ConfigurationModel configurationModel, String destination) {
        this.getPlugins().forEach(plugin -> {
            if (!plugin.getPluginManager().getExtensions(PostGenExtension.class).isEmpty()) {
                LOG.info("Executing PostGenExtension extensions.");
                LOG_ADDONS.info("Executing PostGenExtension extensions.");
                plugin.getPluginManager().getExtensions(PostGenExtension.class).forEach(postGenExt -> {
                    LOG_ADDONS.info("Executing extension " + postGenExt.getName());
                    try {
                        postGenExt.run(this.VERSIONMETA, this.UTILITIES, this.APPLICATIONPROPERTIES, configurationModel, destination, this.getAddonConfig(plugin.getPluginId()), this.getExtensionSpecificConfigs((PluginWrapper)plugin, configurationModel, postGenExt.getExtensionId()));
                    }
                    catch (Error | Exception ex) {
                        LOG_ADDONS.error("Extension " + postGenExt.getName() + " in plugin " + plugin.getPluginId() + " encountered an error.", ex);
                    }
                });
            } else {
                LOG.info("No PostGenExtension extension to execute.");
                LOG_ADDONS.info("No PostGenExtension extension to execute.");
            }
        });
    }

    public void addTabExtensionTabs(JTabbedPane tabbedPane) {
        this.getPlugins().forEach(plugin -> {
            if (!plugin.getPluginManager().getExtensions(TabExtension.class).isEmpty()) {
                LOG.info("Executing TabExtensions extensions.");
                LOG_ADDONS.info("Executing TabExtensions extensions.");
                plugin.getPluginManager().getExtensions(TabExtension.class).forEach(tabExt -> {
                    LOG_ADDONS.info("Executing extension " + tabExt.getName());
                    try {
                        tabbedPane.addTab(tabExt.getTabTitle(), tabExt.getTabIcon(), tabExt.getTab(this.VERSIONMETA, this.APPLICATIONPROPERTIES, this.UTILITIES, this.getAddonConfig(plugin.getPluginId()), this.getAddonConfigFile(plugin.getPluginId())), tabExt.getTabTooltip());
                    }
                    catch (Error | Exception ex) {
                        LOG_ADDONS.error("Extension " + tabExt.getName() + " in plugin " + plugin.getPluginId() + " encountered an error.", ex);
                    }
                });
            } else {
                LOG.info("No TabExtension extension to execute.");
                LOG_ADDONS.info("No TabExtension extension to execute.");
            }
        });
    }

    public List<ExtensionConfigPanel> getConfigPanels(TabCreateServerPack tabCreateServerPack) {
        ArrayList<ExtensionConfigPanel> panels = new ArrayList<ExtensionConfigPanel>(10);
        this.getPlugins().forEach(plugin -> {
            if (!plugin.getPluginManager().getExtensions(ConfigPanelExtension.class).isEmpty()) {
                LOG.info("Executing ConfigPanelExtension extensions.");
                LOG_ADDONS.info("Executing ConfigPanelExtension extensions.");
                plugin.getPluginManager().getExtensions(ConfigPanelExtension.class).forEach(configPanel -> {
                    LOG_ADDONS.info("Executing extension " + configPanel.getName());
                    try {
                        panels.add(configPanel.getPanel(this.VERSIONMETA, this.APPLICATIONPROPERTIES, this.UTILITIES, tabCreateServerPack, this.getAddonConfig(plugin.getPluginId()), configPanel.getName(), plugin.getPluginId()));
                    }
                    catch (Error | Exception ex) {
                        LOG_ADDONS.error("Extension " + configPanel.getName() + " in plugin " + plugin.getPluginId() + " encountered an error.", ex);
                    }
                });
            } else {
                LOG.info("No ConfigPanelExtension extension to execute.");
                LOG_ADDONS.info("No ConfigPanelExtension extension to execute.");
            }
        });
        return panels;
    }

    boolean runConfigCheckExtensions(ConfigurationModel configurationModel, List<String> encounteredErrors) {
        AtomicBoolean hasError = new AtomicBoolean(false);
        this.getPlugins().forEach(plugin -> {
            if (!plugin.getPluginManager().getExtensions(ConfigCheckExtension.class).isEmpty()) {
                LOG.info("Executing ConfigCheckExtensions extensions.");
                LOG_ADDONS.info("Executing ConfigCheckExtensions extensions.");
                plugin.getPluginManager().getExtensions(ConfigCheckExtension.class).forEach(configCheckExt -> {
                    LOG_ADDONS.info("Executing addon " + configCheckExt.getName());
                    try {
                        if (configCheckExt.runCheck(this.VERSIONMETA, this.APPLICATIONPROPERTIES, this.UTILITIES, configurationModel, encounteredErrors, this.getAddonConfig(plugin.getPluginId()), this.getExtensionConfigs((PluginWrapper)plugin, configurationModel))) {
                            hasError.set(true);
                        }
                    }
                    catch (Error | Exception ex) {
                        LOG_ADDONS.error("Extension " + configCheckExt.getName() + " in plugin " + plugin.getPluginId() + " encountered an error.", ex);
                    }
                });
            } else {
                LOG.info("No ConfigCheckExtension extension to execute.");
                LOG_ADDONS.info("No ConfigCheckExtension extension to execute.");
            }
        });
        return hasError.get();
    }

    private void availableExtensions() {
        if (this.preGenExtensions().isEmpty() && this.preZipExtensions().isEmpty() && this.postGenExtensions().isEmpty() && this.tabExtensions().isEmpty() && this.configPanelExtensions().isEmpty() && this.configCheckExtensions().isEmpty()) {
            LOG.info("No extensions installed.");
            return;
        }
        if (!this.preGenExtensions().isEmpty()) {
            LOG.info("Available PreGenExtension extensions:");
            this.preGenExtensions().forEach(extension -> {
                LOG.info("  Name:       " + extension.getName());
                LOG.info("    Description:" + extension.getDescription());
                LOG.info("    Version:    " + extension.getVersion());
                LOG.info("    Author:     " + extension.getAuthor());
            });
        } else {
            LOG.info("No PreGenExtensions installed.");
        }
        if (!this.preZipExtensions().isEmpty()) {
            LOG.info("Available PreZipExtension extensions:");
            this.preZipExtensions().forEach(extension -> {
                LOG.info("  Name:       " + extension.getName());
                LOG.info("    Description:" + extension.getDescription());
                LOG.info("    Version:    " + extension.getVersion());
                LOG.info("    Author:     " + extension.getAuthor());
            });
        } else {
            LOG.info("No PreZipExtension installed.");
        }
        if (!this.postGenExtensions().isEmpty()) {
            LOG.info("Available PostGenExtension extensions:");
            this.postGenExtensions().forEach(extension -> {
                LOG.info("  Name:       " + extension.getName());
                LOG.info("    Description:" + extension.getDescription());
                LOG.info("    Version:    " + extension.getVersion());
                LOG.info("    Author:     " + extension.getAuthor());
            });
        } else {
            LOG.info("No PostGenExtension installed.");
        }
        if (!this.tabExtensions().isEmpty()) {
            LOG.info("Available TabExtension extensions:");
            this.tabExtensions().forEach(extension -> {
                LOG.info("  Name:       " + extension.getName());
                LOG.info("    Description:" + extension.getDescription());
                LOG.info("    Version:    " + extension.getVersion());
                LOG.info("    Author:     " + extension.getAuthor());
            });
        } else {
            LOG.info("No TabExtension installed.");
        }
        if (!this.configPanelExtensions().isEmpty()) {
            LOG.info("Available ConfigPane extensions:");
            this.configPanelExtensions().forEach(extension -> {
                LOG.info("  Name:       " + extension.getName());
                LOG.info("    Description:" + extension.getDescription());
                LOG.info("    Version:    " + extension.getVersion());
                LOG.info("    Author:     " + extension.getAuthor());
            });
        } else {
            LOG.info("No ConfigPane installed.");
        }
        if (!this.configCheckExtensions().isEmpty()) {
            LOG.info("Available ConfigCheck extensions:");
            this.configCheckExtensions().forEach(extension -> {
                LOG.info("  Name:       " + extension.getName());
                LOG.info("    Description:" + extension.getDescription());
                LOG.info("    Version:    " + extension.getVersion());
                LOG.info("    Author:     " + extension.getAuthor());
            });
        } else {
            LOG.info("No ConfigCheck installed.");
        }
    }

    List<PreGenExtension> preGenExtensions() {
        return this.getExtensions(PreGenExtension.class);
    }

    List<PreZipExtension> preZipExtensions() {
        return this.getExtensions(PreZipExtension.class);
    }

    List<PostGenExtension> postGenExtensions() {
        return this.getExtensions(PostGenExtension.class);
    }

    public List<TabExtension> tabExtensions() {
        return this.getExtensions(TabExtension.class);
    }

    public List<ConfigPanelExtension> configPanelExtensions() {
        return this.getExtensions(ConfigPanelExtension.class);
    }

    List<ConfigCheckExtension> configCheckExtensions() {
        return this.getExtensions(ConfigCheckExtension.class);
    }
}

