/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.devtools.logger;

import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.springframework.boot.context.event.ApplicationPreparedEvent;
import org.springframework.boot.logging.DeferredLog;
import org.springframework.context.ApplicationListener;

public final class DevToolsLogFactory {
    private static final Map<Log, Class<?>> logs = new LinkedHashMap();

    private DevToolsLogFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Log getLog(Class<?> source) {
        Map<Log, Class<?>> map = logs;
        synchronized (map) {
            DeferredLog log = new DeferredLog();
            logs.put(log, source);
            return log;
        }
    }

    static class Listener
    implements ApplicationListener<ApplicationPreparedEvent> {
        Listener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onApplicationEvent(ApplicationPreparedEvent event) {
            Map map = logs;
            synchronized (map) {
                logs.forEach((log, source) -> {
                    if (log instanceof DeferredLog) {
                        ((DeferredLog)log).switchTo((Class<?>)source);
                    }
                });
                logs.clear();
            }
        }
    }
}

