/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.devtools.autoconfigure;

import java.io.File;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.NestedConfigurationProperty;
import org.springframework.boot.devtools.autoconfigure.RemoteDevToolsProperties;
import org.springframework.util.StringUtils;

@ConfigurationProperties(prefix="spring.devtools")
public class DevToolsProperties {
    private Restart restart = new Restart();
    private Livereload livereload = new Livereload();
    @NestedConfigurationProperty
    private final RemoteDevToolsProperties remote = new RemoteDevToolsProperties();

    public Restart getRestart() {
        return this.restart;
    }

    public Livereload getLivereload() {
        return this.livereload;
    }

    public RemoteDevToolsProperties getRemote() {
        return this.remote;
    }

    public static class Livereload {
        private boolean enabled = true;
        private int port = 35729;

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public int getPort() {
            return this.port;
        }

        public void setPort(int port) {
            this.port = port;
        }
    }

    public static class Restart {
        private static final String DEFAULT_RESTART_EXCLUDES = "META-INF/maven/**,META-INF/resources/**,resources/**,static/**,public/**,templates/**,**/*Test.class,**/*Tests.class,git.properties,META-INF/build-info.properties";
        private boolean enabled = true;
        private String exclude = "META-INF/maven/**,META-INF/resources/**,resources/**,static/**,public/**,templates/**,**/*Test.class,**/*Tests.class,git.properties,META-INF/build-info.properties";
        private String additionalExclude;
        private Duration pollInterval = Duration.ofSeconds(1L);
        private Duration quietPeriod = Duration.ofMillis(400L);
        private String triggerFile;
        private List<File> additionalPaths = new ArrayList<File>();
        private boolean logConditionEvaluationDelta = true;

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public String[] getAllExclude() {
            ArrayList<String> allExclude = new ArrayList<String>();
            if (StringUtils.hasText(this.exclude)) {
                allExclude.addAll(StringUtils.commaDelimitedListToSet(this.exclude));
            }
            if (StringUtils.hasText(this.additionalExclude)) {
                allExclude.addAll(StringUtils.commaDelimitedListToSet(this.additionalExclude));
            }
            return StringUtils.toStringArray(allExclude);
        }

        public String getExclude() {
            return this.exclude;
        }

        public void setExclude(String exclude) {
            this.exclude = exclude;
        }

        public String getAdditionalExclude() {
            return this.additionalExclude;
        }

        public void setAdditionalExclude(String additionalExclude) {
            this.additionalExclude = additionalExclude;
        }

        public Duration getPollInterval() {
            return this.pollInterval;
        }

        public void setPollInterval(Duration pollInterval) {
            this.pollInterval = pollInterval;
        }

        public Duration getQuietPeriod() {
            return this.quietPeriod;
        }

        public void setQuietPeriod(Duration quietPeriod) {
            this.quietPeriod = quietPeriod;
        }

        public String getTriggerFile() {
            return this.triggerFile;
        }

        public void setTriggerFile(String triggerFile) {
            this.triggerFile = triggerFile;
        }

        public List<File> getAdditionalPaths() {
            return this.additionalPaths;
        }

        public void setAdditionalPaths(List<File> additionalPaths) {
            this.additionalPaths = additionalPaths;
        }

        public boolean isLogConditionEvaluationDelta() {
            return this.logConditionEvaluationDelta;
        }

        public void setLogConditionEvaluationDelta(boolean logConditionEvaluationDelta) {
            this.logConditionEvaluationDelta = logConditionEvaluationDelta;
        }
    }
}

