/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;

public class VerticalLayout
implements LayoutManager {
    private int gap = 0;

    public VerticalLayout() {
    }

    public VerticalLayout(int gap) {
        this.gap = gap;
    }

    public int getGap() {
        return this.gap;
    }

    public void setGap(int gap) {
        this.gap = gap;
    }

    public void addLayoutComponent(String name, Component c) {
    }

    public void layoutContainer(Container parent) {
        Insets insets = parent.getInsets();
        Dimension size = parent.getSize();
        int width = size.width - insets.left - insets.right;
        int height = insets.top;
        int c = parent.getComponentCount();
        for (int i2 = 0; i2 < c; ++i2) {
            Component m3 = parent.getComponent(i2);
            if (!m3.isVisible()) continue;
            m3.setBounds(insets.left, height, width, m3.getPreferredSize().height);
            height += m3.getSize().height + this.gap;
        }
    }

    public Dimension minimumLayoutSize(Container parent) {
        return this.preferredLayoutSize(parent);
    }

    public Dimension preferredLayoutSize(Container parent) {
        Insets insets = parent.getInsets();
        Dimension pref = new Dimension(0, 0);
        int c = parent.getComponentCount();
        for (int i2 = 0; i2 < c; ++i2) {
            Component m3 = parent.getComponent(i2);
            if (!m3.isVisible()) continue;
            Dimension componentPreferredSize = parent.getComponent(i2).getPreferredSize();
            pref.height += componentPreferredSize.height + this.gap;
            pref.width = Math.max(pref.width, componentPreferredSize.width);
        }
        pref.width += insets.left + insets.right;
        pref.height += insets.top + insets.bottom;
        return pref;
    }

    public void removeLayoutComponent(Component c) {
    }
}

