/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.impl;

import java.util.concurrent.ScheduledExecutorService;
import org.apache.activemq.artemis.api.config.ActiveMQDefaultConfiguration;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.filter.Filter;
import org.apache.activemq.artemis.core.filter.impl.FilterImpl;
import org.apache.activemq.artemis.core.paging.PagingManager;
import org.apache.activemq.artemis.core.paging.PagingStore;
import org.apache.activemq.artemis.core.paging.cursor.PageSubscription;
import org.apache.activemq.artemis.core.persistence.StorageManager;
import org.apache.activemq.artemis.core.postoffice.PostOffice;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.server.QueueConfig;
import org.apache.activemq.artemis.core.server.QueueFactory;
import org.apache.activemq.artemis.core.server.impl.AddressInfo;
import org.apache.activemq.artemis.core.server.impl.LastValueQueue;
import org.apache.activemq.artemis.core.server.impl.QueueImpl;
import org.apache.activemq.artemis.core.settings.HierarchicalRepository;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.utils.ExecutorFactory;

public class QueueFactoryImpl
implements QueueFactory {
    protected final HierarchicalRepository<AddressSettings> addressSettingsRepository;
    protected final ScheduledExecutorService scheduledExecutor;
    protected PostOffice postOffice;
    protected final StorageManager storageManager;
    protected final ExecutorFactory executorFactory;
    protected final ActiveMQServer server;

    public QueueFactoryImpl(ExecutorFactory executorFactory, ScheduledExecutorService scheduledExecutor, HierarchicalRepository<AddressSettings> addressSettingsRepository, StorageManager storageManager, ActiveMQServer server) {
        this.addressSettingsRepository = addressSettingsRepository;
        this.scheduledExecutor = scheduledExecutor;
        this.storageManager = storageManager;
        this.executorFactory = executorFactory;
        this.server = server;
    }

    @Override
    public void setPostOffice(PostOffice postOffice) {
        this.postOffice = postOffice;
    }

    @Override
    @Deprecated
    public Queue createQueueWith(QueueConfig config) {
        QueueImpl queue = QueueFactoryImpl.lastValueKey(config) != null ? new LastValueQueue(config.id(), config.address(), config.name(), config.filter(), config.getPagingStore(), config.pageSubscription(), config.user(), config.isDurable(), config.isTemporary(), config.isAutoCreated(), config.deliveryMode(), (Integer)config.maxConsumers(), (Boolean)config.isExclusive(), (Boolean)config.isGroupRebalance(), (Integer)config.getGroupBuckets(), config.getGroupFirstKey(), config.consumersBeforeDispatch(), config.delayBeforeDispatch(), config.isPurgeOnNoConsumers(), QueueFactoryImpl.lastValueKey(config), (Boolean)config.isNonDestructive(), config.isAutoDelete(), (Long)config.getAutoDeleteDelay(), config.getAutoDeleteMessageCount(), config.isConfigurationManaged(), this.scheduledExecutor, this.postOffice, this.storageManager, this.addressSettingsRepository, this.executorFactory.getExecutor(), this.server, (QueueFactory)this) : new QueueImpl(config.id(), config.address(), config.name(), config.filter(), config.getPagingStore(), config.pageSubscription(), config.user(), config.isDurable(), config.isTemporary(), config.isAutoCreated(), config.deliveryMode(), config.maxConsumers(), config.isExclusive(), config.isGroupRebalance(), config.getGroupBuckets(), config.getGroupFirstKey(), config.isNonDestructive(), config.consumersBeforeDispatch(), config.delayBeforeDispatch(), config.isPurgeOnNoConsumers(), config.isAutoDelete(), config.getAutoDeleteDelay(), config.getAutoDeleteMessageCount(), config.isConfigurationManaged(), config.getRingSize(), this.scheduledExecutor, this.postOffice, this.storageManager, this.addressSettingsRepository, this.executorFactory.getExecutor(), this.server, this);
        this.server.getCriticalAnalyzer().add(queue);
        return queue;
    }

    @Override
    public Queue createQueueWith(QueueConfiguration config, PagingManager pagingManager) {
        this.validateState(config);
        PageSubscription pageSubscription = QueueFactoryImpl.getPageSubscription(config, pagingManager);
        QueueImpl queue = QueueFactoryImpl.lastValueKey(config) != null ? new LastValueQueue(config.setLastValueKey(QueueFactoryImpl.lastValueKey(config)), pageSubscription != null ? pageSubscription.getPagingStore() : null, pageSubscription, this.scheduledExecutor, this.postOffice, this.storageManager, this.addressSettingsRepository, this.executorFactory.getExecutor(), this.server, this) : new QueueImpl(config, pageSubscription != null ? pageSubscription.getPagingStore() : null, pageSubscription, this.scheduledExecutor, this.postOffice, this.storageManager, this.addressSettingsRepository, this.executorFactory.getExecutor(), this.server, this);
        this.server.getCriticalAnalyzer().add(queue);
        return queue;
    }

    @Override
    @Deprecated
    public Queue createQueue(long persistenceID, SimpleString address, SimpleString name, Filter filter2, PageSubscription pageSubscription, SimpleString user, boolean durable, boolean temporary, boolean autoCreated) throws Exception {
        this.postOffice.addAddressInfo(new AddressInfo(address));
        AddressSettings addressSettings = this.addressSettingsRepository.getMatch(address.toString());
        QueueImpl queue = QueueFactoryImpl.lastValueKey(addressSettings) != null ? new LastValueQueue(persistenceID, address, name, filter2, pageSubscription == null ? null : pageSubscription.getPagingStore(), pageSubscription, user, durable, temporary, autoCreated, ActiveMQDefaultConfiguration.getDefaultRoutingType(), (Integer)ActiveMQDefaultConfiguration.getDefaultMaxQueueConsumers(), (Boolean)ActiveMQDefaultConfiguration.getDefaultExclusive(), (Boolean)ActiveMQDefaultConfiguration.getDefaultGroupRebalance(), (Integer)ActiveMQDefaultConfiguration.getDefaultGroupBuckets(), ActiveMQDefaultConfiguration.getDefaultGroupFirstKey(), ActiveMQDefaultConfiguration.getDefaultConsumersBeforeDispatch(), ActiveMQDefaultConfiguration.getDefaultDelayBeforeDispatch(), ActiveMQDefaultConfiguration.getDefaultPurgeOnNoConsumers(), QueueFactoryImpl.lastValueKey(addressSettings), (Boolean)ActiveMQDefaultConfiguration.getDefaultNonDestructive(), ActiveMQDefaultConfiguration.getDefaultQueueAutoDelete(autoCreated), (Long)ActiveMQDefaultConfiguration.getDefaultQueueAutoDeleteDelay(), ActiveMQDefaultConfiguration.getDefaultQueueAutoDeleteMessageCount(), false, this.scheduledExecutor, this.postOffice, this.storageManager, this.addressSettingsRepository, this.executorFactory.getExecutor(), this.server, (QueueFactory)this) : new QueueImpl(persistenceID, address, name, filter2, pageSubscription == null ? null : pageSubscription.getPagingStore(), pageSubscription, user, durable, temporary, autoCreated, this.scheduledExecutor, this.postOffice, this.storageManager, this.addressSettingsRepository, this.executorFactory.getExecutor(), this.server, this);
        this.server.getCriticalAnalyzer().add(queue);
        return queue;
    }

    @Override
    public void queueRemoved(Queue queue) {
        this.server.getCriticalAnalyzer().remove(queue);
    }

    public static PageSubscription getPageSubscription(QueueConfiguration queueConfiguration, PagingManager pagingManager) {
        PageSubscription pageSubscription;
        try {
            PagingStore pageStore = pagingManager.getPageStore(queueConfiguration.getAddress());
            pageSubscription = pageStore != null ? pageStore.getCursorProvider().createSubscription(queueConfiguration.getId(), FilterImpl.createFilter(queueConfiguration.getFilterString()), queueConfiguration.isDurable()) : null;
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        return pageSubscription;
    }

    private static SimpleString lastValueKey(QueueConfig config) {
        if (config.lastValueKey() != null && !config.lastValueKey().isEmpty()) {
            return config.lastValueKey();
        }
        if (config.isLastValue()) {
            return Message.HDR_LAST_VALUE_NAME;
        }
        return null;
    }

    private static SimpleString lastValueKey(QueueConfiguration config) {
        if (config.getLastValueKey() != null && !config.getLastValueKey().isEmpty()) {
            return config.getLastValueKey();
        }
        if (config.isLastValue().booleanValue()) {
            return Message.HDR_LAST_VALUE_NAME;
        }
        return null;
    }

    private static SimpleString lastValueKey(AddressSettings addressSettings) {
        if (addressSettings.getDefaultLastValueKey() != null && !addressSettings.getDefaultLastValueKey().isEmpty()) {
            return addressSettings.getDefaultLastValueKey();
        }
        if (addressSettings.isDefaultLastValueQueue()) {
            return Message.HDR_LAST_VALUE_NAME;
        }
        return null;
    }

    private void validateState(QueueConfiguration config) {
        if (QueueFactoryImpl.isEmptyOrNull(config.getName())) {
            throw new IllegalStateException("name can't be null or empty!");
        }
        if (QueueFactoryImpl.isEmptyOrNull(config.getAddress())) {
            throw new IllegalStateException("address can't be null or empty!");
        }
    }

    private static boolean isEmptyOrNull(SimpleString value) {
        return value == null || value.length() == 0;
    }
}

