/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.impl;

import org.apache.activemq.artemis.api.config.ActiveMQDefaultConfiguration;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;

public class QueueConfigurationUtils {
    public static void applyDynamicQueueDefaults(QueueConfiguration config, AddressSettings as) {
        config.setMaxConsumers(config.getMaxConsumers() == null ? as.getDefaultMaxConsumers() : config.getMaxConsumers().intValue());
        config.setExclusive(config.isExclusive() == null ? as.isDefaultExclusiveQueue() : config.isExclusive().booleanValue());
        config.setGroupRebalance(config.isGroupRebalance() == null ? as.isDefaultGroupRebalance() : config.isGroupRebalance().booleanValue());
        config.setGroupRebalancePauseDispatch(config.isGroupRebalancePauseDispatch() == null ? as.isDefaultGroupRebalancePauseDispatch() : config.isGroupRebalancePauseDispatch().booleanValue());
        config.setGroupBuckets(config.getGroupBuckets() == null ? as.getDefaultGroupBuckets() : config.getGroupBuckets().intValue());
        config.setGroupFirstKey(config.getGroupFirstKey() == null ? as.getDefaultGroupFirstKey() : config.getGroupFirstKey());
        config.setLastValue(config.isLastValue() == null ? as.isDefaultLastValueQueue() : config.isLastValue().booleanValue());
        config.setLastValueKey(config.getLastValueKey() == null ? as.getDefaultLastValueKey() : config.getLastValueKey());
        config.setNonDestructive(config.isNonDestructive() == null ? as.isDefaultNonDestructive() : config.isNonDestructive().booleanValue());
        config.setConsumersBeforeDispatch(config.getConsumersBeforeDispatch() == null ? as.getDefaultConsumersBeforeDispatch() : config.getConsumersBeforeDispatch().intValue());
        config.setDelayBeforeDispatch(config.getDelayBeforeDispatch() == null ? as.getDefaultDelayBeforeDispatch() : config.getDelayBeforeDispatch().longValue());
        config.setRingSize(config.getRingSize() == null ? as.getDefaultRingSize() : config.getRingSize().longValue());
        config.setRoutingType(config.getRoutingType() == null ? as.getDefaultQueueRoutingType() : config.getRoutingType());
        config.setPurgeOnNoConsumers(config.isPurgeOnNoConsumers() == null ? as.isDefaultPurgeOnNoConsumers() : config.isPurgeOnNoConsumers().booleanValue());
        config.setAutoCreateAddress(config.isAutoCreateAddress() == null ? as.isAutoCreateAddresses() : config.isAutoCreateAddress().booleanValue());
        config.setAutoDelete(config.isAutoDelete() == null ? !config.isConfigurationManaged().booleanValue() && (config.isAutoCreated().booleanValue() && as.isAutoDeleteQueues() || !config.isAutoCreated().booleanValue() && as.isAutoDeleteCreatedQueues()) : config.isAutoDelete());
        config.setAutoDeleteDelay(config.getAutoDeleteDelay() == null ? as.getAutoDeleteQueuesDelay() : config.getAutoDeleteDelay().longValue());
        config.setAutoDeleteMessageCount(config.getAutoDeleteMessageCount() == null ? as.getAutoDeleteQueuesMessageCount() : config.getAutoDeleteMessageCount().longValue());
        config.setEnabled(config.isEnabled() == null ? ActiveMQDefaultConfiguration.getDefaultEnabled() : config.isEnabled());
    }
}

