/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.protocol.core.impl.wireformat;

import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.ActiveMQBuffers;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.protocol.core.impl.PacketImpl;
import org.apache.activemq.artemis.core.server.cluster.qourum.QuorumVoteHandler;
import org.apache.activemq.artemis.core.server.cluster.qourum.Vote;

public class QuorumVoteReplyMessage
extends PacketImpl {
    private SimpleString handler;
    private Vote vote;
    private ActiveMQBuffer voteBuffer;

    public QuorumVoteReplyMessage(SimpleString handler, Vote vote) {
        super((byte)-3);
        this.handler = handler;
        this.vote = vote;
    }

    public QuorumVoteReplyMessage() {
        super((byte)-3);
    }

    public Vote getVote() {
        return this.vote;
    }

    public SimpleString getHandler() {
        return this.handler;
    }

    @Override
    public boolean isResponse() {
        return true;
    }

    @Override
    public void encodeRest(ActiveMQBuffer buffer) {
        super.encodeRest(buffer);
        buffer.writeSimpleString(this.handler);
        this.vote.encode(buffer);
    }

    @Override
    public void decodeRest(ActiveMQBuffer buffer) {
        super.decodeRest(buffer);
        this.handler = buffer.readSimpleString();
        this.voteBuffer = ActiveMQBuffers.fixedBuffer(buffer.readableBytes());
        buffer.readBytes(this.voteBuffer);
    }

    public void decodeRest(QuorumVoteHandler voteHandler) {
        this.vote = voteHandler.decode(this.voteBuffer);
    }
}

