/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.protocol.core.impl.wireformat;

import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.core.protocol.core.impl.PacketImpl;
import org.apache.activemq.artemis.utils.Preconditions;

public final class BackupReplicationStartFailedMessage
extends PacketImpl {
    private BackupRegistrationProblem problem;

    private static BackupRegistrationProblem getType(int type) {
        return (BackupRegistrationProblem)((Object)BackupRegistrationProblem.TYPE_MAP.get(type));
    }

    public BackupReplicationStartFailedMessage(BackupRegistrationProblem registrationProblem) {
        super((byte)116);
        Preconditions.checkNotNull(registrationProblem);
        this.problem = registrationProblem;
    }

    public BackupReplicationStartFailedMessage() {
        super((byte)116);
    }

    public BackupRegistrationProblem getRegistrationProblem() {
        return this.problem;
    }

    @Override
    public void encodeRest(ActiveMQBuffer buffer) {
        buffer.writeInt(this.problem.code);
    }

    @Override
    public void decodeRest(ActiveMQBuffer buffer) {
        this.problem = BackupReplicationStartFailedMessage.getType(buffer.readInt());
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        BackupReplicationStartFailedMessage that = (BackupReplicationStartFailedMessage)o;
        return this.problem == that.problem;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.problem != null ? this.problem.hashCode() : 0);
        return result;
    }

    @Override
    protected String getPacketString() {
        return super.getPacketString() + ", problem=" + (this.problem != null ? this.problem.name() : null);
    }

    public static enum BackupRegistrationProblem {
        EXCEPTION(0),
        AUTHENTICATION(1),
        ALREADY_REPLICATING(2);

        private static final Map<Integer, BackupRegistrationProblem> TYPE_MAP;
        final int code;

        private BackupRegistrationProblem(int code) {
            this.code = code;
        }

        static {
            HashMap<Integer, BackupRegistrationProblem> map = new HashMap<Integer, BackupRegistrationProblem>();
            for (BackupRegistrationProblem type : EnumSet.allOf(BackupRegistrationProblem.class)) {
                map.put(type.code, type);
            }
            TYPE_MAP = Collections.unmodifiableMap(map);
        }
    }
}

