/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.persistence.impl.journal.codec;

import javax.transaction.xa.Xid;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.ActiveMQBuffers;
import org.apache.activemq.artemis.core.journal.EncodingSupport;
import org.apache.activemq.artemis.utils.XidCodecSupport;

public class XidEncoding
implements EncodingSupport {
    public final Xid xid;

    public XidEncoding(Xid xid) {
        this.xid = xid;
    }

    public XidEncoding(byte[] data) {
        this.xid = XidCodecSupport.decodeXid(ActiveMQBuffers.wrappedBuffer(data));
    }

    @Override
    public void decode(ActiveMQBuffer buffer) {
        throw new IllegalStateException("Non Supported Operation");
    }

    @Override
    public void encode(ActiveMQBuffer buffer) {
        XidCodecSupport.encodeXid(this.xid, buffer);
    }

    @Override
    public int getEncodeSize() {
        return XidCodecSupport.getXidEncodeLength(this.xid);
    }
}

