/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.journal.impl;

import java.util.Arrays;
import java.util.Objects;

final class ObjIntIntArrayList<T> {
    private static final Object[] EMPTY_OBJECTS = new Object[0];
    private static final long[] EMPTY_INTS = new long[0];
    private Object[] objects;
    private long[] ints;
    private int size;

    ObjIntIntArrayList(int initialCapacity) {
        this.objects = initialCapacity == 0 ? EMPTY_OBJECTS : new Object[initialCapacity];
        this.ints = initialCapacity == 0 ? EMPTY_INTS : new long[initialCapacity];
        this.size = 0;
    }

    private static long packInts(int a, int b) {
        if (a < 0 || b < 0) {
            throw new IllegalArgumentException("a and b must be >= 0");
        }
        return (long)a << 32 | (long)b & 0xFFFFFFFFL;
    }

    private static int unpackA(long ints) {
        return (int)(ints >> 32);
    }

    private static int unpackB(long ints) {
        return (int)ints;
    }

    private void ensureCapacity() {
        int expectedCapacity = this.size + 1;
        int currentCapacity = this.objects.length;
        if (expectedCapacity - currentCapacity <= 0) {
            return;
        }
        this.grow(expectedCapacity, currentCapacity);
    }

    private void grow(int expectedCapacity, int currentCapacity) {
        assert (expectedCapacity - currentCapacity > 0);
        int newCapacity = currentCapacity + (currentCapacity >> 1);
        if (newCapacity - expectedCapacity < 0) {
            newCapacity = expectedCapacity;
        }
        if (newCapacity - 0x7FFFFFF7 > 0) {
            newCapacity = ObjIntIntArrayList.hugeCapacity(expectedCapacity);
        }
        Object[] oldObjects = this.objects;
        long[] oldInts = this.ints;
        try {
            Object[] newObjects = Arrays.copyOf(oldObjects, newCapacity);
            long[] newInts = Arrays.copyOf(oldInts, newCapacity);
            this.objects = newObjects;
            this.ints = newInts;
        }
        catch (OutOfMemoryError outOfMemoryError) {
            this.objects = oldObjects;
            this.ints = oldInts;
            throw outOfMemoryError;
        }
    }

    private static int hugeCapacity(int minCapacity) {
        if (minCapacity < 0) {
            throw new OutOfMemoryError();
        }
        return minCapacity > 0x7FFFFFF7 ? Integer.MAX_VALUE : 0x7FFFFFF7;
    }

    public int size() {
        return this.size;
    }

    public boolean addToIntsIfMatch(int index, T e, int deltaA, int deltaB) {
        Objects.requireNonNull(e, "e must be not null");
        if (deltaA < 0) {
            throw new IllegalArgumentException("deltaA must be >= 0");
        }
        if (deltaB < 0) {
            throw new IllegalArgumentException("deltaB must be >= 0");
        }
        if (index < 0 || index >= this.size) {
            throw new IndexOutOfBoundsException("index must be >=0 and <" + this.size);
        }
        Object elm = this.objects[index];
        if (!Objects.equals(elm, e)) {
            return false;
        }
        long packedInts = this.ints[index];
        int oldA = ObjIntIntArrayList.unpackA(packedInts);
        long newA = oldA + deltaA;
        if (newA < (long)oldA) {
            return false;
        }
        int oldB = ObjIntIntArrayList.unpackB(packedInts);
        long newB = oldB + deltaB;
        if (newB < (long)oldB) {
            return false;
        }
        this.ints[index] = ObjIntIntArrayList.packInts((int)newA, (int)newB);
        return true;
    }

    public void add(T e, int a, int b) {
        Objects.requireNonNull(e, "e must be not null");
        long packedInts = ObjIntIntArrayList.packInts(a, b);
        this.ensureCapacity();
        this.objects[this.size] = e;
        this.ints[this.size] = packedInts;
        ++this.size;
    }

    public void clear() {
        Arrays.fill(this.objects, 0, this.size, null);
        this.size = 0;
    }

    public <A> void forEach(ObjIntIntConsumerOneArg<? super T, ? super A> onFile, A arg) {
        int size = this.size;
        for (int i2 = 0; i2 < size; ++i2) {
            Object e = this.objects[i2];
            long packedInts = this.ints[i2];
            onFile.accept(e, ObjIntIntArrayList.unpackA(packedInts), ObjIntIntArrayList.unpackB(packedInts), arg);
        }
    }

    @FunctionalInterface
    public static interface ObjIntIntConsumerOneArg<T, A> {
        public void accept(T var1, int var2, int var3, A var4);
    }
}

