/*
 * Decompiled with CFR 0.152.
 */
package mdlaf.shadows;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ConvolveOp;
import java.awt.image.Kernel;
import java.util.HashMap;
import java.util.Map;
import javax.swing.UIManager;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;

public class DropShadowBorder
extends AbstractBorder
implements Border {
    private static final Map<Integer, Map<Position, BufferedImage>> CACHE = new HashMap<Integer, Map<Position, BufferedImage>>();
    private Color lineColor;
    private int lineWidth;
    private int shadowSize;
    private float shadowOpacity;
    private int cornerSize;
    private boolean showTopShadow;
    private boolean showLeftShadow;
    private boolean showBottomShadow;
    private boolean showRightShadow;

    public DropShadowBorder() {
        this(UIManager.getColor("Control"), 1, 5);
    }

    public DropShadowBorder(Color lineColor, int lineWidth, int shadowSize) {
        this(lineColor, lineWidth, shadowSize, 0.5f, 12, false, false, true, true);
    }

    public DropShadowBorder(Color lineColor, int lineWidth, boolean showLeftShadow) {
        this(lineColor, lineWidth, 5, 0.5f, 12, false, showLeftShadow, true, true);
    }

    public DropShadowBorder(Color lineColor, int lineWidth, int shadowSize, float shadowOpacity, int cornerSize, boolean showTopShadow, boolean showLeftShadow, boolean showBottomShadow, boolean showRightShadow) {
        this.lineColor = lineColor;
        this.lineWidth = lineWidth;
        this.shadowSize = shadowSize;
        this.shadowOpacity = shadowOpacity;
        this.cornerSize = cornerSize;
        this.showTopShadow = showTopShadow;
        this.showLeftShadow = showLeftShadow;
        this.showBottomShadow = showBottomShadow;
        this.showRightShadow = showRightShadow;
    }

    @Override
    public void paintBorder(Component c, Graphics graphics, int x, int y, int width, int height) {
        Map<Position, BufferedImage> images = this.getImages(null);
        Graphics2D g2 = (Graphics2D)graphics;
        g2.setColor(this.lineColor);
        Point topLeftShadowPoint = null;
        if (this.showLeftShadow || this.showTopShadow) {
            topLeftShadowPoint = new Point();
            if (this.showLeftShadow && !this.showTopShadow) {
                topLeftShadowPoint.setLocation(x, y + this.shadowSize);
            } else if (this.showLeftShadow && this.showTopShadow) {
                topLeftShadowPoint.setLocation(x, y);
            } else if (!this.showLeftShadow && this.showTopShadow) {
                topLeftShadowPoint.setLocation(x + this.shadowSize, y);
            }
        }
        Point bottomLeftShadowPoint = null;
        if (this.showLeftShadow || this.showBottomShadow) {
            bottomLeftShadowPoint = new Point();
            if (this.showLeftShadow && !this.showBottomShadow) {
                bottomLeftShadowPoint.setLocation(x, y + height - this.shadowSize - this.shadowSize);
            } else if (this.showLeftShadow && this.showBottomShadow) {
                bottomLeftShadowPoint.setLocation(x, y + height - this.shadowSize);
            } else if (!this.showLeftShadow && this.showBottomShadow) {
                bottomLeftShadowPoint.setLocation(x + this.shadowSize, y + height - this.shadowSize);
            }
        }
        Point bottomRightShadowPoint = null;
        if (this.showRightShadow || this.showBottomShadow) {
            bottomRightShadowPoint = new Point();
            if (this.showRightShadow && !this.showBottomShadow) {
                bottomRightShadowPoint.setLocation(x + width - this.shadowSize, y + height - this.shadowSize - this.shadowSize);
            } else if (this.showRightShadow && this.showBottomShadow) {
                bottomRightShadowPoint.setLocation(x + width - this.shadowSize, y + height - this.shadowSize);
            } else if (!this.showRightShadow && this.showBottomShadow) {
                bottomRightShadowPoint.setLocation(x + width - this.shadowSize - this.shadowSize, y + height - this.shadowSize);
            }
        }
        Point topRightShadowPoint = null;
        if (this.showRightShadow || this.showTopShadow) {
            topRightShadowPoint = new Point();
            if (this.showRightShadow && !this.showTopShadow) {
                topRightShadowPoint.setLocation(x + width - this.shadowSize, y + this.shadowSize);
            } else if (this.showRightShadow && this.showTopShadow) {
                topRightShadowPoint.setLocation(x + width - this.shadowSize, y);
            } else if (!this.showRightShadow && this.showTopShadow) {
                topRightShadowPoint.setLocation(x + width - this.shadowSize - this.shadowSize, y);
            }
        }
        if (this.showLeftShadow) {
            Rectangle leftShadowRect = new Rectangle(x, (int)(topLeftShadowPoint.getY() + (double)this.shadowSize), this.shadowSize, (int)(bottomLeftShadowPoint.getY() - topLeftShadowPoint.getY() - (double)this.shadowSize));
            g2.drawImage(images.get((Object)Position.LEFT).getScaledInstance(leftShadowRect.width, leftShadowRect.height, 2), leftShadowRect.x, leftShadowRect.y, null);
        }
        if (this.showBottomShadow) {
            Rectangle bottomShadowRect = new Rectangle((int)(bottomLeftShadowPoint.getX() + (double)this.shadowSize), y + height - this.shadowSize, (int)(bottomRightShadowPoint.getX() - bottomLeftShadowPoint.getX() - (double)this.shadowSize), this.shadowSize);
            g2.drawImage(images.get((Object)Position.BOTTOM).getScaledInstance(bottomShadowRect.width, bottomShadowRect.height, 2), bottomShadowRect.x, bottomShadowRect.y, null);
        }
        if (this.showRightShadow) {
            Rectangle rightShadowRect = new Rectangle(x + width - this.shadowSize, (int)(topRightShadowPoint.getY() + (double)this.shadowSize), this.shadowSize, (int)(bottomRightShadowPoint.getY() - topRightShadowPoint.getY() - (double)this.shadowSize));
            g2.drawImage(images.get((Object)Position.RIGHT).getScaledInstance(rightShadowRect.width, rightShadowRect.height, 2), rightShadowRect.x, rightShadowRect.y, null);
        }
        if (this.showTopShadow) {
            Rectangle topShadowRect = new Rectangle((int)topLeftShadowPoint.getX() + this.shadowSize, y, (int)(topRightShadowPoint.getX() - topLeftShadowPoint.getX() - (double)this.shadowSize), this.shadowSize);
            g2.drawImage(images.get((Object)Position.TOP).getScaledInstance(topShadowRect.width, topShadowRect.height, 2), topShadowRect.x, topShadowRect.y, null);
        }
        if (this.showLeftShadow || this.showTopShadow) {
            g2.drawImage(images.get((Object)Position.TOP_LEFT), null, (int)topLeftShadowPoint.getX(), (int)topLeftShadowPoint.getY());
        }
        if (this.showLeftShadow || this.showBottomShadow) {
            g2.drawImage(images.get((Object)Position.BOTTOM_LEFT), null, (int)bottomLeftShadowPoint.getX(), (int)bottomLeftShadowPoint.getY());
        }
        if (this.showRightShadow || this.showBottomShadow) {
            g2.drawImage(images.get((Object)Position.BOTTOM_RIGHT), null, (int)bottomRightShadowPoint.getX(), (int)bottomRightShadowPoint.getY());
        }
        if (this.showRightShadow || this.showTopShadow) {
            g2.drawImage(images.get((Object)Position.TOP_RIGHT), null, (int)topRightShadowPoint.getX(), (int)topRightShadowPoint.getY());
        }
    }

    private Map<Position, BufferedImage> getImages(Graphics2D g2) {
        Map<Position, BufferedImage> images = CACHE.get(this.shadowSize);
        if (images == null) {
            images = new HashMap<Position, BufferedImage>();
            int rectWidth = this.cornerSize + 1;
            RoundRectangle2D.Double rect = new RoundRectangle2D.Double(0.0, 0.0, rectWidth, rectWidth, this.cornerSize, this.cornerSize);
            int imageWidth = rectWidth + this.shadowSize * 2;
            BufferedImage image = new BufferedImage(imageWidth, imageWidth, 2);
            Graphics2D buffer = (Graphics2D)image.getGraphics();
            buffer.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            buffer.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            buffer.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            buffer.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
            buffer.setColor(new Color(0.0f, 0.0f, 0.0f, this.shadowOpacity));
            buffer.translate(this.shadowSize, this.shadowSize);
            buffer.fill(rect);
            float blurry = 1.0f / (float)(this.shadowSize * this.shadowSize);
            float[] blurKernel = new float[this.shadowSize * this.shadowSize];
            for (int i2 = 0; i2 < blurKernel.length; ++i2) {
                blurKernel[i2] = blurry;
            }
            ConvolveOp blur = new ConvolveOp(new Kernel(this.shadowSize, this.shadowSize, blurKernel));
            BufferedImage targetImage = new BufferedImage(imageWidth, imageWidth, 2);
            ((Graphics2D)targetImage.getGraphics()).drawImage(image, blur, -(this.shadowSize / 2), -(this.shadowSize / 2));
            int x = 1;
            int y = 1;
            int w = this.shadowSize;
            int h2 = this.shadowSize;
            images.put(Position.TOP_LEFT, targetImage.getSubimage(x, y, w, h2));
            x = 1;
            y = h2;
            w = this.shadowSize;
            h2 = 1;
            images.put(Position.LEFT, targetImage.getSubimage(x, y, w, h2));
            x = 1;
            y = rectWidth;
            w = this.shadowSize;
            h2 = this.shadowSize;
            images.put(Position.BOTTOM_LEFT, targetImage.getSubimage(x, y, w, h2));
            x = this.cornerSize + 1;
            y = rectWidth;
            w = 1;
            h2 = this.shadowSize;
            images.put(Position.BOTTOM, targetImage.getSubimage(x, y, w, h2));
            y = x = rectWidth;
            w = this.shadowSize;
            h2 = this.shadowSize;
            images.put(Position.BOTTOM_RIGHT, targetImage.getSubimage(x, y, w, h2));
            x = rectWidth;
            y = this.cornerSize + 1;
            w = this.shadowSize;
            h2 = 1;
            images.put(Position.RIGHT, targetImage.getSubimage(x, y, w, h2));
            x = rectWidth;
            y = 1;
            w = this.shadowSize;
            h2 = this.shadowSize;
            images.put(Position.TOP_RIGHT, targetImage.getSubimage(x, y, w, h2));
            x = this.shadowSize;
            y = 1;
            w = 1;
            h2 = this.shadowSize;
            images.put(Position.TOP, targetImage.getSubimage(x, y, w, h2));
            buffer.dispose();
            image.flush();
        }
        return images;
    }

    @Override
    public Insets getBorderInsets(Component c) {
        int top = 4 + (this.showTopShadow ? this.lineWidth + this.shadowSize : this.lineWidth);
        int left = 4 + (this.showLeftShadow ? this.lineWidth + this.shadowSize : this.lineWidth);
        int bottom = 4 + (this.showBottomShadow ? this.lineWidth + this.shadowSize : this.lineWidth);
        int right = 4 + (this.showRightShadow ? this.lineWidth + this.shadowSize : this.lineWidth);
        return new Insets(top, left, bottom, right);
    }

    @Override
    public boolean isBorderOpaque() {
        return true;
    }

    public boolean isShowTopShadow() {
        return this.showTopShadow;
    }

    public boolean isShowLeftShadow() {
        return this.showLeftShadow;
    }

    public boolean isShowRightShadow() {
        return this.showRightShadow;
    }

    public boolean isShowBottomShadow() {
        return this.showBottomShadow;
    }

    public int getLineWidth() {
        return this.lineWidth;
    }

    public Color getLineColor() {
        return this.lineColor;
    }

    public int getShadowSize() {
        return this.shadowSize;
    }

    public float getShadowOpacity() {
        return this.shadowOpacity;
    }

    public int getCornerSize() {
        return this.cornerSize;
    }

    private static enum Position {
        TOP,
        TOP_LEFT,
        LEFT,
        BOTTOM_LEFT,
        BOTTOM,
        BOTTOM_RIGHT,
        RIGHT,
        TOP_RIGHT;

    }
}

