/*
 * Decompiled with CFR 0.152.
 */
package io;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteOrder;

public class ByteWriter
extends OutputStream {
    private static boolean le = ByteOrder.nativeOrder().equals(ByteOrder.LITTLE_ENDIAN);
    private OutputStream stream;
    private int pos = 0;

    public ByteWriter(OutputStream out) {
        this.stream = out;
    }

    public int getPosition() {
        return this.pos;
    }

    public ByteWriter changeEndiannes() {
        le = !le;
        return this;
    }

    @Override
    public void write(int b) throws IOException {
        ++this.pos;
        this.stream.write(b);
    }

    public void write(long b) throws IOException {
        this.write((int)b);
    }

    public void write2bytes(long n) throws IOException {
        long b0 = n & 0xFFL;
        long b1 = (n & 0xFF00L) >> 8;
        if (le) {
            this.write(b0);
            this.write(b1);
        } else {
            this.write(b1);
            this.write(b0);
        }
    }

    public void write3bytes(long n) throws IOException {
        long b0 = n & 0xFFL;
        long b1 = (n & 0xFF00L) >> 8;
        long b2 = (n & 0xFF0000L) >> 16;
        if (le) {
            this.write(b0);
            this.write(b1);
            this.write(b2);
        } else {
            this.write(b2);
            this.write(b1);
            this.write(b0);
        }
    }

    public void write4bytes(long n) throws IOException {
        long b0 = n & 0xFFL;
        long b1 = (n & 0xFF00L) >> 8;
        long b2 = (n & 0xFF0000L) >> 16;
        long b3 = (n & 0xFFFFFFFFFF000000L) >>> 24;
        if (le) {
            this.write(b0);
            this.write(b1);
            this.write(b2);
            this.write(b3);
        } else {
            this.write(b3);
            this.write(b2);
            this.write(b1);
            this.write(b0);
        }
    }

    public void write5bytes(long n) throws IOException {
        long b0 = n & 0xFFL;
        long b1 = (n & 0xFF00L) >> 8;
        long b2 = (n & 0xFF0000L) >> 16;
        long b3 = (n & 0xFFFFFFFFFF000000L) >>> 24;
        long b4 = (n & 0xFF00000000L) >> 32;
        if (le) {
            this.write(b0);
            this.write(b1);
            this.write(b2);
            this.write(b3);
            this.write(b4);
        } else {
            this.write(b4);
            this.write(b3);
            this.write(b2);
            this.write(b1);
            this.write(b0);
        }
    }

    public void write6bytes(long n) throws IOException {
        long b0 = n & 0xFFL;
        long b1 = (n & 0xFF00L) >> 8;
        long b2 = (n & 0xFF0000L) >> 16;
        long b3 = (n & 0xFFFFFFFFFF000000L) >>> 24;
        long b4 = (n & 0xFF00000000L) >> 32;
        long b5 = (n & 0xFF0000000000L) >> 40;
        if (le) {
            this.write(b0);
            this.write(b1);
            this.write(b2);
            this.write(b3);
            this.write(b4);
            this.write(b5);
        } else {
            this.write(b5);
            this.write(b4);
            this.write(b3);
            this.write(b2);
            this.write(b1);
            this.write(b0);
        }
    }

    public void write7bytes(long n) throws IOException {
        long b0 = n & 0xFFL;
        long b1 = (n & 0xFF00L) >> 8;
        long b2 = (n & 0xFF0000L) >> 16;
        long b3 = (n & 0xFFFFFFFFFF000000L) >>> 24;
        long b4 = (n & 0xFF00000000L) >> 32;
        long b5 = (n & 0xFF0000000000L) >> 40;
        long b6 = (n & 0xFF000000000000L) >> 48;
        if (le) {
            this.write(b0);
            this.write(b1);
            this.write(b2);
            this.write(b3);
            this.write(b4);
            this.write(b5);
            this.write(b6);
        } else {
            this.write(b6);
            this.write(b5);
            this.write(b4);
            this.write(b3);
            this.write(b2);
            this.write(b1);
            this.write(b0);
        }
    }

    public void write8bytes(long n) throws IOException {
        long b0 = n & 0xFFL;
        long b1 = (n & 0xFF00L) >> 8;
        long b2 = (n & 0xFF0000L) >> 16;
        long b3 = (n & 0xFFFFFFFFFF000000L) >>> 24;
        long b4 = (n & 0xFF00000000L) >> 32;
        long b5 = (n & 0xFF0000000000L) >> 40;
        long b6 = (n & 0xFF000000000000L) >> 48;
        long b7 = (n & 0xFF00000000000000L) >>> 56;
        if (le) {
            this.write(b0);
            this.write(b1);
            this.write(b2);
            this.write(b3);
            this.write(b4);
            this.write(b5);
            this.write(b6);
            this.write(b7);
        } else {
            this.write(b7);
            this.write(b6);
            this.write(b5);
            this.write(b4);
            this.write(b3);
            this.write(b2);
            this.write(b1);
            this.write(b0);
        }
    }

    public void writeBytes(byte[] b) throws IOException {
        for (byte i2 : b) {
            this.write(i2);
        }
    }

    public void writeUnicodeString(String s2) throws IOException {
        this.writeUnicodeString(s2, false);
    }

    public void writeUnicodeString(String s2, boolean nullterm) throws IOException {
        if (!nullterm) {
            this.write2bytes(s2.length());
        }
        for (int i2 = 0; i2 < s2.length(); ++i2) {
            this.write2bytes(s2.charAt(i2));
        }
        if (nullterm) {
            this.write2bytes(0L);
        }
    }
}

