/*
 * Decompiled with CFR 0.152.
 */
package de.griefed.versionchecker;

import com.fasterxml.jackson.databind.JsonNode;
import de.griefed.versionchecker.ArchiveType;
import de.griefed.versionchecker.Comparison;
import de.griefed.versionchecker.ReleaseAsset;
import de.griefed.versionchecker.Source;
import de.griefed.versionchecker.Update;
import de.griefed.versionchecker.VersionChecker;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class GitLabChecker
extends VersionChecker {
    private static final Logger LOG = LogManager.getLogger(GitLabChecker.class);
    private final URL GITLAB_API;
    private JsonNode repository;

    public GitLabChecker(@NotNull String repositoryUrl) throws MalformedURLException {
        this.GITLAB_API = new URL(repositoryUrl);
    }

    public GitLabChecker(@NotNull URL repositoryUrl) {
        this.GITLAB_API = repositoryUrl;
    }

    @Override
    public GitLabChecker refresh() throws IOException {
        this.setRepository();
        this.setAllVersions();
        return this;
    }

    @Override
    public Optional<Update> check(@NotNull String currentVersion, boolean checkForPreReleases) {
        LOG.debug("Current version: " + currentVersion);
        try {
            String newVersion = this.isUpdateAvailable(currentVersion, checkForPreReleases);
            if (!newVersion.equals("up_to_date")) {
                String description = "N/A";
                LocalDate releaseDate = null;
                ArrayList<ReleaseAsset> assets = new ArrayList<ReleaseAsset>();
                ArrayList<Source> sources = new ArrayList<Source>();
                for (JsonNode release : this.repository) {
                    if (!release.get("tag_name").asText().equals(newVersion)) continue;
                    description = release.get("description").asText();
                    releaseDate = LocalDate.parse(release.get("released_at").asText().substring(0, release.get("released_at").asText().lastIndexOf("T")));
                    for (JsonNode asset : release.get("assets").get("links")) {
                        assets.add(new ReleaseAsset(asset.get("name").asText(), new URL(asset.get("direct_asset_url").asText())));
                    }
                    for (JsonNode source : release.get("assets").get("sources")) {
                        ArchiveType type = null;
                        switch (source.get("format").asText()) {
                            case "zip": {
                                type = ArchiveType.ZIP;
                                break;
                            }
                            case "tar.gz": {
                                type = ArchiveType.TAR_GZ;
                                break;
                            }
                            case "tar.bz2": {
                                type = ArchiveType.TAR_BZ2;
                                break;
                            }
                            case "tar": {
                                type = ArchiveType.TAR;
                            }
                        }
                        sources.add(new Source(type, new URL(source.get("url").asText())));
                    }
                }
                return Optional.of(new Update(newVersion, description, new URL(this.getDownloadUrl(newVersion)), releaseDate, assets, sources));
            }
        }
        catch (NumberFormatException ex) {
            LOG.error("A version could not be parsed into integers.", (Throwable)ex);
        }
        catch (MalformedURLException ex) {
            LOG.error("URL could not be created.", (Throwable)ex);
        }
        return Optional.empty();
    }

    @Override
    public List<String> allVersions() {
        ArrayList<String> versions = new ArrayList<String>(1000);
        if (this.repository != null) {
            for (JsonNode version : this.repository) {
                if (versions.contains(version.get("tag_name").asText())) continue;
                versions.add(version.get("tag_name").asText());
            }
        }
        LOG.debug("All versions: " + versions);
        if (versions.size() == 0) {
            return null;
        }
        return versions;
    }

    @Override
    public String latestVersion(boolean checkForPreRelease) {
        if (this.getAllVersions() != null) {
            String latest = null;
            if (checkForPreRelease) {
                latest = this.getAllVersions().get(0);
            } else {
                for (String version : this.getAllVersions()) {
                    if (version.contains("alpha") || version.contains("beta")) continue;
                    latest = version;
                    break;
                }
            }
            if (latest == null) {
                return "no_release";
            }
            for (String version : this.getAllVersions()) {
                LOG.debug("version: " + version);
                if (version.contains("alpha") || version.contains("beta") || !this.compareSemantics(latest, version, Comparison.NEW)) continue;
                latest = version;
            }
            if (checkForPreRelease) {
                String alpha = this.latestAlpha();
                String beta = this.latestBeta();
                if (!beta.equals("no_betas") && this.compareSemantics(latest, beta, Comparison.NEW)) {
                    latest = beta;
                }
                if (!alpha.equals("no_alphas") && this.compareSemantics(latest, alpha, Comparison.NEW)) {
                    latest = alpha;
                }
            }
            return latest;
        }
        return "no_release";
    }

    @Override
    public String getDownloadUrl(@NotNull String version) {
        if (this.repository != null) {
            for (JsonNode tag : this.repository) {
                if (!tag.get("tag_name").asText().equals(version)) continue;
                return tag.get("_links").get("self").asText();
            }
        }
        return "No URL found.";
    }

    @Override
    protected void setRepository() throws IOException {
        this.repository = this.getObjectMapper().readTree(this.getResponse(this.GITLAB_API));
    }

    @Override
    @Deprecated
    public List<String> getAssetsDownloadUrls(@NotNull String requestedVersion) {
        ArrayList<String> assetUrls = new ArrayList<String>(20);
        if (this.repository != null) {
            for (JsonNode version : this.repository) {
                if (!version.get("tag_name").asText().equals(requestedVersion)) continue;
                for (JsonNode asset : version.get("assets").get("links")) {
                    if (assetUrls.contains(asset.get("url").asText())) continue;
                    assetUrls.add(asset.get("url").asText());
                }
            }
        }
        return assetUrls;
    }
}

