/*
 * Decompiled with CFR 0.152.
 */
package de.griefed.serverpackcreator.versionmeta.minecraft;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.griefed.serverpackcreator.ApplicationProperties;
import de.griefed.serverpackcreator.utilities.common.Utilities;
import de.griefed.serverpackcreator.versionmeta.ManifestParser;
import de.griefed.serverpackcreator.versionmeta.Type;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Optional;

public final class MinecraftServer
extends ManifestParser {
    private final Utilities UTILITIES;
    private final ObjectMapper OBJECT_MAPPER;
    private final URL MANIFEST_URL;
    private final File MANIFEST_FILE;
    private final String VERSION;
    private final Type TYPE;
    private JsonNode serverJson = null;

    MinecraftServer(String mcVersion, Type mcType, URL mcUrl, ObjectMapper objectMapper, Utilities utilities, ApplicationProperties applicationProperties) {
        this.UTILITIES = utilities;
        this.MANIFEST_URL = mcUrl;
        this.VERSION = mcVersion;
        this.MANIFEST_FILE = new File(applicationProperties.MINECRAFT_SERVER_MANIFEST_LOCATION() + this.VERSION + ".json");
        this.TYPE = mcType;
        this.OBJECT_MAPPER = objectMapper;
    }

    private void setServerJson() {
        if (!this.MANIFEST_FILE.exists()) {
            this.UTILITIES.WebUtils().downloadFile(this.MANIFEST_FILE, this.MANIFEST_URL);
        }
        try {
            this.serverJson = this.getJson(this.MANIFEST_FILE, this.OBJECT_MAPPER);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public String version() {
        return this.VERSION;
    }

    public Type type() {
        return this.TYPE;
    }

    public Optional<URL> url() {
        if (this.serverJson == null) {
            this.setServerJson();
        }
        try {
            return Optional.of(new URL(this.serverJson.get("downloads").get("server").get("url").asText()));
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }

    public Optional<Byte> javaVersion() {
        if (this.serverJson == null) {
            this.setServerJson();
        }
        try {
            return Optional.of(Byte.parseByte(this.serverJson.get("javaVersion").get("majorVersion").asText()));
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }
}

